##############################################################################
#
# Copyright (c) 2003-2018 by The University of Queensland
# http://www.uq.edu.au
#
# Primary Business: Queensland, Australia
# Licensed under the Apache License, version 2.0
# http://www.apache.org/licenses/LICENSE-2.0
#
# Development until 2012 by Earth Systems Science Computational Center (ESSCC)
# Development 2012-2013 by School of Earth Sciences
# Development from 2014 by Centre for Geoscience Computing (GeoComp)
#
##############################################################################

# This is a template configuration file for escript on Debian/GNU Linux.
# Refer to README_FIRST for usage instructions.

escript_opts_version = 203
cxx_extra = ''          #To allow string addition later
#cxx_extra = '-Wno-literal-suffix'
openmp = True
#mpi = 'OPENMPI'

cxx_extra +=' -Wno-stringop-truncation'
werror = False

import os

from subprocess import check_output
arch = check_output(['dpkg-architecture','-qDEB_HOST_MULTIARCH']).strip()


d_mpi_path = '/usr/lib/' + arch.decode('UTF-8') + '/openmpi'
mpi_prefix = os.path.split(os.path.realpath(d_mpi_path))[0]
mpi_prefix = d_mpi_path
mpi_libs = ['mpi_cxx', 'mpi']
netcdf = 4
#umfpack = True
umfpack_prefix = ['/usr/include/suitesparse', '/usr/lib']
umfpack_libs = ['umfpack', 'blas', 'amd']
lapack_prefix = ['/usr/include/atlas', '/usr/lib/atlas-base']
silo = True
silo_libs = ['siloh5']
dudley_assemble_flags = '-funroll-loops'

#trilinos = True

import subprocess
import os
p = subprocess.Popen(["ld","--verbose"], stdout=subprocess.PIPE)
out,err = p.communicate()
spath = [x[13:-3] for x in out.decode().split() if 'SEARCH_DIR' in x]
p3name = ''
for name in spath:
  try:
    l=os.listdir(name)
    p3res=[x for x in l if (x.startswith('libboost_python-py3') or \
            x.startswith('libboost_python3')) and x.endswith('.so')]
    if len(p3name)==0 and len(p3res)>0:
      p3name=p3res[-1]
  except OSError:
    pass

pythoncmd = '/usr/bin/python3'

import sysconfig
pyversion=sysconfig.get_python_version()
# boost-python library/libraries to link against
# boost_libs = [p2name[3:-3]]
boost_libs = [f'libboost_python{pyversion}']

# this can be used by options files importing us
boost_py3_libs = [p3name[3:-3]]

boost_libs = boost_py3_libs

disable_boost_numpy=True

from site_init import getdebbuildflags
# Now we add the debian build flags
debstuff = getdebbuildflags()
if len(debstuff) > 0:
  print("Building with the following additional flags from debian: "+str(debstuff))
for i in debstuff:
  k=i[0]
  v=i[1]
  try:
    exec(k+"+=' "+v+"'")
  except NameError:   
    exec(k+"='"+v+"'")

import platform
if platform.architecture()[0] == '32bit':
    cxx_extra += ' -Wno-maybe-uninitialized '

if platform.machine() in ('ppc', 'ppc64', 'ppc64le', 's390x'):
    cxx_extra += ' -Wno-strict-overflow -Wno-error=strict-overflow '

# Low memory
if platform.machine() in ('armhf', 'mips', 'mips3l', 'mips64el'):
    cxx_extra += ' -Os -g1'
    ld_extra += ' -Wl,-no-keep-memory'

mathjax_path='file:///usr/share/javascript/mathjax/MathJax.js'
