/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Catalan's constant.
*
* @module @stdlib/constants/float64/catalan
* @type {number}
*
* @example
* var CATALAN = require( '@stdlib/constants/float64/catalan' );
* // returns 0.915965594177219
*/


// MAIN //

/**
* Catalan's constant.
*
* @constant
* @type {number}
* @default 0.915965594177219
* @see [OEIS]{@link http://oeis.org/A006752}
* @see [Wikipedia]{@link http://en.wikipedia.org/wiki/Catalan%27s_constant}
*/
var CATALAN = 0.91596559417721901505460351493238411077414937428167213426649812;


// EXPORTS //

module.exports = CATALAN;
