#pragma once

#include "miniracer/server/entities/IEntity.h"
#include "common/Direction.h"
#include "common/SoundType.h"
#include "common/ConfigVar.h"
#include "common/Log.h"
#include <memory>
#include "network/IProtocolHandler.h"

namespace miniracer {

// forward decl
class Map;

class Player: public IEntity {
private:
	ClientId _clientId;
	std::string _name;
public:
	Player (Map& map, ClientId clientId);
	virtual ~Player ();

	ClientId getClientId () const;
	const std::string& getName () const;
	void setName (const std::string& name);
};

inline ClientId Player::getClientId () const
{
	return _clientId;
}

inline const std::string& Player::getName () const
{
	return _name;
}

inline void Player::setName (const std::string& name)
{
	_name = name;
}

}
