<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Euler's Number

> The mathematical constant [_e_][e].

<section class="usage">

## Usage

```javascript
var e = require( '@stdlib/constants/float64/e' );
```

#### e

The mathematical constant [_e_][e], also known as Euler's number or Napier's constant. [_e_][e] is the base of the natural logarithm.

```javascript
var bool = ( e === 2.718281828459045 );
// returns true
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better example -->

<!-- eslint no-undef: "error" -->

```javascript
var e = require( '@stdlib/constants/float64/e' );

console.log( e );
// => 2.718281828459045
```

</section>

<!-- /.examples -->

<section class="links">

[e]: https://en.wikipedia.org/wiki/E_%28mathematical_constant%29

</section>

<!-- /.links -->
