/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * CRC constants generated by:
 *
 *	./scripts/gen-crc-consts.py riscv_clmul crc16_msb_0x8bb7,crc32_msb_0x04c11db7,crc32_lsb_0xedb88320,crc32_lsb_0x82f63b78,crc64_msb_0x42f0e1eba9ea3693,crc64_lsb_0x9a6c9329ac4bc9b5
 *
 * Do not edit manually.
 */

struct crc_clmul_consts {
	unsigned long fold_across_2_longs_const_hi;
	unsigned long fold_across_2_longs_const_lo;
	unsigned long barrett_reduction_const_1;
	unsigned long barrett_reduction_const_2;
};

/*
 * Constants generated for most-significant-bit-first CRC-16 using
 * G(x) = x^16 + x^15 + x^11 + x^9 + x^8 + x^7 + x^5 + x^4 + x^2 + x^1 + x^0
 */
static const struct crc_clmul_consts crc16_msb_0x8bb7_consts __maybe_unused = {
#ifdef CONFIG_64BIT
	.fold_across_2_longs_const_hi = 0x0000000000001faa, /* x^192 mod G */
	.fold_across_2_longs_const_lo = 0x000000000000a010, /* x^128 mod G */
	.barrett_reduction_const_1 = 0xfb2d2bfc0e99d245, /* floor(x^79 / G) */
	.barrett_reduction_const_2 = 0x0000000000008bb7, /* G - x^16 */
#else
	.fold_across_2_longs_const_hi = 0x00005890, /* x^96 mod G */
	.fold_across_2_longs_const_lo = 0x0000f249, /* x^64 mod G */
	.barrett_reduction_const_1 = 0xfb2d2bfc, /* floor(x^47 / G) */
	.barrett_reduction_const_2 = 0x00008bb7, /* G - x^16 */
#endif
};

/*
 * Constants generated for most-significant-bit-first CRC-32 using
 * G(x) = x^32 + x^26 + x^23 + x^22 + x^16 + x^12 + x^11 + x^10 + x^8 + x^7 +
 *        x^5 + x^4 + x^2 + x^1 + x^0
 */
static const struct crc_clmul_consts crc32_msb_0x04c11db7_consts __maybe_unused = {
#ifdef CONFIG_64BIT
	.fold_across_2_longs_const_hi = 0x00000000c5b9cd4c, /* x^192 mod G */
	.fold_across_2_longs_const_lo = 0x00000000e8a45605, /* x^128 mod G */
	.barrett_reduction_const_1 = 0x826880efa40da72d, /* floor(x^95 / G) */
	.barrett_reduction_const_2 = 0x0000000004c11db7, /* G - x^32 */
#else
	.fold_across_2_longs_const_hi = 0xf200aa66, /* x^96 mod G */
	.fold_across_2_longs_const_lo = 0x490d678d, /* x^64 mod G */
	.barrett_reduction_const_1 = 0x826880ef, /* floor(x^63 / G) */
	.barrett_reduction_const_2 = 0x04c11db7, /* G - x^32 */
#endif
};

/*
 * Constants generated for least-significant-bit-first CRC-32 using
 * G(x) = x^32 + x^26 + x^23 + x^22 + x^16 + x^12 + x^11 + x^10 + x^8 + x^7 +
 *        x^5 + x^4 + x^2 + x^1 + x^0
 */
static const struct crc_clmul_consts crc32_lsb_0xedb88320_consts __maybe_unused = {
#ifdef CONFIG_64BIT
	.fold_across_2_longs_const_hi = 0x65673b4600000000, /* x^191 mod G */
	.fold_across_2_longs_const_lo = 0x9ba54c6f00000000, /* x^127 mod G */
	.barrett_reduction_const_1 = 0xb4e5b025f7011641, /* floor(x^95 / G) */
	.barrett_reduction_const_2 = 0x00000000edb88320, /* (G - x^32) * x^32 */
#else
	.fold_across_2_longs_const_hi = 0xccaa009e, /* x^95 mod G */
	.fold_across_2_longs_const_lo = 0xb8bc6765, /* x^63 mod G */
	.barrett_reduction_const_1 = 0xf7011641, /* floor(x^63 / G) */
	.barrett_reduction_const_2 = 0xedb88320, /* (G - x^32) * x^0 */
#endif
};

/*
 * Constants generated for least-significant-bit-first CRC-32 using
 * G(x) = x^32 + x^28 + x^27 + x^26 + x^25 + x^23 + x^22 + x^20 + x^19 + x^18 +
 *        x^14 + x^13 + x^11 + x^10 + x^9 + x^8 + x^6 + x^0
 */
static const struct crc_clmul_consts crc32_lsb_0x82f63b78_consts __maybe_unused = {
#ifdef CONFIG_64BIT
	.fold_across_2_longs_const_hi = 0x3743f7bd00000000, /* x^191 mod G */
	.fold_across_2_longs_const_lo = 0x3171d43000000000, /* x^127 mod G */
	.barrett_reduction_const_1 = 0x4869ec38dea713f1, /* floor(x^95 / G) */
	.barrett_reduction_const_2 = 0x0000000082f63b78, /* (G - x^32) * x^32 */
#else
	.fold_across_2_longs_const_hi = 0x493c7d27, /* x^95 mod G */
	.fold_across_2_longs_const_lo = 0xdd45aab8, /* x^63 mod G */
	.barrett_reduction_const_1 = 0xdea713f1, /* floor(x^63 / G) */
	.barrett_reduction_const_2 = 0x82f63b78, /* (G - x^32) * x^0 */
#endif
};

/*
 * Constants generated for most-significant-bit-first CRC-64 using
 * G(x) = x^64 + x^62 + x^57 + x^55 + x^54 + x^53 + x^52 + x^47 + x^46 + x^45 +
 *        x^40 + x^39 + x^38 + x^37 + x^35 + x^33 + x^32 + x^31 + x^29 + x^27 +
 *        x^24 + x^23 + x^22 + x^21 + x^19 + x^17 + x^13 + x^12 + x^10 + x^9 +
 *        x^7 + x^4 + x^1 + x^0
 */
#ifdef CONFIG_64BIT
static const struct crc_clmul_consts crc64_msb_0x42f0e1eba9ea3693_consts __maybe_unused = {
	.fold_across_2_longs_const_hi = 0x4eb938a7d257740e, /* x^192 mod G */
	.fold_across_2_longs_const_lo = 0x05f5c3c7eb52fab6, /* x^128 mod G */
	.barrett_reduction_const_1 = 0xabc694e836627c39, /* floor(x^127 / G) */
	.barrett_reduction_const_2 = 0x42f0e1eba9ea3693, /* G - x^64 */
};
#endif

/*
 * Constants generated for least-significant-bit-first CRC-64 using
 * G(x) = x^64 + x^63 + x^61 + x^59 + x^58 + x^56 + x^55 + x^52 + x^49 + x^48 +
 *        x^47 + x^46 + x^44 + x^41 + x^37 + x^36 + x^34 + x^32 + x^31 + x^28 +
 *        x^26 + x^23 + x^22 + x^19 + x^16 + x^13 + x^12 + x^10 + x^9 + x^6 +
 *        x^4 + x^3 + x^0
 */
#ifdef CONFIG_64BIT
static const struct crc_clmul_consts crc64_lsb_0x9a6c9329ac4bc9b5_consts __maybe_unused = {
	.fold_across_2_longs_const_hi = 0xeadc41fd2ba3d420, /* x^191 mod G */
	.fold_across_2_longs_const_lo = 0x21e9761e252621ac, /* x^127 mod G */
	.barrett_reduction_const_1 = 0x27ecfa329aef9f77, /* floor(x^127 / G) */
	.barrett_reduction_const_2 = 0x9a6c9329ac4bc9b5, /* (G - x^64) * x^0 */
};
#endif
