/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2017 Intel Corporation
 */

#ifndef ACC100_PF_ENUM_H
#define ACC100_PF_ENUM_H

/*
 * ACC100 Register mapping on PF BAR0
 * This is automatically generated from RDL, format may change with new RDL
 * Release.
 * Variable names are as is
 */
enum {
	HWPfQmgrEgressQueuesTemplate          =  0x0007FE00,
	HWPfQmgrIngressAq                     =  0x00080000,
	HWPfQmgrDepthLog2Grp                  =  0x00A00200,
	HWPfQmgrTholdGrp                      =  0x00A00300,
	HWPfQmgrGrpTmplateReg0Indx            =  0x00A00600,
	HWPfQmgrGrpTmplateReg1Indx            =  0x00A00680,
	HWPfQmgrGrpTmplateReg2indx            =  0x00A00700,
	HWPfQmgrGrpTmplateReg3Indx            =  0x00A00780,
	HWPfQmgrGrpTmplateReg4Indx            =  0x00A00800,
	HWPfQmgrVfBaseAddr                    =  0x00A01000,
	HWPfQmgrArbQDepthGrp                  =  0x00A02F00,
	HWPfQmgrGrpFunction0                  =  0x00A02F40,
	HWPfQmgrGrpPriority                   =  0x00A02F48,
	HWPfQmgrAqEnableVf                    =  0x00A10000,
	HWPfQmgrRingSizeVf                    =  0x00A20004,
	HWPfQmgrGrpDepthLog20Vf               =  0x00A20008,
	HWPfQmgrGrpDepthLog21Vf               =  0x00A2000C,
	HWPfDmaConfig0Reg                     =  0x00B80000,
	HWPfDmaConfig1Reg                     =  0x00B80004,
	HWPfDmaQmgrAddrReg                    =  0x00B80008,
	HWPfDmaAxcacheReg                     =  0x00B80010,
	HWPfDmaAxiControl                     =  0x00B8002C,
	HWPfDmaQmanen                         =  0x00B80040,
	HWPfDmaInboundDrainDataSize           =  0x00B800C0,
	HWPfDmaVfDdrBaseRw                    =  0x00B80400,
	HWPfDmaDescriptorSignatuture          =  0x00B80868,
	HWPfDmaErrorDetectionEn               =  0x00B80870,
	HWPfDmaFec5GulDescBaseLoRegVf         =  0x00B88020,
	HWPfDmaFec5GulDescBaseHiRegVf         =  0x00B88024,
	HWPfDmaFec5GulRespPtrLoRegVf          =  0x00B88028,
	HWPfDmaFec5GulRespPtrHiRegVf          =  0x00B8802C,
	HWPfDmaFec5GdlDescBaseLoRegVf         =  0x00B88040,
	HWPfDmaFec5GdlDescBaseHiRegVf         =  0x00B88044,
	HWPfDmaFec5GdlRespPtrLoRegVf          =  0x00B88048,
	HWPfDmaFec5GdlRespPtrHiRegVf          =  0x00B8804C,
	HWPfDmaFec4GulDescBaseLoRegVf         =  0x00B88060,
	HWPfDmaFec4GulDescBaseHiRegVf         =  0x00B88064,
	HWPfDmaFec4GulRespPtrLoRegVf          =  0x00B88068,
	HWPfDmaFec4GulRespPtrHiRegVf          =  0x00B8806C,
	HWPfDmaFec4GdlDescBaseLoRegVf         =  0x00B88080,
	HWPfDmaFec4GdlDescBaseHiRegVf         =  0x00B88084,
	HWPfDmaFec4GdlRespPtrLoRegVf          =  0x00B88088,
	HWPfDmaFec4GdlRespPtrHiRegVf          =  0x00B8808C,
	HWPfQosmonAEvalOverflow0              =  0x00B90008,
	HWPfPermonACntrlRegVf                 =  0x00B98000,
	HWPfQosmonBEvalOverflow0              =  0x00BA0008,
	HWPfPermonBCntrlRegVf                 =  0x00BA8000,
	HWPfFabricMode                        =  0x00BB1000,
	HWPfFecUl5gCntrlReg                   =  0x00BC0000,
	HwPfFecUl5gIbDebugReg                 =  0x00BC0200,
	HWPfChaDl5gPllPhshft0                 =  0x00C40098,
	HWPfChaDdrStDoneStatus                =  0x00C40434,
	HWPfChaDdrWbRstCfg                    =  0x00C40438,
	HWPfChaDdrApbRstCfg                   =  0x00C4043C,
	HWPfChaDdrPhyRstCfg                   =  0x00C40440,
	HWPfChaDdrCpuRstCfg                   =  0x00C40444,
	HWPfChaDdrSifRstCfg                   =  0x00C40448,
	HWPfHi5GHardResetReg                  =  0x00C8400C,
	HWPfHiInfoRingBaseLoRegPf             =  0x00C84010,
	HWPfHiInfoRingBaseHiRegPf             =  0x00C84014,
	HWPfHiInfoRingPointerRegPf            =  0x00C84018,
	HWPfHiInfoRingIntWrEnRegPf            =  0x00C84020,
	HWPfHiInfoRingVf2pfLoWrEnReg          =  0x00C84024,
	HWPfHiBlockTransmitOnErrorEn          =  0x00C84038,
	HWPfHiCfgMsiIntWrEnRegPf              =  0x00C84040,
	HWPfHiCfgMsiVf2pfLoWrEnReg            =  0x00C84044,
	HWPfHiPfMode                          =  0x00C84108,
	HWPfHiClkGateHystReg                  =  0x00C8410C,
	HWPfHiMsiDropEnableReg                =  0x00C84114,
	HWPfDdrUmmcCtrl                       =  0x00D00020,
	HWPfDdrMemInitPhyTrng0                =  0x00D00240,
	HWPfDdrBcDram                         =  0x00D003C0,
	HWPfDdrBcAddrMap                      =  0x00D003D0,
	HWPfDdrBcRef                          =  0x00D003E0,
	HWPfDdrBcTim0                         =  0x00D00400,
	HWPfDdrBcTim1                         =  0x00D00410,
	HWPfDdrBcTim2                         =  0x00D00420,
	HWPfDdrBcTim3                         =  0x00D00430,
	HWPfDdrBcTim4                         =  0x00D00440,
	HWPfDdrBcTim5                         =  0x00D00450,
	HWPfDdrBcTim6                         =  0x00D00460,
	HWPfDdrBcTim7                         =  0x00D00470,
	HWPfDdrBcTim8                         =  0x00D00480,
	HWPfDdrBcTim9                         =  0x00D00490,
	HWPfDdrBcTim10                        =  0x00D004A0,
	HWPfDdrDfiInit                        =  0x00D004D0,
	HWPfDdrDfiTim0                        =  0x00D004F0,
	HWPfDdrDfiTim1                        =  0x00D00500,
	HWPfDdrDfiPhyUpdEn                    =  0x00D00530,
	HWPfDdrUmmcIntEn                      =  0x00D00570,
	HWPfDdrPhyRdLatency                   =  0x00D48400,
	HWPfDdrPhyRdLatencyDbi                =  0x00D48410,
	HWPfDdrPhyWrLatency                   =  0x00D48420,
	HWPfDdrPhyTrngType                    =  0x00D48430,
	HWPfDdrPhyMr01Dimm                    =  0x00D484C0,
	HWPfDdrPhyMr01DimmDbi                 =  0x00D484D0,
	HWPfDdrPhyMr23Dimm                    =  0x00D484E0,
	HWPfDdrPhyMr45Dimm                    =  0x00D484F0,
	HWPfDdrPhyMr67Dimm                    =  0x00D48500,
	HWPfDdrPhyWrlvlWwRdlvlRr              =  0x00D48510,
	HWPfDdrPhyIdletimeout                 =  0x00D48560,
	HWPfDdrPhyDqsCountMax                 =  0x00D485D0,
	HWPfDdrPhyDqsCountNum                 =  0x00D485E0,
	HWPfDdrPhyIdtmFwVersion               =  0x00D6C410,
	HWPfDdrPhyDqsCount                    =  0x00D70020,
	HwPfPcieLnAdaptctrl                   =  0x00D80108,
	HwPfPciePcsEqControl                  =  0x00D81098,
	HwPfPcieGpexBridgeControl             =  0x00D90808,
	HwPfPcieGpexAxiPioControl             =  0x00D90840,
	HwPfPcieGpexAxiAddrMappingWindowPexBaseHigh =  0x00D90BAC,
};

/* TIP PF Interrupt numbers */
enum {
	ACC100_PF_INT_QMGR_AQ_OVERFLOW = 0,
	ACC100_PF_INT_DOORBELL_VF_2_PF = 1,
	ACC100_PF_INT_DMA_DL_DESC_IRQ = 2,
	ACC100_PF_INT_DMA_UL_DESC_IRQ = 3,
	ACC100_PF_INT_DMA_MLD_DESC_IRQ = 4,
	ACC100_PF_INT_DMA_UL5G_DESC_IRQ = 5,
	ACC100_PF_INT_DMA_DL5G_DESC_IRQ = 6,
	ACC100_PF_INT_ILLEGAL_FORMAT = 7,
	ACC100_PF_INT_QMGR_DISABLED_ACCESS = 8,
	ACC100_PF_INT_QMGR_AQ_OVERTHRESHOLD = 9,
	ACC100_PF_INT_ARAM_ACCESS_ERR = 10,
	ACC100_PF_INT_ARAM_ECC_1BIT_ERR = 11,
	ACC100_PF_INT_PARITY_ERR = 12,
	ACC100_PF_INT_QMGR_ERR = 13,
	ACC100_PF_INT_INT_REQ_OVERFLOW = 14,
	ACC100_PF_INT_APB_TIMEOUT = 15,
};

#endif /* ACC100_PF_ENUM_H */
