/* ZScoreBoard.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import se.kth.netzack.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;
import java.lang.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.awt.event.*;


public class ZScoreBoard extends Canvas {

    private VolatileImage img;
    private Graphics g;

    private Game game;

    private int X = 200;

    private Font smallFont;
    private int smallLine;
    private FontMetrics smallMetrics;

    private Font bigFont;
    private int bigLine;
    private FontMetrics bigMetrics;

    private int border;

    ZScoreBoard(Game ga) {
	game = ga;
	setBackground(Color.black);
	setSize(200, 0);
	setVisible(true);
    }

    void init() {
	smallFont = new Font(Config.FONT, Font.PLAIN, Config.FONT_SIZE);
	bigFont = new Font(Config.FONT, Font.BOLD|Font.ITALIC, Config.FONT_SIZE+20);

	Graphics2D graph = (Graphics2D)getGraphics();

	smallMetrics = graph.getFontMetrics(smallFont);
	bigMetrics = graph.getFontMetrics(bigFont);


	border = smallLine = smallMetrics.getHeight();
	bigLine = bigMetrics.getHeight();

	String max = "";
	for(int i = 0; i < Config.NICKNAME_LENGTH; i++)
	    max = max.concat("O");

	X = smallMetrics.stringWidth(max) + 2*border;

	setSize(X, getHeight());

	img = createVolatileImage(getWidth(), getHeight());
	if(img == null)
	    return;
	g = img.getGraphics();
	g.setColor(Color.black);
	g.fillRect(0, 0, getWidth(), getHeight());

    }




    public void update(Graphics graphics)
    {

	synchronized(img) {
	    g.setColor(Color.black);
	    g.fillRect(0, 0, X, getHeight());

	    int y = border;
	    synchronized(game.players){
		Iterator itr = game.players.values().iterator();
		Player p = null;

		do {
		    if(p == null)
			p = (Player)game.players.get((Object)new Integer(game.me));
		    else {
			p = (Player)itr.next();
			if(p.id == game.me)
			    continue;
		    }

		    if(p == null)
			break;

		    g.setColor(p.color);

		    g.setFont(smallFont);
		    String name = p.name;
		    if(p.name.length() > Config.NICKNAME_LENGTH)
			name = p.name.substring(0, Config.NICKNAME_LENGTH);
		    g.drawString(name, (X - smallMetrics.stringWidth(name))/2, y);
		    y += bigLine;


		    String score = (new Integer(p.score)).toString();
		    g.setFont(bigFont);
		    g.drawString(score, (X - smallMetrics.stringWidth(score))/2, y);
		    y += 2*smallLine;

		} while(itr.hasNext());

	    }


	}


	paint(graphics);
    }

    public void paint(Graphics g) {
	if(img != null) {
	    synchronized(img) {
		g.drawImage(img, 0, 0, this);
	    }
	}
	else {
	    g.fillRect(0, 0, getWidth(), getHeight());
	}

    }



}
