/* ZConsole.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.image.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.text.*;


public class ZInitDialog extends JFrame {

    JTextFieldLimited text = new JTextFieldLimited(Config.NICKNAME_LENGTH);
    Swatch sw = new Swatch();

    Object lock;

    ZInitDialog(Object o, String name, Color clr) {
	setTitle(Config.PRODUCT + " " + Config.VERSION);

	lock = o;


	ActionListener go = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    dispose();
		    synchronized(lock) {
			lock.notifyAll();
		    }
		}
	    };



	text.setText(name);
	text.setCaretPosition(name.length());
	sw.setSelected(clr);

	setDefaultCloseOperation(EXIT_ON_CLOSE);

	setLayout(new GridBagLayout());
	GridBagConstraints c = new GridBagConstraints();
	c.insets = new Insets(7, 7, 7, 7);

	JPanel panel = new JPanel();
	panel.setBackground(new Color(250, 250, 250));
	panel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
	panel.setLayout(new GridBagLayout());

	JLabel nickname = new JLabel("Nickname:");
	c.gridx = 0;
	c.gridy = 0;
	c.anchor = GridBagConstraints.EAST;
	panel.add(nickname, c);

	text.addActionListener(go);
	text.setFocusable(true);
	text.setPreferredSize(new Dimension(0, 22));
	c.gridx = 1;
	c.gridy = 0;
	c.anchor = GridBagConstraints.WEST;
	panel.add(text, c);

	JLabel color = new JLabel("Color:");
	c.gridx = 0;
	c.gridy = 1;
	c.anchor = GridBagConstraints.EAST;
	panel.add(color, c);


	sw.setBorder(BorderFactory.createLineBorder(Color.black));
	c.gridx = 1;
	c.gridy = 1;
	c.anchor = GridBagConstraints.CENTER;
	panel.add(sw, c);


	JPanel buttons = new JPanel(new FlowLayout());
	JButton play = new JButton("Play");
	JButton cancel = new JButton("Cancel");
	buttons.add(play);
	buttons.add(cancel);

	play.addActionListener(go);

	cancel.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    System.exit(0);
		}
	    });

	getRootPane().setDefaultButton(play);

	c.gridx = 0;
	c.gridy = 0;
	c.anchor = GridBagConstraints.CENTER;
	add(panel, c);


	c.gridx = 0;
	c.gridy = 1;
	c.gridwidth = 2;
	c.anchor = GridBagConstraints.EAST;
	add(buttons, c);


	addWindowListener(new WindowAdapter(){
		public void windowClosing(WindowEvent we){
		    System.exit(0);
		}
		public void windowActivated(WindowEvent e) {
		    requestFocusInWindow();
		}
	    });



	setResizable(false);


	pack();
	setVisible(true);

	text.requestFocus();

    }


    public String getNickname() {
	return text.getText();
    }

    public Color getColor() {
	return sw.getSelected();
    }



}

