/* ZFrame.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import se.kth.netzack.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;
import java.lang.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.awt.event.*;
import java.io.*;

class ViewLicense extends Frame {

    ViewLicense() {
	super("COPYING");

	addWindowListener(new WindowAdapter(){
		public void windowClosing(WindowEvent we){
		    dispose();
		}
	    });


	TextArea text = new TextArea("", 25, 80, TextArea.SCROLLBARS_VERTICAL_ONLY);

	try {
	    InputStream in = ClassLoader.getSystemResourceAsStream("COPYING");
	    if(in == null)
		throw new IOException();

	    byte[] bytes = new byte[1000];
	    int length = 0;
	    while((length = in.read(bytes)) != -1) {
		text.append(new String(bytes, 0, length));
	    }

	}
	catch(IOException e) {
	    text.append("Could'nt find COPYING file. Please see <http://www.gnu.org/licenses/>.");
	}

	text.setEditable(false);

	add(text);
	pack();
	setVisible(true);
    }

}



public class ZFrame extends Frame implements FocusListener {

    ZCanvas canvas;
    ZConsole console;
    ZScoreBoard board;
    Game game;

    public void console(String s){
	console.print(s);
    }



    ZFrame(Game g) {

	game = g;
	canvas = new ZCanvas(game.players);
	console = new ZConsole();
	board = new ZScoreBoard(game);

	setTitle(Config.PRODUCT + " " + Config.VERSION);

	addFocusListener(this);

	add(canvas, BorderLayout.CENTER);
	canvas.setFocusable(true);


	add(board, BorderLayout.LINE_END);
	board.setFocusable(false);


	add(console, BorderLayout.PAGE_END);
	console.setFocusable(false);



	pack();
	setVisible(true);

	board.init();
	pack();
	console.init();

	pack();

	canvas.initBuffers();

	addWindowListener(new WindowAdapter(){
		public void windowClosing(WindowEvent we){
		    System.exit(0);
		}
		public void windowActivated(WindowEvent e) {
		    requestFocusInWindow();
		}
	    });

	console(Config.COPYRIGHT);
	console(Config.NOTICE);

	pack();
	setResizable(false);

    }

    public void viewLicense() {
	new ViewLicense();
    }

    public void updateScore() {
	board.repaint();
    }


    public int paintWorld(long elapsed) {
	return canvas.paintWorms(elapsed);
    }

    public void clear() {
	canvas.clear();
    }


    public void focusGained(FocusEvent e) {
	canvas.requestFocusInWindow();
    }

    public void focusLost(FocusEvent e) {
    }


}
