/* Player.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import se.kth.netzack.*;
import java.util.*;
import java.awt.*;


public class Player {

    public int id;
    public String name;
    public Color color;

    public int score = 0;

    public Worm worm = new Worm();

    public int nextX;
    public int nextY;
    public double nextA;

    public boolean isPlaying = false;
    public boolean isReady = false;


    private Vector deathListeners = new Vector();


    Player(int i, String n, Color c) {
	id = i;
	name = n;
	color = c;
	worm.color = color;
    }

    public void turn(Direction dir) {
	worm.turn(dir);
    }

    public void addDeathListener(DeathListener l) {
	deathListeners.add(l);
    }

    public boolean startPlaying() {
	if(isReady) {
	    worm.x = nextX;
	    worm.y = nextY;
	    worm.a = nextA;

	    isPlaying = true;
	    isReady = false;

	    return true;
	}

	return false;
    }


    public void youDied() {
	isPlaying = false;

	Iterator i = deathListeners.iterator();
	while(i.hasNext()) {
	    DeathListener l = (DeathListener)i.next();
	    l.death(this);
	}
    }

}