/* Peer.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import se.kth.netzack.*;
import java.net.*;
import java.lang.*;
import java.io.*;



public class Peer extends Thread {

    Socket socket;
    Server server;

    int id = 0;
    int tries = 0;

    Peer(Socket s, Server serv) {
	server = serv;
	socket = s;

	start();
    }


     public void run() {
	 Packet p = new Packet();

	 boolean normal = true;

	 try{
	    while(p.receive(this, socket)) {

		Message m = p.getMsg();

		//Netzack.debug("<Peer> m:" + m.get());

		if(m.equals(Message.HELLO)) {
		    id = server.generateId();
		    //Netzack.debug("Giving away id #" + id + ".");
		    Packet s = Packet.idPacket(id, server.id);
		    send(s);
		    server.peerConnected(id);
		}
		else if(m.equals(Message.ID)) {
		    int i = p.readInt();
		    id = p.readInt();
		    //Netzack.debug("Received id #" + id + ".");
		    server.id = i;
		    server.game.thisIsMe(i);
		}
		else if(m.equals(Message.RECONNECT)) {
		    id = p.readInt();

		    int i = p.readInt();
		    if(i != 0) {
			server.reconnected(i);

			Packet s = Packet.reconnectPacket(server.id, 0);
			send(s);
		    }
		}
		else if(m.equals(Message.LOOP)) {
		    Netzack.debug("Peer #" + id + " closed connection to prevent loop.");
		    normal = false;
		    break;
		}
		else {
		    if(p.readInt() == server.id) {
			Netzack.debug("Closing peer #" + id + " to prevent loop.");
			send(Packet.loopPacket());
			normal = false;
			break;
		    }

		    p.dispatch(server);
		}
	    }
	}
	catch(IOException e) {
	    Netzack.debug(e);
	}

	p.release();
	close();
	Netzack.debug("Peer #" + id + " quit.");

	server.peerQuit(id, normal);

    }


    protected void finalize() throws Throwable {
	try {
	    socket.close();
	}
	finally {
	    super.finalize();
	}
    }


    public void close() {
	try {
	    socket.close();
	}
	catch(IOException e){
	    Netzack.debug(e);
	}

    }

    public boolean isConnected() {
	return socket.isConnected();
    }


    public boolean send(Packet data) {
	if(socket.isConnected()) {
	    try {
		data.send(socket);
		return true;
	    }
	    catch(SocketException e) {

	    }
	    catch(IOException e){
		Netzack.debug(e);
	    }
	}

	return false;
    }




}

