/* JTextFieldLimited.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import javax.swing.*;
import java.awt.*;
import java.util.*;
import javax.swing.text.*;


class JTextFieldLimited extends JTextField {

    class doc extends PlainDocument {
	int limit;


	doc(int l) {
	    limit = l;
	}

	public void insertString(int offset, String  str, AttributeSet attr) throws BadLocationException {
	    if (str == null) {
		return;
	    }

	    if ((getLength() + str.length()) <= limit) {
		super.insertString(offset, str, attr);
	    }

	}
    }

    JTextFieldLimited(int length) {
	super(length);

	setDocument(new doc(length));
    }

    public void setCaretPosition(int position) {
	try {
	    super.setCaretPosition(position);
	}
	catch(IllegalArgumentException e) {

	}
    }
}



