# netzack.sh
# Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
#
# This file is part of Netzack.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#!/bin/sh

CLASSPATH="%%PREFIX%%/%%PREFIX_LIB%%/%%JARFILE%%:${CLASSPATH}"

RUN="%%JAVA%% -classpath ${CLASSPATH} se.kth.netzack.Netzack $@"

debug=0
verbose=0
for o in $@
do
    case "$o" in
	-v) verbose=1
	    shift;;
	-d) verbose=1
	    debug=1
	    shift;;
    esac
done

if [ $debug -eq 0 ]
then
    if [ $verbose -eq 0 ]
    then
	env -u ZATACKA_VERBOSE -u ZATACKA_DEBUG ${RUN}
    else
	env -u ZATACKA_DEBUG ZATACKA_VERBOSE=1 ${RUN}
    fi
else
    env ZATACKA_VERBOSE=1 ZATACKA_DEBUG=1 ${RUN}
fi

if [ $? -eq 2 ]
then
    echo "Usage: $0 [OPTION]..."
    echo "Connect to game or start a game by default."
    echo ""
    echo "  -h          display this message"
    echo "  -version    display version information"
    echo "  -v		include verbose output"
    echo "  -d		include debug output"
    echo "  -n NAME 	set nickname to NAME"
    echo "  -c rrggbb	set color to a RGB value"
    echo "  -f FPS 	run with FPS frames per second"
fi
