/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.menu;

import gde.config.Settings;
import gde.data.AbstractRecord;
import gde.data.AbstractRecordSet;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.histo.recordings.TrailRecord;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.AxisEndValuesDialog;
import gde.ui.tab.GraphicsComposite;
import gde.ui.tab.GraphicsWindow;
import gde.utils.ColorUtils;
import gde.utils.TimeLine;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableItem;

public class CurveSelectorContextMenu {
    static final Logger log = Logger.getLogger(CurveSelectorContextMenu.class.getName());
    Menu menu;
    Menu lineWidthMenu;
    Menu lineTypeMenu;
    Menu axisEndValuesMenu;
    Menu axisNumberFormatMenu;
    Menu axisPositionMenu;
    Menu timeGridMenu;
    Menu valueGridMenu;
    Menu measurementMenu;
    MenuItem recordName;
    MenuItem lineVisible;
    MenuItem lineColor;
    MenuItem copyCurveCompare;
    MenuItem cleanCurveCompare;
    MenuItem lineWidth;
    MenuItem lineWidthMenuItem1;
    MenuItem lineWidthMenuItem2;
    MenuItem lineWidthMenuItem3;
    MenuItem lineType;
    MenuItem lineTypeMenuItem1;
    MenuItem lineTypeMenuItem2;
    MenuItem lineTypeMenuItem3;
    MenuItem smoothAtCurrentDropItem;
    MenuItem smoothVoltageCurveItem;
    MenuItem axisEndValues;
    MenuItem axisEndAuto;
    MenuItem axisEndRound;
    MenuItem axisStarts0;
    MenuItem axisEndManual;
    MenuItem axisNumberFormat;
    MenuItem axisNumberFormatAuto;
    MenuItem axisNumberFormat0;
    MenuItem axisNumberFormat1;
    MenuItem axisNumberFormat2;
    MenuItem axisNumberFormat3;
    MenuItem axisPosition;
    MenuItem axisPositionLeft;
    MenuItem axisPositionRight;
    MenuItem measurement;
    MenuItem measurementRecordName;
    MenuItem simpleMeasure;
    MenuItem deltaMeasure;
    MenuItem avgMedianMeasure;
    MenuItem timeGridColor;
    MenuItem timeGrid;
    MenuItem timeGridOff;
    MenuItem timeGridMain;
    MenuItem timeGridMod60;
    MenuItem valueGridRecordName;
    MenuItem valueGridColor;
    MenuItem valueGrid;
    MenuItem valueGridOff;
    MenuItem valueGridEveryTick;
    MenuItem valueGridEverySecond;
    AbstractRecordSet recordSet;
    final DataExplorer application;
    final Settings settings = Settings.getInstance();
    AxisEndValuesDialog axisEndValuesDialog;
    boolean isActiveColorDialog = false;
    boolean isActiveEnValueDialog = false;
    TableItem selectedItem;
    AbstractRecord actualRecord = null;
    boolean isRecordVisible = false;
    boolean isSmoothAtCurrentDrop = false;
    boolean isSmoothVoltageCurve = false;
    String recordNameKey = null;
    String recordNameMeasurement = " ";
    boolean isTypeCompare = false;
    boolean isTypeUtility = false;
    boolean isTypeHisto = false;

    public CurveSelectorContextMenu() {
        this.application = DataExplorer.getInstance();
        this.axisEndValuesDialog = new AxisEndValuesDialog(this.application.getShell(), 34912);
    }

    public void createMenu(final Menu popupmenu) {
        this.menu = popupmenu;
        try {
            popupmenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent evt) {
                    log.finest(() -> "popupmenu MenuListener.menuShown " + String.valueOf(evt));
                    CurveSelectorContextMenu.this.selectedItem = (TableItem)popupmenu.getData("curveSelectedItem");
                    if (CurveSelectorContextMenu.this.selectedItem != null && !CurveSelectorContextMenu.this.selectedItem.isDisposed()) {
                        log.finer(() -> CurveSelectorContextMenu.this.selectedItem.toString());
                        if (CurveSelectorContextMenu.this.selectedItem != null && !CurveSelectorContextMenu.this.selectedItem.isDisposed()) {
                            CurveSelectorContextMenu.this.recordNameKey = (String)popupmenu.getData("recordName");
                            String recordNameUi = (String)popupmenu.getData("nameReplacement") == null ? CurveSelectorContextMenu.this.recordNameKey : (String)popupmenu.getData("nameReplacement");
                            log.fine(() -> "===>>" + CurveSelectorContextMenu.this.recordNameKey);
                            CurveSelectorContextMenu.this.isTypeCompare = CurveSelectorContextMenu.this.application.isWindowVisible(GraphicsWindow.GraphicsType.COMPARE);
                            CurveSelectorContextMenu.this.isTypeUtility = CurveSelectorContextMenu.this.application.isWindowVisible(GraphicsWindow.GraphicsType.UTIL);
                            CurveSelectorContextMenu.this.isTypeHisto = CurveSelectorContextMenu.this.application.getHistoExplorer().map(h -> h.isHistoChartWindowVisible()).orElse(false);
                            CurveSelectorContextMenu.this.recordSet = CurveSelectorContextMenu.this.application.getRecordSetOfVisibleTab();
                            if (CurveSelectorContextMenu.this.recordSet != null) {
                                CurveSelectorContextMenu.this.setAllEnabled(true);
                                if (CurveSelectorContextMenu.this.recordNameKey != null && CurveSelectorContextMenu.this.recordNameKey.length() > 1) {
                                    CurveSelectorContextMenu.this.actualRecord = (AbstractRecord)CurveSelectorContextMenu.this.recordSet.get(CurveSelectorContextMenu.this.recordNameKey);
                                    if (CurveSelectorContextMenu.this.actualRecord != null) {
                                        CurveSelectorContextMenu.this.recordName.setText(">>>>  " + recordNameUi + "  <<<<");
                                        CurveSelectorContextMenu.this.lineVisible.setText(Messages.getString("GDE_MSGT0085"));
                                        CurveSelectorContextMenu.this.isRecordVisible = CurveSelectorContextMenu.this.actualRecord.isVisible();
                                        CurveSelectorContextMenu.this.lineVisible.setSelection(CurveSelectorContextMenu.this.isRecordVisible);
                                        CurveSelectorContextMenu.this.isSmoothAtCurrentDrop = CurveSelectorContextMenu.this.actualRecord.getAbstractParent().isSmoothAtCurrentDrop();
                                        CurveSelectorContextMenu.this.smoothAtCurrentDropItem.setSelection(CurveSelectorContextMenu.this.isSmoothAtCurrentDrop);
                                        if (CurveSelectorContextMenu.this.isTypeHisto) {
                                            CurveSelectorContextMenu.this.smoothAtCurrentDropItem.setEnabled(false);
                                            CurveSelectorContextMenu.this.timeGrid.setEnabled(false);
                                            CurveSelectorContextMenu.this.copyCurveCompare.setEnabled(false);
                                        }
                                        CurveSelectorContextMenu.this.isSmoothVoltageCurve = CurveSelectorContextMenu.this.actualRecord.getAbstractParent().isSmoothVoltageCurve();
                                        CurveSelectorContextMenu.this.smoothVoltageCurveItem.setSelection(CurveSelectorContextMenu.this.isSmoothVoltageCurve);
                                        if (!CurveSelectorContextMenu.this.isTypeHisto && CurveSelectorContextMenu.this.recordSet.getDevice().getName().startsWith("Ultra")) {
                                            CurveSelectorContextMenu.this.smoothVoltageCurveItem.setEnabled(true);
                                        } else {
                                            CurveSelectorContextMenu.this.smoothVoltageCurveItem.setEnabled(false);
                                        }
                                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                                            CurveSelectorContextMenu.this.copyCurveCompare.setEnabled(false);
                                        }
                                    } else {
                                        return;
                                    }
                                }
                                if (!CurveSelectorContextMenu.this.isTypeHisto && ((RecordSet)CurveSelectorContextMenu.this.recordSet).isZoomMode()) {
                                    CurveSelectorContextMenu.this.axisEndValues.setEnabled(false);
                                    CurveSelectorContextMenu.this.axisEndValues.setText(Messages.getString("GDE_MSGT0083"));
                                } else {
                                    CurveSelectorContextMenu.this.axisEndValues.setText(Messages.getString("GDE_MSGT0084"));
                                }
                                if (CurveSelectorContextMenu.this.isTypeCompare) {
                                    CurveSelectorContextMenu.this.smoothAtCurrentDropItem.setEnabled(false);
                                    if (CurveSelectorContextMenu.this.smoothVoltageCurveItem != null) {
                                        CurveSelectorContextMenu.this.smoothVoltageCurveItem.setEnabled(false);
                                    }
                                    CurveSelectorContextMenu.this.copyCurveCompare.setEnabled(false);
                                    CurveSelectorContextMenu.this.axisPosition.setEnabled(false);
                                    CurveSelectorContextMenu.this.axisEndValues.setEnabled(false);
                                    CurveSelectorContextMenu.this.deltaMeasure.setEnabled(false);
                                    CurveSelectorContextMenu.this.avgMedianMeasure.setEnabled(false);
                                }
                                if (CurveSelectorContextMenu.this.isTypeUtility) {
                                    CurveSelectorContextMenu.this.smoothAtCurrentDropItem.setEnabled(false);
                                    if (CurveSelectorContextMenu.this.smoothVoltageCurveItem != null) {
                                        CurveSelectorContextMenu.this.smoothVoltageCurveItem.setEnabled(false);
                                    }
                                    CurveSelectorContextMenu.this.copyCurveCompare.setEnabled(false);
                                    CurveSelectorContextMenu.this.measurement.setEnabled(false);
                                    CurveSelectorContextMenu.this.deltaMeasure.setEnabled(false);
                                    CurveSelectorContextMenu.this.avgMedianMeasure.setEnabled(false);
                                }
                                if (CurveSelectorContextMenu.this.isTypeHisto) {
                                    CurveSelectorContextMenu.this.avgMedianMeasure.setEnabled(false);
                                }
                                if (!CurveSelectorContextMenu.this.application.isWithCompareSet()) {
                                    CurveSelectorContextMenu.this.cleanCurveCompare.setEnabled(false);
                                }
                            } else {
                                CurveSelectorContextMenu.this.setAllEnabled(false);
                            }
                        }
                    } else {
                        CurveSelectorContextMenu.this.recordName.setText(">>>>  " + Messages.getString("GDE_MSGT0408") + "  <<<<");
                        CurveSelectorContextMenu.this.setAllEnabled(false);
                    }
                }

                public void menuHidden(MenuEvent evt) {
                    log.finest(() -> "popupmenu MenuListener.menuHidden " + String.valueOf(evt));
                }
            });
            popupmenu.addListener(16, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "widgetDisposed Action performed! " + String.valueOf(e));
                    CurveSelectorContextMenu.this.menu.setData("recordName", null);
                    CurveSelectorContextMenu.this.menu.setData("curveSelectedItem", null);
                }
            });
            this.recordName = new MenuItem(popupmenu, 0);
            new MenuItem(popupmenu, 2);
            this.lineVisible = new MenuItem(popupmenu, 32);
            this.lineVisible.setText(Messages.getString("GDE_MSGT0085"));
            this.lineVisible.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "lineVisible selected evt=" + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null) {
                        boolean checked = CurveSelectorContextMenu.this.lineVisible.getSelection();
                        CurveSelectorContextMenu.this.actualRecord.setVisible(checked);
                        CurveSelectorContextMenu.this.recordSet.syncScaleOfSyncableRecords();
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.lineColor = new MenuItem(popupmenu, 8);
            this.lineColor.setText(Messages.getString("GDE_MSGT0086"));
            this.lineColor.addListener(13, new Listener(){

                public void handleEvent(Event evt) {
                    log.finer(() -> "lineColor performed! " + String.valueOf(evt));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.selectedItem != null && !CurveSelectorContextMenu.this.selectedItem.isDisposed()) {
                        CurveSelectorContextMenu.this.isActiveColorDialog = true;
                        RGB rgb = CurveSelectorContextMenu.this.application.openColorDialog();
                        if (rgb != null) {
                            Color color = SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue);
                            CurveSelectorContextMenu.this.selectedItem.setForeground(color);
                            CurveSelectorContextMenu.this.actualRecord.setRGB(ColorUtils.toRGB(rgb.red, rgb.green, rgb.blue));
                            if (!CurveSelectorContextMenu.this.isRecordVisible) {
                                CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                            }
                        }
                        CurveSelectorContextMenu.this.isActiveColorDialog = false;
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.lineWidth = new MenuItem(popupmenu, 64);
            this.lineWidth.setText(Messages.getString("GDE_MSGT0087"));
            this.lineWidthMenu = new Menu(this.lineWidth);
            this.lineWidth.setMenu(this.lineWidthMenu);
            this.lineWidthMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent evt) {
                    log.finest(() -> "lineWidthMenu MenuListener " + String.valueOf(evt));
                    if (CurveSelectorContextMenu.this.actualRecord != null && CurveSelectorContextMenu.this.selectedItem != null && !CurveSelectorContextMenu.this.selectedItem.isDisposed()) {
                        int width = CurveSelectorContextMenu.this.actualRecord.getLineWidth();
                        switch (width) {
                            case 1: {
                                CurveSelectorContextMenu.this.lineWidthMenuItem1.setSelection(true);
                                CurveSelectorContextMenu.this.lineWidthMenuItem2.setSelection(false);
                                CurveSelectorContextMenu.this.lineWidthMenuItem3.setSelection(false);
                                break;
                            }
                            case 2: {
                                CurveSelectorContextMenu.this.lineWidthMenuItem1.setSelection(false);
                                CurveSelectorContextMenu.this.lineWidthMenuItem2.setSelection(true);
                                CurveSelectorContextMenu.this.lineWidthMenuItem3.setSelection(false);
                                break;
                            }
                            case 3: {
                                CurveSelectorContextMenu.this.lineWidthMenuItem1.setSelection(false);
                                CurveSelectorContextMenu.this.lineWidthMenuItem2.setSelection(false);
                                CurveSelectorContextMenu.this.lineWidthMenuItem3.setSelection(true);
                                break;
                            }
                            default: {
                                CurveSelectorContextMenu.this.lineWidthMenuItem1.setSelection(false);
                                CurveSelectorContextMenu.this.lineWidthMenuItem2.setSelection(false);
                                CurveSelectorContextMenu.this.lineWidthMenuItem3.setSelection(false);
                            }
                        }
                    }
                }

                public void menuHidden(MenuEvent evt) {
                    log.finest(() -> "lineWidthMenu MenuListener " + String.valueOf(evt));
                }
            });
            this.lineWidthMenuItem1 = new MenuItem(this.lineWidthMenu, 32);
            this.lineWidthMenuItem1.setImage(SWTResourceManager.getImage("gde/resource/LineWidth1.gif"));
            this.lineWidthMenuItem1.setText(Messages.getString("GDE_MSGT0088"));
            this.lineWidthMenuItem1.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> Messages.getString("GDE_MSGT0089") + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setLineWidth(1);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.lineWidthMenuItem2.setSelection(false);
                        CurveSelectorContextMenu.this.lineWidthMenuItem3.setSelection(false);
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.lineWidthMenuItem2 = new MenuItem(this.lineWidthMenu, 32);
            this.lineWidthMenuItem2.setImage(SWTResourceManager.getImage("gde/resource/LineWidth2.gif"));
            this.lineWidthMenuItem2.setText(Messages.getString("GDE_MSGT0090"));
            this.lineWidthMenuItem2.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> Messages.getString("GDE_MSGT0091") + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setLineWidth(2);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.lineWidthMenuItem1.setSelection(false);
                        CurveSelectorContextMenu.this.lineWidthMenuItem3.setSelection(false);
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.lineWidthMenuItem3 = new MenuItem(this.lineWidthMenu, 32);
            this.lineWidthMenuItem3.setImage(SWTResourceManager.getImage("gde/resource/LineWidth3.gif"));
            this.lineWidthMenuItem3.setText(Messages.getString("GDE_MSGT0092"));
            this.lineWidthMenuItem3.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> Messages.getString("GDE_MSGT0093") + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setLineWidth(3);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.lineWidthMenuItem1.setSelection(false);
                        CurveSelectorContextMenu.this.lineWidthMenuItem2.setSelection(false);
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.lineType = new MenuItem(popupmenu, 64);
            this.lineType.setText(Messages.getString("GDE_MSGT0094"));
            this.lineTypeMenu = new Menu(this.lineType);
            this.lineType.setMenu(this.lineTypeMenu);
            this.lineTypeMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent evt) {
                    log.finest(() -> "lineTypeMenu MenuListener " + String.valueOf(evt));
                    if (CurveSelectorContextMenu.this.actualRecord != null && CurveSelectorContextMenu.this.selectedItem != null && !CurveSelectorContextMenu.this.selectedItem.isDisposed()) {
                        int type = CurveSelectorContextMenu.this.actualRecord.getLineStyle();
                        switch (type) {
                            case 1: {
                                CurveSelectorContextMenu.this.lineTypeMenuItem1.setSelection(true);
                                CurveSelectorContextMenu.this.lineTypeMenuItem2.setSelection(false);
                                CurveSelectorContextMenu.this.lineTypeMenuItem3.setSelection(false);
                                break;
                            }
                            case 2: {
                                CurveSelectorContextMenu.this.lineTypeMenuItem1.setSelection(false);
                                CurveSelectorContextMenu.this.lineTypeMenuItem2.setSelection(true);
                                CurveSelectorContextMenu.this.lineTypeMenuItem3.setSelection(false);
                                break;
                            }
                            case 3: {
                                CurveSelectorContextMenu.this.lineTypeMenuItem1.setSelection(false);
                                CurveSelectorContextMenu.this.lineTypeMenuItem2.setSelection(false);
                                CurveSelectorContextMenu.this.lineTypeMenuItem3.setSelection(true);
                                break;
                            }
                            default: {
                                CurveSelectorContextMenu.this.lineTypeMenuItem1.setSelection(false);
                                CurveSelectorContextMenu.this.lineTypeMenuItem2.setSelection(false);
                                CurveSelectorContextMenu.this.lineTypeMenuItem3.setSelection(false);
                            }
                        }
                    }
                }

                public void menuHidden(MenuEvent evt) {
                    log.finest(() -> "lineTypeMenu MenuListener " + String.valueOf(evt));
                }
            });
            this.lineTypeMenuItem1 = new MenuItem(this.lineTypeMenu, 32);
            this.lineTypeMenuItem1.setImage(SWTResourceManager.getImage("gde/resource/LineType1.gif"));
            this.lineTypeMenuItem1.setText(Messages.getString("GDE_MSGT0095"));
            this.lineTypeMenuItem1.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "lineTypeMenuItem1 " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setLineStyle(1);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.lineTypeMenuItem2.setSelection(false);
                        CurveSelectorContextMenu.this.lineTypeMenuItem3.setSelection(false);
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.lineTypeMenuItem2 = new MenuItem(this.lineTypeMenu, 32);
            this.lineTypeMenuItem2.setImage(SWTResourceManager.getImage("gde/resource/LineType2.gif"));
            this.lineTypeMenuItem2.setText(Messages.getString("GDE_MSGT0096"));
            this.lineTypeMenuItem2.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "lineTypeMenuItem2 " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setLineStyle(2);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.lineTypeMenuItem1.setSelection(false);
                        CurveSelectorContextMenu.this.lineTypeMenuItem3.setSelection(false);
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.lineTypeMenuItem3 = new MenuItem(this.lineTypeMenu, 32);
            this.lineTypeMenuItem3.setImage(SWTResourceManager.getImage("gde/resource/LineType3.gif"));
            this.lineTypeMenuItem3.setText(Messages.getString("GDE_MSGT0097"));
            this.lineTypeMenuItem3.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "lineTypeMenuItem3 " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setLineStyle(3);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.lineTypeMenuItem1.setSelection(false);
                        CurveSelectorContextMenu.this.lineTypeMenuItem2.setSelection(false);
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.smoothAtCurrentDropItem = new MenuItem(popupmenu, 32);
            this.smoothAtCurrentDropItem.setText(Messages.getString("GDE_MSGT0335"));
            this.smoothAtCurrentDropItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "smoothAtCurrentDropItem selected evt=" + String.valueOf(e));
                    if (!CurveSelectorContextMenu.this.isTypeHisto && CurveSelectorContextMenu.this.recordSet != null) {
                        boolean checked = CurveSelectorContextMenu.this.smoothAtCurrentDropItem.getSelection();
                        ((RecordSet)CurveSelectorContextMenu.this.recordSet).setSmoothAtCurrentDrop(checked);
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.smoothVoltageCurveItem = new MenuItem(popupmenu, 32);
            this.smoothVoltageCurveItem.setText(Messages.getString("GDE_MSGT0685"));
            this.smoothVoltageCurveItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "smoothVoltageCurveItem selected evt=" + String.valueOf(e));
                    if (!CurveSelectorContextMenu.this.isTypeHisto && CurveSelectorContextMenu.this.recordSet != null) {
                        boolean checked = CurveSelectorContextMenu.this.smoothVoltageCurveItem.getSelection();
                        ((RecordSet)CurveSelectorContextMenu.this.recordSet).setSmoothVoltageCurve(checked);
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            new MenuItem(popupmenu, 2);
            this.axisEndValues = new MenuItem(popupmenu, 64);
            this.axisEndValues.setText(Messages.getString("GDE_MSGT0098"));
            this.axisEndValuesMenu = new Menu(this.axisEndValues);
            this.axisEndValues.setMenu(this.axisEndValuesMenu);
            this.axisEndValuesMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent evt) {
                    log.finest(() -> "axisEndValuesMenu MenuListener " + String.valueOf(evt));
                    if (CurveSelectorContextMenu.this.actualRecord != null && CurveSelectorContextMenu.this.selectedItem != null && !CurveSelectorContextMenu.this.selectedItem.isDisposed()) {
                        boolean isRounded = CurveSelectorContextMenu.this.actualRecord.isRoundOut();
                        boolean isStart0 = CurveSelectorContextMenu.this.actualRecord.isStartpointZero();
                        boolean isManual = CurveSelectorContextMenu.this.actualRecord.isStartEndDefined();
                        boolean isAuto = !isRounded && !isManual;
                        CurveSelectorContextMenu.this.axisEndAuto.setSelection(isAuto);
                        CurveSelectorContextMenu.this.axisEndRound.setSelection(isRounded);
                        CurveSelectorContextMenu.this.axisStarts0.setSelection(isStart0);
                        CurveSelectorContextMenu.this.axisEndManual.setSelection(isManual);
                    }
                }

                public void menuHidden(MenuEvent evt) {
                    log.finest(() -> "axisEndValuesMenu MenuListener " + String.valueOf(evt));
                }
            });
            this.axisEndAuto = new MenuItem(this.axisEndValuesMenu, 32);
            this.axisEndAuto.setText(Messages.getString("GDE_MSGT0099"));
            this.axisEndAuto.setSelection(true);
            this.axisEndAuto.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "axisEndAuto.SelectionListener = " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setStartpointZero(false);
                        CurveSelectorContextMenu.this.axisEndRound.setSelection(false);
                        CurveSelectorContextMenu.this.actualRecord.setRoundOut(false);
                        CurveSelectorContextMenu.this.axisEndManual.setSelection(false);
                        CurveSelectorContextMenu.this.actualRecord.setStartEndDefined(false, 0.0, 0.0);
                        CurveSelectorContextMenu.this.actualRecord.getAbstractParent().syncMasterSlaveRecords(CurveSelectorContextMenu.this.actualRecord, 0);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.axisEndRound = new MenuItem(this.axisEndValuesMenu, 32);
            this.axisEndRound.setText(Messages.getString("GDE_MSGT0101"));
            this.axisEndRound.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "axisEndRound.SelectionListener = " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        if (CurveSelectorContextMenu.this.axisEndRound.getSelection()) {
                            CurveSelectorContextMenu.this.axisEndAuto.setSelection(false);
                            CurveSelectorContextMenu.this.actualRecord.setRoundOut(true);
                            CurveSelectorContextMenu.this.axisEndManual.setSelection(false);
                            CurveSelectorContextMenu.this.actualRecord.setStartEndDefined(false, 0.0, 0.0);
                        } else {
                            CurveSelectorContextMenu.this.axisEndAuto.setSelection(true);
                            CurveSelectorContextMenu.this.actualRecord.setRoundOut(false);
                            CurveSelectorContextMenu.this.axisEndManual.setSelection(false);
                            CurveSelectorContextMenu.this.actualRecord.setStartEndDefined(false, 0.0, 0.0);
                        }
                        CurveSelectorContextMenu.this.actualRecord.getAbstractParent().syncMasterSlaveRecords(CurveSelectorContextMenu.this.actualRecord, 0);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.axisStarts0 = new MenuItem(this.axisEndValuesMenu, 32);
            this.axisStarts0.setText(Messages.getString("GDE_MSGT0103"));
            this.axisStarts0.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "axisStarts0 " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        if (CurveSelectorContextMenu.this.axisStarts0.getSelection()) {
                            CurveSelectorContextMenu.this.actualRecord.setStartpointZero(true);
                            CurveSelectorContextMenu.this.axisEndManual.setSelection(false);
                            CurveSelectorContextMenu.this.actualRecord.setStartEndDefined(false, 0.0, 0.0);
                        } else {
                            CurveSelectorContextMenu.this.actualRecord.setStartpointZero(false);
                            CurveSelectorContextMenu.this.axisEndManual.setSelection(false);
                            CurveSelectorContextMenu.this.actualRecord.setStartEndDefined(false, 0.0, 0.0);
                        }
                        CurveSelectorContextMenu.this.actualRecord.getAbstractParent().syncMasterSlaveRecords(CurveSelectorContextMenu.this.actualRecord, 0);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.axisEndManual = new MenuItem(this.axisEndValuesMenu, 32);
            this.axisEndManual.setText(Messages.getString("GDE_MSGT0104"));
            this.axisEndManual.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "axisEndManual Action performed! " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.isActiveEnValueDialog = true;
                        CurveSelectorContextMenu.this.axisEndManual.setSelection(true);
                        CurveSelectorContextMenu.this.axisEndAuto.setSelection(false);
                        CurveSelectorContextMenu.this.axisStarts0.setSelection(false);
                        AbstractRecord record = CurveSelectorContextMenu.this.actualRecord;
                        record.setStartpointZero(false);
                        CurveSelectorContextMenu.this.axisEndRound.setSelection(false);
                        record.setRoundOut(false);
                        double[] oldMinMax = new double[]{record.getMinScaleValue(), record.getMaxScaleValue()};
                        double[] newMinMax = CurveSelectorContextMenu.this.axisEndValuesDialog.open(oldMinMax);
                        record.setStartEndDefined(true, newMinMax[0], newMinMax[1]);
                        CurveSelectorContextMenu.this.actualRecord.getAbstractParent().syncMasterSlaveRecords(CurveSelectorContextMenu.this.actualRecord, 0);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.isActiveEnValueDialog = false;
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.axisNumberFormat = new MenuItem(popupmenu, 64);
            this.axisNumberFormat.setText(Messages.getString("GDE_MSGT0105"));
            this.axisNumberFormatMenu = new Menu(this.axisNumberFormat);
            this.axisNumberFormat.setMenu(this.axisNumberFormatMenu);
            this.axisNumberFormatMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent evt) {
                    log.finest(() -> "axisNumberFormatMenu MenuListener.menuShown " + String.valueOf(evt));
                    if (CurveSelectorContextMenu.this.selectedItem != null && !CurveSelectorContextMenu.this.selectedItem.isDisposed()) {
                        int format = CurveSelectorContextMenu.this.actualRecord.getNumberFormat();
                        switch (format) {
                            case -1: {
                                CurveSelectorContextMenu.this.axisNumberFormatAuto.setSelection(true);
                                CurveSelectorContextMenu.this.axisNumberFormat0.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat1.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat2.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat3.setSelection(false);
                                break;
                            }
                            case 0: {
                                CurveSelectorContextMenu.this.axisNumberFormatAuto.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat0.setSelection(true);
                                CurveSelectorContextMenu.this.axisNumberFormat1.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat2.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat3.setSelection(false);
                                break;
                            }
                            case 1: {
                                CurveSelectorContextMenu.this.axisNumberFormatAuto.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat0.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat1.setSelection(true);
                                CurveSelectorContextMenu.this.axisNumberFormat2.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat3.setSelection(false);
                                break;
                            }
                            default: {
                                CurveSelectorContextMenu.this.axisNumberFormatAuto.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat0.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat1.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat2.setSelection(true);
                                CurveSelectorContextMenu.this.axisNumberFormat3.setSelection(false);
                                break;
                            }
                            case 3: {
                                CurveSelectorContextMenu.this.axisNumberFormatAuto.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat0.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat1.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat2.setSelection(false);
                                CurveSelectorContextMenu.this.axisNumberFormat3.setSelection(true);
                            }
                        }
                    }
                }

                public void menuHidden(MenuEvent evt) {
                    log.finest(() -> "axisNumberFormatMenu MenuListener.menuHidden " + String.valueOf(evt));
                }
            });
            this.axisNumberFormatAuto = new MenuItem(this.axisNumberFormatMenu, 32);
            this.axisNumberFormatAuto.setText(Messages.getString("GDE_MSGT0099"));
            this.axisNumberFormatAuto.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "axisNumberFormatAuto " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setNumberFormat(-1);
                        CurveSelectorContextMenu.this.actualRecord.getAbstractParent().syncMasterSlaveRecords(CurveSelectorContextMenu.this.actualRecord, 1);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.axisNumberFormat0 = new MenuItem(this.axisNumberFormatMenu, 32);
            this.axisNumberFormat0.setText(Messages.getString("GDE_MSGT0106"));
            this.axisNumberFormat0.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "axisNumberFormat0 " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setNumberFormat(0);
                        CurveSelectorContextMenu.this.actualRecord.getAbstractParent().syncMasterSlaveRecords(CurveSelectorContextMenu.this.actualRecord, 1);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.axisNumberFormat1 = new MenuItem(this.axisNumberFormatMenu, 32);
            this.axisNumberFormat1.setText(Messages.getString("GDE_MSGT0107"));
            this.axisNumberFormat1.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "axisNumberFormat1 " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setNumberFormat(1);
                        CurveSelectorContextMenu.this.actualRecord.getAbstractParent().syncMasterSlaveRecords(CurveSelectorContextMenu.this.actualRecord, 1);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.axisNumberFormat2 = new MenuItem(this.axisNumberFormatMenu, 32);
            this.axisNumberFormat2.setText(Messages.getString("GDE_MSGT0108"));
            this.axisNumberFormat2.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "axisNumberFormat2 " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setNumberFormat(2);
                        CurveSelectorContextMenu.this.actualRecord.getAbstractParent().syncMasterSlaveRecords(CurveSelectorContextMenu.this.actualRecord, 1);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.axisNumberFormat3 = new MenuItem(this.axisNumberFormatMenu, 32);
            this.axisNumberFormat3.setText(Messages.getString("GDE_MSGT0109"));
            this.axisNumberFormat3.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "axisNumberFormat3 " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setNumberFormat(3);
                        CurveSelectorContextMenu.this.actualRecord.getAbstractParent().syncMasterSlaveRecords(CurveSelectorContextMenu.this.actualRecord, 1);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.axisPosition = new MenuItem(popupmenu, 64);
            this.axisPosition.setText(Messages.getString("GDE_MSGT0110"));
            this.axisPositionMenu = new Menu(this.axisPosition);
            this.axisPosition.setMenu(this.axisPositionMenu);
            this.axisPositionMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent evt) {
                    log.finest(() -> "axisPositionMenu MenuListener " + String.valueOf(evt));
                    if (CurveSelectorContextMenu.this.actualRecord != null && CurveSelectorContextMenu.this.selectedItem != null && !CurveSelectorContextMenu.this.selectedItem.isDisposed()) {
                        boolean isLeft = CurveSelectorContextMenu.this.actualRecord.isPositionLeft();
                        if (isLeft) {
                            CurveSelectorContextMenu.this.axisPositionLeft.setSelection(true);
                            CurveSelectorContextMenu.this.axisPositionRight.setSelection(false);
                        } else {
                            CurveSelectorContextMenu.this.axisPositionLeft.setSelection(false);
                            CurveSelectorContextMenu.this.axisPositionRight.setSelection(true);
                        }
                    }
                }

                public void menuHidden(MenuEvent evt) {
                    log.finest(() -> "axisPositionMenu MenuListener " + String.valueOf(evt));
                }
            });
            this.axisPositionLeft = new MenuItem(this.axisPositionMenu, 32);
            this.axisPositionLeft.setText(Messages.getString("GDE_MSGT0111"));
            this.axisPositionLeft.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "axisPositionLeft Action performed! " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setPositionLeft(true);
                        CurveSelectorContextMenu.this.actualRecord.getAbstractParent().syncMasterSlaveRecords(CurveSelectorContextMenu.this.actualRecord, 2);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            this.axisPositionRight = new MenuItem(this.axisPositionMenu, 32);
            this.axisPositionRight.setText(Messages.getString("GDE_MSGT0112"));
            this.axisPositionRight.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "axisPositionRight Action performed! " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.actualRecord.setPositionLeft(false);
                        CurveSelectorContextMenu.this.actualRecord.getAbstractParent().syncMasterSlaveRecords(CurveSelectorContextMenu.this.actualRecord, 2);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                    }
                }
            });
            new MenuItem(popupmenu, 2);
            this.timeGrid = new MenuItem(popupmenu, 64);
            this.timeGrid.setText(Messages.getString("GDE_MSGT0113"));
            this.timeGridMenu = new Menu(this.timeGrid);
            this.timeGrid.setMenu(this.timeGridMenu);
            this.timeGridMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent evt) {
                    log.finest(() -> "timeGridMenu MenuListener " + String.valueOf(evt));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.selectedItem != null && !CurveSelectorContextMenu.this.selectedItem.isDisposed()) {
                        int gridType = CurveSelectorContextMenu.this.isTypeHisto ? 0 : ((RecordSet)CurveSelectorContextMenu.this.recordSet).getTimeGridType();
                        switch (gridType) {
                            case 1: {
                                CurveSelectorContextMenu.this.timeGridOff.setSelection(false);
                                CurveSelectorContextMenu.this.timeGridMain.setSelection(true);
                                CurveSelectorContextMenu.this.timeGridMod60.setSelection(false);
                                break;
                            }
                            case 2: {
                                CurveSelectorContextMenu.this.timeGridOff.setSelection(false);
                                CurveSelectorContextMenu.this.timeGridMain.setSelection(false);
                                break;
                            }
                            default: {
                                CurveSelectorContextMenu.this.timeGridOff.setSelection(true);
                                CurveSelectorContextMenu.this.timeGridMain.setSelection(false);
                                CurveSelectorContextMenu.this.timeGridMod60.setSelection(false);
                            }
                        }
                    }
                }

                public void menuHidden(MenuEvent evt) {
                    log.finest(() -> "timeGridMenu MenuListener " + String.valueOf(evt));
                }
            });
            this.timeGridOff = new MenuItem(this.timeGridMenu, 32);
            this.timeGridOff.setText(Messages.getString("GDE_MSGT0114"));
            this.timeGridOff.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "timeGridOff Action performed! " + String.valueOf(e));
                    if (!CurveSelectorContextMenu.this.isTypeHisto && CurveSelectorContextMenu.this.recordSet != null) {
                        ((RecordSet)CurveSelectorContextMenu.this.recordSet).setTimeGridType(0);
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                        if (CurveSelectorContextMenu.this.isTypeCompare) {
                            CurveSelectorContextMenu.this.settings.setGridCompareWindowVerticalType(0);
                        }
                    }
                }
            });
            this.timeGridMain = new MenuItem(this.timeGridMenu, 32);
            this.timeGridMain.setText(Messages.getString("GDE_MSGT0115"));
            this.timeGridMain.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "timeGridMain Action performed! " + String.valueOf(e));
                    if (!CurveSelectorContextMenu.this.isTypeHisto && CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        ((RecordSet)CurveSelectorContextMenu.this.recordSet).setTimeGridType(1);
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                        if (CurveSelectorContextMenu.this.isTypeCompare) {
                            CurveSelectorContextMenu.this.settings.setGridCompareWindowVerticalType(1);
                            if (!CurveSelectorContextMenu.this.isRecordVisible) {
                                CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                            }
                            CurveSelectorContextMenu.this.application.updateCompareWindow();
                        }
                    }
                }
            });
            this.timeGridMod60 = new MenuItem(this.timeGridMenu, 32);
            this.timeGridMod60.setText(Messages.getString("GDE_MSGT0116"));
            this.timeGridMod60.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "timeGridMod60 Action performed! " + String.valueOf(e));
                    if (!CurveSelectorContextMenu.this.isTypeHisto && CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        ((RecordSet)CurveSelectorContextMenu.this.recordSet).setTimeGridType(2);
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                        if (CurveSelectorContextMenu.this.isTypeCompare) {
                            CurveSelectorContextMenu.this.settings.setGridCompareWindowVerticalType(2);
                            if (!CurveSelectorContextMenu.this.isRecordVisible) {
                                CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                            }
                            CurveSelectorContextMenu.this.application.updateCompareWindow();
                        }
                    }
                }
            });
            this.timeGridColor = new MenuItem(this.timeGridMenu, 8);
            this.timeGridColor.setText(Messages.getString("GDE_MSGT0117"));
            this.timeGridColor.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    RGB rgb;
                    log.finest(() -> "timeGridColor Action performed! " + String.valueOf(e));
                    if (!CurveSelectorContextMenu.this.isTypeHisto && CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null && (rgb = CurveSelectorContextMenu.this.application.openColorDialog()) != null) {
                        ((RecordSet)CurveSelectorContextMenu.this.recordSet).setTimeGridColor(SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue));
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                        if (CurveSelectorContextMenu.this.isTypeCompare) {
                            CurveSelectorContextMenu.this.settings.setGridCompareWindowVerticalColor(SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue));
                            if (!CurveSelectorContextMenu.this.isRecordVisible) {
                                CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                            }
                            CurveSelectorContextMenu.this.application.updateCompareWindow();
                        }
                    }
                }
            });
            this.valueGrid = new MenuItem(popupmenu, 64);
            this.valueGrid.setText(Messages.getString("GDE_MSGT0100"));
            this.valueGridMenu = new Menu(this.valueGrid);
            this.valueGrid.setMenu(this.valueGridMenu);
            this.valueGridMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent evt) {
                    int selectedValueGridOrdinal;
                    log.finest(() -> "horizontalGridMenu MenuListener " + String.valueOf(evt));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.selectedItem != null && !CurveSelectorContextMenu.this.selectedItem.isDisposed() && (selectedValueGridOrdinal = CurveSelectorContextMenu.this.recordSet.getValueGridRecordOrdinal()) >= 0) {
                        AbstractRecord abstractRecord = CurveSelectorContextMenu.this.recordSet.isCompareSet() ? CurveSelectorContextMenu.this.recordSet.get(0) : CurveSelectorContextMenu.this.recordSet.get(selectedValueGridOrdinal);
                        String recordNameUi = abstractRecord instanceof TrailRecord ? ((TrailRecord)abstractRecord).getNameReplacement() : abstractRecord.getName();
                        CurveSelectorContextMenu.this.valueGridRecordName.setText(Messages.getString("GDE_MSGT0118") + recordNameUi);
                        int gridType = CurveSelectorContextMenu.this.recordSet.getValueGridType();
                        switch (gridType) {
                            case 1: {
                                CurveSelectorContextMenu.this.valueGridOff.setSelection(false);
                                CurveSelectorContextMenu.this.valueGridEveryTick.setSelection(true);
                                CurveSelectorContextMenu.this.valueGridEverySecond.setSelection(false);
                                break;
                            }
                            case 2: {
                                CurveSelectorContextMenu.this.valueGridOff.setSelection(false);
                                CurveSelectorContextMenu.this.valueGridEveryTick.setSelection(false);
                                CurveSelectorContextMenu.this.valueGridEverySecond.setSelection(true);
                                break;
                            }
                            default: {
                                CurveSelectorContextMenu.this.valueGridOff.setSelection(true);
                                CurveSelectorContextMenu.this.valueGridEveryTick.setSelection(false);
                                CurveSelectorContextMenu.this.valueGridEverySecond.setSelection(false);
                            }
                        }
                    }
                }

                public void menuHidden(MenuEvent evt) {
                    log.finest(() -> "horizontalGridMenu MenuListener " + String.valueOf(evt));
                }
            });
            this.valueGridRecordName = new MenuItem(this.valueGridMenu, 0);
            new MenuItem(this.valueGridMenu, 2);
            this.valueGridOff = new MenuItem(this.valueGridMenu, 32);
            this.valueGridOff.setText(Messages.getString("GDE_MSGT0119"));
            this.valueGridOff.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "horizontalGridOff Action performed! " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.recordSet.setValueGridType(0);
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                        CurveSelectorContextMenu.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                        if (CurveSelectorContextMenu.this.isTypeCompare) {
                            CurveSelectorContextMenu.this.settings.setGridCompareWindowHorizontalType(0);
                        }
                    }
                }
            });
            this.valueGridEveryTick = new MenuItem(this.valueGridMenu, 32);
            this.valueGridEveryTick.setText(Messages.getString("GDE_MSGT0120"));
            this.valueGridEveryTick.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "horizontalGridMain Action performed! " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.recordSet.setValueGridType(1);
                        CurveSelectorContextMenu.this.recordSet.setValueGridRecordOrdinal(!CurveSelectorContextMenu.this.isTypeHisto && ((RecordSet)CurveSelectorContextMenu.this.recordSet).isCompareSet() ? 0 : CurveSelectorContextMenu.this.actualRecord.getOrdinal());
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                        CurveSelectorContextMenu.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                        if (CurveSelectorContextMenu.this.isTypeCompare) {
                            CurveSelectorContextMenu.this.settings.setGridCompareWindowHorizontalType(1);
                            if (!CurveSelectorContextMenu.this.isRecordVisible) {
                                CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                            }
                            CurveSelectorContextMenu.this.application.updateCompareWindow();
                        }
                    }
                }
            });
            this.valueGridEverySecond = new MenuItem(this.valueGridMenu, 32);
            this.valueGridEverySecond.setText(Messages.getString("GDE_MSGT0121"));
            this.valueGridEverySecond.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "horizontalGridMod60 Action performed! " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null) {
                        CurveSelectorContextMenu.this.recordSet.setValueGridType(2);
                        CurveSelectorContextMenu.this.recordSet.setValueGridRecordOrdinal(CurveSelectorContextMenu.this.actualRecord.getOrdinal());
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                        CurveSelectorContextMenu.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                        if (CurveSelectorContextMenu.this.isTypeCompare) {
                            CurveSelectorContextMenu.this.settings.setGridCompareWindowHorizontalType(2);
                            if (!CurveSelectorContextMenu.this.isRecordVisible) {
                                CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                            }
                            CurveSelectorContextMenu.this.application.updateCompareWindow();
                        }
                    }
                }
            });
            this.valueGridColor = new MenuItem(this.valueGridMenu, 8);
            this.valueGridColor.setText(Messages.getString("GDE_MSGT0122"));
            this.valueGridColor.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    RGB rgb;
                    log.finest(() -> "horizontalGridColor Action performed! " + String.valueOf(e));
                    if (CurveSelectorContextMenu.this.recordSet != null && CurveSelectorContextMenu.this.actualRecord != null && (rgb = CurveSelectorContextMenu.this.application.openColorDialog()) != null) {
                        CurveSelectorContextMenu.this.recordSet.setValueGridColor(SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue));
                        if (!CurveSelectorContextMenu.this.isRecordVisible) {
                            CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                        }
                        CurveSelectorContextMenu.this.application.updateGraphicsWindow();
                        CurveSelectorContextMenu.this.application.getHistoExplorer().ifPresent(h -> h.updateHistoTabs(false, false, true));
                        if (CurveSelectorContextMenu.this.isTypeCompare) {
                            CurveSelectorContextMenu.this.settings.setGridCompareWindowHorizontalColor(SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue));
                            if (!CurveSelectorContextMenu.this.isRecordVisible) {
                                CurveSelectorContextMenu.this.actualRecord.setVisible(true);
                            }
                            CurveSelectorContextMenu.this.application.updateCompareWindow();
                        }
                    }
                }
            });
            new MenuItem(popupmenu, 2);
            this.measurement = new MenuItem(popupmenu, 64);
            this.measurement.setText(Messages.getString("GDE_MSGT0123"));
            this.measurementMenu = new Menu(this.valueGrid);
            this.measurement.setMenu(this.measurementMenu);
            this.measurementMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent evt) {
                    log.finest(() -> "measurementMenu MenuListener " + String.valueOf(evt));
                    if (CurveSelectorContextMenu.this.selectedItem != null && !CurveSelectorContextMenu.this.selectedItem.isDisposed()) {
                        AbstractRecord abstractRecord = (AbstractRecord)CurveSelectorContextMenu.this.recordSet.get(CurveSelectorContextMenu.this.recordNameMeasurement);
                        if (abstractRecord != null) {
                            String recordNameUi = abstractRecord instanceof TrailRecord ? ((TrailRecord)abstractRecord).getNameReplacement() : CurveSelectorContextMenu.this.recordNameMeasurement;
                            CurveSelectorContextMenu.this.measurementRecordName.setText(Messages.getString("GDE_MSGT0124") + recordNameUi);
                        } else {
                            CurveSelectorContextMenu.this.measurementRecordName.setText(Messages.getString("GDE_MSGT0124") + CurveSelectorContextMenu.this.recordNameMeasurement);
                        }
                    }
                }

                public void menuHidden(MenuEvent evt) {
                    log.finest(() -> "measurementMenu MenuListener " + String.valueOf(evt));
                }
            });
            this.measurementRecordName = new MenuItem(this.measurementMenu, 0);
            new MenuItem(this.measurementMenu, 2);
            this.simpleMeasure = new MenuItem(this.measurementMenu, 32);
            this.simpleMeasure.setText(Messages.getString("GDE_MSGT0125"));
            this.simpleMeasure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.finest(() -> "measure.widgetSelected, event=" + String.valueOf(evt));
                    CurveSelectorContextMenu.this.setMeasurement(CurveSelectorContextMenu.this.recordNameKey, CurveSelectorContextMenu.this.simpleMeasure.getSelection());
                }
            });
            this.deltaMeasure = new MenuItem(this.measurementMenu, 32);
            this.deltaMeasure.setText(Messages.getString("GDE_MSGT0126"));
            this.deltaMeasure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.finest(() -> "deltaMeasure.widgetSelected, event=" + String.valueOf(evt));
                    CurveSelectorContextMenu.this.setDeltaMeasurement(CurveSelectorContextMenu.this.recordNameKey, CurveSelectorContextMenu.this.deltaMeasure.getSelection());
                }
            });
            this.avgMedianMeasure = new MenuItem(this.measurementMenu, 32);
            this.avgMedianMeasure.setText(Messages.getString("GDE_MSGT0972"));
            this.avgMedianMeasure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.finest(() -> "avgMedianMeasure.widgetSelected, event=" + String.valueOf(evt));
                    CurveSelectorContextMenu.this.setAvgMedianMeasurement(CurveSelectorContextMenu.this.recordNameKey, CurveSelectorContextMenu.this.avgMedianMeasure.getSelection());
                }
            });
            new MenuItem(popupmenu, 2);
            this.copyCurveCompare = new MenuItem(popupmenu, 8);
            this.copyCurveCompare.setText(Messages.getString("GDE_MSGT0127"));
            this.copyCurveCompare.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "copyCurveCompare Action performed! " + String.valueOf(e));
                    CurveSelectorContextMenu.this.application.createCompareWindowTabItem();
                    String copyFromRecordKey = (String)popupmenu.getData("recordName");
                    RecordSet copyFromRecordSet = Channels.getInstance().getActiveChannel().getActiveRecordSet();
                    if (copyFromRecordSet != null && copyFromRecordKey != null) {
                        Record copyFromRecord = copyFromRecordSet.get(copyFromRecordKey);
                        if (copyFromRecord != null && copyFromRecord.isVisible()) {
                            RecordSet compareSet;
                            if (CurveSelectorContextMenu.this.application.isWithCompareSet()) {
                                compareSet = CurveSelectorContextMenu.this.application.getCompareSet();
                                if (!compareSet.get(compareSet.getFirstRecordName()).getUnit().equalsIgnoreCase(copyFromRecord.getUnit())) {
                                    CurveSelectorContextMenu.this.application.openMessageDialog(Messages.getString("GDE_MSGW0004", new Object[]{copyFromRecordKey + " - " + compareSet.getFirstRecordName()}));
                                }
                                CurveSelectorContextMenu.this.application.setCompareWindowMode(GraphicsComposite.GraphicsMode.RESET, false);
                            }
                            compareSet = CurveSelectorContextMenu.this.application.getCompareSet();
                            String newRecordkey = CurveSelectorContextMenu.this.settings.isCurveCompareChannelConfigName() ? copyFromRecord.getChannelConfigKey() + "_" + copyFromRecordKey + "_" + compareSet.size() : copyFromRecordKey + "_" + compareSet.size();
                            Record newRecord = compareSet.put(newRecordkey, copyFromRecord.clone());
                            newRecord.setOrdinal(copyFromRecord.getOrdinal());
                            newRecord.setDescription(copyFromRecordSet.getRecordSetDescription());
                            newRecord.setVisible(true);
                            if (compareSet.size() == 1) {
                                compareSet.setValueGridType(CurveSelectorContextMenu.this.settings.getGridCompareWindowHorizontalType());
                                compareSet.setValueGridColor(CurveSelectorContextMenu.this.settings.getGridCompareWindowHorizontalColor());
                                compareSet.setTimeGridType(CurveSelectorContextMenu.this.settings.getGridCompareWindowVerticalType());
                                compareSet.setTimeGridColor(CurveSelectorContextMenu.this.settings.getGridCompareWindowVerticalColor());
                                compareSet.setValueGridRecordOrdinal(0);
                            }
                            double maxRecordTime_ms = compareSet.getCompareSetMaxScaleTime_ms();
                            double newRecordMaxTime_ms = newRecord.getMaxTime_ms();
                            newRecord.setCompareSetDrawLimit_ms(newRecordMaxTime_ms);
                            if (newRecordMaxTime_ms > maxRecordTime_ms) {
                                compareSet.setCompareSetMaxScaleTime_ms(newRecordMaxTime_ms);
                                maxRecordTime_ms = newRecordMaxTime_ms;
                                log.fine(() -> "adapt compareSet maxRecordTime_sec = " + TimeLine.getFomatedTimeWithUnit(newRecordMaxTime_ms));
                                for (Map.Entry tmpRecordEntry : compareSet.entrySet()) {
                                    Record tmpRecord;
                                    if (newRecordkey.equals(tmpRecordEntry.getKey()) || (tmpRecord = (Record)tmpRecordEntry.getValue()).getCompareSetDrawLimit_ms() != 2.147483647E9 && !(tmpRecord.getCompareSetDrawLimit_ms() < newRecordMaxTime_ms)) continue;
                                    double avgTimeStep_ms = tmpRecord.getAverageTimeStep_ms();
                                    int steps = (int)((maxRecordTime_ms - tmpRecord.getCompareSetDrawLimit_ms()) / avgTimeStep_ms);
                                    int value = (Integer)tmpRecord.lastElement();
                                    double timeStep = tmpRecord.getLastTime_ms();
                                    for (int i = 0; i < steps; ++i) {
                                        tmpRecord.add((Integer)value, timeStep += avgTimeStep_ms);
                                    }
                                    tmpRecord.setDrawTimeWidth(newRecordMaxTime_ms);
                                }
                            } else {
                                double avgTimeStep_ms = newRecord.getAverageTimeStep_ms();
                                int steps = (int)((maxRecordTime_ms - newRecordMaxTime_ms) / avgTimeStep_ms);
                                int value = (Integer)newRecord.lastElement();
                                double timeStep = newRecord.getLastTime_ms();
                                for (int i = 0; i < steps; ++i) {
                                    newRecord.add((Integer)value, timeStep += avgTimeStep_ms);
                                }
                                newRecord.setDrawTimeWidth(maxRecordTime_ms);
                            }
                            double oldMinValue = compareSet.getMinValue();
                            double oldMaxValue = compareSet.getMaxValue();
                            log.fine(() -> String.format("scale values from compare set min=%.3f max=%.3f", compareSet.getMinValue(), compareSet.getMaxValue()));
                            for (int i = 0; i < compareSet.size(); ++i) {
                                Record record = compareSet.get(i);
                                double newMinValue = record.getMinScaleValue();
                                double newMaxValue = record.getMaxScaleValue();
                                log.fine(() -> String.format("scale values from record (" + record.getName() + ") to be checked min=%.3f max=%.3f", newMinValue, newMaxValue));
                                if (newMinValue < oldMinValue) {
                                    compareSet.setMinValue(newMinValue);
                                }
                                oldMinValue = compareSet.getMinValue();
                                if (!(newMaxValue > oldMaxValue)) continue;
                                compareSet.setMaxValue(newMaxValue);
                            }
                            for (AbstractRecord tmpRecord : compareSet.values()) {
                                Record record = (Record)tmpRecord;
                                record.setStartEndDefined(true, compareSet.getMinValue(), compareSet.getMaxValue());
                            }
                            CurveSelectorContextMenu.this.application.updateCompareWindow();
                        } else {
                            CurveSelectorContextMenu.this.application.openMessageDialog(Messages.getString("GDE_MSGW0005"));
                        }
                        CurveSelectorContextMenu.this.application.setCompareWindowMode(GraphicsComposite.GraphicsMode.RESET, false);
                    }
                }
            });
            this.cleanCurveCompare = new MenuItem(popupmenu, 8);
            this.cleanCurveCompare.setText(Messages.getString("GDE_MSGT0128"));
            this.cleanCurveCompare.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.finest(() -> "cleanCurveCompare Action performed! " + String.valueOf(e));
                    RecordSet compareSet = CurveSelectorContextMenu.this.application.getCompareSet();
                    compareSet.clear();
                    CurveSelectorContextMenu.this.application.updateCompareWindow();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setAllEnabled(boolean enabled) {
        this.lineVisible.setEnabled(enabled);
        this.lineColor.setEnabled(enabled);
        this.lineWidth.setEnabled(enabled);
        this.lineType.setEnabled(enabled);
        this.smoothAtCurrentDropItem.setEnabled(enabled);
        if (this.smoothVoltageCurveItem != null) {
            this.smoothVoltageCurveItem.setEnabled(enabled);
        }
        this.axisEndValues.setEnabled(enabled);
        this.axisNumberFormat.setEnabled(enabled);
        this.axisPosition.setEnabled(enabled);
        this.timeGrid.setEnabled(enabled);
        this.valueGrid.setEnabled(enabled);
        this.measurement.setEnabled(enabled);
        this.copyCurveCompare.setEnabled(enabled);
        this.cleanCurveCompare.setEnabled(enabled);
    }

    boolean isMeasurementWhileNameChanged(String tmpRecordNameMeasurement) {
        boolean isChanged = false;
        if (!this.recordNameMeasurement.equals(tmpRecordNameMeasurement) && this.recordNameMeasurement.length() > 1) {
            this.application.setMeasurementActive(this.recordNameMeasurement, false);
            this.application.setDeltaMeasurementActive(this.recordNameMeasurement, false);
            this.application.setStatusMessage("");
            isChanged = true;
        }
        return isChanged;
    }

    public boolean isActive() {
        boolean isActive = this.menu != null && this.menu.isVisible() || this.isActiveEnValueDialog || this.isActiveColorDialog;
        log.fine(() -> "isActive = " + isActive);
        return isActive;
    }

    public void resetMeasuring() {
        this.recordNameMeasurement = " ";
        this.simpleMeasure.setSelection(false);
        this.deltaMeasure.setSelection(false);
        this.avgMedianMeasure.setSelection(false);
        this.application.setStatusMessage("");
    }

    public void setMeasurement(String tmpRecordNameMeasurement, boolean isActive) {
        if (this.isMeasurementWhileNameChanged(tmpRecordNameMeasurement) || isActive) {
            this.recordNameMeasurement = tmpRecordNameMeasurement;
            this.setMeasurementActive(tmpRecordNameMeasurement, true);
            this.simpleMeasure.setSelection(true);
            this.deltaMeasure.setSelection(false);
            this.avgMedianMeasure.setSelection(false);
        } else {
            this.recordNameMeasurement = " ";
            this.setMeasurementActive(tmpRecordNameMeasurement, false);
            this.simpleMeasure.setSelection(false);
            this.application.setStatusMessage("");
        }
    }

    private void setMeasurementActive(String tmpRecordNameMeasurement, boolean enabled) {
        if (this.isTypeHisto) {
            this.application.getPresentHistoExplorer().getActiveHistoChartTabItem().setMeasurementActive(tmpRecordNameMeasurement, enabled, false);
        } else {
            this.application.setMeasurementActive(tmpRecordNameMeasurement, enabled);
        }
    }

    public void setDeltaMeasurement(String tmpRecordNameKey, boolean isActive) {
        if (this.isMeasurementWhileNameChanged(tmpRecordNameKey) || isActive) {
            this.recordNameMeasurement = tmpRecordNameKey;
            this.setDeltaMeasurementActive(tmpRecordNameKey, true);
            this.deltaMeasure.setSelection(true);
            this.simpleMeasure.setSelection(false);
            this.avgMedianMeasure.setSelection(false);
        } else {
            this.recordNameMeasurement = " ";
            this.setDeltaMeasurementActive(tmpRecordNameKey, false);
            this.deltaMeasure.setSelection(false);
            this.application.setStatusMessage("");
        }
    }

    private void setDeltaMeasurementActive(String tmpRecordNameMeasurement, boolean enabled) {
        if (this.isTypeHisto) {
            this.application.getPresentHistoExplorer().getActiveHistoChartTabItem().setMeasurementActive(tmpRecordNameMeasurement, enabled, true);
        } else {
            this.application.setDeltaMeasurementActive(tmpRecordNameMeasurement, enabled);
        }
    }

    public void setAvgMedianMeasurement(String tmpRecordNameKey, boolean isActive) {
        if (this.isMeasurementWhileNameChanged(tmpRecordNameKey) || isActive) {
            this.recordNameMeasurement = tmpRecordNameKey;
            this.setAvgMedianMeasurementActive(tmpRecordNameKey, true);
            this.avgMedianMeasure.setSelection(true);
            this.deltaMeasure.setSelection(false);
            this.simpleMeasure.setSelection(false);
        } else {
            this.recordNameMeasurement = " ";
            this.setAvgMedianMeasurementActive(tmpRecordNameKey, false);
            this.avgMedianMeasure.setSelection(false);
            this.application.setStatusMessage("");
        }
    }

    private void setAvgMedianMeasurementActive(String tmpRecordNameMeasurement, boolean enabled) {
        if (this.isTypeHisto) {
            this.application.getPresentHistoExplorer().getActiveHistoChartTabItem().setMeasurementActive(tmpRecordNameMeasurement, enabled, true);
        } else {
            this.application.setAvgMedianMeasurementActive(tmpRecordNameMeasurement, enabled);
        }
    }
}

