/*
 * Decompiled with CFR 0.152.
 */
package gde.ui;

import gde.GDE;
import gde.device.DataTypes;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;

public class ParameterConfigControl {
    static final Logger log = Logger.getLogger(ParameterConfigControl.class.getName());
    final Composite baseComposite;
    final CLabel nameLabel;
    final CLabel descriptionLabel;
    final Text text;
    final Color textColor = GDE.isSystemDarkTheme ? SWTResourceManager.getColor(1) : SWTResourceManager.getColor(2);
    final Color textWarningColor = SWTResourceManager.getColor(3);
    final Slider slider;
    final int controlHeight = GDE.IS_MAC ? 20 : 18;
    int sliderMinValue;
    int sliderMaxValue;
    int sliderMaxWarningValue;
    int offset;
    final String format;
    int value = 0;
    String[] textValues = new String[0];
    float devisor = 1.0f;

    public ParameterConfigControl(final Composite parent, final int[] valueArray, final int valueIndex, String valueFormat, String parameterName, int nameWidth, String parameterDescription, int descriptionWidth, boolean isTextValueEditable, int textFieldWidth, int sliderWidth, int sliderMinValue, int sliderMaxValue, int sliderOffset, final boolean isRounding) {
        this.value = valueArray[valueIndex];
        String string = this.format = valueFormat.equals("") ? "%d" : valueFormat;
        if (this.format.contains(".")) {
            int startIndex = this.format.indexOf(46) + 1;
            int digits = Integer.valueOf(this.format.substring(startIndex, startIndex + 1));
            switch (digits) {
                case 1: {
                    this.devisor = 10.0f;
                    break;
                }
                case 2: {
                    this.devisor = 100.0f;
                    break;
                }
                case 3: {
                    this.devisor = 1000.0f;
                    break;
                }
                default: {
                    this.devisor = 1.0f;
                }
            }
        }
        this.sliderMinValue = sliderMinValue;
        this.sliderMaxValue = sliderMaxValue;
        this.offset = sliderOffset;
        this.baseComposite = new Composite(parent, 0);
        RowLayout group1Layout = new RowLayout(256);
        group1Layout.center = true;
        this.baseComposite.setLayout((Layout)group1Layout);
        this.baseComposite.setBackground(parent.getBackground());
        this.nameLabel = new CLabel(this.baseComposite, 131072);
        RowData nameLabelLData = new RowData();
        nameLabelLData.width = nameWidth;
        nameLabelLData.height = this.controlHeight;
        this.nameLabel.setLayoutData((Object)nameLabelLData);
        this.nameLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.nameLabel.setText(parameterName);
        this.nameLabel.setBackground(parent.getBackground());
        this.nameLabel.setForeground(DataExplorer.getInstance().COLOR_BLACK);
        this.text = new Text(this.baseComposite, 0x1000800);
        RowData textLData = new RowData();
        textLData.width = textFieldWidth;
        textLData.height = this.controlHeight;
        this.text.setLayoutData((Object)textLData);
        this.text.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.text.setEditable(isTextValueEditable);
        this.text.setBackground(GDE.isSystemDarkTheme ? SWTResourceManager.getColor(isTextValueEditable ? 15 : 17) : SWTResourceManager.getColor(isTextValueEditable ? 1 : 19));
        if (isTextValueEditable) {
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "text.verifyText, event=" + String.valueOf(evt));
                    }
                    evt.doit = (double)ParameterConfigControl.this.devisor == 1.0 ? StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text) : StringHelper.verifyTypedInput(DataTypes.DOUBLE, evt.text);
                }
            });
            this.text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "text.keyReleased, event=" + String.valueOf(evt));
                    }
                    ParameterConfigControl.this.value = Integer.parseInt(ParameterConfigControl.this.text.getText().replace(".", "").replace(",", ""));
                    if (ParameterConfigControl.this.value < ParameterConfigControl.this.sliderMinValue) {
                        ParameterConfigControl.this.value = ParameterConfigControl.this.sliderMinValue;
                        if ((double)ParameterConfigControl.this.devisor == 1.0) {
                            ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, ParameterConfigControl.this.value));
                        } else {
                            ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, Float.valueOf((float)ParameterConfigControl.this.value / ParameterConfigControl.this.devisor)));
                        }
                    }
                    if (ParameterConfigControl.this.value > ParameterConfigControl.this.sliderMaxValue) {
                        ParameterConfigControl.this.value = ParameterConfigControl.this.sliderMaxValue;
                        if ((double)ParameterConfigControl.this.devisor == 1.0) {
                            ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, ParameterConfigControl.this.value));
                        } else {
                            ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, Float.valueOf((float)ParameterConfigControl.this.value / ParameterConfigControl.this.devisor)));
                        }
                    }
                    valueArray[valueIndex] = ParameterConfigControl.this.value;
                    ParameterConfigControl.this.slider.setSelection(ParameterConfigControl.this.value + ParameterConfigControl.this.offset);
                    ParameterConfigControl.this.slider.notifyListeners(13, new Event());
                    Event changeEvent = new Event();
                    changeEvent.index = valueIndex;
                    parent.notifyListeners(13, changeEvent);
                }

                public void keyPressed(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "text.keyPressed, event=" + String.valueOf(evt));
                    }
                }
            });
        }
        this.descriptionLabel = new CLabel(this.baseComposite, 16384);
        RowData descriptionLabelLData = new RowData();
        descriptionLabelLData.width = descriptionWidth;
        descriptionLabelLData.height = this.controlHeight;
        this.descriptionLabel.setLayoutData((Object)descriptionLabelLData);
        this.descriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.descriptionLabel.setText(parameterDescription);
        this.descriptionLabel.setBackground(parent.getBackground());
        this.descriptionLabel.setForeground(DataExplorer.getInstance().COLOR_BLACK);
        RowData sliderLData = new RowData();
        sliderLData.width = sliderWidth;
        sliderLData.height = this.controlHeight;
        this.slider = new Slider(this.baseComposite, 0);
        this.slider.setLayoutData((Object)sliderLData);
        this.slider.setMinimum(this.sliderMinValue + this.offset);
        this.slider.setMaximum(this.sliderMaxValue + this.offset + 10);
        this.slider.setIncrement(1);
        this.slider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "slider.widgetSelected, event=" + String.valueOf(evt));
                }
                ParameterConfigControl.this.value = ParameterConfigControl.this.slider.getSelection() - ParameterConfigControl.this.offset;
                valueArray[valueIndex] = isRounding ? (ParameterConfigControl.this.value > 1000 ? (valueArray[valueIndex] <= ParameterConfigControl.this.value ? ParameterConfigControl.this.value + 49 : ParameterConfigControl.this.value - 40) / 50 * 50 : (valueArray[valueIndex] <= ParameterConfigControl.this.value ? ParameterConfigControl.this.value + 9 : ParameterConfigControl.this.value - 5) / 10 * 10) : ParameterConfigControl.this.value;
                if ((double)ParameterConfigControl.this.devisor == 1.0) {
                    ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, ParameterConfigControl.this.value));
                } else {
                    ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, Float.valueOf((float)ParameterConfigControl.this.value / ParameterConfigControl.this.devisor)));
                }
                if (evt.data == null) {
                    Event changeEvent = new Event();
                    changeEvent.index = valueIndex;
                    parent.notifyListeners(13, changeEvent);
                }
            }
        });
    }

    public ParameterConfigControl(final Composite parent, final int[] valueArray, final int valueIndex, String valueFormat, String parameterName, int nameWidth, String parameterDescription, int descriptionWidth, boolean isTextValueEditable, int textFieldWidth, int sliderWidth, int sliderMinValue, int sliderMaxValue, int sliderMaxWarningValue, int sliderOffset, final boolean isRounding) {
        this.value = valueArray[valueIndex];
        String string = this.format = valueFormat.equals("") ? "%d" : valueFormat;
        if (this.format.contains(".")) {
            int startIndex = this.format.indexOf(46) + 1;
            int digits = Integer.valueOf(this.format.substring(startIndex, startIndex + 1));
            switch (digits) {
                case 1: {
                    this.devisor = 10.0f;
                    break;
                }
                case 2: {
                    this.devisor = 100.0f;
                    break;
                }
                case 3: {
                    this.devisor = 1000.0f;
                    break;
                }
                default: {
                    this.devisor = 1.0f;
                }
            }
        }
        this.sliderMinValue = sliderMinValue;
        this.sliderMaxValue = sliderMaxValue;
        this.sliderMaxWarningValue = sliderMaxWarningValue;
        this.offset = sliderOffset;
        this.baseComposite = new Composite(parent, 0);
        RowLayout group1Layout = new RowLayout(256);
        group1Layout.center = true;
        this.baseComposite.setLayout((Layout)group1Layout);
        this.baseComposite.setBackground(parent.getBackground());
        this.nameLabel = new CLabel(this.baseComposite, 131072);
        RowData nameLabelLData = new RowData();
        nameLabelLData.width = nameWidth;
        nameLabelLData.height = this.controlHeight;
        this.nameLabel.setLayoutData((Object)nameLabelLData);
        this.nameLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.nameLabel.setText(parameterName);
        this.nameLabel.setBackground(parent.getBackground());
        this.nameLabel.setForeground(DataExplorer.getInstance().COLOR_BLACK);
        this.text = new Text(this.baseComposite, 0x1000800);
        RowData textLData = new RowData();
        textLData.width = textFieldWidth;
        textLData.height = this.controlHeight;
        this.text.setLayoutData((Object)textLData);
        this.text.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.text.setEditable(isTextValueEditable);
        this.text.setBackground(GDE.isSystemDarkTheme ? SWTResourceManager.getColor(isTextValueEditable ? 15 : 17) : SWTResourceManager.getColor(isTextValueEditable ? 1 : 19));
        this.text.setForeground(this.textColor);
        if (isTextValueEditable) {
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "text.verifyText, event=" + String.valueOf(evt));
                    }
                    evt.doit = (double)ParameterConfigControl.this.devisor == 1.0 ? StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text) : StringHelper.verifyTypedInput(DataTypes.DOUBLE, evt.text);
                }
            });
            this.text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "text.keyReleased, event=" + String.valueOf(evt));
                    }
                    ParameterConfigControl.this.value = Integer.parseInt(ParameterConfigControl.this.text.getText().replace(".", "").replace(",", ""));
                    if (ParameterConfigControl.this.value < ParameterConfigControl.this.sliderMinValue) {
                        ParameterConfigControl.this.value = ParameterConfigControl.this.sliderMinValue;
                        if ((double)ParameterConfigControl.this.devisor == 1.0) {
                            ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, ParameterConfigControl.this.value));
                        } else {
                            ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, Float.valueOf((float)ParameterConfigControl.this.value / ParameterConfigControl.this.devisor)));
                        }
                    }
                    if (ParameterConfigControl.this.value > ParameterConfigControl.this.sliderMaxValue) {
                        ParameterConfigControl.this.value = ParameterConfigControl.this.sliderMaxValue;
                        if ((double)ParameterConfigControl.this.devisor == 1.0) {
                            ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, ParameterConfigControl.this.value));
                        } else {
                            ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, Float.valueOf((float)ParameterConfigControl.this.value / ParameterConfigControl.this.devisor)));
                        }
                    }
                    if (ParameterConfigControl.this.value > ParameterConfigControl.this.sliderMaxWarningValue) {
                        ParameterConfigControl.this.text.setForeground(ParameterConfigControl.this.textWarningColor);
                    } else {
                        ParameterConfigControl.this.text.setForeground(ParameterConfigControl.this.textColor);
                    }
                    valueArray[valueIndex] = ParameterConfigControl.this.value;
                    ParameterConfigControl.this.slider.setSelection(ParameterConfigControl.this.value + ParameterConfigControl.this.offset);
                    ParameterConfigControl.this.slider.notifyListeners(13, new Event());
                    Event changeEvent = new Event();
                    changeEvent.index = valueIndex;
                    parent.notifyListeners(13, changeEvent);
                }

                public void keyPressed(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "text.keyPressed, event=" + String.valueOf(evt));
                    }
                }
            });
        }
        this.descriptionLabel = new CLabel(this.baseComposite, 16384);
        RowData descriptionLabelLData = new RowData();
        descriptionLabelLData.width = descriptionWidth;
        descriptionLabelLData.height = this.controlHeight;
        this.descriptionLabel.setLayoutData((Object)descriptionLabelLData);
        this.descriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.descriptionLabel.setText(parameterDescription);
        this.descriptionLabel.setBackground(parent.getBackground());
        this.descriptionLabel.setForeground(DataExplorer.getInstance().COLOR_BLACK);
        RowData sliderLData = new RowData();
        sliderLData.width = sliderWidth;
        sliderLData.height = this.controlHeight;
        this.slider = new Slider(this.baseComposite, 0);
        this.slider.setLayoutData((Object)sliderLData);
        this.slider.setMinimum(this.sliderMinValue + this.offset);
        this.slider.setMaximum(this.sliderMaxValue + this.offset + 10);
        this.slider.setIncrement(1);
        this.slider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "slider.widgetSelected, event=" + String.valueOf(evt));
                }
                ParameterConfigControl.this.value = ParameterConfigControl.this.slider.getSelection() - ParameterConfigControl.this.offset;
                valueArray[valueIndex] = isRounding ? (ParameterConfigControl.this.value > 1000 ? (valueArray[valueIndex] <= ParameterConfigControl.this.value ? ParameterConfigControl.this.value + 49 : ParameterConfigControl.this.value - 40) / 50 * 50 : (valueArray[valueIndex] <= ParameterConfigControl.this.value ? ParameterConfigControl.this.value + 9 : ParameterConfigControl.this.value - 5) / 10 * 10) : ParameterConfigControl.this.value;
                if ((double)ParameterConfigControl.this.devisor == 1.0) {
                    ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, ParameterConfigControl.this.value));
                } else {
                    ParameterConfigControl.this.text.setText(String.format(Locale.ENGLISH, ParameterConfigControl.this.format, Float.valueOf((float)ParameterConfigControl.this.value / ParameterConfigControl.this.devisor)));
                }
                if (ParameterConfigControl.this.value > ParameterConfigControl.this.sliderMaxWarningValue) {
                    ParameterConfigControl.this.text.setForeground(ParameterConfigControl.this.textWarningColor);
                } else {
                    ParameterConfigControl.this.text.setForeground(ParameterConfigControl.this.textColor);
                }
                if (evt.data == null) {
                    Event changeEvent = new Event();
                    changeEvent.index = valueIndex;
                    parent.notifyListeners(13, changeEvent);
                }
            }
        });
    }

    public ParameterConfigControl(final Composite parent, final int[] valueArray, final int valueIndex, String valueFormat, String parameterName, int nameWidth, String parameterDescription, int descriptionWidth, boolean isTextValueEditable, int textFieldWidth, int sliderWidth, int sliderMinValue, int sliderMaxValue) {
        this.value = valueArray[valueIndex];
        this.format = valueFormat.equals("") ? "%d" : valueFormat;
        this.sliderMinValue = sliderMinValue;
        this.sliderMaxValue = sliderMaxValue;
        this.offset = 0;
        this.baseComposite = new Composite(parent, 0);
        RowLayout group1Layout = new RowLayout(256);
        group1Layout.center = true;
        this.baseComposite.setLayout((Layout)group1Layout);
        this.baseComposite.setBackground(parent.getBackground());
        this.nameLabel = new CLabel(this.baseComposite, 131072);
        RowData nameLabelLData = new RowData();
        nameLabelLData.width = nameWidth;
        nameLabelLData.height = this.controlHeight;
        this.nameLabel.setLayoutData((Object)nameLabelLData);
        this.nameLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.nameLabel.setText(parameterName);
        this.nameLabel.setBackground(parent.getBackground());
        this.nameLabel.setForeground(DataExplorer.getInstance().COLOR_BLACK);
        this.text = new Text(this.baseComposite, 0x1000800);
        RowData textLData = new RowData();
        textLData.width = textFieldWidth;
        textLData.height = this.controlHeight;
        this.text.setLayoutData((Object)textLData);
        this.text.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.text.setEditable(isTextValueEditable);
        this.text.setBackground(GDE.isSystemDarkTheme ? SWTResourceManager.getColor(isTextValueEditable ? 15 : 17) : SWTResourceManager.getColor(isTextValueEditable ? 1 : 19));
        if (isTextValueEditable) {
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "text.verifyText, event=" + String.valueOf(evt));
                    }
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "text.keyReleased, event=" + String.valueOf(evt));
                    }
                    ParameterConfigControl.this.value = Integer.parseInt(ParameterConfigControl.this.text.getText());
                    if (ParameterConfigControl.this.value < ParameterConfigControl.this.sliderMinValue) {
                        ParameterConfigControl.this.value = ParameterConfigControl.this.sliderMinValue;
                        ParameterConfigControl.this.text.setText(String.format(ParameterConfigControl.this.format, ParameterConfigControl.this.value));
                    }
                    if (ParameterConfigControl.this.value > ParameterConfigControl.this.sliderMaxValue) {
                        ParameterConfigControl.this.value = ParameterConfigControl.this.sliderMaxValue;
                        ParameterConfigControl.this.text.setText(String.format(ParameterConfigControl.this.format, ParameterConfigControl.this.value));
                    }
                    valueArray[valueIndex] = ParameterConfigControl.this.value;
                    ParameterConfigControl.this.slider.setSelection(ParameterConfigControl.this.value);
                    ParameterConfigControl.this.slider.notifyListeners(13, new Event());
                    Event changeEvent = new Event();
                    changeEvent.index = valueIndex;
                    parent.notifyListeners(13, changeEvent);
                }

                public void keyPressed(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "text.keyPressed, event=" + String.valueOf(evt));
                    }
                }
            });
        }
        this.descriptionLabel = new CLabel(this.baseComposite, 16384);
        RowData descriptionLabelLData = new RowData();
        descriptionLabelLData.width = descriptionWidth;
        descriptionLabelLData.height = this.controlHeight;
        this.descriptionLabel.setLayoutData((Object)descriptionLabelLData);
        this.descriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.descriptionLabel.setText(parameterDescription);
        this.descriptionLabel.setBackground(parent.getBackground());
        this.descriptionLabel.setForeground(DataExplorer.getInstance().COLOR_BLACK);
        RowData sliderLData = new RowData();
        sliderLData.width = sliderWidth;
        sliderLData.height = this.controlHeight;
        this.slider = new Slider(this.baseComposite, 0);
        this.slider.setLayoutData((Object)sliderLData);
        this.slider.setMinimum(this.sliderMinValue);
        this.slider.setMaximum(this.sliderMaxValue + 10);
        this.slider.setIncrement(1);
        this.slider.setSelection(this.value);
        this.slider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "slider.widgetSelected, event=" + String.valueOf(evt));
                }
                ParameterConfigControl.this.value = ParameterConfigControl.this.slider.getSelection();
                ParameterConfigControl.this.text.setText(String.format(ParameterConfigControl.this.format, ParameterConfigControl.this.value));
                valueArray[valueIndex] = ParameterConfigControl.this.value;
                if (evt.data == null) {
                    Event changeEvent = new Event();
                    changeEvent.index = valueIndex;
                    parent.notifyListeners(13, changeEvent);
                }
            }
        });
    }

    public ParameterConfigControl(final Composite parent, final int[] valueArray, final int valueIndex, String parameterName, int nameWidth, String parameterDescription, int descriptionWidth, String[] textFiledValues, int textFieldWidth, int sliderWidth) {
        this.value = valueArray[valueIndex];
        this.textValues = textFiledValues;
        this.format = "";
        this.offset = 0;
        this.baseComposite = new Composite(parent, 0);
        RowLayout group1Layout = new RowLayout(256);
        group1Layout.center = true;
        this.baseComposite.setLayout((Layout)group1Layout);
        this.baseComposite.setBackground(parent.getBackground());
        this.nameLabel = new CLabel(this.baseComposite, 131072);
        RowData nameLabelLData = new RowData();
        nameLabelLData.width = nameWidth;
        nameLabelLData.height = this.controlHeight;
        this.nameLabel.setLayoutData((Object)nameLabelLData);
        this.nameLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.nameLabel.setText(parameterName);
        this.nameLabel.setBackground(parent.getBackground());
        this.nameLabel.setForeground(DataExplorer.getInstance().COLOR_BLACK);
        this.text = new Text(this.baseComposite, 0x1000800);
        RowData textLData = new RowData();
        textLData.width = textFieldWidth;
        textLData.height = this.controlHeight;
        this.text.setLayoutData((Object)textLData);
        this.text.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.text.setEditable(false);
        this.text.setBackground(GDE.isSystemDarkTheme ? SWTResourceManager.getColor(17) : SWTResourceManager.getColor(19));
        this.descriptionLabel = new CLabel(this.baseComposite, 16384);
        RowData descriptionLabelLData = new RowData();
        descriptionLabelLData.width = descriptionWidth;
        descriptionLabelLData.height = this.controlHeight;
        this.descriptionLabel.setLayoutData((Object)descriptionLabelLData);
        this.descriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.descriptionLabel.setText(parameterDescription);
        this.descriptionLabel.setBackground(parent.getBackground());
        this.descriptionLabel.setForeground(DataExplorer.getInstance().COLOR_BLACK);
        RowData sliderLData = new RowData();
        sliderLData.width = sliderWidth;
        sliderLData.height = this.controlHeight;
        this.slider = new Slider(this.baseComposite, 0);
        this.slider.setLayoutData((Object)sliderLData);
        this.slider.setMinimum(0);
        this.slider.setMaximum(this.textValues.length < 15 ? 10 + this.textValues.length - 1 : this.textValues.length + 1);
        this.slider.setSelection(this.value);
        this.slider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "slider.widgetSelected, event=" + String.valueOf(evt));
                }
                ParameterConfigControl.this.value = ParameterConfigControl.this.slider.getSelection();
                ParameterConfigControl.this.text.setText(ParameterConfigControl.this.textValues[ParameterConfigControl.this.value]);
                valueArray[valueIndex] = ParameterConfigControl.this.value;
                if (evt.data == null) {
                    Event changeEvent = new Event();
                    changeEvent.index = valueIndex;
                    parent.notifyListeners(13, changeEvent);
                }
            }
        });
    }

    public ParameterConfigControl dispose() {
        this.baseComposite.dispose();
        return null;
    }

    public void setEnabled(boolean enable) {
        this.nameLabel.setForeground(enable ? DataExplorer.getInstance().COLOR_BLACK : DataExplorer.getInstance().COLOR_GREY);
        this.text.setEnabled(enable);
        this.descriptionLabel.setForeground(enable ? DataExplorer.getInstance().COLOR_BLACK : DataExplorer.getInstance().COLOR_GREY);
        this.slider.setEnabled(enable);
    }

    public void setSliderSelection(int useValue) {
        this.value = useValue;
        if (!this.slider.isDisposed()) {
            this.slider.setSelection(this.value + this.offset);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "slider value = " + this.value + " offset = " + this.offset);
            }
            Event updateEvent = new Event();
            updateEvent.data = new Object();
            this.slider.notifyListeners(13, updateEvent);
        }
    }

    public Slider getSlider() {
        return this.slider;
    }

    public void redraw() {
        this.baseComposite.redraw();
    }

    public void updateValueRange(String newParameterDescription, int newMinSliderValue, int newMaxSliderValue) {
        this.descriptionLabel.setText(newParameterDescription);
        this.sliderMinValue = newMinSliderValue;
        this.slider.setMinimum(newMinSliderValue);
        this.sliderMaxValue = newMaxSliderValue;
        this.slider.setMaximum(newMaxSliderValue);
    }

    public void updateValueRange(String newParameterDescription, int newMinSliderValue, int newMaxSliderValue, int newOffset) {
        this.descriptionLabel.setText(newParameterDescription);
        this.offset = newOffset;
        this.sliderMinValue = newMinSliderValue;
        this.slider.setMinimum(newMinSliderValue + this.offset);
        this.sliderMaxValue = newMaxSliderValue;
        this.slider.setMaximum(newMaxSliderValue + this.offset + 10);
    }

    public void updateValueRange(String newParameterDescription, int newMinSliderValue, int newMaxSliderValue, int newSliderMaxWarningValue, int newOffset) {
        this.descriptionLabel.setText(newParameterDescription);
        this.offset = newOffset;
        this.sliderMinValue = newMinSliderValue;
        this.slider.setMinimum(newMinSliderValue + this.offset);
        this.sliderMaxValue = newMaxSliderValue;
        this.slider.setMaximum(newMaxSliderValue + this.offset + 10);
        this.sliderMaxWarningValue = newSliderMaxWarningValue;
    }

    public void updateTextFieldValues(String[] textFiledValues) {
        this.descriptionLabel.setText(String.join((CharSequence)",", textFiledValues));
        this.textValues = textFiledValues;
        this.sliderMaxValue = this.textValues.length < 10 ? 10 + this.textValues.length - 1 : this.textValues.length + 1;
        this.slider.setMaximum(this.sliderMaxValue);
        this.value = this.slider.getSelection();
        this.text.setText(this.textValues[this.value]);
    }

    public void updateNameLabel(String newNameText) {
        this.nameLabel.setText(newNameText);
    }
}

