/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import gde.GDE;
import gde.data.ObjectData;
import gde.exception.ApplicationConfigurationException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class ObjectDataReaderWriter {
    private static final String LINE_DELIMITER = "{$}";
    private static final String DELIMITER = "{%}";
    static final Logger log = Logger.getLogger(ObjectDataReaderWriter.class.getName());
    private static final String BEGIN_STYLES = "{BeginStyles}";
    private static final String END_STYLES = "{EndStyles}";
    private static final String BEGIN_HEADER = "{BeginHeader}";
    private static final String BEGIN_CHARACTERISTICS = "{BeginCharacteristics}";
    private static final String BEGIN_STYLED_TEXT = "{BeginStyledText}";
    private static final String BEGIN_FONT = "{BeginFont}";
    private ObjectData objectData;
    private String filePath;

    public ObjectDataReaderWriter(ObjectData newObjectData) {
        this.objectData = newObjectData;
        this.filePath = newObjectData.getFullQualifiedObjectFilePath().replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        ZipFile zipFile = null;
        String redObjectkey = Messages.getString("GDE_MSGT0279");
        File file = new File(this.filePath);
        try {
            if (file.exists()) {
                zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.getName().endsWith(".stf")) {
                        int i;
                        String[] content = StringHelper.splitString(this.extract(zipFile.getInputStream(entry)), LINE_DELIMITER, "");
                        redObjectkey = content[0].substring(BEGIN_HEADER.length());
                        if (!this.objectData.getKey().equals(redObjectkey)) {
                            throw new ApplicationConfigurationException(Messages.getString("GDE_MSGW0029"));
                        }
                        for (i = 1; i < content.length; ++i) {
                            if (!content[i].contains(BEGIN_CHARACTERISTICS)) continue;
                            String[] tmpCharacteristics = StringHelper.splitString(content[i], DELIMITER, BEGIN_CHARACTERISTICS);
                            this.objectData.setType(tmpCharacteristics[0]);
                            this.objectData.setActivationDate(tmpCharacteristics[1]);
                            this.objectData.setStatus(tmpCharacteristics[2]);
                            break;
                        }
                        for (i = 1; i < content.length; ++i) {
                            if (!content[i].contains(BEGIN_FONT)) continue;
                            String[] tmpFontData = StringHelper.splitString(content[i], DELIMITER, BEGIN_FONT);
                            this.objectData.setFont(SWTResourceManager.getFont(tmpFontData[0], Integer.parseInt(tmpFontData[1]), Integer.parseInt(tmpFontData[2]), false, false));
                            break;
                        }
                        for (i = 1; i < content.length; ++i) {
                            if (!content[i].contains(BEGIN_STYLED_TEXT)) continue;
                            this.objectData.setStyledText(content[i].substring(BEGIN_STYLED_TEXT.length()));
                            break;
                        }
                        Vector<StyleRange> tmpRanges = new Vector<StyleRange>();
                        for (int i2 = 1; i2 < content.length; ++i2) {
                            String line = content[i2];
                            if (line.contains(BEGIN_STYLES)) {
                                String[] ranges;
                                for (String styleRangeText : ranges = StringHelper.splitString(line, DELIMITER, BEGIN_STYLES)) {
                                    if (styleRangeText.contains(END_STYLES)) break;
                                    tmpRanges.add(this.buildOneStyle(styleRangeText));
                                }
                            }
                            if (line.contains(END_STYLES)) break;
                        }
                        this.objectData.setStyleRanges(tmpRanges.toArray(new StyleRange[0]));
                        continue;
                    }
                    if (entry.getName().endsWith(".jpg")) {
                        String imageKey = entry.getName().substring(0, entry.getName().length() - ".jpg".length());
                        InputStream inZip = zipFile.getInputStream(entry);
                        ImageLoader imageLoader = new ImageLoader();
                        this.objectData.setImage(SWTResourceManager.getImage(imageLoader.load(inZip)[0], imageKey, 400, 300, true));
                        inZip.close();
                        continue;
                    }
                    if (entry.getName().endsWith(".ini")) {
                        InputStream inZip = zipFile.getInputStream(entry);
                        Properties properties = new Properties();
                        properties.load(inZip);
                        this.objectData.setProperties(properties);
                        inZip.close();
                        continue;
                    }
                    log.log(Level.WARNING, entry.getName());
                }
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.getLocalizedMessage(), t);
            if (t instanceof ZipException) {
                if (DataExplorer.getInstance().isVisible()) {
                    int answer = DataExplorer.getInstance().openYesNoMessageDialog(Messages.getString("GDE_MSGW0025", new Object[]{file.getAbsolutePath()}));
                    if (answer == 64 && !file.delete()) {
                        log.log(Level.WARNING, "failed to delete " + file.getAbsolutePath());
                    }
                } else {
                    String msg = Messages.getString("GDE_MSGW0026", new Object[]{file.getAbsolutePath()});
                    GDE.setInitError(msg);
                }
            } else if (t instanceof ApplicationConfigurationException) {
                if (DataExplorer.getInstance().isVisible()) {
                    String msg = Messages.getString("GDE_MSGW0027", new Object[]{file.getAbsolutePath(), redObjectkey});
                    int answer = DataExplorer.getInstance().openYesNoMessageDialog(msg);
                    if (answer == 64 && !file.delete()) {
                        log.log(Level.WARNING, "failed to delete " + file.getAbsolutePath());
                    }
                } else {
                    String msg = Messages.getString("GDE_MSGW0028", new Object[]{file.getAbsolutePath(), redObjectkey});
                    GDE.setInitError(msg);
                }
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String extract(InputStream inZip) throws FileNotFoundException, IOException {
        int len;
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[2048];
        while ((len = inZip.read(buffer)) >= 0) {
            byte[] stringBuffer = new byte[len];
            System.arraycopy(buffer, 0, stringBuffer, 0, len);
            sb.append(new String(stringBuffer));
        }
        inZip.close();
        return sb.toString();
    }

    private StyleRange buildOneStyle(String styleRangeString) {
        int textStyle;
        Color background;
        Color foreground;
        int length;
        int startPos;
        try {
            String[] styleRangeData = styleRangeString.split(" ");
            startPos = Integer.parseInt(styleRangeData[0]);
            length = Integer.parseInt(styleRangeData[1]);
            foreground = null;
            try {
                foreground = SWTResourceManager.getColor(Integer.parseInt(styleRangeData[2]), Integer.parseInt(styleRangeData[3]), Integer.parseInt(styleRangeData[4]));
            }
            catch (NumberFormatException e) {
                foreground = null;
            }
            background = null;
            try {
                background = SWTResourceManager.getColor(Integer.parseInt(styleRangeData[5]), Integer.parseInt(styleRangeData[6]), Integer.parseInt(styleRangeData[7]));
            }
            catch (NumberFormatException e) {
                background = null;
            }
            textStyle = Integer.parseInt(styleRangeData[8]);
        }
        catch (NumberFormatException e) {
            startPos = 0;
            length = 0;
            foreground = null;
            background = null;
            textStyle = 0;
        }
        return new StyleRange(startPos, length, foreground, background, textStyle);
    }

    public void write() {
        try {
            StyleRange[] styles;
            File targetFile = new File(this.filePath);
            File targetFileDir = new File(this.filePath.substring(0, this.filePath.lastIndexOf(47)));
            if (targetFileDir.exists()) {
                if (!targetFile.exists() && !targetFile.createNewFile()) {
                    log.log(Level.WARNING, "failed to create " + this.filePath);
                }
            } else if (targetFileDir.mkdir() && !targetFile.createNewFile()) {
                log.log(Level.WARNING, "failed to create " + this.filePath);
            }
            ZipOutputStream outZip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetFile)));
            if (this.objectData.getImage() != null) {
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{this.objectData.getImage().getImageData()};
                outZip.putNextEntry(new ZipEntry(this.objectData.getKey() + ".jpg"));
                imageLoader.save((OutputStream)outZip, 4);
                outZip.closeEntry();
            }
            outZip.putNextEntry(new ZipEntry(this.objectData.getKey() + ".stf"));
            Object text = this.objectData.getKey();
            this.write(outZip, BEGIN_HEADER + (String)text + LINE_DELIMITER);
            log.log(Level.FINE, BEGIN_HEADER + (String)text + LINE_DELIMITER);
            text = this.objectData.getType() + DELIMITER + this.objectData.getActivationDate() + DELIMITER + this.objectData.getStatus();
            this.write(outZip, BEGIN_CHARACTERISTICS + (String)text + LINE_DELIMITER);
            log.log(Level.FINE, BEGIN_CHARACTERISTICS + (String)text + LINE_DELIMITER);
            FontData fd = this.objectData.getFontData();
            text = fd.getName() + DELIMITER + fd.getHeight() + DELIMITER + fd.getStyle();
            this.write(outZip, BEGIN_FONT + (String)text + LINE_DELIMITER);
            log.log(Level.FINE, BEGIN_FONT + (String)text + LINE_DELIMITER);
            text = this.objectData.getStyledText();
            this.write(outZip, BEGIN_STYLED_TEXT + (String)text + LINE_DELIMITER);
            log.log(Level.FINE, BEGIN_STYLED_TEXT + (String)text + LINE_DELIMITER);
            this.write(outZip, BEGIN_STYLES);
            log.log(Level.FINE, BEGIN_STYLES);
            for (StyleRange style : styles = this.objectData.getStyleRanges()) {
                text = style.start + " " + style.length + " " + String.valueOf(style.foreground == null ? "-" : Integer.valueOf(style.foreground.getRed())) + " " + String.valueOf(style.foreground == null ? "-" : Integer.valueOf(style.foreground.getGreen())) + " " + String.valueOf(style.foreground == null ? "-" : Integer.valueOf(style.foreground.getBlue())) + " " + String.valueOf(style.background == null ? "-" : Integer.valueOf(style.background.getRed())) + " " + String.valueOf(style.background == null ? "-" : Integer.valueOf(style.background.getGreen())) + " " + String.valueOf(style.background == null ? "-" : Integer.valueOf(style.background.getBlue())) + " " + style.fontStyle + DELIMITER;
                this.write(outZip, (String)text);
                log.log(Level.FINE, (String)text);
            }
            this.write(outZip, "{EndStyles}\n");
            outZip.closeEntry();
            log.log(Level.FINE, END_STYLES);
            outZip.putNextEntry(new ZipEntry(this.objectData.getKey() + ".ini"));
            if (this.objectData.getProperties() != null) {
                this.objectData.getProperties().store(outZip, "GPS velocity limits and colors");
            }
            outZip.closeEntry();
            outZip.flush();
            outZip.close();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    void write(ZipOutputStream outZip, String text) throws IOException {
        byte[] buffer = text.getBytes();
        int length = buffer.length;
        outZip.write(buffer, 0, length);
    }
}

