/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import gde.GDE;
import gde.config.Settings;
import gde.data.AbstractRecordSet;
import gde.data.Channels;
import gde.histo.datasources.HistoSet;
import gde.histo.datasources.SourceFolders;
import gde.histo.recordings.TrailDataTags;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordSet;
import gde.histo.recordings.TrailRecordSetFormatter;
import gde.histo.ui.AbstractChartComposite;
import gde.histo.ui.ExclusionActivity;
import gde.histo.ui.GraphicsMeasuring;
import gde.histo.ui.Measure;
import gde.histo.ui.menu.AbstractTabAreaContextMenu;
import gde.histo.ui.menu.ChartTabAreaContextMenu;
import gde.histo.utils.HistoCurveUtils;
import gde.histo.utils.HistoTimeLine;
import gde.log.Logger;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.MathUtils;
import gde.utils.StringHelper;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class GraphicsComposite
extends AbstractChartComposite {
    private static final String $CLASS_NAME = GraphicsComposite.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final HistoTimeLine timeLine = new HistoTimeLine();
    private final AbstractChartComposite.AbstractChartData chartData = new AbstractChartComposite.AbstractChartData();
    final Rectangle monitorBounds = GDE.display.getPrimaryMonitor().getBounds();
    private Shell measurePopUp;
    private StyledText styledText;
    int lastXPositionMeasure = Integer.MAX_VALUE;

    GraphicsComposite(SashForm useParent, CTabItem parentWindow) {
        super((Composite)useParent, parentWindow, 0);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.curveAreaBackground = this.settings.getGraphicsCurveAreaBackground();
        this.surroundingBackground = this.settings.getGraphicsSurroundingBackground();
        this.curveAreaBorderColor = this.settings.getGraphicsCurvesBorderColor();
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new ChartTabAreaContextMenu();
        this.init();
        this.enableGraphicsScale(true);
    }

    private void init() {
        this.setLayout(null);
        this.setDragDetect(false);
        this.setBackground(this.surroundingBackground);
        this.contextMenu.createMenu(this.popupmenu);
        this.addListener(11, new Listener(){

            public void handleEvent(Event evt) {
                log.finer(() -> "GraphicsComposite.controlResized() = " + String.valueOf(evt));
                Rectangle clientRect = GraphicsComposite.this.getClientArea();
                Point size = new Point(clientRect.width, clientRect.height);
                log.finer(() -> String.valueOf(GraphicsComposite.this.oldSize) + " - " + String.valueOf(size));
                if (!GraphicsComposite.this.oldSize.equals((Object)size)) {
                    log.fine(() -> "size changed, update " + String.valueOf(GraphicsComposite.this.oldSize) + " - " + String.valueOf(size));
                    GraphicsComposite.this.oldSize = size;
                    GraphicsComposite.this.setComponentBounds();
                    GraphicsComposite.this.doRedrawGraphics();
                }
            }
        });
        this.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                log.finer(() -> "GraphicsComposite.helpRequested " + String.valueOf(evt));
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_94.html");
            }
        });
        this.graphicsHeader = new Text((Composite)this, 0x100000C);
        this.graphicsHeader.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 3, 1));
        this.graphicsHeader.setBackground(this.surroundingBackground);
        this.graphicsHeader.setMenu(this.popupmenu);
        this.graphicsHeader.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                int levelMax;
                String levelsText;
                Object toolTipText;
                log.finer(() -> "graphicsHeader.paintControl, event=" + String.valueOf(evt));
                SourceFolders sourceFolders = DataExplorer.getInstance().getPresentHistoExplorer().getHistoSet().getSourceFolders();
                String headerText = sourceFolders != null ? sourceFolders.getTruncatedFileNamesCsv().replace(",", " | ") : "";
                Object object = toolTipText = sourceFolders != null ? sourceFolders.getDecoratedPathsCsv().replace(',', '\n') : "";
                if (!headerText.equals(GraphicsComposite.this.graphicsHeaderText)) {
                    GraphicsComposite.this.graphicsHeaderText = headerText;
                    GraphicsComposite.this.graphicsHeader.setText(headerText);
                }
                String string = levelsText = (levelMax = Settings.getInstance().getSubDirectoryLevelMax()) > 0 ? "\n+ " + levelMax + " " + Messages.getString("GDE_MSGT0870") : "";
                if (!((String)toolTipText).isEmpty()) {
                    toolTipText = (String)toolTipText + levelsText;
                }
                GraphicsComposite.this.graphicsHeader.setToolTipText((String)toolTipText);
            }
        });
        this.graphicCanvas = new Canvas((Composite)this, 0);
        this.graphicCanvas.setBackground(this.surroundingBackground);
        this.graphicCanvas.setMenu(this.popupmenu);
        this.graphicCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent evt) {
                log.finest(() -> "graphicCanvas.mouseMove = " + String.valueOf(evt));
                GraphicsComposite.this.mouseMoveAction(evt);
            }
        });
        this.graphicCanvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent evt) {
                log.finest(() -> "graphicCanvas.mouseExit, event=" + String.valueOf(evt));
                GraphicsComposite.this.graphicCanvas.setCursor(DataExplorer.getInstance().getCursor());
            }
        });
        this.graphicCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent evt) {
                log.finest(() -> "graphicCanvas.mouseDown, event=" + String.valueOf(evt));
                if (evt.button == 1 || evt.button == 3) {
                    GraphicsComposite.this.mouseDownAction(evt);
                }
            }

            public void mouseUp(MouseEvent evt) {
                log.finest(() -> "graphicCanvas.mouseUp, event=" + String.valueOf(evt));
                if (evt.button == 1 || evt.button == 3) {
                    GraphicsComposite.this.mouseUpAction(evt);
                }
            }
        });
        this.graphicCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.finer(() -> "graphicCanvas.paintControl, event=" + String.valueOf(evt));
                try {
                    GraphicsComposite.this.drawAreaPaintControl(evt);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        });
        this.recordSetComment = new Text((Composite)this, 16394);
        this.recordSetComment.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.recordSetComment.setBackground(this.surroundingBackground);
        this.recordSetComment.setMenu(this.popupmenu);
        this.recordSetComment.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.finer(() -> "recordSetComment.paintControl, event=" + String.valueOf(evt));
            }
        });
        this.xScale = new Text((Composite)this, 16394);
        this.xScale.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.xScale.setBackground(this.surroundingBackground);
        this.xScale.setMenu(this.popupmenu);
        this.xScale.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.finer(() -> "xScale.paintControl, event=" + String.valueOf(evt));
            }
        });
    }

    private void drawAreaPaintControl(PaintEvent evt) {
        log.fine(() -> "drawAreaPaintControl.paintControl, event=" + String.valueOf(evt));
        long nanoTime = System.nanoTime();
        this.abstractDrawAreaPaintControl(evt.gc);
        log.time(() -> "drawTime=" + StringHelper.getFormatedTime("ss:SSS", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - nanoTime)));
    }

    void mouseMoveAction(MouseEvent evt) {
        if (Channels.getInstance().getActiveChannel() == null) {
            return;
        }
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (trailRecordSet != null && trailRecordSet.getTimeStepSize() > 0 && this.canvasImage != null) {
            Point point = this.checkCurveBounds(evt.x, evt.y);
            this.graphicCanvas.setCursor(this.application.getCursor());
            if (point.x > 0 && point.y > this.curveAreaBounds.height - this.curveAreaBounds.y) {
                String text;
                Long timestamp_ms = this.timeLine.getSnappedTimestamp(point.x);
                String string = text = timestamp_ms != null ? Paths.get(trailRecordSet.getDataTagText(trailRecordSet.getIndex(timestamp_ms), TrailDataTags.DataTag.FILE_PATH), new String[0]).getFileName().toString() : null;
                if (text != null) {
                    if (this.graphicCanvas.getToolTipText() == null || !text.equals(this.graphicCanvas.getToolTipText())) {
                        this.graphicCanvas.setToolTipText(text);
                    }
                } else {
                    this.graphicCanvas.setToolTipText(null);
                }
            } else {
                this.graphicCanvas.setToolTipText(null);
            }
            if ((evt.stateMask & 0x80000) == 524288) {
                this.windowActor.processMouseDownMove(this.timeLine.getAdjacentTimestamp(point.x));
            } else {
                this.windowActor.processMouseUpMove(point);
            }
        }
    }

    void mouseDownAction(MouseEvent evt) {
        if (Channels.getInstance().getActiveChannel() == null) {
            return;
        }
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (this.canvasImage != null && trailRecordSet != null && trailRecordSet.getTimeStepSize() > 0) {
            Point point = this.checkCurveBounds(evt.x, evt.y);
            if (evt.button == 1) {
                this.windowActor.processMouseDownAction(point);
            } else if (evt.button == 3) {
                this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.IS_CURSOR_IN_CANVAS.name(), (Object)"true");
                this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.EXCLUDED_LIST.name(), (Object)Arrays.stream(ExclusionActivity.getExcludedTrusses()).collect(Collectors.joining(",")));
                if (point.x > 0 && point.x < this.curveAreaBounds.width) {
                    int index = trailRecordSet.getIndex(this.timeLine.getAdjacentTimestamp(point.x));
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_LINK_PATH.name(), (Object)trailRecordSet.getDataTagText(index, TrailDataTags.DataTag.LINK_PATH));
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_FILE_PATH.name(), (Object)trailRecordSet.getDataTagText(index, TrailDataTags.DataTag.FILE_PATH));
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.RECORDSET_BASE_NAME.name(), (Object)trailRecordSet.getDataTagText(index, TrailDataTags.DataTag.RECORDSET_BASE_NAME));
                } else {
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_LINK_PATH.name(), (Object)"");
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_FILE_PATH.name(), (Object)"");
                    this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.RECORDSET_BASE_NAME.name(), (Object)"");
                }
            }
        }
    }

    void mouseUpAction(MouseEvent evt) {
        if (Channels.getInstance().getActiveChannel() == null) {
            return;
        }
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (this.canvasImage != null && trailRecordSet != null && trailRecordSet.getTimeStepSize() > 0) {
            Point point = this.checkCurveBounds(evt.x, evt.y);
            if (evt.button == 1) {
                this.windowActor.processMouseUpAction(point);
            }
        }
    }

    @Override
    protected void setFixedGraphicCanvas(Rectangle realBounds) {
    }

    @Override
    protected void drawCurveArea(int dataScaleWidth) {
        this.canvasImageGC.setBackground(this.curveAreaBackground);
        this.canvasImageGC.fillRectangle(this.curveAreaBounds);
        this.canvasImageGC.setBackground(this.surroundingBackground);
        this.canvasImageGC.setForeground(this.curveAreaBorderColor);
        int xMax = this.curveAreaBounds.x + this.curveAreaBounds.width;
        int y0 = this.curveAreaBounds.y + this.curveAreaBounds.height;
        this.canvasImageGC.drawLine(this.curveAreaBounds.x - 1, this.curveAreaBounds.y - 1, xMax + 1, this.curveAreaBounds.y - 1);
        this.canvasImageGC.drawLine(this.curveAreaBounds.x - 1, this.curveAreaBounds.y - 1, this.curveAreaBounds.x - 1, y0);
        this.canvasImageGC.drawLine(xMax + 1, this.curveAreaBounds.y - 1, xMax + 1, y0);
        this.timeLine.drawTimeLine(this.canvasImageGC);
        long startTime = new Date().getTime();
        this.drawTrailRecordSet(dataScaleWidth);
        log.fine(() -> "draw records time = " + StringHelper.getFormatedDuration("ss.SSS", new Date().getTime() - startTime));
    }

    @Override
    protected void defineLayoutParams() {
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        this.timeLine.initialize(trailRecordSet, this.curveAreaBounds);
        this.chartData.clear();
        for (TrailRecord record : trailRecordSet.getValues()) {
            this.chartData.put(record.getName(), new GraphicsLayout(record, this));
        }
        trailRecordSet.updateSyncGraphicsScale(this);
        TrailRecord[] trailRecordsSortedForDisplay = trailRecordSet.getRecordsSortedForDisplay();
        for (int i = 0; i < trailRecordsSortedForDisplay.length; ++i) {
            boolean isActualRecordEnabled;
            TrailRecord actualRecord = trailRecordsSortedForDisplay[i];
            boolean bl = isActualRecordEnabled = actualRecord.isVisible() && actualRecord.isDisplayable();
            if (isActualRecordEnabled) {
                log.fine(() -> String.format("record=%s  isVisible=%b isDisplayable=%b isScaleVisible=%b", actualRecord.getName(), actualRecord.isVisible(), actualRecord.isDisplayable(), actualRecord.isScaleSynced(), actualRecord.isScaleVisible()));
            }
            this.setRecordDisplayValues(actualRecord);
        }
    }

    private void drawTrailRecordSet(int dataScaleWidth) {
        log.finer(() -> "trail record set graphics");
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (trailRecordSet == null) {
            return;
        }
        boolean isCurveGridEnabled = trailRecordSet.getValueGridType() > 0;
        boolean isDrawScaleInRecordColor = this.settings.isDrawScaleInRecordColor();
        boolean isDrawNameInRecordColor = this.settings.isDrawNameInRecordColor();
        boolean isDrawNumbersInRecordColor = this.settings.isDrawNumbersInRecordColor();
        TrailRecord[] trailRecordsSortedForDisplay = trailRecordSet.getRecordsSortedForDisplay();
        for (int i = 0; i < trailRecordsSortedForDisplay.length; ++i) {
            boolean isActualRecordEnabled;
            TrailRecord actualRecord = trailRecordsSortedForDisplay[i];
            boolean bl = isActualRecordEnabled = actualRecord.isVisible() && actualRecord.isDisplayable();
            if (isActualRecordEnabled) {
                log.fine(() -> String.format("record=%s  isVisible=%b isDisplayable=%b isScaleSynced=%b isScaleVisible=%b", actualRecord.getName(), actualRecord.isVisible(), actualRecord.isDisplayable(), actualRecord.isScaleSynced(), actualRecord.isScaleVisible()));
            }
            if (actualRecord.isScaleVisible()) {
                HistoCurveUtils.drawHistoScale(this.getChartData(actualRecord), this.canvasImageGC, this.curveAreaBounds, dataScaleWidth, isDrawScaleInRecordColor, isDrawNameInRecordColor, isDrawNumbersInRecordColor);
            }
            if (isCurveGridEnabled && trailRecordSet.isValueGridRecord(actualRecord)) {
                HistoCurveUtils.drawCurveGrid(trailRecordSet, this.canvasImageGC, this.curveAreaBounds, this.settings.getGridDashStyle());
            }
            if (!isActualRecordEnabled) continue;
            this.canvasImageGC.setClipping(this.curveAreaBounds.x - 1, this.curveAreaBounds.y - 1, this.curveAreaBounds.width + 2, this.curveAreaBounds.height + 2);
            if (actualRecord.getTrailSelector().isTrailSuite()) {
                HistoCurveUtils.drawHistoSuite(this.getChartData(actualRecord), this.canvasImageGC, this.curveAreaBounds, this.timeLine);
            } else {
                HistoCurveUtils.drawHistoCurve(this.getChartData(actualRecord), this.canvasImageGC, this.curveAreaBounds, this.timeLine);
            }
            this.canvasImageGC.setClipping(this.canvasBounds);
        }
    }

    @Override
    protected int[] defineNumberLeftRightScales() {
        int numberCurvesRight = 0;
        int numberCurvesLeft = 0;
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        TrailRecord[] trailRecordsSortedForDisplay = trailRecordSet.getRecordsSortedForDisplay();
        for (int i = 0; i < trailRecordsSortedForDisplay.length; ++i) {
            TrailRecord tmpRecord = trailRecordsSortedForDisplay[i];
            if (tmpRecord == null || !tmpRecord.isScaleVisible()) continue;
            log.finer(() -> "==>> " + tmpRecord.getName() + " isScaleVisible = " + tmpRecord.isScaleVisible());
            if (tmpRecord.isPositionLeft()) {
                ++numberCurvesLeft;
                continue;
            }
            ++numberCurvesRight;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "nCurveLeft=" + numberCurvesLeft + ", nCurveRight=" + numberCurvesRight);
        }
        int[] numberLeftRightScales = new int[]{numberCurvesLeft, numberCurvesRight};
        return numberLeftRightScales;
    }

    private void setRecordDisplayValues(TrailRecord record) {
        int[] numberTickMarks = new int[]{10, 5};
        double yMaxValue = (double)this.getChartData(record).getSyncMaxValue() / 1000.0;
        double yMinValue = (double)this.getChartData(record).getSyncMinValue() / 1000.0;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "unmodified yMinValue=" + yMinValue + "; yMaxValue=" + yMaxValue);
        }
        double yMinValueDisplay = yMinValue;
        double yMaxValueDisplay = yMaxValue;
        if (record.isStartEndDefined()) {
            yMinValueDisplay = record.getMinScaleValue();
            yMaxValueDisplay = record.getMaxScaleValue();
            yMinValue = HistoSet.encodeVaultValue(record, yMinValueDisplay);
            yMaxValue = HistoSet.encodeVaultValue(record, yMaxValueDisplay);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "defined yMinValue=" + yMinValue + "; yMaxValue=" + yMaxValue);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "defined -> yMinValueDisplay = " + yMinValueDisplay + "; yMaxValueDisplay = " + yMaxValueDisplay);
            }
        } else {
            double deltaValueDisplay;
            if (record.getTrailSelector().isTrailSuite() || !record.parallelStream().noneMatch(Objects::nonNull)) {
                yMinValueDisplay = HistoSet.decodeVaultValue(record.getChannelItem(), yMinValue);
                yMaxValueDisplay = HistoSet.decodeVaultValue(record.getChannelItem(), yMaxValue);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "undefined -> yMinValueDisplay = " + yMinValueDisplay + "; yMaxValueDisplay = " + yMaxValueDisplay);
            }
            if (Math.abs(deltaValueDisplay = yMaxValueDisplay - yMinValueDisplay) < 1.0E-4) {
                yMaxValueDisplay = MathUtils.roundUp(yMaxValueDisplay, deltaValueDisplay);
                yMinValueDisplay = MathUtils.roundDown(yMinValueDisplay, deltaValueDisplay);
                Object[] roundResult = MathUtils.adaptRounding(yMinValueDisplay, yMaxValueDisplay, false, this.curveAreaBounds.height / 25 >= 3 ? this.curveAreaBounds.height / 25 : 2);
                yMinValueDisplay = (Double)roundResult[0];
                yMaxValueDisplay = (Double)roundResult[1];
                numberTickMarks[0] = (Integer)roundResult[2];
                numberTickMarks[1] = (Integer)roundResult[3];
                yMinValue = HistoSet.encodeVaultValue(record, yMinValueDisplay);
                yMaxValue = HistoSet.encodeVaultValue(record, yMaxValueDisplay);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("rounded yMinValue = %5.3f - yMaxValue = %5.3f", yMinValue, yMaxValue));
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "rounded -> yMinValueDisplay = " + yMinValueDisplay + "; yMaxValueDisplay = " + yMaxValueDisplay);
                }
            }
            if (record.isStartpointZero()) {
                if (record.getAvgValue() > 0) {
                    yMinValueDisplay = 0.0;
                    yMinValue = HistoSet.encodeVaultValue(record, yMinValueDisplay);
                } else {
                    yMaxValueDisplay = 0.0;
                    yMaxValue = HistoSet.encodeVaultValue(record, yMaxValueDisplay);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "scale starts at 0; yMinValue=" + yMinValue + "; yMaxValue=" + yMaxValue);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "scale starts at 0 -> yMinValueDisplay = " + yMinValueDisplay + "; yMaxValueDisplay = " + yMaxValueDisplay);
                }
            }
        }
        record.setMinMaxScaleValue(yMinValueDisplay, yMaxValueDisplay);
        this.getChartData(record).setSyncedMinMaxDisplayValues(yMinValue, yMaxValue);
        this.getChartData(record).setNumberTickMarks(numberTickMarks);
    }

    @Override
    public void setMeasuringActive(Measure measure) {
        this.measuring = new GraphicsMeasuring(this, measure);
        if (this.canvasBounds == null) {
            return;
        }
        this.doRedrawGraphics();
    }

    public HistoTimeLine getTimeLine() {
        return this.timeLine;
    }

    public GraphicsLayout getChartData(TrailRecord trailRecord) {
        return (GraphicsLayout)this.chartData.get(trailRecord.getName());
    }

    public void callMeasurePopUp(long timestamp_ms) {
        boolean isCreated = false;
        if (this.measurePopUp == null || this.measurePopUp != null && this.measurePopUp.isDisposed()) {
            this.measurePopUp = new Shell(GDE.shell, 8);
            this.measurePopUp.setParent((Composite)this);
            this.measurePopUp.setLayout((Layout)new FillLayout());
            this.measurePopUp.setAlpha(200);
            isCreated = true;
        }
        if (this.styledText == null || this.styledText != null && this.styledText.isDisposed()) {
            this.styledText = new StyledText((Composite)this.measurePopUp, 0);
            this.styledText.setEditable(false);
            this.styledText.setEnabled(false);
            this.styledText.setFont(SWTResourceManager.getFont("Courier New", GDE.WIDGET_FONT_SIZE + 1, 1));
        }
        if (GraphicsMeasuring.xPosMeasure != this.lastXPositionMeasure) {
            TrailRecordSetFormatter.setSelectedMeasurementsAsTable4PopUp(this.styledText, timestamp_ms);
            this.measurePopUp.pack();
            int locationX = GDE.shell.getLocation().x + (GDE.shell.getBounds().width - this.getBounds().width) + this.timeLine.getCurveAreaBounds().x + GraphicsMeasuring.xPosMeasure + 20;
            locationX = locationX + this.measurePopUp.getBounds().width > this.monitorBounds.width || GraphicsMeasuring.xPosMeasure > this.lastXPositionMeasure && locationX - 30 - this.measurePopUp.getBounds().width > 0 ? locationX - 30 - this.measurePopUp.getBounds().width : locationX;
            int locationY = GDE.shell.getLocation().y + this.application.getTabFolder().getLocation().y + this.graphicsHeader.getBounds().height + GraphicsMeasuring.yPosMeasure + 18;
            locationY = locationY < 0 ? GDE.shell.getLocation().y + this.application.getTabFolder().getLocation().y + this.graphicsHeader.getBounds().height + this.graphicCanvas.getBounds().height / 2 : locationY;
            this.measurePopUp.setLocation(locationX, locationY);
            if (isCreated) {
                this.measurePopUp.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphicsComposite.this.measurePopUp.open();
                    }
                });
            }
            this.lastXPositionMeasure = GraphicsMeasuring.xPosMeasure;
        }
    }

    public void cleanMeasurePopUp() {
        if (this.measurePopUp != null && !this.measurePopUp.isDisposed()) {
            if (this.styledText != null && !this.styledText.isDisposed()) {
                this.styledText.dispose();
                this.styledText = null;
            }
            this.measurePopUp.close();
            this.measurePopUp = null;
        }
    }

    public static final class GraphicsLayout
    extends AbstractChartComposite.AbstractChartLayout {
        private final TrailRecord trailRecord;
        private final GraphicsComposite parent;
        protected int syncMaxValue = Integer.MAX_VALUE;
        protected int syncMinValue = Integer.MIN_VALUE;
        double displayScaleFactorTime;
        protected double displayScaleFactorValue;
        protected double syncMasterFactor = 1.0;
        protected double minDisplayValue;
        protected double maxDisplayValue;
        int numberScaleTicks = 0;
        private int[] numberTickMarks;

        public GraphicsLayout(TrailRecord trailRecord, GraphicsComposite parent) {
            this.trailRecord = trailRecord;
            this.parent = parent;
            if (trailRecord.isStartEndDefined()) {
                this.maxDisplayValue = trailRecord.getMaxScaleValue();
                this.minDisplayValue = trailRecord.getMinScaleValue();
            }
        }

        public double getDisplayScaleFactorValue() {
            return this.displayScaleFactorValue;
        }

        public void setDisplayScaleFactorValue(int drawAreaHeight) {
            this.displayScaleFactorValue = 1.0 * (double)drawAreaHeight / (this.maxDisplayValue - this.minDisplayValue);
            AbstractRecordSet abstractParent = this.trailRecord.getAbstractParent();
            if (abstractParent.isOneOfSyncableRecord(this.trailRecord.getName()) && this.trailRecord.getFactor() / abstractParent.get(abstractParent.getSyncMasterRecordOrdinal(this.trailRecord.getName())).getFactor() != 1.0) {
                this.syncMasterFactor = this.trailRecord.getFactor() / abstractParent.get(abstractParent.getSyncMasterRecordOrdinal(this.trailRecord.getName())).getFactor();
                this.displayScaleFactorValue *= this.syncMasterFactor;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format(Locale.ENGLISH, "drawAreaHeight = %d displayScaleFactorValue = %.3f (this.maxDisplayValue - this.minDisplayValue) = %.3f", drawAreaHeight, this.displayScaleFactorValue, this.maxDisplayValue - this.minDisplayValue));
            }
        }

        public double getMinDisplayValue() {
            return this.minDisplayValue;
        }

        public double getMaxDisplayValue() {
            return this.maxDisplayValue;
        }

        public int getNumberScaleTicks() {
            return this.numberScaleTicks;
        }

        public void setNumberScaleTicks(int newNumberScaleTicks) {
            this.numberScaleTicks = newNumberScaleTicks;
        }

        public int[] getNumberTickMarks() {
            return this.numberTickMarks;
        }

        public void setNumberTickMarks(int[] numberTickMarks) {
            this.numberTickMarks = numberTickMarks;
        }

        public void setSyncedMinMaxDisplayValues(double newMinValue, double newMaxValue) {
            this.minDisplayValue = HistoSet.decodeVaultValue(this.trailRecord.getChannelItem(), newMinValue);
            this.maxDisplayValue = HistoSet.decodeVaultValue(this.trailRecord.getChannelItem(), newMaxValue);
            TrailRecordSet trailRecordset = this.trailRecord.getParent();
            if (trailRecordset.isOneOfSyncableRecord(this.trailRecord.getName())) {
                for (TrailRecord record : trailRecordset.getScaleSyncedRecords(trailRecordset.getSyncMasterRecordOrdinal(this.trailRecord.getName()))) {
                    this.parent.getChartData((TrailRecord)record).minDisplayValue = this.minDisplayValue;
                    this.parent.getChartData((TrailRecord)record).maxDisplayValue = this.maxDisplayValue;
                }
            }
            log.fine(this.trailRecord.getName() + " yMinValue = " + newMinValue + "; yMaxValue = " + newMaxValue);
        }

        public void setSyncMaxMinValue() {
            if (this.trailRecord.getTrailSelector().isTrailSuite()) {
                int suiteMinValue;
                int suiteMaxValue = this.trailRecord.getSuiteRecords().getSuiteMaxValue();
                int tmpMaxValue = suiteMaxValue == (suiteMinValue = this.trailRecord.getSuiteRecords().getSuiteMinValue()) ? suiteMaxValue + 100 : suiteMaxValue;
                int tmpMinValue = suiteMaxValue == suiteMinValue ? suiteMinValue - 100 : suiteMinValue;
                this.syncMaxValue = (int)((double)tmpMaxValue * this.getSyncMasterFactor());
                this.syncMinValue = (int)((double)tmpMinValue * this.getSyncMasterFactor());
            } else {
                this.syncMaxValue = (int)((double)this.trailRecord.getMaxValue() * this.getSyncMasterFactor());
                this.syncMinValue = (int)((double)this.trailRecord.getMinValue() * this.getSyncMasterFactor());
            }
            log.finer(() -> this.trailRecord.getName() + "  syncMin = " + this.getSyncMinValue() + "; syncMax = " + this.getSyncMaxValue());
        }

        public void setSyncMinMax(int newMin, int newMax) {
            if (newMin == Integer.MIN_VALUE && newMax == Integer.MAX_VALUE) {
                return;
            }
            this.syncMinValue = newMin;
            this.syncMaxValue = newMax;
            log.finer(() -> this.trailRecord.getName() + " syncMinValue=" + newMin + " syncMaxValue=" + newMax);
        }

        public int getSyncMinValue() {
            return this.syncMinValue == this.syncMaxValue ? this.syncMinValue - 100 : this.syncMinValue;
        }

        public int getSyncMaxValue() {
            return this.syncMaxValue == this.syncMinValue ? this.syncMaxValue + 100 : this.syncMaxValue;
        }

        public double getSyncMasterFactor() {
            return this.syncMasterFactor;
        }

        public TrailRecord getTrailRecord() {
            return this.trailRecord;
        }

        public String toString() {
            return "GraphicsLayout [trailRecordSize=" + this.trailRecord.size() + ", parent=" + String.valueOf((Object)this.parent) + ", syncMaxValue=" + this.syncMaxValue + ", syncMinValue=" + this.syncMinValue + ", displayScaleFactorTime=" + this.displayScaleFactorTime + ", displayScaleFactorValue=" + this.displayScaleFactorValue + ", syncMasterFactor=" + this.syncMasterFactor + ", minDisplayValue=" + this.minDisplayValue + ", maxDisplayValue=" + this.maxDisplayValue + ", numberScaleTicks=" + this.numberScaleTicks + ", numberTickMarks=" + Arrays.toString(this.numberTickMarks) + "]";
        }
    }
}

