/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.cache;

import gde.data.Record;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="data_types")
@XmlEnum
public enum DataTypes {
    DEFAULT("default"),
    GPS_LATITUDE("gps_latitude"),
    GPS_LONGITUDE("gps_longitude"),
    GPS_ALTITUDE("gps_altitude"),
    GPS_AZIMUTH("gps_azimuth"),
    SPEED("speed"),
    DATE_TIME("date_time"),
    CURRENT("current"),
    VOLTAGE("voltage");

    private final String value;
    public static final DataTypes[] VALUES;

    private DataTypes(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static DataTypes fromValue(String v) {
        for (DataTypes c : VALUES) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public static DataTypes fromDataType(Record.DataType v) {
        for (DataTypes c : VALUES) {
            if (!c.name().equals(v.name())) continue;
            return c;
        }
        throw new IllegalArgumentException(v.name());
    }

    public static Record.DataType toDataType(DataTypes vaultDataType) {
        for (Record.DataType recordDataType : Record.DataType.values()) {
            if (!recordDataType.name().equals(vaultDataType.name())) continue;
            return recordDataType;
        }
        throw new IllegalArgumentException(vaultDataType.name());
    }

    public static List<DataTypes> getAsList() {
        ArrayList<DataTypes> dataTypes = new ArrayList<DataTypes>();
        for (DataTypes type : VALUES) {
            dataTypes.add(type);
        }
        return dataTypes;
    }

    public static List<String> getValuesAsList() {
        ArrayList<String> dataTypeValues = new ArrayList<String>();
        for (DataTypes type : VALUES) {
            dataTypeValues.add(type.value);
        }
        return dataTypeValues;
    }

    static {
        VALUES = DataTypes.values();
    }
}

