/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.BookmarkElement;
import org.xhtmlrenderer.pdf.CheckboxFormField;
import org.xhtmlrenderer.pdf.EmptyReplacedElement;
import org.xhtmlrenderer.pdf.ITextImageElement;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.RadioButtonFormField;
import org.xhtmlrenderer.pdf.TextFormField;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;

public class ITextReplacedElementFactory
implements ReplacedElementFactory {
    private ITextOutputDevice _outputDevice;
    private Map _radioButtonsByElem = new HashMap();
    private Map _radioButtonsByName = new HashMap();

    public ITextReplacedElementFactory(ITextOutputDevice outputDevice) {
        this._outputDevice = outputDevice;
    }

    @Override
    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("img")) {
            FSImage fsImage;
            String srcAttr = e.getAttribute("src");
            if (srcAttr != null && srcAttr.length() > 0 && (fsImage = uac.getImageResource(srcAttr).getImage()) != null) {
                if (cssWidth != -1 || cssHeight != -1) {
                    fsImage.scale(cssWidth, cssHeight);
                }
                return new ITextImageElement(fsImage);
            }
        } else {
            if (nodeName.equals("input")) {
                String type2 = e.getAttribute("type");
                if (type2.equals("hidden")) {
                    return new EmptyReplacedElement(1, 1);
                }
                if (type2.equals("checkbox")) {
                    return new CheckboxFormField(c, box, cssWidth, cssHeight);
                }
                if (type2.equals("radio")) {
                    return new EmptyReplacedElement(0, 0);
                }
                return new TextFormField(c, box, cssWidth, cssHeight);
            }
            if (nodeName.equals("bookmark")) {
                BookmarkElement result2 = new BookmarkElement();
                if (e.hasAttribute("name")) {
                    String name = e.getAttribute("name");
                    c.addBoxId(name, box);
                    result2.setAnchorName(name);
                }
                return result2;
            }
        }
        return null;
    }

    private boolean isTextarea(Element e) {
        if (!e.getNodeName().equals("textarea")) {
            return false;
        }
        Node n = e.getFirstChild();
        while (n != null) {
            short nodeType = n.getNodeType();
            if (nodeType == 3 || nodeType == 4) continue;
            return false;
        }
        return true;
    }

    private void saveResult(Element e, RadioButtonFormField result2) {
        this._radioButtonsByElem.put(e, result2);
        String fieldName = result2.getFieldName(this._outputDevice, e);
        ArrayList<RadioButtonFormField> fields2 = (ArrayList<RadioButtonFormField>)this._radioButtonsByName.get(fieldName);
        if (fields2 == null) {
            fields2 = new ArrayList<RadioButtonFormField>();
            this._radioButtonsByName.put(fieldName, fields2);
        }
        fields2.add(result2);
    }

    @Override
    public void reset() {
        this._radioButtonsByElem = new HashMap();
        this._radioButtonsByName = new HashMap();
    }

    @Override
    public void remove(Element e) {
        String fieldName;
        List values2;
        RadioButtonFormField field2 = (RadioButtonFormField)this._radioButtonsByElem.remove(e);
        if (field2 != null && (values2 = (List)this._radioButtonsByName.get(fieldName = field2.getFieldName(this._outputDevice, e))) != null) {
            values2.remove(field2);
            if (values2.size() == 0) {
                this._radioButtonsByName.remove(fieldName);
            }
        }
    }

    public void remove(String fieldName) {
        List values2 = (List)this._radioButtonsByName.get(fieldName);
        if (values2 != null) {
            for (RadioButtonFormField field2 : values2) {
                this._radioButtonsByElem.remove(field2.getBox().getElement());
            }
        }
        this._radioButtonsByName.remove(fieldName);
    }

    public List getRadioButtons(String name) {
        return (List)this._radioButtonsByName.get(name);
    }

    @Override
    public void setFormSubmissionListener(FormSubmissionListener listener2) {
    }
}

