/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.util.Iterator;
import java.util.List;
import org.xhtmlrenderer.css.constants.IdentValue;

public class CounterFunction {
    private IdentValue _listStyleType;
    private int _counterValue;
    private List _counterValues;
    private String _separator;

    public CounterFunction(int counterValue, IdentValue listStyleType) {
        this._counterValue = counterValue;
        this._listStyleType = listStyleType;
    }

    public CounterFunction(List counterValues, String separator2, IdentValue listStyleType) {
        this._counterValues = counterValues;
        this._separator = separator2;
        this._listStyleType = listStyleType;
    }

    public String evaluate() {
        if (this._counterValues == null) {
            return CounterFunction.createCounterText(this._listStyleType, this._counterValue);
        }
        StringBuffer sb = new StringBuffer();
        Iterator i2 = this._counterValues.iterator();
        while (i2.hasNext()) {
            Integer value = (Integer)i2.next();
            sb.append(CounterFunction.createCounterText(this._listStyleType, value));
            if (!i2.hasNext()) continue;
            sb.append(this._separator);
        }
        return sb.toString();
    }

    public static String createCounterText(IdentValue listStyle, int listCounter) {
        String text2 = listStyle == IdentValue.LOWER_LATIN || listStyle == IdentValue.LOWER_ALPHA ? CounterFunction.toLatin(listCounter).toLowerCase() : (listStyle == IdentValue.UPPER_LATIN || listStyle == IdentValue.UPPER_ALPHA ? CounterFunction.toLatin(listCounter).toUpperCase() : (listStyle == IdentValue.LOWER_ROMAN ? CounterFunction.toRoman(listCounter).toLowerCase() : (listStyle == IdentValue.UPPER_ROMAN ? CounterFunction.toRoman(listCounter).toUpperCase() : (listStyle == IdentValue.DECIMAL_LEADING_ZERO ? (listCounter >= 10 ? "" : "0") + listCounter : Integer.toString(listCounter)))));
        return text2;
    }

    private static String toLatin(int val) {
        String result2 = "";
        --val;
        while (val >= 0) {
            int letter = val % 26;
            val = val / 26 - 1;
            result2 = (char)(letter + 65) + result2;
        }
        return result2;
    }

    private static String toRoman(int val) {
        int[] ints = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] nums = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < ints.length; ++i2) {
            int count = val / ints[i2];
            for (int j = 0; j < count; ++j) {
                sb.append(nums[i2]);
            }
            val -= ints[i2] * count;
        }
        return sb.toString();
    }
}

