/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTMenu;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    NSMenuItem nsItem;
    Menu parent;
    Menu menu;
    int accelerator;
    long nsItemAction;
    id nsItemTarget;
    String toolTipText;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    MenuItem(Menu parent, NSMenuItem nsMenuItem) {
        super(parent, 0);
        this.parent = parent;
        this.nsItem = nsMenuItem;
        parent.createItem(this, parent.getItemCount());
    }

    public void addArmListener(ArmListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        return MenuItem.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    NSMenu createEmptyMenu() {
        if ((this.parent.style & 2) != 0) {
            return (NSMenu)new SWTMenu().alloc().init();
        }
        return null;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsItem);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getID() {
        this.checkWidget();
        return (int)this.nsItem.tag();
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    @Override
    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return this.nsItem.state() == 1L;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    int keyChar(int key2) {
        switch (key2) {
            case 8: {
                return 8;
            }
            case 13: {
                return 13;
            }
            case 127: {
                return 127;
            }
            case 27: {
                return 27;
            }
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 65536: {
                return 8997;
            }
            case 131072: {
                return 8679;
            }
            case 262144: {
                return 992003;
            }
            case 0x400000: {
                return 8984;
            }
            case 0x1000001: {
                return 8593;
            }
            case 0x1000002: {
                return 8595;
            }
            case 0x1000003: {
                return 8592;
            }
            case 0x1000004: {
                return 8594;
            }
            case 0x1000005: {
                return 8670;
            }
            case 0x1000006: {
                return 8671;
            }
            case 0x1000050: {
                return 3;
            }
            case 0x1000051: {
                return 63302;
            }
            case 0x1000007: {
                return 63273;
            }
            case 0x1000008: {
                return 63275;
            }
            case 0x100000A: {
                return 63236;
            }
            case 0x100000B: {
                return 63237;
            }
            case 0x100000C: {
                return 63238;
            }
            case 0x100000D: {
                return 63239;
            }
            case 0x100000E: {
                return 63240;
            }
            case 0x100000F: {
                return 63241;
            }
            case 0x1000010: {
                return 63242;
            }
            case 0x1000011: {
                return 63243;
            }
            case 0x1000012: {
                return 63244;
            }
            case 0x1000013: {
                return 63245;
            }
            case 0x1000014: {
                return 63246;
            }
            case 0x1000015: {
                return 63247;
            }
            case 0x1000016: {
                return 63248;
            }
            case 0x1000017: {
                return 63249;
            }
            case 0x1000018: {
                return 63250;
            }
        }
        return 0;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.nsItem, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.nsItem != null) {
            this.nsItem.release();
        }
        this.nsItem = null;
        this.parent = null;
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.accelerator = 0;
        if (this == this.parent.defaultItem) {
            this.parent.defaultItem = null;
        }
    }

    public void removeArmListener(ArmListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener2);
    }

    public void removeHelpListener(HelpListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener2);
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener2);
        this.eventTable.unhook(14, listener2);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.menu != null) {
            this.menu.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    void selectRadio() {
        int index = 0;
        MenuItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i2 = index - 1;
        while (i2 >= 0 && items[i2].setRadioSelection(false)) {
            --i2;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    @Override
    void sendSelection() {
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        } else if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.getSelection());
            } else {
                this.selectRadio();
            }
        }
        Event event = new Event();
        this.sendSelectionEvent(13, event, this.nsItemAction != 0L);
        if (this.isDisposed()) {
            return;
        }
        if (this.nsItemAction != 0L && event.doit) {
            NSApplication app = NSApplication.sharedApplication();
            app.sendAction(this.nsItemAction, this.nsItemTarget, app);
        }
    }

    public void setAccelerator(int accelerator) {
        int virtualKey;
        this.checkWidget();
        if (this.accelerator == accelerator) {
            return;
        }
        this.accelerator = accelerator;
        int key2 = accelerator & 0x100FFFF;
        if (key2 == 27 && key2 == accelerator && !this.display.escAsAcceleratorPresent) {
            this.display.escAsAcceleratorPresent = true;
        }
        String string2 = (virtualKey = this.keyChar(key2)) != 0 ? String.valueOf((char)virtualKey) : String.valueOf((char)key2);
        NSString nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString(string2);
        this.nsItem.setKeyEquivalent(nsstring.lowercaseString());
        nsstring.release();
        int mask = 0;
        if ((accelerator & 0x20000) != 0) {
            mask |= 0x20000;
        }
        if ((accelerator & 0x40000) != 0) {
            mask |= 0x40000;
        }
        if ((accelerator & 0x400000) != 0) {
            mask |= 0x100000;
        }
        if ((accelerator & 0x10000) != 0) {
            mask |= 0x80000;
        }
        this.nsItem.setKeyEquivalentModifierMask(mask);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.nsItem.setEnabled(enabled);
    }

    public void setID(int id2) {
        this.checkWidget();
        if (id2 < 0) {
            this.error(5);
        }
        this.nsItem.setTag(id2);
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.nsItem.setImage(image != null ? image.handle : null);
    }

    public void setMenu(Menu menu2) {
        Menu oldMenu;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu2 != null) {
            if (menu2.isDisposed() || menu2 == this.parent) {
                this.error(5);
            }
            if ((menu2.style & 4) == 0) {
                this.error(21);
            }
            if (this.parent.parent != null && menu2.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((oldMenu = this.menu) == menu2) {
            return;
        }
        if (oldMenu != null) {
            oldMenu.cascade = null;
        }
        this.menu = menu2;
        if (menu2 == null) {
            NSMenu emptyMenu = this.createEmptyMenu();
            if (emptyMenu != null) {
                this.nsItem.setSubmenu(emptyMenu);
                emptyMenu.release();
            }
        } else {
            menu2.cascade = this;
            this.nsItem.setSubmenu(menu2.nsMenu);
        }
        if (menu2 != null) {
            this.nsItem.setTarget(null);
            this.nsItem.setAction(0L);
        } else {
            this.nsItem.setTarget(this.nsItem);
            this.nsItem.setAction(OS.sel_sendSelection);
        }
        this.updateText();
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.nsItem.setState(selected ? 1 : 0);
    }

    @Override
    public void setText(String string2) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string2)) {
            return;
        }
        super.setText(string2);
        this.updateText();
    }

    public void setToolTipText(String toolTip) {
        this.checkWidget();
        if (toolTip == null && this.toolTipText != null) {
            this.toolTipText = null;
            this.nsItem.setToolTip(null);
        }
        if (toolTip == null || toolTip.trim().length() == 0 || toolTip.equals(this.toolTipText)) {
            return;
        }
        this.toolTipText = toolTip;
        char[] chars = new char[this.toolTipText.length()];
        this.toolTipText.getChars(0, chars.length, chars, 0);
        int length = this.fixMnemonic(chars);
        this.nsItem.setToolTip(NSString.stringWithCharacters(chars, length));
    }

    void updateText() {
        if (this.isDisposed() || this.parent.isDisposed()) {
            return;
        }
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int i2 = 0;
        int j = 0;
        while (i2 < buffer.length) {
            if (buffer[i2] == '\t') break;
            if ((buffer[j++] = buffer[i2++]) != '&' || i2 == buffer.length) continue;
            if (buffer[i2] == '&') {
                ++i2;
                continue;
            }
            --j;
        }
        String text2 = new String(buffer, 0, j);
        NSMenu submenu = this.nsItem.submenu();
        NSString label2 = (NSString)new NSString().alloc();
        label2 = label2.initWithString(text2);
        if (submenu != null && (this.parent.getStyle() & 2) != 0) {
            submenu.setTitle(label2);
        } else {
            int direction = (this.parent.getStyle() & 0x4000000) != 0 ? 1 : 0;
            NSMutableDictionary dict = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(2L);
            NSMutableParagraphStyle paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            paragraphStyle.setBaseWritingDirection(direction);
            paragraphStyle.setLineBreakMode(5L);
            dict.setObject(paragraphStyle, OS.NSParagraphStyleAttributeName);
            paragraphStyle.release();
            dict.setObject(NSFont.menuBarFontOfSize(0.0), OS.NSFontAttributeName);
            NSAttributedString attribStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(label2, dict);
            dict.release();
            this.nsItem.setAttributedTitle(attribStr);
            if (text2.length() == 0) {
                this.nsItem.setTitle(NSString.string());
            }
            attribStr.release();
        }
        label2.release();
    }

    boolean updateAccelerator(boolean show2) {
        if (this.accelerator != 0) {
            return false;
        }
        int mask = 0;
        int key2 = 0;
        if (show2) {
            char[] buffer = new char[this.text.length()];
            this.text.getChars(0, buffer.length, buffer, 0);
            int i2 = 0;
            int j = 0;
            while (i2 < buffer.length) {
                if (buffer[i2] == '\t') break;
                if ((buffer[j++] = buffer[i2++]) != '&' || i2 == buffer.length) continue;
                if (buffer[i2] == '&') {
                    ++i2;
                    continue;
                }
                --j;
            }
            if (i2 < buffer.length && buffer[i2] == '\t') {
                j = i2 + 1;
                while (j < buffer.length) {
                    switch (buffer[j]) {
                        case '\u2303': {
                            mask |= 0x40000;
                            ++i2;
                            break;
                        }
                        case '\u2325': {
                            mask |= 0x80000;
                            ++i2;
                            break;
                        }
                        case '\u21e7': {
                            mask |= 0x20000;
                            ++i2;
                            break;
                        }
                        case '\u2318': {
                            mask |= 0x100000;
                            ++i2;
                            break;
                        }
                        default: {
                            j = buffer.length;
                        }
                    }
                    ++j;
                }
                block6 : switch (buffer.length - i2 - 1) {
                    case 1: {
                        key2 = buffer[i2 + 1];
                        if (key2 != 9251) break;
                        key2 = 32;
                        break;
                    }
                    case 2: {
                        if (buffer[i2 + 1] != 'F') break;
                        switch (buffer[i2 + 2]) {
                            case '1': {
                                key2 = 63236;
                                break;
                            }
                            case '2': {
                                key2 = 63237;
                                break;
                            }
                            case '3': {
                                key2 = 63238;
                                break;
                            }
                            case '4': {
                                key2 = 63239;
                                break;
                            }
                            case '5': {
                                key2 = 63240;
                                break;
                            }
                            case '6': {
                                key2 = 63241;
                                break;
                            }
                            case '7': {
                                key2 = 63242;
                                break;
                            }
                            case '8': {
                                key2 = 63243;
                                break;
                            }
                            case '9': {
                                key2 = 63244;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (buffer[i2 + 1] != 'F' || buffer[i2 + 2] != '1') break;
                        switch (buffer[i2 + 3]) {
                            case '0': {
                                key2 = 63245;
                                break block6;
                            }
                            case '1': {
                                key2 = 63246;
                                break block6;
                            }
                            case '2': {
                                key2 = 63247;
                                break block6;
                            }
                            case '3': {
                                key2 = 63248;
                                break block6;
                            }
                            case '4': {
                                key2 = 63249;
                                break block6;
                            }
                            case '5': {
                                key2 = 63250;
                            }
                        }
                    }
                }
            }
        }
        this.nsItem.setKeyEquivalentModifierMask(mask);
        NSString nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString(key2 == 0 ? "" : String.valueOf((char)key2));
        this.nsItem.setKeyEquivalent(nsstring.lowercaseString());
        nsstring.release();
        return key2 != 0;
    }
}

