/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTMenu;
import org.eclipse.swt.internal.cocoa.SWTMenuItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    NSMenu nsMenu;
    int x;
    int y;
    int itemCount;
    boolean hasLocation;
    boolean visible;
    MenuItem[] items;
    MenuItem cascade;
    MenuItem defaultItem;
    Decorations parent;
    static final int GAP = 4;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = Menu.checkStyle(style);
        if (parent != null) {
            this.display = parent.display;
        } else {
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = Display.getDefault();
            }
            if (!this.display.isValidThread()) {
                this.error(22);
            }
        }
        this.parent = parent;
        this.reskinWidget();
        this.createWidget();
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    Menu(Display display) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.display = display;
        this.style = 2;
        this.reskinWidget();
        this.createWidget();
    }

    Menu(Display display, NSMenu nativeMenu) {
        this.display = display;
        this.style = 4;
        this.nsMenu = nativeMenu;
        this.reskinWidget();
        this.createWidget();
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu2) {
        if (menu2 == null) {
            SWT.error(4);
        }
        return menu2;
    }

    static MenuItem checkNull(MenuItem item2) {
        if (item2 == null) {
            SWT.error(4);
        }
        return item2;
    }

    @Override
    void checkParent(Widget parent) {
        if (parent == null && Display.getDefault().appMenuBar == null) {
            this.error(4);
        }
        if (parent != null) {
            if (parent.isDisposed()) {
                this.error(5);
            }
            parent.checkWidget();
            parent.checkOpen();
        }
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    void _setVisible(boolean visible) {
        if ((this.style & 6) != 0) {
            return;
        }
        TrayItem trayItem = this.display.currentTrayItem;
        if (trayItem != null && visible) {
            trayItem.showMenu(this);
            return;
        }
        if (visible) {
            Shell shell = this.getShell();
            NSWindow window = shell.view.window();
            NSPoint location = null;
            if (this.hasLocation) {
                NSView topView = window.contentView();
                Point shellCoord = this.display.map(null, (Control)shell, new Point(this.x, this.y));
                location = new NSPoint();
                location.x = shellCoord.x;
                location.y = topView.frame().height - (double)shellCoord.y;
            } else {
                location = window.mouseLocationOutsideOfEventStream();
            }
            this.hasLocation = false;
            window.retain();
            this.display.sendPreExternalEventDispatchEvent();
            NSEvent nsEvent = NSEvent.otherEventWithType(15L, location, 0L, 0.0, window.windowNumber(), window.graphicsContext(), (short)0, 0L, 0L);
            NSMenu.popUpContextMenu(this.nsMenu, nsEvent, shell.view);
            this.display.sendPostExternalEventDispatchEvent();
            window.release();
        } else {
            this.nsMenu.cancelTracking();
        }
    }

    public void addHelpListener(HelpListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    @Override
    void createHandle() {
        this.display.addMenu(this);
        if (this.nsMenu == null) {
            NSMenu widget = (NSMenu)new SWTMenu().alloc();
            widget = widget.initWithTitle(NSString.string());
            widget.setAutoenablesItems(false);
            widget.setDelegate(widget);
            this.nsMenu = widget;
        } else {
            this.nsMenu.retain();
            long cls = OS.object_getClass(this.nsMenu.id);
            long dynNSMenu_class = this.display.createMenuSubclass(cls, "SWTSystemMenu", true);
            if (cls != dynNSMenu_class) {
                OS.object_setClass(this.nsMenu.id, dynNSMenu_class);
            }
            this.nsMenu.setDelegate(this.nsMenu);
        }
    }

    void createItem(MenuItem item2, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        boolean add2 = true;
        NSMenuItem nsItem = item2.nsItem;
        if (nsItem == null) {
            if ((item2.style & 2) != 0) {
                nsItem = NSMenuItem.separatorItem();
                nsItem.retain();
            } else {
                nsItem = (NSMenuItem)new SWTMenuItem().alloc();
                NSString empty = NSString.string();
                nsItem.initWithTitle(empty, 0L, empty);
                nsItem.setTarget(nsItem);
                nsItem.setAction(OS.sel_sendSelection);
            }
            item2.nsItem = nsItem;
        } else {
            long dynNSMenuItem_class;
            long cls = OS.object_getClass(nsItem.id);
            if (cls != (dynNSMenuItem_class = this.display.createMenuItemSubclass(cls, "SWTSystemMenuItem", true))) {
                OS.object_setClass(nsItem.id, dynNSMenuItem_class);
            }
            nsItem.retain();
            item2.nsItemAction = nsItem.action();
            item2.nsItemTarget = nsItem.target();
            nsItem.setTarget(nsItem);
            nsItem.setAction(OS.sel_sendSelection);
            int type2 = 8;
            if (nsItem.isSeparatorItem()) {
                type2 = 2;
            }
            if (nsItem.submenu() != null) {
                type2 = 64;
            }
            item2.style |= type2;
            item2.text = nsItem.title().getString();
            long keyMask = nsItem.keyEquivalentModifierMask();
            NSString keyEquivString = nsItem.keyEquivalent();
            long keyEquiv = 0L;
            if (keyEquivString != null) {
                keyEquiv = keyEquivString.characterAtIndex(0L);
                if ((keyMask & 0x100000L) != 0L) {
                    keyEquiv |= 0x400000L;
                }
                if ((keyMask & 0x80000L) != 0L) {
                    keyEquiv |= 0x10000L;
                }
                item2.accelerator = (int)keyEquiv;
            }
            add2 = false;
        }
        item2.createJNIRef();
        item2.register();
        if (add2) {
            this.nsMenu.insertItem(nsItem, index);
        }
        if (this.itemCount == this.items.length) {
            MenuItem[] newItems = new MenuItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item2;
        if (add2) {
            NSApplication application;
            NSMenu menubar2;
            NSMenu emptyMenu = item2.createEmptyMenu();
            if (emptyMenu != null) {
                nsItem.setSubmenu(emptyMenu);
                emptyMenu.release();
            }
            if (this.display.menuBar == this && (menubar2 = (application = this.display.application).mainMenu()) != null) {
                nsItem.setMenu(null);
                menubar2.insertItem(nsItem, index + 1);
            }
        }
        if (!this.getEnabled()) {
            nsItem.setEnabled(false);
        }
    }

    @Override
    void createWidget() {
        this.checkOrientation(this.parent);
        super.createWidget();
        this.items = new MenuItem[4];
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsMenu);
    }

    void destroyItem(MenuItem item2) {
        NSApplication application;
        NSMenu menubar2;
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item2) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.items = new MenuItem[4];
        }
        this.nsMenu.removeItem(item2.nsItem);
        if (this.display.menuBar == this && (menubar2 = (application = this.display.application).mainMenu()) != null) {
            NSMenuItem nsItem = item2.nsItem;
            menubar2.removeItem(nsItem);
        }
    }

    void fixMenus(Decorations newParent) {
        this.parent = newParent;
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        MenuItem[] result2 = new MenuItem[this.itemCount];
        int index = 0;
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.itemCount) {
                MenuItem item2 = this.items[i2];
                if (item2 != null && !item2.isDisposed()) {
                    result2[index++] = item2;
                }
                ++i2;
            }
        }
        if (index != result2.length) {
            MenuItem[] newItems = new MenuItem[index];
            System.arraycopy(result2, 0, newItems, 0, index);
            result2 = newItems;
        }
        return result2;
    }

    @Override
    String getNameText() {
        String result2 = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i2 = 0;
            while (i2 < length - 1) {
                result2 = String.valueOf(result2) + items[i2].getNameText() + ", ";
                ++i2;
            }
            result2 = String.valueOf(result2) + items[length - 1].getNameText();
        }
        return result2;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        if (this.parent != null) {
            return this.parent.getShell();
        }
        return null;
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            if (this == this.display.appMenuBar) {
                return this.display.application.isActive();
            }
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            Menu[] popups = this.display.popups;
            if (popups == null) {
                return false;
            }
            int i2 = 0;
            while (i2 < popups.length) {
                if (popups[i2] == this) {
                    return true;
                }
                ++i2;
            }
        }
        return this.visible;
    }

    public int indexOf(MenuItem item2) {
        this.checkWidget();
        if (item2 == null) {
            this.error(4);
        }
        int i2 = 0;
        while (i2 < this.itemCount) {
            if (this.items[i2] == item2) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        if (this == this.display.appMenuBar) {
            return this.getEnabled();
        }
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    @Override
    void menu_willHighlightItem(long id2, long sel, long menu2, long itemID) {
        Widget widget = this.display.getWidget(itemID);
        if (widget instanceof MenuItem) {
            MenuItem item2 = (MenuItem)widget;
            item2.sendEvent(30);
        }
    }

    @Override
    void menuNeedsUpdate(long id2, long sel, long menu2) {
    }

    @Override
    void menuWillOpen(long id2, long sel, long menu2) {
        MenuItem item2;
        this.visible = true;
        this.sendEvent(22);
        if (this.isDisposed()) {
            return;
        }
        double width = 0.0;
        NSAttributedString[] strs = new NSAttributedString[this.itemCount];
        int i2 = 0;
        while (i2 < this.itemCount) {
            item2 = this.items[i2];
            NSMenuItem nsItem = item2.nsItem;
            strs[i2] = nsItem.attributedTitle();
            NSImage nsImage = nsItem.image();
            double w = 4.0;
            if (strs[i2] != null) {
                w += strs[i2].size().width;
            }
            if (nsImage != null) {
                w += nsImage.size().width + 4.0;
            }
            if (strs[i2] != null) {
                width = Math.max(width, w);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.itemCount) {
            String accelText;
            int length;
            int accelIndex;
            item2 = this.items[i2];
            if (!item2.updateAccelerator(true) && item2.accelerator == 0 && strs[i2] != null && (this.style & 2) == 0 && (item2.style & 0x40) == 0 && (accelIndex = item2.text.indexOf(9)) != -1 && (length = (accelText = item2.text.substring(accelIndex)).length()) > 1) {
                NSMenuItem nsItem = item2.nsItem;
                NSImage nsImage = nsItem.image();
                double tab2 = width;
                if (nsImage != null) {
                    tab2 -= nsImage.size().width + 4.0;
                }
                NSMutableAttributedString str = new NSMutableAttributedString(strs[i2].mutableCopy());
                NSString label2 = (NSString)new NSString().alloc();
                label2 = label2.initWithString(accelText);
                NSMutableDictionary dict = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(1L);
                dict.setObject(NSFont.menuBarFontOfSize(0.0), OS.NSFontAttributeName);
                NSAttributedString attribStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(label2, dict);
                dict.release();
                label2.release();
                str.appendAttributedString(attribStr);
                attribStr.release();
                NSRange range = new NSRange();
                range.length = str.length();
                NSMutableParagraphStyle paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
                paragraphStyle.setTabStops(NSArray.array());
                NSTextTab stop2 = (NSTextTab)new NSTextTab().alloc();
                stop2 = stop2.initWithType(0L, tab2);
                paragraphStyle.addTabStop(stop2);
                stop2.release();
                str.addAttribute(OS.NSParagraphStyleAttributeName, paragraphStyle, range);
                paragraphStyle.release();
                nsItem.setAttributedTitle(str);
                str.release();
            }
            ++i2;
        }
    }

    @Override
    void menuDidClose(long id2, long sel, long menu2) {
        this.sendEvent(23);
        if (this.isDisposed()) {
            return;
        }
        this.visible = false;
        int i2 = 0;
        while (i2 < this.itemCount) {
            MenuItem item2 = this.items[i2];
            item2.updateAccelerator(false);
            if ((item2.style & 2) == 0) {
                item2.updateText();
            }
            ++i2;
        }
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.nsMenu, this);
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.items.length) {
                MenuItem item2 = this.items[i2];
                if (item2 != null && !item2.isDisposed()) {
                    item2.release(false);
                }
                ++i2;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.nsMenu != null) {
            this.nsMenu.release();
        }
        this.nsMenu = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this.parent != null && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.display.removeMenu(this);
        this.parent = null;
        this.defaultItem = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener2);
    }

    public void removeMenuListener(MenuListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener2);
        this.eventTable.unhook(22, listener2);
    }

    @Override
    void reskinChildren(int flags) {
        MenuItem[] items = this.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            MenuItem item2 = items[i2];
            item2.reskin(flags);
            ++i2;
        }
        super.reskinChildren(flags);
    }

    public void setDefaultItem(MenuItem item2) {
        this.checkWidget();
        if (item2 != null && item2.isDisposed()) {
            this.error(5);
        }
        this.defaultItem = item2;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        int i2 = 0;
        while (i2 < this.items.length) {
            MenuItem item2 = this.items[i2];
            if (item2 != null) {
                item2.nsItem.setEnabled(enabled && item2.getEnabled());
            }
            ++i2;
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

