/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items = new ExpandItem[4];
    int itemCount;
    ExpandItem focusItem;
    int spacing;
    int yCurrentScroll;
    Font font;
    Color foreground;
    Listener listener = event -> {
        switch (event.type) {
            case 12: {
                this.onDispose(event);
                break;
            }
            case 3: {
                this.onMouseDown(event);
                break;
            }
            case 4: {
                this.onMouseUp(event);
                break;
            }
            case 9: {
                this.onPaint(event);
                break;
            }
            case 11: {
                this.onResize();
                break;
            }
            case 1: {
                this.onKeyDown(event);
                break;
            }
            case 15: {
                this.onFocus();
                break;
            }
            case 16: {
                this.onFocus();
                break;
            }
            case 31: {
                this.onTraverse(event);
            }
        }
    };
    boolean inDispose;

    public ExpandBar(Composite parent, int style) {
        super(parent, ExpandBar.checkStyle(style));
        this.addListener(12, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(1, this.listener);
        this.addListener(15, this.listener);
        this.addListener(16, this.listener);
        this.addListener(31, this.listener);
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar != null) {
            verticalBar.addListener(13, event -> this.onScroll(event));
        }
    }

    public void addExpandListener(ExpandListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFEFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed2) {
        this.checkWidget();
        int height = 0;
        int width = 0;
        if ((wHint == -1 || hHint == -1) && this.itemCount > 0) {
            height += this.spacing;
            GC gc = new GC(this);
            int i2 = 0;
            while (i2 < this.itemCount) {
                ExpandItem item2 = this.items[i2];
                height += item2.getHeaderHeight();
                if (item2.expanded) {
                    height += item2.height;
                }
                height += this.spacing;
                width = Math.max(width, item2.getPreferredWidth(gc));
                ++i2;
            }
            gc.dispose();
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    void createItem(ExpandItem item2, int style, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] newItems = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item2;
        ++this.itemCount;
        if (this.focusItem == null) {
            this.focusItem = item2;
        }
        item2.width = Math.max(0, this.getClientArea().width - this.spacing * 2);
        this.layoutItems(index, true);
    }

    void destroyItem(ExpandItem item2) {
        if (this.inDispose) {
            return;
        }
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item2) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        if (item2 == this.focusItem) {
            int focusIndex;
            int n = focusIndex = index > 0 ? index - 1 : 1;
            if (focusIndex < this.itemCount) {
                this.focusItem = this.items[focusIndex];
                this.focusItem.redraw();
            } else {
                this.focusItem = null;
            }
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        item2.redraw();
        this.layoutItems(index, true);
    }

    int getBandHeight() {
        if (this.font == null) {
            return 24;
        }
        GC gc = new GC(this);
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        return Math.max(24, metrics.getHeight());
    }

    @Override
    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            Display display = this.getDisplay();
            return display.getSystemColor(30);
        }
        return this.foreground;
    }

    public ExpandItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] result2 = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, result2, 0, this.itemCount);
        return result2;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    public int indexOf(ExpandItem item2) {
        this.checkWidget();
        if (item2 == null) {
            this.error(4);
        }
        int i2 = 0;
        while (i2 < this.itemCount) {
            if (this.items[i2] == item2) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    void layoutItems(int index, boolean setScrollbar) {
        if (index < this.itemCount) {
            ExpandItem item2;
            int y = this.spacing - this.yCurrentScroll;
            int i2 = 0;
            while (i2 < index) {
                item2 = this.items[i2];
                if (item2.expanded) {
                    y += item2.height;
                }
                y += item2.getHeaderHeight() + this.spacing;
                ++i2;
            }
            i2 = index;
            while (i2 < this.itemCount) {
                item2 = this.items[i2];
                item2.setBounds(this.spacing, y, 0, 0, true, false);
                if (item2.expanded) {
                    y += item2.height;
                }
                y += item2.getHeaderHeight() + this.spacing;
                ++i2;
            }
        }
        if (setScrollbar) {
            this.setScrollbar();
        }
    }

    public void removeExpandListener(ExpandListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener2);
        this.eventTable.unhook(18, listener2);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.items.length) {
                ExpandItem item2 = this.items[i2];
                if (item2 != null) {
                    item2.reskin(flags);
                }
                ++i2;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.layoutItems(0, true);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar == null) {
            return;
        }
        int height = this.getClientArea().height;
        ExpandItem item2 = this.items[this.itemCount - 1];
        int maxHeight = item2.y + this.getBandHeight() + this.spacing;
        if (item2.expanded) {
            maxHeight += item2.height;
        }
        if (this.yCurrentScroll > 0 && height > maxHeight) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + maxHeight - height);
            this.layoutItems(0, false);
        }
        int selection2 = Math.min(this.yCurrentScroll, maxHeight += this.yCurrentScroll);
        int increment = verticalBar.getIncrement();
        int pageIncrement = verticalBar.getPageIncrement();
        verticalBar.setValues(selection2, 0, maxHeight, height, increment, pageIncrement);
        verticalBar.setVisible(maxHeight > height);
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        if (spacing < 0) {
            return;
        }
        if (spacing == this.spacing) {
            return;
        }
        this.spacing = spacing;
        int width = Math.max(0, this.getClientArea().width - spacing * 2);
        int i2 = 0;
        while (i2 < this.itemCount) {
            ExpandItem item2 = this.items[i2];
            if (item2.width != width) {
                item2.setBounds(0, 0, width, item2.height, false, true);
            }
            ++i2;
        }
        this.layoutItems(0, true);
        this.redraw();
    }

    void showItem(ExpandItem item2) {
        Control control = item2.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(item2.expanded);
        }
        item2.redraw();
        int index = this.indexOf(item2);
        this.layoutItems(index + 1, true);
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        int i2 = 0;
        while (i2 < this.itemCount) {
            this.items[i2].dispose();
            ++i2;
        }
        this.items = null;
        this.font = null;
        this.foreground = null;
        this.focusItem = null;
    }

    void onFocus() {
        if (this.focusItem != null) {
            this.focusItem.redraw();
        }
    }

    void onKeyDown(Event event) {
        if (this.focusItem == null) {
            return;
        }
        switch (event.keyCode) {
            case 13: 
            case 32: {
                Event ev = new Event();
                ev.item = this.focusItem;
                this.sendEvent(this.focusItem.expanded ? 18 : 17, ev);
                this.focusItem.expanded = !this.focusItem.expanded;
                this.showItem(this.focusItem);
                break;
            }
            case 0x1000001: {
                int focusIndex = this.indexOf(this.focusItem);
                if (focusIndex <= 0) break;
                this.focusItem.redraw();
                this.focusItem = this.items[focusIndex - 1];
                this.focusItem.redraw();
                break;
            }
            case 0x1000002: {
                int focusIndex = this.indexOf(this.focusItem);
                if (focusIndex >= this.itemCount - 1) break;
                this.focusItem.redraw();
                this.focusItem = this.items[focusIndex + 1];
                this.focusItem.redraw();
            }
        }
    }

    void onMouseDown(Event event) {
        if (event.button != 1) {
            return;
        }
        int x = event.x;
        int y = event.y;
        int i2 = 0;
        while (i2 < this.itemCount) {
            boolean hover;
            ExpandItem item2 = this.items[i2];
            boolean bl = hover = item2.x <= x && x < item2.x + item2.width && item2.y <= y && y < item2.y + this.getBandHeight();
            if (hover && item2 != this.focusItem) {
                this.focusItem.redraw();
                this.focusItem = item2;
                this.focusItem.redraw();
                this.forceFocus();
                break;
            }
            ++i2;
        }
    }

    void onMouseUp(Event event) {
        boolean hover;
        if (event.button != 1) {
            return;
        }
        if (this.focusItem == null) {
            return;
        }
        int x = event.x;
        int y = event.y;
        boolean bl = hover = this.focusItem.x <= x && x < this.focusItem.x + this.focusItem.width && this.focusItem.y <= y && y < this.focusItem.y + this.getBandHeight();
        if (hover) {
            Event ev = new Event();
            ev.item = this.focusItem;
            this.notifyListeners(this.focusItem.expanded ? 18 : 17, ev);
            this.focusItem.expanded = !this.focusItem.expanded;
            this.showItem(this.focusItem);
        }
    }

    void onPaint(Event event) {
        boolean hasFocus = this.isFocusControl();
        int i2 = 0;
        while (i2 < this.itemCount) {
            ExpandItem item2 = this.items[i2];
            item2.drawItem(event.gc, hasFocus && item2 == this.focusItem);
            ++i2;
        }
    }

    void onResize() {
        Rectangle rect = this.getClientArea();
        int width = Math.max(0, rect.width - this.spacing * 2);
        int i2 = 0;
        while (i2 < this.itemCount) {
            ExpandItem item2 = this.items[i2];
            item2.setBounds(0, 0, width, item2.height, false, true);
            ++i2;
        }
        this.setScrollbar();
    }

    void onScroll(Event event) {
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar != null) {
            this.yCurrentScroll = verticalBar.getSelection();
            this.layoutItems(0, false);
        }
    }

    void onTraverse(Event event) {
        switch (event.detail) {
            case 8: 
            case 16: {
                event.doit = true;
            }
        }
    }
}

