/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class CTabFolderLayout
extends Layout {
    CTabFolderLayout() {
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int minHeight;
        CTabFolder folder = (CTabFolder)composite;
        CTabItem[] items = folder.items;
        CTabFolderRenderer renderer = folder.renderer;
        int tabW = 0;
        int selectedIndex = folder.selectedIndex;
        if (selectedIndex == -1) {
            selectedIndex = 0;
        }
        GC gc = new GC(folder);
        int i2 = 0;
        while (i2 < items.length) {
            if (folder.single) {
                tabW = Math.max(tabW, renderer.computeSize((int)i2, (int)2, (GC)gc, (int)-1, (int)-1).x);
            } else {
                int state = 0;
                if (i2 == selectedIndex) {
                    state |= 2;
                }
                tabW += renderer.computeSize((int)i2, (int)state, (GC)gc, (int)-1, (int)-1).x;
            }
            ++i2;
        }
        int width = 0;
        int wrapHeight = 0;
        boolean leftControl = false;
        boolean rightControl = false;
        if (wHint == -1) {
            int i3 = 0;
            while (i3 < folder.controls.length) {
                Control control = folder.controls[i3];
                if (!control.isDisposed() && control.getVisible()) {
                    if ((folder.controlAlignments[i3] & 0x4000) != 0) {
                        leftControl = true;
                    } else {
                        rightControl = true;
                    }
                    width += control.computeSize((int)-1, (int)-1).x;
                }
                ++i3;
            }
        } else {
            Point size = new Point(wHint, hHint);
            boolean[][] positions = new boolean[1][];
            Rectangle[] rects = folder.computeControlBounds(size, positions);
            int minY = Integer.MAX_VALUE;
            int maxY = 0;
            int i4 = 0;
            while (i4 < rects.length) {
                if (positions[0][i4]) {
                    minY = Math.min(minY, rects[i4].y);
                    maxY = Math.max(maxY, rects[i4].y + rects[i4].height);
                    wrapHeight = maxY - minY;
                } else {
                    if ((folder.controlAlignments[i4] & 0x4000) != 0) {
                        leftControl = true;
                    } else {
                        rightControl = true;
                    }
                    width += rects[i4].width;
                }
                ++i4;
            }
        }
        if (leftControl) {
            width += 6;
        }
        if (rightControl) {
            width += 6;
        }
        tabW += width;
        gc.dispose();
        int controlW = 0;
        int controlH = 0;
        int i5 = 0;
        while (i5 < items.length) {
            Control control = items[i5].control;
            if (control != null && !control.isDisposed()) {
                Point size = control.computeSize(wHint, hHint, flushCache);
                controlW = Math.max(controlW, size.x);
                controlH = Math.max(controlH, size.y);
            }
            ++i5;
        }
        int minWidth = Math.max(tabW, controlW + folder.marginWidth);
        int n = minHeight = folder.minimized ? 0 : controlH + wrapHeight;
        if (minWidth == 0) {
            minWidth = 64;
        }
        if (minHeight == 0) {
            minHeight = 64;
        }
        if (wHint != -1) {
            minWidth = wHint;
        }
        if (hHint != -1) {
            minHeight = hHint;
        }
        return new Point(minWidth, minHeight);
    }

    @Override
    protected boolean flushCache(Control control) {
        return true;
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        Control control;
        CTabFolder folder = (CTabFolder)composite;
        if (folder.selectedIndex != -1 && (control = folder.items[folder.selectedIndex].control) != null && !control.isDisposed()) {
            control.setBounds(folder.getClientArea());
        }
    }
}

