/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;

public class JacobianFunction
implements MultivariateMatrixFunction {
    private final MultivariateDifferentiableVectorFunction f;

    public JacobianFunction(MultivariateDifferentiableVectorFunction f) {
        this.f = f;
    }

    public double[][] value(double[] point) {
        DerivativeStructure[] dsX = new DerivativeStructure[point.length];
        for (int i2 = 0; i2 < point.length; ++i2) {
            dsX[i2] = new DerivativeStructure(point.length, 1, i2, point[i2]);
        }
        DerivativeStructure[] dsY = this.f.value(dsX);
        double[][] y = new double[dsY.length][point.length];
        int[] orders = new int[point.length];
        for (int i3 = 0; i3 < dsY.length; ++i3) {
            for (int j = 0; j < point.length; ++j) {
                orders[j] = 1;
                y[i3][j] = dsY[i3].getPartialDerivative(orders);
                orders[j] = 0;
            }
        }
        return y;
    }
}

