/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.core._UnexpectedTypeErrorExplainerTemplateModel;
import freemarker.ext.dom.AtAtKey;
import freemarker.ext.dom.DomStringUtil;
import freemarker.ext.dom.ElementModel;
import freemarker.ext.dom.NodeModel;
import freemarker.ext.dom.XPathSupport;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeListModel
extends SimpleSequence
implements TemplateHashModel,
_UnexpectedTypeErrorExplainerTemplateModel {
    NodeModel contextNode;
    XPathSupport xpathSupport;
    private static final ObjectWrapper NODE_WRAPPER = new ObjectWrapper(){

        public TemplateModel wrap(Object obj) {
            if (obj instanceof NodeModel) {
                return (NodeModel)obj;
            }
            return NodeModel.wrap((Node)obj);
        }
    };

    NodeListModel(Node contextNode) {
        this(NodeModel.wrap(contextNode));
    }

    NodeListModel(NodeModel contextNode) {
        super(NODE_WRAPPER);
        this.contextNode = contextNode;
    }

    NodeListModel(NodeList nodeList, NodeModel contextNode) {
        super(NODE_WRAPPER);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            this.list.add(nodeList.item(i2));
        }
        this.contextNode = contextNode;
    }

    NodeListModel(NamedNodeMap nodeList, NodeModel contextNode) {
        super(NODE_WRAPPER);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            this.list.add(nodeList.item(i2));
        }
        this.contextNode = contextNode;
    }

    NodeListModel(List list2, NodeModel contextNode) {
        super(list2, NODE_WRAPPER);
        this.contextNode = contextNode;
    }

    NodeListModel filterByName(String name) throws TemplateModelException {
        NodeListModel result2 = new NodeListModel(this.contextNode);
        int size = this.size();
        if (size == 0) {
            return result2;
        }
        Environment env = Environment.getCurrentEnvironment();
        for (int i2 = 0; i2 < size; ++i2) {
            NodeModel nm = (NodeModel)this.get(i2);
            if (!(nm instanceof ElementModel) || !((ElementModel)nm).matchesName(name, env)) continue;
            result2.add(nm);
        }
        return result2;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public TemplateModel get(String key2) throws TemplateModelException {
        int size = this.size();
        if (size == 1) {
            NodeModel nm = (NodeModel)this.get(0);
            return nm.get(key2);
        }
        if (key2.startsWith("@@")) {
            if (key2.equals(AtAtKey.MARKUP.getKey()) || key2.equals(AtAtKey.NESTED_MARKUP.getKey()) || key2.equals(AtAtKey.TEXT.getKey())) {
                StringBuilder result2 = new StringBuilder();
                for (int i2 = 0; i2 < size; ++i2) {
                    NodeModel nm = (NodeModel)this.get(i2);
                    TemplateScalarModel textModel = (TemplateScalarModel)nm.get(key2);
                    result2.append(textModel.getAsString());
                }
                return new SimpleScalar(result2.toString());
            }
            if (key2.length() != 2) {
                if (AtAtKey.containsKey(key2)) {
                    throw new TemplateModelException("\"" + key2 + "\" is only applicable to a single XML node, but it was applied on " + (size != 0 ? size + " XML nodes (multiple matches)." : "an empty list of XML nodes (no matches)."));
                }
                throw new TemplateModelException("Unsupported @@ key: " + key2);
            }
        }
        if (DomStringUtil.isXMLNameLike(key2) || key2.startsWith("@") && (DomStringUtil.isXMLNameLike(key2, 1) || key2.equals("@@") || key2.equals("@*")) || key2.equals("*") || key2.equals("**")) {
            NodeListModel result3 = new NodeListModel(this.contextNode);
            for (int i3 = 0; i3 < size; ++i3) {
                TemplateSequenceModel tsm;
                NodeModel nm = (NodeModel)this.get(i3);
                if (!(nm instanceof ElementModel) || (tsm = (TemplateSequenceModel)((ElementModel)nm).get(key2)) == null) continue;
                int tsmSize = tsm.size();
                for (int j = 0; j < tsmSize; ++j) {
                    result3.add(tsm.get(j));
                }
            }
            if (result3.size() == 1) {
                return result3.get(0);
            }
            return result3;
        }
        XPathSupport xps = this.getXPathSupport();
        if (xps != null) {
            List context = size == 0 ? null : this.rawNodeList();
            return xps.executeQuery(context, key2);
        }
        throw new TemplateModelException("Can't try to resolve the XML query key, because no XPath support is available. This is either malformed or an XPath expression: " + key2);
    }

    private List rawNodeList() throws TemplateModelException {
        int size = this.size();
        ArrayList<Node> al = new ArrayList<Node>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            al.add(((NodeModel)this.get((int)i2)).node);
        }
        return al;
    }

    XPathSupport getXPathSupport() throws TemplateModelException {
        if (this.xpathSupport == null) {
            if (this.contextNode != null) {
                this.xpathSupport = this.contextNode.getXPathSupport();
            } else if (this.size() > 0) {
                this.xpathSupport = ((NodeModel)this.get(0)).getXPathSupport();
            }
        }
        return this.xpathSupport;
    }

    public Object[] explainTypeError(Class[] expectedClasses) {
        for (int i2 = 0; i2 < expectedClasses.length; ++i2) {
            Class expectedClass = expectedClasses[i2];
            if (TemplateScalarModel.class.isAssignableFrom(expectedClass) || TemplateDateModel.class.isAssignableFrom(expectedClass) || TemplateNumberModel.class.isAssignableFrom(expectedClass) || TemplateBooleanModel.class.isAssignableFrom(expectedClass)) {
                return this.newTypeErrorExplanation("string");
            }
            if (!TemplateNodeModel.class.isAssignableFrom(expectedClass)) continue;
            return this.newTypeErrorExplanation("node");
        }
        return null;
    }

    private Object[] newTypeErrorExplanation(String type2) {
        int size = this.size();
        return new Object[]{"This XML query result can't be used as ", type2, " because for that it had to contain exactly 1 XML node, but it contains ", size, " nodes. That is, the constructing XML query has found ", size == 0 ? "no matches." : "multiple matches."};
    }
}

