/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParameterRole;
import freemarker.core.StringLiteral;
import freemarker.core._DelayedGetMessage;
import freemarker.core._DelayedJQuote;
import freemarker.core._MiscTemplateException;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

final class ListLiteral
extends Expression {
    final ArrayList items;

    ListLiteral(ArrayList items) {
        this.items = items;
        items.trimToSize();
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        SimpleSequence list2 = new SimpleSequence(this.items.size());
        for (Expression exp : this.items) {
            TemplateModel tm = exp.eval(env);
            if (env == null || !env.isClassicCompatible()) {
                exp.assertNonNull(tm, env);
            }
            list2.add(tm);
        }
        return list2;
    }

    List getValueList(Environment env) throws TemplateException {
        int size = this.items.size();
        switch (size) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections.singletonList(((Expression)this.items.get(0)).evalAndCoerceToPlainText(env));
            }
        }
        ArrayList<String> result2 = new ArrayList<String>(this.items.size());
        ListIterator iterator2 = this.items.listIterator();
        while (iterator2.hasNext()) {
            Expression exp = (Expression)iterator2.next();
            result2.add(exp.evalAndCoerceToPlainText(env));
        }
        return result2;
    }

    List getModelList(Environment env) throws TemplateException {
        int size = this.items.size();
        switch (size) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections.singletonList(((Expression)this.items.get(0)).eval(env));
            }
        }
        ArrayList<TemplateModel> result2 = new ArrayList<TemplateModel>(this.items.size());
        ListIterator iterator2 = this.items.listIterator();
        while (iterator2.hasNext()) {
            Expression exp = (Expression)iterator2.next();
            result2.add(exp.eval(env));
        }
        return result2;
    }

    public String getCanonicalForm() {
        StringBuilder buf = new StringBuilder("[");
        int size = this.items.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Expression value = (Expression)this.items.get(i2);
            buf.append(value.getCanonicalForm());
            if (i2 == size - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        return "[...]";
    }

    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            Expression exp = (Expression)this.items.get(i2);
            if (exp.isLiteral()) continue;
            return false;
        }
        return true;
    }

    TemplateSequenceModel evaluateStringsToNamespaces(Environment env) throws TemplateException {
        TemplateSequenceModel val = (TemplateSequenceModel)this.eval(env);
        SimpleSequence result2 = new SimpleSequence(val.size());
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            Object itemExpr = this.items.get(i2);
            if (itemExpr instanceof StringLiteral) {
                String s = ((StringLiteral)itemExpr).getAsString();
                try {
                    Environment.Namespace ns = env.importLib(s, null);
                    result2.add(ns);
                    continue;
                }
                catch (IOException ioe) {
                    throw new _MiscTemplateException((Expression)((StringLiteral)itemExpr), "Couldn't import library ", new _DelayedJQuote(s), ": ", new _DelayedGetMessage(ioe));
                }
            }
            result2.add(val.get(i2));
        }
        return result2;
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        ArrayList clonedValues = (ArrayList)this.items.clone();
        ListIterator<Expression> iter = clonedValues.listIterator();
        while (iter.hasNext()) {
            iter.set(((Expression)iter.next()).deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState));
        }
        return new ListLiteral(clonedValues);
    }

    int getParameterCount() {
        return this.items != null ? this.items.size() : 0;
    }

    Object getParameterValue(int idx) {
        this.checkIndex(idx);
        return this.items.get(idx);
    }

    ParameterRole getParameterRole(int idx) {
        this.checkIndex(idx);
        return ParameterRole.ITEM_VALUE;
    }

    private void checkIndex(int idx) {
        if (this.items == null || idx >= this.items.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

