/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PdfChunk;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfFont;
import com.itextpdf.text.pdf.PdfLine;
import java.util.ArrayList;
import java.util.Iterator;

public class VerticalText {
    public static final int NO_MORE_TEXT = 1;
    public static final int NO_MORE_COLUMN = 2;
    protected ArrayList<PdfChunk> chunks = new ArrayList();
    protected PdfContentByte text;
    protected int alignment = 0;
    protected int currentChunkMarker = -1;
    protected PdfChunk currentStandbyChunk;
    protected String splittedChunkText;
    protected float leading;
    protected float startX;
    protected float startY;
    protected int maxLines;
    protected float height;
    private Float curCharSpace = Float.valueOf(0.0f);

    public VerticalText(PdfContentByte text2) {
        this.text = text2;
    }

    public void addText(Phrase phrase) {
        for (Chunk c : phrase.getChunks()) {
            this.chunks.add(new PdfChunk(c, null));
        }
    }

    public void addText(Chunk chunk) {
        this.chunks.add(new PdfChunk(chunk, null));
    }

    public void setVerticalLayout(float startX, float startY, float height, int maxLines, float leading) {
        this.startX = startX;
        this.startY = startY;
        this.height = height;
        this.maxLines = maxLines;
        this.setLeading(leading);
    }

    public void setLeading(float leading) {
        this.leading = leading;
    }

    public float getLeading() {
        return this.leading;
    }

    protected PdfLine createLine(float width) {
        if (this.chunks.isEmpty()) {
            return null;
        }
        this.splittedChunkText = null;
        this.currentStandbyChunk = null;
        PdfLine line2 = new PdfLine(0.0f, width, this.alignment, 0.0f);
        this.currentChunkMarker = 0;
        while (this.currentChunkMarker < this.chunks.size()) {
            PdfChunk original = this.chunks.get(this.currentChunkMarker);
            String total = original.toString();
            this.currentStandbyChunk = line2.add(original);
            if (this.currentStandbyChunk != null) {
                this.splittedChunkText = original.toString();
                original.setValue(total);
                return line2;
            }
            ++this.currentChunkMarker;
        }
        return line2;
    }

    protected void shortenChunkArray() {
        if (this.currentChunkMarker < 0) {
            return;
        }
        if (this.currentChunkMarker >= this.chunks.size()) {
            this.chunks.clear();
            return;
        }
        PdfChunk split = this.chunks.get(this.currentChunkMarker);
        split.setValue(this.splittedChunkText);
        this.chunks.set(this.currentChunkMarker, this.currentStandbyChunk);
        for (int j = this.currentChunkMarker - 1; j >= 0; --j) {
            this.chunks.remove(j);
        }
    }

    public int go() {
        return this.go(false);
    }

    public int go(boolean simulate) {
        boolean dirty2 = false;
        PdfContentByte graphics = null;
        if (this.text != null) {
            graphics = this.text.getDuplicate();
        } else if (!simulate) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("verticaltext.go.with.simulate.eq.eq.false.and.text.eq.eq.null", new Object[0]));
        }
        int status = 0;
        while (true) {
            if (this.maxLines <= 0) {
                status = 2;
                if (!this.chunks.isEmpty()) break;
                status |= 1;
                break;
            }
            if (this.chunks.isEmpty()) {
                status = 1;
                break;
            }
            PdfLine line2 = this.createLine(this.height);
            if (!simulate && !dirty2) {
                this.text.beginText();
                dirty2 = true;
            }
            this.shortenChunkArray();
            if (!simulate) {
                this.text.setTextMatrix(this.startX, this.startY - line2.indentLeft());
                this.writeLine(line2, this.text, graphics);
            }
            --this.maxLines;
            this.startX -= this.leading;
        }
        if (dirty2) {
            this.text.endText();
            this.text.add(graphics);
        }
        return status;
    }

    void writeLine(PdfLine line2, PdfContentByte text2, PdfContentByte graphics) {
        PdfFont currentFont = null;
        Iterator<PdfChunk> j = line2.iterator();
        while (j.hasNext()) {
            Float charSpace;
            PdfChunk chunk = j.next();
            if (!chunk.isImage() && chunk.font().compareTo(currentFont) != 0) {
                currentFont = chunk.font();
                text2.setFontAndSize(currentFont.getFont(), currentFont.size());
            }
            Object[] textRender = (Object[])chunk.getAttribute("TEXTRENDERMODE");
            int tr = 0;
            float strokeWidth = 1.0f;
            BaseColor color = chunk.color();
            BaseColor strokeColor = null;
            if (textRender != null) {
                tr = (Integer)textRender[0] & 3;
                if (tr != 0) {
                    text2.setTextRenderingMode(tr);
                }
                if (tr == 1 || tr == 2) {
                    strokeWidth = ((Float)textRender[1]).floatValue();
                    if (strokeWidth != 1.0f) {
                        text2.setLineWidth(strokeWidth);
                    }
                    if ((strokeColor = (BaseColor)textRender[2]) == null) {
                        strokeColor = color;
                    }
                    if (strokeColor != null) {
                        text2.setColorStroke(strokeColor);
                    }
                }
            }
            if ((charSpace = (Float)chunk.getAttribute("CHAR_SPACING")) != null && !this.curCharSpace.equals(charSpace)) {
                this.curCharSpace = Float.valueOf(charSpace.floatValue());
                text2.setCharacterSpacing(this.curCharSpace.floatValue());
            }
            if (color != null) {
                text2.setColorFill(color);
            }
            text2.showText(chunk.toString());
            if (color != null) {
                text2.resetRGBColorFill();
            }
            if (tr != 0) {
                text2.setTextRenderingMode(0);
            }
            if (strokeColor != null) {
                text2.resetRGBColorStroke();
            }
            if (strokeWidth == 1.0f) continue;
            text2.setLineWidth(1.0f);
        }
    }

    public void setOrigin(float startX, float startY) {
        this.startX = startX;
        this.startY = startY;
    }

    public float getOriginX() {
        return this.startX;
    }

    public float getOriginY() {
        return this.startY;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }
}

