/*
 * Decompiled with CFR 0.152.
 */
package gde.device.renschler;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.renschler.Picolario2;
import gde.device.renschler.Picolario2DialogTabItem;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Picolario2Dialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(Picolario2Dialog.class.getName());
    CTabFolder tabFolder;
    Button saveButton;
    Button closeButton;
    Button helpButton;
    final Picolario2 device;
    final Settings settings;
    int measurementsCount = 0;
    final List<CTabItem> configurations = new ArrayList<CTabItem>();

    public Picolario2Dialog(Shell parent, Picolario2 useDevice) {
        super(parent);
        this.device = useDevice;
        this.settings = Settings.getInstance();
        for (int i = 1; i <= this.device.getChannelCount(); ++i) {
            int actualMeasurementCount = this.device.getNumberOfMeasurements(i);
            this.measurementsCount = actualMeasurementCount > this.measurementsCount ? actualMeasurementCount : this.measurementsCount;
        }
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                if (this.isAlphaEnabled) {
                    this.dialogShell.setAlpha(254);
                }
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.setSize(325, 90 + this.measurementsCount * 28 + 40 + 50);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                Picolario2Dialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                        if (Picolario2Dialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{Picolario2Dialog.this.device.getPropertiesFileName()});
                            if (Picolario2Dialog.this.application.openYesNoMessageDialog(Picolario2Dialog.this.getDialogShell(), msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                Picolario2Dialog.this.device.storeDeviceProperties();
                                Picolario2Dialog.this.setClosePossible(true);
                            }
                        }
                        Picolario2Dialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINER, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                        Picolario2Dialog.this.application.openHelpDialog("CSV2SerialAdapter", "HelpInfo.html");
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                for (int i = 0; i < this.device.getChannelCount(); ++i) {
                    this.configurations.add(new Picolario2DialogTabItem(this.tabFolder, this, i + 1, this.device));
                }
                this.saveButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 105;
                saveButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveButtonLData.left = new FormAttachment(0, 1000, 10);
                saveButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.saveButton.setLayoutData((Object)saveButtonLData);
                this.saveButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveButton.setText(Messages.getString((String)"GDE_MSGT0486"));
                this.saveButton.setEnabled(false);
                this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "saveButton.widgetSelected, event=" + String.valueOf(evt));
                        Picolario2Dialog.this.device.storeDeviceProperties();
                        Picolario2Dialog.this.saveButton.setEnabled(false);
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData helpButtonLData = new FormData();
                helpButtonLData.width = GDE.IS_MAC ? 50 : 40;
                helpButtonLData.height = GDE.IS_MAC ? 33 : 30;
                helpButtonLData.left = new FormAttachment(0, 1000, GDE.IS_MAC ? 129 : 132);
                helpButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.helpButton.setLayoutData((Object)helpButtonLData);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "helpButton.widgetSelected, event=" + String.valueOf(evt));
                        Picolario2Dialog.this.application.openHelpDialog("Picolario", "HelpInfo2.html");
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 105;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "closeButton.widgetSelected, event=" + String.valueOf(evt));
                        Picolario2Dialog.this.dialogShell.dispose();
                    }
                });
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -50);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "configTabFolder.widgetSelected, event=" + String.valueOf(evt));
                        int channelNumber = Picolario2Dialog.this.tabFolder.getSelectionIndex();
                        if (channelNumber >= 0 && channelNumber <= Picolario2Dialog.this.device.getChannelCount()) {
                            String configKey = ++channelNumber + " : " + ((CTabItem)evt.item).getText();
                            Channels channels = Channels.getInstance();
                            Channel activeChannel = channels.getActiveChannel();
                            if (activeChannel != null) {
                                log.log(Level.FINE, "activeChannel = " + activeChannel.getName() + " configKey = " + configKey);
                                RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
                                if (activeRecordSet != null && activeChannel.getNumber() != channelNumber) {
                                    int answer = Picolario2Dialog.this.application.openYesNoMessageDialog(Picolario2Dialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGT1202"));
                                    if (answer == 64) {
                                        String recordSetKey = activeRecordSet.getName();
                                        Channel tmpChannel = (Channel)channels.get((Object)channelNumber);
                                        if (tmpChannel != null) {
                                            log.log(Level.FINE, "move record set " + recordSetKey + " to channel/configuration " + channelNumber + " : " + configKey);
                                            tmpChannel.put((Object)recordSetKey, (Object)activeRecordSet.clone(channelNumber));
                                            activeChannel.remove(recordSetKey);
                                            channels.switchChannel(channelNumber, recordSetKey);
                                            RecordSet newActiveRecordSet = ((Channel)channels.get((Object)channelNumber)).getActiveRecordSet();
                                            if (newActiveRecordSet != null) {
                                                Picolario2Dialog.this.device.updateVisibilityStatus(newActiveRecordSet, false);
                                                Picolario2Dialog.this.device.makeInActiveDisplayable(newActiveRecordSet);
                                            }
                                        }
                                    }
                                    Picolario2Dialog.this.application.updateCurveSelectorTable();
                                }
                            }
                        }
                    }
                });
                try {
                    this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                }
                catch (RuntimeException e) {
                    this.tabFolder.setSelection(0);
                }
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 175, 10));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void enableSaveButton(boolean enable) {
        this.saveButton.setEnabled(enable);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolder.getSelectionIndex();
    }
}

