/*
 * Decompiled with CFR 0.152.
 */
package gde.device.wb;

import gde.data.Record;
import gde.device.CheckSumTypes;
import gde.device.FormatTypes;
import gde.device.MeasurementPropertyTypes;
import gde.device.PropertyType;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.io.DataParser;
import gde.messages.Messages;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AkkuMonitorParser
extends DataParser {
    private static final Logger log = Logger.getLogger(AkkuMonitorParser.class.getName());

    public AkkuMonitorParser(int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, int useDataSize) {
        super(useTimeFactor, useLeaderChar, useSeparator, useCheckSumType, useDataSize);
    }

    public AkkuMonitorParser(int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, FormatTypes useCheckSumFormatType, int useDataSize, FormatTypes useDataFormatType, boolean doMultiply1000) {
        super(useTimeFactor, useLeaderChar, useSeparator, useCheckSumType, useCheckSumFormatType, useDataSize, useDataFormatType, doMultiply1000);
    }

    public void parse(String inputLine, String[] strValues) throws DevicePropertiesInconsistenceException {
        String strValue = strValues[0].trim().substring(1);
        this.channelConfigNumber = Integer.parseInt(strValue);
        strValue = strValues[1].trim();
        this.state = Integer.parseInt(strValue);
        strValue = strValues[2].trim().replace(',', '.');
        String string = strValue = strValue.length() > 0 ? strValue : "0";
        if (this.start_time_ms == Integer.MIN_VALUE) {
            this.start_time_ms = (int)(Double.parseDouble(strValue) * (double)this.timeFactor);
        } else {
            this.time_ms = (int)(Double.parseDouble(strValue) * (double)this.timeFactor) - this.start_time_ms;
        }
        for (int i = 0; i < this.valueSize; ++i) {
            strValue = strValues[i + 3].trim();
            PropertyType property = this.device.getMeasurement(this.channelConfigNumber, i).getProperty(MeasurementPropertyTypes.DATA_TYPE.value());
            try {
                if (property == null) {
                    double tmpValue;
                    double d = tmpValue = strValue.length() > 0 ? Double.parseDouble(strValue.trim()) : 0.0;
                    if (this.isMultiply1000 && tmpValue < 2147483.0 && tmpValue > -2147483.0) {
                        this.values[i] = (int)(tmpValue * 1000.0);
                        continue;
                    }
                    if (tmpValue < 2.147483647E9 || tmpValue > -2.147483648E9) {
                        this.values[i] = (int)tmpValue;
                        continue;
                    }
                    this.values[i] = (int)(tmpValue / 1000.0);
                    continue;
                }
                log.log(Level.FINE, Record.DataType.fromValue((String)property.getValue()).toString());
                switch (Record.DataType.fromValue((String)property.getValue())) {
                    case GPS_LATITUDE: 
                    case GPS_LONGITUDE: {
                        this.values[i] = Integer.parseInt(strValue.replace(".", ""));
                        break;
                    }
                    case GPS_ALTITUDE: {
                        this.values[i] = Integer.parseInt(strValue) * 1000;
                        break;
                    }
                    case DATE_TIME: {
                        String[] tmpValues = strValue.split(":");
                        if (tmpValues.length == 2) {
                            int n = this.values[i] = tmpValues[0].trim().length() > 0 ? Integer.parseInt(tmpValues[0].trim()) * 60 * 1000 : 0;
                            if (tmpValues[1].indexOf(46) >= 0) {
                                tmpValues[0] = tmpValues[1].substring(0, tmpValues[1].indexOf(46));
                                tmpValues[1] = tmpValues[1].substring(tmpValues[1].indexOf(46) + 1);
                                int n2 = i;
                                this.values[n2] = this.values[n2] + (tmpValues[0].trim().length() > 0 ? Integer.parseInt(tmpValues[0].trim()) * 1000 : 0);
                                int n3 = i;
                                this.values[n3] = this.values[n3] + (tmpValues[1].trim().length() > 0 ? Integer.parseInt(tmpValues[1].trim()) * 100 : 0);
                                break;
                            }
                            int n4 = i;
                            this.values[n4] = this.values[n4] + Integer.parseInt(tmpValues[1].substring(0, 2).trim()) * 1000;
                            break;
                        }
                        if (strValue.contains(".")) {
                            tmpValues = new String[]{strValue.substring(0, strValue.indexOf(46)), strValue.substring(strValue.indexOf(46) + 1)};
                            int n = i;
                            this.values[n] = this.values[n] + (tmpValues[0].trim().length() > 0 ? Integer.parseInt(tmpValues[0].trim()) * 60 * 1000 : 0);
                            int n5 = i;
                            this.values[n5] = this.values[n5] + (tmpValues[1].trim().length() > 0 ? Integer.parseInt(tmpValues[1].trim()) * 1000 : 0);
                            break;
                        }
                        this.values[i] = tmpValues[0].trim().length() > 0 ? Integer.parseInt(tmpValues[0].trim()) * 60 * 1000 : 0;
                        break;
                    }
                }
                continue;
            }
            catch (NumberFormatException e) {
                this.values[i] = 0;
            }
        }
        if (this.device.getTimeStep_ms() < 0.0 && this.time_ms <= 0 && this.isTimeResetEnabled) {
            this.recordSetNumberOffset += ++this.timeResetCounter;
            this.isTimeResetEnabled = false;
        }
        if (this.checkSumType != null && !this.isChecksumOK(inputLine, Integer.parseInt(strValues[strValues.length - 1].trim(), 16))) {
            DevicePropertiesInconsistenceException e = new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGE0049", (Object[])new Object[]{strValues[strValues.length - 1].trim(), String.format("%X", this.calcChecksum(inputLine))}));
            log.log(Level.WARNING, e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

