/*
 * Decompiled with CFR 0.152.
 */
package gde.device.wb;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.FormatTypes;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.wb.Simulator;
import gde.device.wb.SimulatorSerialPort;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SimulatorDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(SimulatorDialog.class.getName());
    private static final String DEVICE_NAME = "Simulator";
    CLabel currentLabel;
    CCombo currentCombo;
    CLabel voltageLabel;
    CCombo voltageCombo;
    CLabel timeLabel;
    CCombo timeCombo;
    Button stopButton;
    final Simulator device;
    Text description;
    CLabel descriptionLabel;
    Button startButton;
    final SimulatorSerialPort serialPort;
    final Channels channels;
    final Settings settings;
    Channel channel;
    Timer timer;
    CLabel timeResultLabel;
    CLabel timesLabel;
    CCombo clusterCombo;
    CLabel clusterLabel;
    TimerTask timerTask;
    boolean isCollectDataStopped = false;
    int recordNumber = 0;

    public static void main(String[] args) {
        try {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            Simulator device = new Simulator("c:\\Documents and Settings\\user\\Application Data\\DataExplorer\\Devices\\Htronic Akkumaster C4.ini");
            SimulatorDialog inst = new SimulatorDialog(shell, device);
            inst.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SimulatorDialog(Shell parent, Simulator useDevice) {
        super(parent);
        this.serialPort = useDevice.getCommunicationPort();
        this.device = useDevice;
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                if (this.isAlphaEnabled) {
                    this.dialogShell.setAlpha(254);
                }
                this.dialogShell.setLayout((Layout)new FormLayout());
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(336, 393);
                this.dialogShell.setText(DEVICE_NAME + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                FormData timeResultLabelLData = new FormData();
                timeResultLabelLData.width = 94;
                timeResultLabelLData.height = 22;
                timeResultLabelLData.left = new FormAttachment(0, 1000, 213);
                timeResultLabelLData.top = new FormAttachment(0, 1000, 111);
                this.timeResultLabel = new CLabel((Composite)this.dialogShell, 0);
                this.timeResultLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeResultLabel.setLayoutData((Object)timeResultLabelLData);
                this.timeResultLabel.setText(Messages.getString((String)"GDE_MSGT1050"));
                FormData timesLabelLData = new FormData();
                timesLabelLData.width = 13;
                timesLabelLData.height = 22;
                timesLabelLData.left = new FormAttachment(0, 1000, 106);
                timesLabelLData.top = new FormAttachment(0, 1000, 111);
                this.timesLabel = new CLabel((Composite)this.dialogShell, 0);
                this.timesLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timesLabel.setLayoutData((Object)timesLabelLData);
                this.timesLabel.setText(Messages.getString((String)"GDE_MSGT1051"));
                FormData clusterComboLData = new FormData();
                clusterComboLData.width = 84;
                clusterComboLData.height = GDE.IS_LINUX ? 22 : 20;
                clusterComboLData.left = new FormAttachment(0, 1000, 125);
                clusterComboLData.top = new FormAttachment(0, 1000, 138);
                this.clusterCombo = new CCombo((Composite)this.dialogShell, 2048);
                this.clusterCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.clusterCombo.setLayoutData((Object)clusterComboLData);
                this.clusterCombo.setItems(new String[]{"10", "20", "50", "100"});
                this.clusterCombo.setText(Integer.valueOf(Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO))).toString());
                this.clusterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINE, "clusterCombo.widgetSelected, event=" + String.valueOf(evt));
                        SimulatorDialog.this.device.setDataBlockSize(InputTypes.SERIAL_IO, FormatTypes.BYTE, (int)Integer.valueOf(SimulatorDialog.this.clusterCombo.getText()));
                        log.log(Level.FINE, " new clusterSize = " + Math.abs(SimulatorDialog.this.device.getDataBlockSize(InputTypes.SERIAL_IO)));
                    }
                });
                FormData clusterLabelLData = new FormData();
                clusterLabelLData.width = 82;
                clusterLabelLData.height = 22;
                clusterLabelLData.left = new FormAttachment(0, 1000, 125);
                clusterLabelLData.top = new FormAttachment(0, 1000, 111);
                this.clusterLabel = new CLabel((Composite)this.dialogShell, 0);
                this.clusterLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.clusterLabel.setLayoutData((Object)clusterLabelLData);
                this.clusterLabel.setText(Messages.getString((String)"GDE_MSGT1052"));
                FormData currentLabelLData = new FormData();
                currentLabelLData.width = 70;
                currentLabelLData.height = 22;
                currentLabelLData.left = new FormAttachment(0, 1000, 29);
                currentLabelLData.top = new FormAttachment(0, 1000, 221);
                this.currentLabel = new CLabel((Composite)this.dialogShell, 0x1000000);
                this.currentLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.currentLabel.setLayoutData((Object)currentLabelLData);
                this.currentLabel.setText(Messages.getString((String)"GDE_MSGT1053"));
                FormData currentComboLData = new FormData();
                currentComboLData.width = 84;
                currentComboLData.height = GDE.IS_LINUX ? 22 : 20;
                currentComboLData.left = new FormAttachment(0, 1000, 29);
                currentComboLData.top = new FormAttachment(0, 1000, 244);
                this.currentCombo = new CCombo((Composite)this.dialogShell, 2048);
                this.currentCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.currentCombo.setLayoutData((Object)currentComboLData);
                this.currentCombo.setText("cCombo1");
                this.currentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINE, "currentCombo.widgetSelected, event=" + String.valueOf(evt));
                    }
                });
                FormData voltageLabelLData = new FormData();
                voltageLabelLData.width = 84;
                voltageLabelLData.height = 22;
                voltageLabelLData.left = new FormAttachment(0, 1000, 29);
                voltageLabelLData.top = new FormAttachment(0, 1000, 167);
                this.voltageLabel = new CLabel((Composite)this.dialogShell, 0);
                this.voltageLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.voltageLabel.setLayoutData((Object)voltageLabelLData);
                this.voltageLabel.setText(Messages.getString((String)"GDE_MSGT1054"));
                FormData voltageComboLData = new FormData();
                voltageComboLData.width = 84;
                voltageComboLData.height = GDE.IS_LINUX ? 22 : 20;
                voltageComboLData.left = new FormAttachment(0, 1000, 29);
                voltageComboLData.top = new FormAttachment(0, 1000, 198);
                this.voltageCombo = new CCombo((Composite)this.dialogShell, 2048);
                this.voltageCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.voltageCombo.setLayoutData((Object)voltageComboLData);
                this.voltageCombo.setText("cCombo1");
                this.voltageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINE, "voltageCombo.widgetSelected, event=" + String.valueOf(evt));
                    }
                });
                FormData timeLabelLData = new FormData();
                timeLabelLData.width = 74;
                timeLabelLData.height = 22;
                timeLabelLData.left = new FormAttachment(0, 1000, 29);
                timeLabelLData.top = new FormAttachment(0, 1000, 111);
                this.timeLabel = new CLabel((Composite)this.dialogShell, 0);
                this.timeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeLabel.setLayoutData((Object)timeLabelLData);
                this.timeLabel.setText(Messages.getString((String)"GDE_MSGT1055"));
                FormData timeComboLData = new FormData();
                timeComboLData.width = 84;
                timeComboLData.height = GDE.IS_LINUX ? 22 : 20;
                timeComboLData.left = new FormAttachment(0, 1000, 29);
                timeComboLData.top = new FormAttachment(0, 1000, 138);
                this.timeCombo = new CCombo((Composite)this.dialogShell, 2048);
                this.timeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeCombo.setLayoutData((Object)timeComboLData);
                this.timeCombo.setItems(new String[]{"1", "2", "3", "4", "5", "10", "20", "50", "100", "1000", "10000"});
                this.timeCombo.setText(String.format("%.0f", this.device.getTimeStep_ms()));
                this.timeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINE, "timeCombo.widgetSelected, event=" + String.valueOf(evt));
                        SimulatorDialog.this.device.setTimeStep_ms(Integer.valueOf(SimulatorDialog.this.timeCombo.getText()).intValue());
                        log.log(Level.FINE, " new timeStep_ms = " + SimulatorDialog.this.device.getTimeStep_ms());
                    }
                });
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                SimulatorDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(Level.FINE, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                        SimulatorDialog.this.dispose();
                    }
                });
                this.dialogShell.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent evt) {
                        log.log(Level.FINE, "dialogShell.keyReleased, event=" + String.valueOf(evt));
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINE, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                        SimulatorDialog.this.application.openHelpDialog(SimulatorDialog.DEVICE_NAME, "HelpInfo.html");
                    }
                });
                this.dialogShell.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent evt) {
                        log.log(Level.FINER, "dialogShell.mouseEnter, event=" + String.valueOf(evt));
                        SimulatorDialog.this.fadeOutAplhaBlending(evt, SimulatorDialog.this.getDialogShell().getClientArea(), 10, 10, 10, 10);
                    }

                    public void mouseHover(MouseEvent evt) {
                        log.log(Level.FINEST, "dialogShell.mouseHover, event=" + String.valueOf(evt));
                    }

                    public void mouseExit(MouseEvent evt) {
                        log.log(Level.FINER, "dialogShell.mouseExit, event=" + String.valueOf(evt));
                        SimulatorDialog.this.fadeInAlpaBlending(evt, SimulatorDialog.this.getDialogShell().getClientArea(), 10, 10, -10, 10);
                    }
                });
                FormData descriptionLData = new FormData();
                descriptionLData.width = 277;
                descriptionLData.height = 60;
                descriptionLData.left = new FormAttachment(0, 1000, 26);
                descriptionLData.top = new FormAttachment(0, 1000, 49);
                this.description = new Text((Composite)this.dialogShell, 0x1000040);
                this.description.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.description.setLayoutData((Object)descriptionLData);
                this.description.setText(Messages.getString((String)"GDE_MSGT1056"));
                this.description.setBackground(Display.getDefault().getSystemColor(22));
                this.description.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                FormData descriptionLabelLData = new FormData();
                descriptionLabelLData.width = 304;
                descriptionLabelLData.height = 37;
                descriptionLabelLData.left = new FormAttachment(0, 1000, 12);
                descriptionLabelLData.top = new FormAttachment(0, 1000, 12);
                descriptionLabelLData.right = new FormAttachment(1000, 1000, -12);
                this.descriptionLabel = new CLabel((Composite)this.dialogShell, 0x1000040);
                this.descriptionLabel.setFont(SWTResourceManager.getFont((Control)this.application, (int)(GDE.WIDGET_FONT_SIZE + 4), (int)0));
                this.descriptionLabel.setLayoutData((Object)descriptionLabelLData);
                this.descriptionLabel.setText(Messages.getString((String)"GDE_MSGT1057"));
                this.descriptionLabel.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                FormData startButtonLData = new FormData();
                startButtonLData.width = 121;
                startButtonLData.height = 31;
                startButtonLData.left = new FormAttachment(0, 1000, 29);
                startButtonLData.top = new FormAttachment(0, 1000, 296);
                this.startButton = new Button((Composite)this.dialogShell, 0x1000008);
                this.startButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.startButton.setLayoutData((Object)startButtonLData);
                this.startButton.setText(Messages.getString((String)"GDE_MSGT0274"));
                this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINE, "startButton.widgetSelected, event=" + String.valueOf(evt));
                        SimulatorDialog.this.startButton.setEnabled(false);
                        SimulatorDialog.this.stopButton.setEnabled(true);
                        SimulatorDialog.this.channel = SimulatorDialog.this.channels.getActiveChannel();
                        SimulatorDialog.this.channels.switchChannel(SimulatorDialog.this.channel.getName());
                        int delay = 0;
                        int period = Double.valueOf(SimulatorDialog.this.device.getTimeStep_ms() * (double)Math.abs(SimulatorDialog.this.device.getDataBlockSize(InputTypes.SERIAL_IO))).intValue();
                        log.log(Level.FINE, "timer period = " + period + " ms");
                        SimulatorDialog.this.timer = new Timer();
                        SimulatorDialog.this.timerTask = new TimerTask(){
                            HashMap<String, Object> data;
                            String recordSetKey;

                            @Override
                            public void run() {
                                try {
                                    RecordSet recordSet;
                                    if (SimulatorDialog.this.channel.size() == 0 || SimulatorDialog.this.isCollectDataStopped) {
                                        SimulatorDialog.this.isCollectDataStopped = false;
                                        ++SimulatorDialog.this.recordNumber;
                                        this.recordSetKey = SimulatorDialog.this.channel.size() + 1 + SimulatorDialog.this.device.getRecordSetStemNameReplacement();
                                        SimulatorDialog.this.channel.put((Object)this.recordSetKey, (Object)RecordSet.createRecordSet((String)this.recordSetKey, (IDevice)SimulatorDialog.this.application.getActiveDevice(), (int)1, (boolean)true, (boolean)false, (boolean)true));
                                        log.log(Level.FINE, this.recordSetKey + " created for channel " + SimulatorDialog.this.channel.getName());
                                        if (SimulatorDialog.this.channel.getActiveRecordSet() == null) {
                                            Channels.getInstance().getActiveChannel().setActiveRecordSet(this.recordSetKey);
                                        }
                                        recordSet = (RecordSet)SimulatorDialog.this.channel.get((Object)this.recordSetKey);
                                        recordSet.setTimeStep_ms(SimulatorDialog.this.device.getTimeStep_ms());
                                        recordSet.setAllDisplayable();
                                        SimulatorDialog.this.channel.applyTemplate(this.recordSetKey, false);
                                        if (SimulatorDialog.this.channel.getName().equals(SimulatorDialog.this.channels.getActiveChannel().getName())) {
                                            SimulatorDialog.this.application.getMenuToolBar().addRecordSetName(this.recordSetKey);
                                            SimulatorDialog.this.channels.getActiveChannel().switchRecordSet(this.recordSetKey);
                                        }
                                        log.log(Level.FINE, "recordSetKey = " + this.recordSetKey + " channelKonfigKey = " + recordSet.getChannelConfigName());
                                    } else {
                                        recordSet = (RecordSet)SimulatorDialog.this.channel.get((Object)this.recordSetKey);
                                        log.log(Level.FINE, "re-using " + this.recordSetKey);
                                    }
                                    this.data = SimulatorDialog.this.serialPort.getData(SimulatorDialog.this.recordNumber, recordSet.getChannelConfigNumber());
                                    int[] points = new int[recordSet.size()];
                                    String[] measurements = SimulatorDialog.this.device.getMeasurementNames(recordSet.getChannelConfigNumber());
                                    Vector voltage = (Vector)this.data.get(measurements[0]);
                                    Vector current = (Vector)this.data.get(measurements[1]);
                                    Iterator iterV = voltage.iterator();
                                    Iterator iterA = current.iterator();
                                    while (iterV.hasNext()) {
                                        points[0] = (Integer)iterV.next();
                                        points[1] = (Integer)iterA.next();
                                        log.log(Level.FINE, String.format("Spannung = %d mV, Strom = %d mA", points[0], points[1]));
                                        recordSet.addPoints(points);
                                    }
                                    SimulatorDialog.this.application.updateAllTabs(false);
                                }
                                catch (DataInconsitsentException e) {
                                    if (SimulatorDialog.this.timerTask != null) {
                                        SimulatorDialog.this.timerTask.cancel();
                                    }
                                    if (SimulatorDialog.this.timer != null) {
                                        SimulatorDialog.this.timer.cancel();
                                    }
                                    log.log(Level.SEVERE, e.getMessage(), e);
                                    SimulatorDialog.this.application.openMessageDialog(SimulatorDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0028", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()}));
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, e.getMessage(), e);
                                }
                            }
                        };
                        SimulatorDialog.this.timer.scheduleAtFixedRate(SimulatorDialog.this.timerTask, delay, (long)period);
                    }
                });
                FormData okButtonLData = new FormData();
                okButtonLData.width = 121;
                okButtonLData.height = 31;
                okButtonLData.left = new FormAttachment(0, 1000, 180);
                okButtonLData.top = new FormAttachment(0, 1000, 296);
                this.stopButton = new Button((Composite)this.dialogShell, 0x1000008);
                this.stopButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.stopButton.setLayoutData((Object)okButtonLData);
                this.stopButton.setText(Messages.getString((String)"GDE_MSGT0275"));
                this.stopButton.setEnabled(false);
                this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINE, "stopButton.widgetSelected, event=" + String.valueOf(evt));
                        SimulatorDialog.this.stopTimer();
                        SimulatorDialog.this.isCollectDataStopped = true;
                        SimulatorDialog.this.startButton.setEnabled(true);
                        SimulatorDialog.this.stopButton.setEnabled(false);
                        SimulatorDialog.this.application.updateStatisticsData();
                        SimulatorDialog.this.application.updateDataTable(SimulatorDialog.this.channels.getActiveChannel().getActiveRecordSet().getName(), false);
                    }
                });
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 175, 100));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void stopTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

