/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ConnectionI;
import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.Exception;
import com.zeroc.Ice.FormatType;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationInterruptedException;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.TwowayOnlyException;
import com.zeroc.Ice.UnknownException;
import com.zeroc.Ice.UnknownUserException;
import com.zeroc.Ice.UserException;
import com.zeroc.Ice._ObjectPrxI;
import com.zeroc.IceInternal.CollocatedRequestHandler;
import com.zeroc.IceInternal.Protocol;
import com.zeroc.IceInternal.ProxyOutgoingAsyncBaseI;
import com.zeroc.IceInternal.RetryException;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class OutgoingAsync<T>
extends ProxyOutgoingAsyncBaseI<T> {
    private final EncodingVersion _encoding;
    private InputStream _is;
    private Class<?>[] _userExceptions;
    private Unmarshaler<T> _unmarshal;

    public OutgoingAsync(ObjectPrx prx, String operation, OperationMode mode, boolean synchronous, Class<?>[] userExceptions) {
        super((_ObjectPrxI)prx, operation, null);
        _ObjectPrxI.StreamPair p;
        this._mode = mode == null ? OperationMode.Normal : mode;
        this._synchronous = synchronous;
        this._userExceptions = userExceptions;
        this._encoding = Protocol.getCompatibleEncoding(this._proxy._getReference().getEncoding());
        if (this._instance.cacheMessageBuffers() > 0 && (p = this._proxy._getCachedMessageBuffers()) != null) {
            this._is = p.is;
            this._os = p.os;
        }
        if (this._os == null) {
            this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
        }
    }

    public void invoke(boolean twowayOnly, Map<String, String> ctx, FormatType format, OutputStream.Marshaler marshal, Unmarshaler<T> unmarshal) {
        this._unmarshal = unmarshal;
        if (twowayOnly && !this._proxy.ice_isTwoway()) {
            throw new TwowayOnlyException(this._operation);
        }
        if (format == null) {
            format = FormatType.DefaultFormat;
        }
        try {
            this.prepare(ctx);
            if (marshal == null) {
                this.writeEmptyParams();
            } else {
                marshal.marshal(this.startWriteParams(format));
                this.endWriteParams();
            }
            if (this.isBatch()) {
                this._sentSynchronously = true;
                this._proxy._getBatchRequestQueue().finishBatchRequest(this._os, this._proxy, this._operation);
                this.finished(true, false);
            } else {
                this.invokeImpl(true);
            }
        }
        catch (Exception ex) {
            this.abort(ex);
        }
    }

    @Override
    public T waitForResponse() {
        if (this.isBatch()) {
            return null;
        }
        try {
            return this.waitForResponseOrUserEx();
        }
        catch (UserException ex) {
            throw new UnknownUserException(ex.ice_id(), ex);
        }
    }

    public T waitForResponseOrUserEx() throws UserException {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        try {
            return this.get();
        }
        catch (InterruptedException ex) {
            throw new OperationInterruptedException(ex);
        }
        catch (ExecutionException ee) {
            try {
                throw ee.getCause().fillInStackTrace();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (UserException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new UnknownException(ex);
            }
        }
    }

    @Override
    public boolean sent() {
        return this.sent(!this._proxy.ice_isTwoway());
    }

    @Override
    public int invokeRemote(ConnectionI connection, boolean compress, boolean response) throws RetryException {
        this._cachedConnection = connection;
        return connection.sendAsyncRequest(this, compress, response, 0);
    }

    @Override
    public int invokeCollocated(CollocatedRequestHandler handler) {
        if (!this._proxy.ice_isTwoway() || this._proxy._getReference().getInvocationTimeout() > 0) {
            this._state = (byte)(this._state | 8);
        }
        return handler.invokeAsyncRequest(this, 0, this._synchronous);
    }

    @Override
    public void abort(Exception ex) {
        if (this.isBatch()) {
            this._proxy._getBatchRequestQueue().abortBatchRequest(this._os);
        }
        super.abort(ex);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void markCompleted() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[FORLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public final boolean completed(InputStream is) {
        if (this._is == null) {
            this._is = new InputStream(this._instance, Protocol.currentProtocolEncoding);
        }
        this._is.swap(is);
        return super.completed(this._is);
    }

    private OutputStream startWriteParams(FormatType format) {
        this._os.startEncapsulation(this._encoding, format);
        return this._os;
    }

    private void endWriteParams() {
        this._os.endEncapsulation();
    }

    private void writeEmptyParams() {
        this._os.writeEmptyEncapsulation(this._encoding);
    }

    private InputStream startReadParams() {
        this._is.startEncapsulation();
        return this._is;
    }

    private void endReadParams() {
        this._is.endEncapsulation();
    }

    private void readEmptyParams() {
        this._is.skipEmptyEncapsulation();
    }

    private final void throwUserException() throws UserException {
        try {
            this._is.startEncapsulation();
            this._is.throwException(null);
        }
        catch (UserException ex) {
            this._is.endEncapsulation();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cacheMessageBuffers() {
        if (this._instance.cacheMessageBuffers() > 0) {
            OutgoingAsync outgoingAsync = this;
            synchronized (outgoingAsync) {
                if ((this._state & 8) > 0) {
                    return;
                }
                this._state = (byte)(this._state | 8);
            }
            if (this._is != null) {
                this._is.reset();
            }
            this._os.reset();
            this._proxy._cacheMessageBuffers(this._is, this._os);
            this._is = null;
            this._os = null;
        }
    }

    @FunctionalInterface
    public static interface Unmarshaler<V> {
        public V unmarshal(InputStream var1);
    }
}

