/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.scan;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.zaproxy.zap.scan.BaseScannerThread;
import org.zaproxy.zap.scan.ScannerThreadManager;

public abstract class BaseScannerThreadManager<ScannerThread extends BaseScannerThread<?>>
implements ScannerThreadManager<ScannerThread, Integer> {
    private Map<Integer, ScannerThread> threadsMap = new HashMap<Integer, ScannerThread>();

    @Override
    public ScannerThread getScannerThread(Integer contextId) {
        BaseScannerThread<Object> thread = (BaseScannerThread)this.threadsMap.get(contextId);
        if (thread == null) {
            thread = this.createNewScannerThread(contextId);
            this.threadsMap.put(contextId, thread);
        }
        return (ScannerThread)thread;
    }

    @Override
    public ScannerThread recreateScannerThreadIfHasRun(Integer contextId) {
        BaseScannerThread<Object> thread = (BaseScannerThread)this.threadsMap.get(contextId);
        if (thread.hasRun()) {
            thread = this.createNewScannerThread(contextId);
            this.threadsMap.put(contextId, thread);
        }
        return (ScannerThread)thread;
    }

    @Override
    public Collection<ScannerThread> getAllThreads() {
        return this.threadsMap.values();
    }

    @Override
    public void clearThreads() {
        this.threadsMap.clear();
    }

    @Override
    public void stopAllScannerThreads() {
        for (BaseScannerThread scanner : this.getAllThreads()) {
            scanner.stopScan();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.clearThreads();
    }

    public abstract ScannerThread createNewScannerThread(int var1);
}

