/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.formatter;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.formatter.DexFormattedWriter;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.reference.CallSiteReference;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodHandleReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.MethodHandleEncodedValue;
import org.jf.dexlib2.iface.value.MethodTypeEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.jf.util.IndentingWriter;

public class BaksmaliWriter
extends DexFormattedWriter {
    @Nullable
    private final String classContext;
    protected final char[] buffer = new char[24];

    public BaksmaliWriter(Writer writer) {
        this(writer, null);
    }

    public BaksmaliWriter(Writer writer, @Nullable String classContext) {
        super(writer instanceof IndentingWriter ? writer : new IndentingWriter(writer));
        this.classContext = classContext;
    }

    @Override
    public void writeMethodDescriptor(MethodReference methodReference) throws IOException {
        if (methodReference.getDefiningClass().equals(this.classContext)) {
            this.writeShortMethodDescriptor(methodReference);
        } else {
            super.writeMethodDescriptor(methodReference);
        }
    }

    @Override
    public void writeFieldDescriptor(FieldReference fieldReference) throws IOException {
        if (fieldReference.getDefiningClass().equals(this.classContext)) {
            this.writeShortFieldDescriptor(fieldReference);
        } else {
            super.writeFieldDescriptor(fieldReference);
        }
    }

    @Override
    protected void writeClass(CharSequence type) throws IOException {
        int i;
        assert (type.charAt(0) == 'L');
        this.writer.write(type.charAt(0));
        int startIndex = 1;
        boolean hasSpace = false;
        for (i = startIndex; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (Character.getType(c) == 12) {
                hasSpace = true;
                continue;
            }
            if (c == '/') {
                if (i == startIndex) {
                    throw new IllegalArgumentException(String.format("Invalid type string: %s", type));
                }
                this.writeSimpleName(type.subSequence(startIndex, i), hasSpace);
                this.writer.write(type.charAt(i));
                hasSpace = false;
                startIndex = i + 1;
                continue;
            }
            if (c != ';') continue;
            if (i == startIndex) {
                throw new IllegalArgumentException(String.format("Invalid type string: %s", type));
            }
            this.writeSimpleName(type.subSequence(startIndex, i), hasSpace);
            this.writer.write(type.charAt(i));
            break;
        }
        if (i != type.length() - 1 || type.charAt(i) != ';') {
            throw new IllegalArgumentException(String.format("Invalid type string: %s", type));
        }
    }

    @Override
    public void writeSimpleName(CharSequence simpleName) throws IOException {
        boolean hasSpace = false;
        for (int i = 0; i < simpleName.length(); ++i) {
            if (Character.getType(simpleName.charAt(i)) != 12) continue;
            hasSpace = true;
            break;
        }
        this.writeSimpleName(simpleName, hasSpace);
    }

    public void writeSimpleName(CharSequence simpleName, boolean quoted) throws IOException {
        if (quoted) {
            this.writer.write(96);
        }
        this.writer.append(simpleName);
        if (quoted) {
            this.writer.write(96);
        }
    }

    @Override
    public void writeEncodedValue(EncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case 31: {
                this.writeBooleanEncodedValue((BooleanEncodedValue)encodedValue);
                break;
            }
            case 0: {
                this.writeIntegralValue(((ByteEncodedValue)encodedValue).getValue(), Character.valueOf('t'));
                break;
            }
            case 3: {
                this.writeCharEncodedValue((CharEncodedValue)encodedValue);
                break;
            }
            case 2: {
                this.writeIntegralValue(((ShortEncodedValue)encodedValue).getValue(), Character.valueOf('s'));
                break;
            }
            case 4: {
                this.writeIntegralValue(((IntEncodedValue)encodedValue).getValue(), null);
                break;
            }
            case 6: {
                this.writeIntegralValue(((LongEncodedValue)encodedValue).getValue(), Character.valueOf('L'));
                break;
            }
            case 16: {
                this.writeFloatEncodedValue((FloatEncodedValue)encodedValue);
                break;
            }
            case 17: {
                this.writeDoubleEncodedValue((DoubleEncodedValue)encodedValue);
                break;
            }
            case 29: {
                this.writeAnnotation((AnnotationEncodedValue)encodedValue);
                break;
            }
            case 28: {
                this.writeArray((ArrayEncodedValue)encodedValue);
                break;
            }
            case 23: {
                this.writeQuotedString(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                this.writeFieldDescriptor(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                this.writeEnum((EnumEncodedValue)encodedValue);
                break;
            }
            case 26: {
                this.writeMethodDescriptor(((MethodEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                this.writeType(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 21: {
                this.writeMethodProtoDescriptor(((MethodTypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 22: {
                this.writeMethodHandle(((MethodHandleEncodedValue)encodedValue).getValue());
                break;
            }
            case 30: {
                this.writer.write("null");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown encoded value type");
            }
        }
    }

    protected void writeBooleanEncodedValue(BooleanEncodedValue encodedValue) throws IOException {
        this.writer.write(Boolean.toString(encodedValue.getValue()));
    }

    protected void writeIntegralValue(long value, @Nullable Character suffix) throws IOException {
        if (value < 0L) {
            this.writer.write("-0x");
            this.writeUnsignedLongAsHex(-value);
        } else {
            this.writer.write("0x");
            this.writeUnsignedLongAsHex(value);
        }
        if (suffix != null) {
            this.writer.write(suffix.charValue());
        }
    }

    protected void writeCharEncodedValue(CharEncodedValue encodedValue) throws IOException {
        char c = encodedValue.getValue();
        if (c >= ' ' && c < '\u007f') {
            this.writer.write(39);
            if (c == '\'' || c == '\"' || c == '\\') {
                this.writer.write(92);
            }
            this.writer.write(c);
            this.writer.write(39);
            return;
        }
        if (c <= '\u007f') {
            switch (c) {
                case '\n': {
                    this.writer.write("'\\n'");
                    return;
                }
                case '\r': {
                    this.writer.write("'\\r'");
                    return;
                }
                case '\t': {
                    this.writer.write("'\\t'");
                    return;
                }
            }
        }
        this.writer.write(39);
        this.writer.write("\\u");
        this.writer.write(Character.forDigit(c >> 12, 16));
        this.writer.write(Character.forDigit(c >> 8 & 0xF, 16));
        this.writer.write(Character.forDigit(c >> 4 & 0xF, 16));
        this.writer.write(Character.forDigit(c & 0xF, 16));
        this.writer.write(39);
    }

    protected void writeFloatEncodedValue(FloatEncodedValue encodedValue) throws IOException {
        this.writer.write(Float.toString(encodedValue.getValue()));
        this.writer.write(102);
    }

    protected void writeDoubleEncodedValue(DoubleEncodedValue encodedValue) throws IOException {
        this.writer.write(Double.toString(encodedValue.getValue()));
    }

    protected void writeEnum(EnumEncodedValue encodedValue) throws IOException {
        this.writer.write(".enum ");
        this.writeFieldDescriptor(encodedValue.getValue());
    }

    @Override
    protected void writeAnnotation(AnnotationEncodedValue annotation) throws IOException {
        this.writer.write(".subannotation ");
        this.writeType(annotation.getType());
        this.writer.write(10);
        this.writeAnnotationElements(annotation.getElements());
        this.writer.write(".end subannotation");
    }

    public void writeAnnotationElements(@Nonnull Collection<? extends AnnotationElement> annotationElements) throws IOException {
        this.indent(4);
        for (AnnotationElement annotationElement : annotationElements) {
            this.writeSimpleName(annotationElement.getName());
            this.writer.write(" = ");
            this.writeEncodedValue(annotationElement.getValue());
            this.writer.write(10);
        }
        this.deindent(4);
    }

    @Override
    protected void writeArray(ArrayEncodedValue array) throws IOException {
        this.writer.write(123);
        List<? extends EncodedValue> values = array.getValue();
        if (values.size() == 0) {
            this.writer.write(125);
            return;
        }
        this.writer.write(10);
        this.indent(4);
        boolean first = true;
        for (EncodedValue encodedValue : values) {
            if (!first) {
                this.writer.write(",\n");
            }
            first = false;
            this.writeEncodedValue(encodedValue);
        }
        this.deindent(4);
        this.writer.write("\n}");
    }

    @Override
    public void writeCallSite(CallSiteReference callSiteReference) throws IOException {
        this.writeSimpleName(callSiteReference.getName());
        this.writer.write(40);
        this.writeQuotedString(callSiteReference.getMethodName());
        this.writer.write(", ");
        this.writeMethodProtoDescriptor(callSiteReference.getMethodProto());
        for (EncodedValue encodedValue : callSiteReference.getExtraArguments()) {
            this.writer.write(", ");
            this.writeEncodedValue(encodedValue);
        }
        this.writer.write(")@");
        MethodHandleReference methodHandle = callSiteReference.getMethodHandle();
        if (methodHandle.getMethodHandleType() != 4) {
            throw new IllegalArgumentException("The linker method handle for a call site must be of type invoke-static");
        }
        this.writeMethodDescriptor((MethodReference)callSiteReference.getMethodHandle().getMemberReference());
    }

    public IndentingWriter indentingWriter() {
        return (IndentingWriter)this.writer;
    }

    public void writeUnsignedLongAsHex(long value) throws IOException {
        int bufferIndex = 23;
        do {
            int digit;
            this.buffer[bufferIndex--] = (digit = (int)(value & 0xFL)) < 10 ? (char)(digit + 48) : (char)(digit - 10 + 97);
        } while ((value >>>= 4) != 0L);
        this.write(this.buffer, ++bufferIndex, 24 - bufferIndex);
    }

    public void writeSignedLongAsDec(long value) throws IOException {
        int bufferIndex = 23;
        if (value < 0L) {
            this.write(45);
        }
        do {
            long digit = Math.abs(value % 10L);
            this.buffer[bufferIndex--] = (char)(digit + 48L);
        } while ((value /= 10L) != 0L);
        this.write(this.buffer, ++bufferIndex, 24 - bufferIndex);
    }

    public void writeSignedIntAsDec(int value) throws IOException {
        int bufferIndex = 15;
        if (value < 0) {
            this.write(45);
        }
        do {
            int digit = Math.abs(value % 10);
            this.buffer[bufferIndex--] = (char)(digit + 48);
        } while ((value /= 10) != 0);
        this.write(this.buffer, ++bufferIndex, 16 - bufferIndex);
    }

    public void writeUnsignedIntAsDec(int value) throws IOException {
        if (value < 0) {
            this.writeSignedLongAsDec((long)value & 0xFFFFFFFFL);
        } else {
            this.writeSignedIntAsDec(value);
        }
    }

    public void writeSignedIntOrLongTo(long val) throws IOException {
        if (val < 0L) {
            this.writer.write("-0x");
            this.writeUnsignedLongAsHex(-val);
            if (val < Integer.MIN_VALUE) {
                this.writer.write(76);
            }
        } else {
            this.writer.write("0x");
            this.writeUnsignedLongAsHex(val);
            if (val > Integer.MAX_VALUE) {
                this.writer.write(76);
            }
        }
    }

    public void indent(int indentAmount) {
        ((IndentingWriter)this.writer).indent(indentAmount);
    }

    public void deindent(int indentAmount) {
        ((IndentingWriter)this.writer).deindent(indentAmount);
    }
}

