/*global sinon, sCategoriesXML, sCategoriesJSON */
sap.ui.define("ODataTreeBindingFakeService", ["sap/base/Log"], function(Log) {

	"use strict";

	var xhr;

	function teardown() {
		xhr.restore();
	}

	function setup() {
		var baseURL = "ZTJ_SFIN_HIERARCHY_02_SRV/",
			responseDelay = 10,
			_setTimeout = window.setTimeout,
			csrfToken,
			sessionContextId;

		xhr = sinon.useFakeXMLHttpRequest();

		function updateSessionContextId() {
				sessionContextId = "SID-" + Math.floor(Math.random() * 1000000000) + "-NEW";
		}

		function getHeader(headers, header) {
			header = header.toLowerCase();
			for (var i in headers) {
				if (i.toLowerCase() == header) {
					return headers[i];
				}
			}
			return undefined;
		}

		window.odataFakeServiceData = {
			forbidHeadRequest: false,
			csrfRequests: []
		};

		xhr.useFilters = true;
		xhr.addFilter(function(method, url) {
			return url.indexOf(baseURL) != 0;
		});
		xhr.onCreate = function(request) {
			var	responses = {
				"GET": {
					"$metadata":
						[200, oMetaDataHeaders, sMetaData],

					/* =============================================================
						Restore expansion state mock data
					*/

					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsL0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%201":
						[200, oJSONHeaders, sResultsL1Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=0&$top=29&$inlinecount=allpages&$filter=GLAccount_Level%20le%201":
						[200, oJSONHeaders, sResultsL1Top29],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a99991%27":
						[200, oJSONHeaders, sResultsL0Parent0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=0&$top=7&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsL0Top7], // Beware: Response payload does not contain inlinecount! (feel free to change that)
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=0&$top=6&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a99991%27":
						[200, oJSONHeaders, sResultsL0Parent0Top6],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a999912%27":
						[200, oJSONHeaders, sResultsL1Parent0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=0&$top=1&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a999912%27":
						[200, oJSONHeaders, sResultsL1Parent0Top1],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsL4Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=167&$top=120&$filter=GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsL4Skip167Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=0&$top=118&$inlinecount=allpages&$filter=GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsL4Top118], // Beware: Response payload does not contain inlinecount! (feel free to change that)
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='9999')/Results?$skip=164&$top=204&$filter=GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsL4Skip164Top204],

					/* Use case 1 */
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='001')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsUC1L4Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='001')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27i2uraf135q%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsUC1PrePosNODE111114],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='001')/Results?$skip=0&$top=62&$inlinecount=allpages&$filter=GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsUC1L4Top62],

					/* Use case 2 */
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='002')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC2L3Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='002')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20UI51383315%27":
						[200, oJSONHeaders, sResultsUC2Top120ParentUI51383315],
					"ZTJ_G4_C_GLHIERResults('uc2-new-node-1')?$select=GLAccount_SiblingsPosition":
						[200, oJSONHeaders, sResultsUC2SibPosNode1],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='002')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%2714t10bv38u%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsEmptyCollection],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='002')/Results?$skip=0&$top=45&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC2L3Top45],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='002')/Results?$skip=0&$top=5&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20UI51383315%27":
						[200, oJSONHeaders, sResultsUC2Top5ParentUI51383315],

					/* Use case 3
						create FSI in deep node area and a range node as child of created FSI
					*/

					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='003')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC3L3Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='003')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20UI53844872%27":
						[200, oJSONHeaders, sResultsUC3Top120ParentUI53844872],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='003')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27xccw7jnhn6%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsEmptyCollection],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='003')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%2797qiqdppge%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsEmptyCollection],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='003')/Results?$skip=0&$top=45&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC3L3Top45],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='003')/Results?$skip=0&$top=3&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20UI53844872%27":
						[200, oJSONHeaders, sResultsUC3Top3ParentUI53844872],

					/* Use case 4
						create FSI on initial expand level and a FSI below it and 2 range nodes below the former created one
					*/

					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC4L3Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3a0.20.0.0.0_IEQCACNIEQ0010000052372%3a001%20NODE500000%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC4PrePosNODE500000],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3a0.20.0.0.0_IEQCACNIEQ0010000052372%3a001%20NODE500001%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsEmptyCollection],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3a0.47.0.0.0_IEQCACNIEQ0010000052371%3aNODE500001001%200000360000500002-0000500002%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsEmptyCollection],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3a0.47.0.0.0_IEQCACNIEQ0010000052371%3aNODE500001001%200000360000500001-0000500001%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsEmptyCollection],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?$skip=0&$top=46&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC4L3Top46],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?$skip=0&$top=1&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE500000%27":
						[200, oJSONHeaders, sResultsUC4Top1ParentNODE500000],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?$skip=0&$top=2&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE500001%27":
						[200, oJSONHeaders, sResultsUC4Top2ParentNODE500001],

					/* Use case 4b
						create FSI in server index area and additional FSI on initial expand level and two deep nodes underneath
					*/
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004b')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC4bL3Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004b')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3a0.19.0.0.0_IEQCACNIEQ0010000052372%3a001%20NODE40090%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC4bPrePosNODE40090],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004b')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3a0.19.0.0.0_IEQCACNIEQ0010000052372%3a001%20NODE40091%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC4bPrePosNODE40091],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004b')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27d%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsEmptyCollection],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004b')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27c%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsEmptyCollection],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004b')/Results?$skip=0&$top=36&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC4bL3Top36],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004b')/Results?$skip=0&$top=2&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE40091%27":
						[200, oJSONHeaders, sResultsUC4bTop2ParentNODE40091],

					/* Use case x3
						Create a single FSI node on the initial expand level

						- initial expand level: 2
						- new node is created on level 2
					*/
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x3')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%202":
						[200, oJSONHeaders, sResultsUCx3L2Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x3')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%273u8atky9ya%27%20and%20GLAccount_Level%20le%202":
						[200, oJSONHeaders, sResultsUCx3PrePosNODE123456],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x3')/Results?$skip=0&$top=24&$inlinecount=allpages&$filter=GLAccount_Level%20le%202":
						[200, oJSONHeaders, sResultsUCx3L2Top24],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x3')/Results?$filter=GLAccount_NodeID%20eq%20%27FinancialStatementItem%3a001%20NODE123456%27%20and%20GLAccount_Level%20le%202&$top=1":
						[200, oJSONHeaders, sResultsUCx3L2Top1NodeIDNODE123456],

					/* Use case x4
						Create FSI node on (initial expand level - 1) to make the artificial node a server index node

						- initial expand level: 3
						- new node is created on level 2
					*/
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x4')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUCx4L3Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x4')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27cu59y0t37v%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUCx4PrePosNODE000001],
					"ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x4')/Results?$filter=GLAccount_NodeID%20eq%20%27FinancialStatementItem%3a001%20NODE000001%27%20and%20GLAccount_Level%20le%203&$select=GLAccount_NodeID%2cGLAccount_Nodecount&$top=1":
						[200, oJSONHeaders, sResultsUCx4L3Top1NodeIDNODE000001], // TODO check if $select is necessary
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x4')/Results?$skip=0&$top=41&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUCx4L3Top41], // TODO check if $select is necessary

					/* Use case x2
						Delete server index node w/ generated server index node
					*/
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x2')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUCx2L3Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x2')/Results?$skip=0&$top=46&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUCx2L3Top46],

					/* Use case 8
						Move server index node with deep node children to deep node area
					*/
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='008')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC8L3Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='008')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE500000%27":
						[200, oJSONHeaders, sResultsUC8L3Top120NodeIDNODE500000],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='008')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3a0.20.0.0.0_IEQCACNIEQ0010000052372%3a001%20UI57446534%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsEmptyCollection],
					"ZTJ_G4_C_GLHIERResults('V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534')?$select=GLAccount_SiblingsPosition":
						[200, oJSONHeaders, sResultsUC8SibPosNodeIdUI57446534],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='008')/Results?$skip=0&$top=42&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC8L3Top42],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='008')/Results?$skip=0&$top=2&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE500000%27":
						[200, oJSONHeaders, sResultsUC8L3Top2NodeIDNODE500000],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='008')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20UI57446534%27":
						[200, oJSONHeaders, sResultsUC8L3Top120NodeIDUI57446534],

					/* Use case 10
						Move server index node one level down. Child nodes become deep nodes
						- initial expand level: 1
					 */
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='010')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC10L3Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='010')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3a0.20.0.0.0_IEQCACNIEQ0010000052372%3a001%20NODE133700%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC10PrePosNODE133700],
					"ZTJ_G4_C_GLHIERResults('V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE133700')?$select=GLAccount_SiblingsPosition":
						[200, oJSONHeaders, sResultsUC10SibPosNodeIdUI133700],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='010')/Results?$skip=0&$top=39&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC10L3Top39],

					/* Use case 17
						Move deep nodes. Some deep-nodes become server index nodes
						- initial expand level: 1
					 */
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC17L3Top120],
					// "ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$skip=0&$top=20&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE133702%27":
					// 	[200, oJSONHeaders, sResultsUC17L3Parent0Top1],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE133703%27":
						[200, oJSONHeaders, sResultsUC17L3Parent03Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE133704%27":
						[200, oJSONHeaders, sResultsUC17L3Parent04Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE133705%27":
						[200, oJSONHeaders, sResultsUC17L3Parent05Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE133706%27":
						[200, oJSONHeaders, sResultsUC17L3Parent06Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$select=ID%2cGLAccount_NodeID%2cGLAccount_Nodecount%2cGLAccount_Drillstate%2cGLAccount_PreorderPosition&$filter=ID%20eq%20%27V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3a0.20.0.0.0_IEQCACNIEQ0010000052372%3a001%20NODE133704%27%20and%20GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC17PrePosNODE133704],
					"ZTJ_G4_C_GLHIERResults('V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE133704')?$select=GLAccount_SiblingsPosition":
						[200, oJSONHeaders, sResultsUC17SibPosNodeIdUI133704],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$skip=0&$top=42&$inlinecount=allpages&$filter=GLAccount_Level%20le%203":
						[200, oJSONHeaders, sResultsUC17L3Top42],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$skip=0&$top=1&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE133704%27":
						[200, oJSONHeaders, sResultsUC17L3Parent04Top1],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$skip=0&$top=1&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE133705%27":
						[200, oJSONHeaders, sResultsUC17L3Parent05Top1],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$skip=0&$top=1&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE133706%27":
						[200, oJSONHeaders, sResultsUC17L3Parent06Top1],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='017')/Results?$skip=0&$top=1&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20NODE133703%27":
						[200, oJSONHeaders, sResultsUC17L3Parent03Top1AfterRestore],

					/* /Restore expansion state mock data
					============================================================= */

					/* =============================================================
						Expand node to level mock data
					*/

					// ENtL01: Expand root node (initial expansion level 0) to level 4
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL01')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsENtL01_L0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL01')/Results?$filter=GLAccount_NodeID%20eq%20%27GLAccountHierarchy%3a001%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL01_ExpRootToL4],

					// ENtL02: Expand root node (initial expansion level 2) to level 4
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL02')/Results?$skip=0&$top=5&$inlinecount=allpages&$filter=GLAccount_Level%20le%202":
						[200, oJSONHeaders, sResultsENtL02_L2Top5],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL02')/Results?$skip=5&$top=16&$filter=GLAccount_Level%20le%202":
						[200, oJSONHeaders, sResultsENtL02_L2Skip5Top16],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL02')/Results?$filter=GLAccount_NodeID%20eq%20%27GLAccountHierarchy%3a001%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL02_ExpRootToL4],

					// ENtL03: Expand root node (initial expansion level 0 + first child and childrens child manually expanded) to level 4
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL03')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsENtL03_L0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL03')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27GLAccountHierarchy%3a001%27":
						[200, oJSONHeaders, sResultsENtL03_Parent00Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL03')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%27":
						[200, oJSONHeaders, sResultsENtL03_Parent01Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL03')/Results?$filter=GLAccount_NodeID%20eq%20%27GLAccountHierarchy%3a001%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL03_ExpRootToL4],

					// ENtL04: Expand deep node to level 4
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL04')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsENtL04_L0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL04')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27GLAccountHierarchy%3a001%27":
						[200, oJSONHeaders, sResultsENtL04_Parent00Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL04')/Results?$filter=GLAccount_NodeID%20eq%20%27FinancialStatementItem%3a001%206%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL04_ExpDeepToL4],

					// ENtL05: Expand root node (initial expansion level 0 + first child and childrens child manually expanded) to level 4
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL05')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsENtL05_L0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL05')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27GLAccountHierarchy%3a001%27":
						[200, oJSONHeaders, sResultsENtL05_Parent00Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL05')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%206%27":
						[200, oJSONHeaders, sResultsENtL05_Parent07Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL05')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%20B1%27":
						[200, oJSONHeaders, sResultsENtL05_Parent08Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL05')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27RangeNode%3aB1%20%20%20%20%20%20%20%20001%200000090000000001-0000000100%27":
						[200, oJSONHeaders, sResultsENtL05_Parent09Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL05')/Results?$filter=GLAccount_NodeID%20eq%20%27GLAccountHierarchy%3a001%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL05_ExpRootToL4],

					// ENtL06
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL06')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsENtL06_L0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL06')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27GLAccountHierarchy%3a001%27":
						[200, oJSONHeaders, sResultsENtL06_Parent00Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL06')/Results?$filter=GLAccount_NodeID%20eq%20%27GLAccountHierarchy%3a001%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL06_ExpRootToL4],

					// ENtL07
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL07')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsENtL07_L0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL07')/Results?$filter=GLAccount_NodeID%20eq%20%27GLAccountHierarchy%3a001%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL07_ExpRootToL4],

					// ENtL08
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL08')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsENtL08_L0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL08')/Results?$filter=GLAccount_NodeID%20eq%20%27GLAccountHierarchy%3a001%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL08_ExpRootToL4],

					// ENtL09
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL09')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%202":
						[200, oJSONHeaders, sResultsENtL09_L2Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL09')/Results?$filter=GLAccount_NodeID%20eq%20%27GLAccountHierarchy%3a001%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL09_ExpRootToL4],

					// ENtL10
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL10')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsENtL10_L0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL10')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27GLAccountHierarchy%3a001%27":
						[200, oJSONHeaders, sResultsENtL10_Parent00Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL10')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27FinancialStatementItem%3a001%206%27":
						[200, oJSONHeaders, sResultsENtL10_Parent07Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL10')/Results?$filter=GLAccount_NodeID%20eq%20%27FinancialStatementItem%3a001%206%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL10_Exp07ToL4],

					// ENtL11
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL11')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%202":
						[200, oJSONHeaders, sResultsENtL11_L2Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL11')/Results?$filter=GLAccount_NodeID%20eq%20%27FinancialStatementItem%3a001%206%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL11_Exp07ToL4],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL11')/Results?$filter=GLAccount_NodeID%20eq%20%27GLAccountHierarchy%3a001%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL11_ExpRootToL4],

					// ENtL12
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL12')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsENtL12_L0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL12')/Results?$filter=GLAccount_NodeID%20eq%20%27GLAccountHierarchy%3a001%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL12_ExpRootToL4],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL12')/Results?$filter=GLAccount_NodeID%20eq%20%27RangeNode%3aB1%20%20%20%20%20%20%20%20001%200000090000000001-0000000100%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL12_Exp15ToL4],

					// ENtL13
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL13')/Results?$skip=0&$top=120&$inlinecount=allpages&$filter=GLAccount_Level%20le%200":
						[200, oJSONHeaders, sResultsENtL13_L0Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL13')/Results?$skip=0&$top=20&$inlinecount=allpages&$filter=GLAccount_ParentID%20eq%20%27GLAccountHierarchy%3a001%27":
						[200, oJSONHeaders, sResultsENtL13_Parent00Top120],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='ENtL13')/Results?$filter=GLAccount_NodeID%20eq%20%27GLAccountHierarchy%3a001%27%20and%20GLAccount_Level%20le%204":
						[200, oJSONHeaders, sResultsENtL13_ExpRootToL4]

					/* /Expand node to level mock data
					============================================================= */
				},
				"POST":{
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='001')/Results?hierarchy_fake_node_id=NODE111114":
						[201, oJSONHeaders, sResultsAfterCreateUC1NODE111114],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='002')/Results?hierarchy_fake_node_id=NODE113334":
						[201, oJSONHeaders, sResultsAfterCreateUC2NODE113334],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='003')/Results?hierarchy_fake_node_id=NODE333444":
						[201, oJSONHeaders, sResultsAfterCreateUC3NODE333444],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='003')/Results?hierarchy_fake_node_id=RANGE333444":
						[201, oJSONHeaders, sResultsAfterCreateUC3RANGE333444],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?hierarchy_fake_node_id=NODE500000":
						[201, oJSONHeaders, sResultsAfterCreateUC4NODE500000],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?hierarchy_fake_node_id=NODE500001":
						[201, oJSONHeaders, sResultsAfterCreateUC4NODE500001],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?hierarchy_fake_node_id=RANGE500001":
						[201, oJSONHeaders, sResultsAfterCreateUC4RANGE500001],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004')/Results?hierarchy_fake_node_id=RANGE500002":
						[201, oJSONHeaders, sResultsAfterCreateUC4RANGE500002],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004b')/Results?hierarchy_fake_node_id=NODE40090":
						[201, oJSONHeaders, sResultsAfterCreateUC4bNODE40090],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004b')/Results?hierarchy_fake_node_id=NODE40091":
						[201, oJSONHeaders, sResultsAfterCreateUC4bNODE40091],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004b')/Results?hierarchy_fake_node_id=RANGE400090":
						[201, oJSONHeaders, sResultsAfterCreateUC4bRANGE400090],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='004b')/Results?hierarchy_fake_node_id=RANGE400092":
						[201, oJSONHeaders, sResultsAfterCreateUC4bRANGE400092],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x3')/Results?hierarchy_fake_node_id=NODE123456":
						[201, oJSONHeaders, sResultsAfterCreateUCx3NODE123456],
					"ZTJ_G4_C_GLHIER(P_CHARTOFACCOUNTS='CACN',P_FINANCIALSTATEMENTVARIANT='0x4')/Results?hierarchy_fake_node_id=NODE000001":
						[201, oJSONHeaders, sResultsAfterCreateUCx4NODE000001]
				},
				"PUT": {
					// UC8
					"ZTJ_G4_C_GLHIERResults('V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534')":
						[204, oNoContentHeaders, ""],
					// UC10
					"ZTJ_G4_C_GLHIERResults('V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE133700')":
						[204, oNoContentHeaders, ""],
					// UC17
					"ZTJ_G4_C_GLHIERResults('V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE133704')":
						[204, oNoContentHeaders, ""]

				},
				"MERGE": {

				},
				"DELETE": {
					// UC5
					"ZTJ_G4_C_GLHIERResults('1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99993101')":
						[204, oNoContentHeaders, ""],
					// UCx2
					"ZTJ_G4_C_GLHIERResults('chnew7es8')":
						[204, oNoContentHeaders, ""]
				},
				"HEAD": {

				}
			};

			var getResponse = function(method, url, headers) {
				var bError =
					url.indexOf("Fail500") >= 0 ||
					(url === "/Categories(1-NOHEAD)" && method === "HEAD");

				if (!bError && oServiceStatusConfig.url && Array.isArray(oServiceStatusConfig.url["500"])) {
					bError = oServiceStatusConfig.url["500"].some(function(rCheck) {
						return rCheck.test(url);
					});
				}
				Log.info("ODataTreeBindingFakeService", "Handling request: " + url);

				if (bError) {
					return [500, oHTMLHeaders, "Server Error"];
				}
				var vResponse = typeof responses[method][url] === "function"
					? responses[method][url](url, headers)
					: responses[method][url];


				switch (method) {
					case "GET":
						return vResponse || [404, oJSONHeaders, ""];
					case "HEAD":
						var aReturnValues = vResponse || [404, oJSONHeaders, ""];
						aReturnValues[2] = ""; // Same as "GET" but without body
						return aReturnValues;
					case "PUT":
						return vResponse || [204, oJSONHeaders, ""];
					case "MERGE":
						return vResponse || [204, oJSONHeaders, ""];
					case "POST":
						return vResponse || [201, oJSONHeaders, ""/*TODO: Need to send something here?*/];
					case "DELETE":
						return vResponse || [204, oJSONHeaders, ""];
					default:
						return vResponse || [500, oHTMLHeaders, ""];
				}
			};

			request.onSend = function() {
				if (window.fakeRequested) {
					window.fakeRequested();
				}

				function respond(code, headers, data) {
					if (request.async) {
						_setTimeout(function() {
							if (!request.aborted) {
								if (window.fakeResponded) {
									window.fakeResponded();
								}
								request.respond(code, headers, data);
							}
						}, responseDelay);
					} else {
						if (!request.aborted) {
							if (window.fakeResponded) {
								window.fakeResponded();
							}
							request.respond(code, headers, data);
						}
					}
				}

				// CSRF Token handling

				// Special case: Simulate backend that does not allow HEAD requests
				if (window.odataFakeServiceData.forbidHeadRequest && request.method === "HEAD") {
					if (request.url == baseURL) {
						window.odataFakeServiceData.csrfRequests.push(request.method); // Log Requests to service document
					}
					respond(500, oHTMLHeaders, "Server Error");
					return;
				}



				if (["GET", "HEAD"].indexOf(request.method) === -1 && csrfToken) {
					if (getHeader(request.requestHeaders, "X-CSRF-Token") != csrfToken) {

						respond(403, oCsrfRequireHeaders, "");
						return;
					}
				}

				if (request.url == baseURL) {
					// Simulate Soft State header handling
					updateSessionContextId();
					oCsrfResponseHeaders["sap-contextid"] = sessionContextId;

					oCsrfResponseHeaders["X-CSRF-Token"] = csrfToken;
					window.odataFakeServiceData.csrfRequests.push(request.method); // Log Requests to service document
					respond(200, oCsrfResponseHeaders, sServiceDocJSON);
					return;
				}

				// Special handling SAML authentication redirect
				if (request.url.indexOf("SAML200") > 0 || (request.requestBody && request.requestBody.indexOf("SAML200") > 0)) {
					respond(200, oSAMLHeaders, sSAMLLoginPage);
					return;
				}

				// Special handling based on headers
				if (request.url == baseURL + "Categories" || request.url == baseURL + "Categories?horst=true") {
					if (request.requestHeaders["Accept"] == "application/atom+xml,application/atomsvc+xml,application/xml") {
						respond(200, oXMLHeaders, sCategoriesXML);
					} else {
						// Simulate Soft State header handling
						updateSessionContextId();
						oJSONHeaders["sap-contextid"] = sessionContextId;

						respond(200, oJSONHeaders, sCategoriesJSON);
					}
					return;
				}

				// Batch request
				if (request.url == baseURL + "$batch") {
					if (request.requestBody.indexOf("Batch500") > 0 || oServiceStatusConfig.batch === 500) {
						respond(500, oJSONHeaders, "Request Failed");
						return;
					}

					if (oServiceStatusConfig.batch === "abort") {
						// sinon.js crashes without this line
						request.responseHeaders = {};
						request.abort();
						return;
					}

					var requests = parseBatchRequest(request.requestBody),
						batchResponses = [],
						nestedResponses,
						failed,
						batchResponse;
					for (var i = 0; i < requests.length; i++) {
						if (requests[i] instanceof Array) {
							nestedResponses = [];
							failed = false;
							for (var j = 0; j < requests[i].length; j++) {
								var response = getResponse(requests[i][j].method, requests[i][j].url, requests[i][j].requestHeaders);
								nestedResponses.push(response);
								if (response[0] >= 300) {
									failed = true;
								}
							}
							if (failed) {
								batchResponses.push([500, oJSONHeaders, "Changeset failed"]);
							} else {
								batchResponses.push(nestedResponses);
							}
						} else {
							response = getResponse(requests[i].method, requests[i].url, requests[i].requestHeaders);
							batchResponses.push(response);
						}
					}
					batchResponse = createBatchResponse(batchResponses, "batch-408D0D264EF1AB69CA1BF7");

					updateSessionContextId();
					oBatchHeaders["sap-contextid"] = sessionContextId;

					respond(202, oBatchHeaders, batchResponse);
					return;
				}

				// Look up response
				respond.apply(this, getResponse(request.method, request.url.substr(baseURL.length), request.requestHeaders));
			};
		};

		function parseBatchRequest(body) {
			var token = body.split("\r\n")[1],
				parts = body.split("\r\n" + token),
				part, lines,
				nestedRequests,
				requests = [];
			// loop through parts and create request objects
			for (var i = 1; i < parts.length - 1; i++) {
				part = parts[i];
				if (part.indexOf("\r\nContent-Type: multipart/mixed") == 0) {
					nestedRequests = parseBatchRequest("\r\n" + part.substr(part.indexOf("--")));
					requests.push(nestedRequests);
				} else {
					var request = {};
					lines = part.split("\r\n");
					var result = lines[4].match(/(GET|POST|MERGE|PUT|DELETE) ([^ ]*) HTTP\/1\.1/);
					request.method = result[1];
					request.url = result[2];
					request.body = "";
					request.headers = {};
					var headers = true;
					for (var j = 5; j < lines.length; j++) {
						if (lines[j] == "") {
							headers = false;
							continue;
						}
						if (headers) {
							var header = lines[j].split(": ");
							request.headers[header[0]] = header[1];
						} else {
							request.body += lines[j] + "\n";
						}
					}
					requests.push(request);
				}
			}
			return requests;
		}

		function createBatchResponse(responses, token) {
			var responseText = "",
				code, headers, body,
				innerText,
				innerToken;
			for (var i = 0; i < responses.length; i++) {
				if (typeof responses[i][0] != "number") {
					innerToken = "changeset-" + Math.random() * 1000000000000000000;
					innerText = "\r\n";
					innerText += createBatchResponse(responses[i], innerToken);
					responseText += "--" + token + "\r\n";
					responseText += "Content-Type: multipart/mixed; boundary=" + innerToken + "\r\n";
					responseText += "Content-Length: " + innerText.length + "\r\n";
					responseText += innerText + "\r\n";
				} else {
					code = responses[i][0];
					headers = responses[i][1];
					body = responses[i][2];
					innerText = "HTTP/1.1 " + code + " ";
					switch (code) {
						case 200:
							innerText += "OK";
							break;
						case 204:
							innerText += "No content";
							break;
						case 201:
							innerText += "Created";
							break;
						case 404:
							innerText += "Not Found";
							break;
						case 500:
							innerText += "Server Error";
							break;
						case 412:
							innerText += "Precodition failed";
							break;
					}
					innerText += "\r\n";
					for (var j in headers) {
						innerText += j + ": " + headers[j] + "\r\n";
					}
					innerText += "Content-Length: " + body.length + "\r\n";
					innerText += "\r\n";
					if (body.length > 0) {
						innerText += body + "\r\n";
					}
					responseText += "--" + token + "\r\n";
					responseText += "Content-Type: application/http\r\n";
					responseText += "Content-Transfer-Encoding: binary\r\n";
					responseText += "Content-Length: " + innerText.length + "\r\n";
					responseText += "\r\n";
					responseText += innerText + "\r\n";
				}
			}
			responseText += "--" + token + "--\r\n";
			return responseText;
		}

	}

	var oMetaDataHeaders = {
			"Content-Type": "application/xml;charset=utf-8",
			"DataServiceVersion": "1.0",
			"last-modified": "Tue, 15 Nov 1994 12:45:26 GMT"
		};
	/* currently unused
	var oNodataHeaders = {
			"DataServiceVersion": "1.0"
		}; */
	var oXMLHeaders = {
			"Content-Type": "application/atom+xml;charset=utf-8",
			"DataServiceVersion": "2.0",
			"Age": "oh so very old",
			"Invalid": "invalid"
		};

	var oJSONHeaders = {
			"Content-Type": "application/json;charset=utf-8",
			"DataServiceVersion": "2.0"
		};

	var oNoContentHeaders = {
			"DataServiceVersion": "2.0"
		};
	/* currently unused
	var oCountHeaders = {
			"Content-Type": "text/plain;charset=utf-8",
			"DataServiceVersion": "2.0"
		}; */
	var oBatchHeaders = {
			"Content-Type": "multipart/mixed; boundary=batch-408D0D264EF1AB69CA1BF7",
			"DataServiceVersion": "2.0"
		};
	var oHTMLHeaders = {
			"Content-Type": "text/html"
		};
	var oSAMLHeaders = {
			"Content-Type": "text/html",
			"com.sap.cloud.security.login": "login-request"
		};
	var oCsrfRequireHeaders = {
			"Content-Type": "text/plain;charset=utf-8",
			"DataServiceVersion": "2.0",
			"X-CSRF-Token": "required"
		};
	var oCsrfResponseHeaders = {
			"Content-Type": "application/json;charset=utf-8",
			"DataServiceVersion": "1.0",
			"X-CSRF-Token": ""
		};
	/* unused?
	var oSpecialHeaders = {
		"Content-Type": "application/xml;charset=utf-8",
		"DataServiceVersion": "1.0",
		"lAsT-mOdIfIeD": "morgen frueh",
		"X-CuStOm-HeAdEr": "case-sensitive"
	};*/
	var sSAMLLoginPage = '<html><body><h1>SAML Login Page</h1></body></html>';

	var sServiceDocJSON = '{"d":{"EntitySets":["AdditionalMetadata","HierarchyNodeInfomationCollection","ZTJ_G4_C_GLHIERResults","ZTJG4GLHIERLabels","ZTJ_G4_C_GLHIER","P_CHARTOFACCOUNTS","I_ChartOfAccounts","I_DraftAdministrativeData","I_FinancialStatementVersionT","I_Language","ZTJ_C_FSVHierarchyTP","Ztj_G4_Chartofaccounts","Ztj_G4_Hierarchy","Ztj_G4_Hierarchyt"]}}';


	var sMetaData = '\
<?xml version="1.0" encoding="utf-8"?>\
<edmx:Edmx Version="1.0" xmlns:edmx="http://schemas.microsoft.com/ado/2007/06/edmx" xmlns:m="http://schemas.microsoft.com/ado/2007/08/dataservices/metadata" xmlns:sap="http://www.sap.com/Protocols/SAPData">\
<edmx:Reference Uri="https://ponyhost/sap/opu/odata/IWFND/CATALOGSERVICE;v=2/Vocabularies(TechnicalName=\'%2FIWBEP%2FVOC_COMMON\',Version=\'0001\',SAP__Origin=\'LOCAL\')/$value" xmlns:edmx="http://docs.oasis-open.org/odata/ns/edmx">\
<edmx:Include Alias="Common" Namespace="com.sap.vocabularies.Common.v1"/>\
</edmx:Reference>\
<edmx:Reference Uri="https://ponyhost/sap/opu/odata/IWFND/CATALOGSERVICE;v=2/Vocabularies(TechnicalName=\'%2FIWBEP%2FVOC_COMMON\',Version=\'0001\',SAP__Origin=\'SFINODATA1\')/$value" xmlns:edmx="http://docs.oasis-open.org/odata/ns/edmx">\
<edmx:Include Alias="Common" Namespace="com.sap.vocabularies.Common.v1"/>\
</edmx:Reference>\
<edmx:Reference Uri="https://ponyhost/sap/opu/odata/IWFND/CATALOGSERVICE;v=2/Vocabularies(TechnicalName=\'%2FIWBEP%2FVOC_CAPABILITIES\',Version=\'0001\',SAP__Origin=\'SFINODATA1\')/$value" xmlns:edmx="http://docs.oasis-open.org/odata/ns/edmx">\
<edmx:Include Alias="Capabilities" Namespace="Org.OData.Capabilities.V1"/>\
</edmx:Reference>\
<edmx:DataServices m:DataServiceVersion="2.0">\
<Schema Namespace="ZTJ_SFIN_HIERARCHY_02_SRV" sap:schema-version="1" xml:lang="en" xmlns="http://schemas.microsoft.com/ado/2008/09/edm">\
<EntityType Name="ZTJ_G4_C_GLHIERResult" sap:content-version="1" sap:label="No label defined for CDS view ZTJG4GLHIER" sap:semantics="aggregate">\
<Key>\
<PropertyRef Name="ID"/>\
</Key>\
<Property Name="ID" Nullable="false" Type="Edm.String" sap:filterable="false" sap:sortable="false" sap:updatable="false"/>\
<Property Name="TotaledProperties" Type="Edm.String" sap:aggregation-role="totaled-properties-list" sap:is-annotation="true" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="4" Name="ChartOfAccounts" Type="Edm.String" sap:aggregation-role="dimension" sap:creatable="false" sap:label="Chart of Accounts" sap:updatable="false"/>\
<Property MaxLength="10" Name="GLAccount" Type="Edm.String" sap:aggregation-role="dimension" sap:creatable="false" sap:filterable="false" sap:label="G/L Account" sap:super-ordinate="ChartOfAccounts" sap:text="GLAccount_T" sap:updatable="false"/>\
<Property MaxLength="281" Name="GLAccount_NodeID" Type="Edm.String" sap:filter-restriction="multi-value" sap:hierarchy-node-for="GLAccount" sap:label="G/L Account Node ID" sap:required-in-filter="false" sap:sortable="false" sap:text="GLAccount_NodeText"/>\
<Property MaxLength="250" Name="GLAccount_NodeIDExt" Type="Edm.String" sap:filter-restriction="multi-value" sap:hierarchy-node-external-key-for="GLAccount_NodeID" sap:label="G/L Account Node ID External" sap:required-in-filter="false" sap:sortable="false" sap:text="GLAccount_NodeText"/>\
<Property MaxLength="60" Name="GLAccount_NodeText" Type="Edm.String" sap:filterable="false" sap:label="G/L Account Node Text" sap:sortable="false"/>\
<Property MaxLength="281" Name="GLAccount_ParentID" Type="Edm.String" sap:filter-restriction="multi-value" sap:hierarchy-parent-node-for="GLAccount_NodeID" sap:label="G/L Account Parent ID" sap:required-in-filter="false" sap:sortable="false"/>\
<Property Name="GLAccount_Level" Type="Edm.Int16" sap:filter-restriction="multi-value" sap:hierarchy-level-for="GLAccount_NodeID" sap:label="G/L Account Level" sap:required-in-filter="false" sap:sortable="false"/>\
<Property MaxLength="9" Name="GLAccount_Drillstate" Type="Edm.String" sap:filterable="false" sap:hierarchy-drill-state-for="GLAccount_NodeID" sap:is-annotation="true" sap:label="G/L Account Drilldown State" sap:sortable="false"/>\
<Property Name="GLAccount_Nodecount" Type="Edm.Int16" sap:filterable="false" sap:hierarchy-node-descendant-count-for="GLAccount_NodeID" sap:is-annotation="true" sap:label="G/L Account Counter for Descendant Nodes" sap:sortable="false"/>\
<Property MaxLength="40" Name="GLAccount_T" Type="Edm.String" sap:creatable="false" sap:filterable="false" sap:label="G/L Account (Description)" sap:updatable="false"/>\
<Property MaxLength="1" Name="IsBalanceSheetAccount" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="Balance sheet acct" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="4" Name="GLAccountGroup" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="Account Group" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="10" Name="CorporateGroupAccount" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="Group Account Number" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="2" Name="ProfitLossAccountType" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="P&amp;L statmt acct type" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="10" Name="SampleGLAccount" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="Sample Account" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="1" Name="AccountIsMarkedForDeletion" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="Mark for Deletion" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="1" Name="AccountIsBlockedForCreation" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="Blocked for Creation" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="1" Name="AccountIsBlockedForPosting" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="Blocked for Posting" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="1" Name="AccountIsBlockedForPlanning" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="Blocked for Planning" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="6" Name="PartnerCompany" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="Trading Partner" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="16" Name="FunctionalArea" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="Functional Area" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="1" Name="FakeGLAccountFlag" Type="Edm.String" sap:attribute-for="GLAccount" sap:filterable="false" sap:label="FAKEGLACCOUNTFLAG" sap:sortable="false" sap:updatable="false"/>\
<Property Name="GLAccount_SiblingsPosition" sap:hierarchy-sibling-rank-for="GLAccount_NodeID" Type="Edm.Int32" sap:aggregation-role="dimension" sap:creatable="false" sap:label="GLACCOUNT_SIBLINGSPOSITION" sap:updatable="false"/>\
<Property Name="GLAccount_PreorderPosition" sap:hierarchy-preorder-rank-for="GLAccount_NodeID" Type="Edm.Int32" sap:aggregation-role="dimension" sap:creatable="false" sap:label="GLACCOUNT_PREORDERPOSITION" sap:updatable="false"/>\
<Property MaxLength="1" Name="Action" Type="Edm.String" sap:aggregation-role="dimension" sap:creatable="false" sap:label="ACTION" sap:updatable="false"/>\
<Property MaxLength="1" Name="NodeType" Type="Edm.String" sap:aggregation-role="dimension" sap:creatable="false" sap:label="NODETYPE" sap:updatable="false"/>\
<Property Name="counter" Precision="42" Scale="0" Type="Edm.Decimal" sap:aggregation-role="measure" sap:creatable="false" sap:filterable="false" sap:label="Counter" sap:text="counter_F" sap:updatable="false"/>\
<Property MaxLength="60" Name="counter_F" Type="Edm.String" sap:creatable="false" sap:filterable="false" sap:label="Counter (Formatted)" sap:updatable="false"/>\
<NavigationProperty FromRole="ToRole_ZTJG4GLHIERParametersToResult" Name="Parameters" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJG4GLHIERParametersToResult" ToRole="FromRole_ZTJG4GLHIERParametersToResult"/>\
</EntityType>\
<EntityType Name="ZTJG4GLHIERLabels" sap:content-version="1">\
<Key>\
<PropertyRef Name="Name"/>\
</Key>\
<Property Name="Name" Nullable="false" Type="Edm.String"/>\
<Property Name="Label" Type="Edm.String"/>\
</EntityType>\
<EntityType Name="ZTJ_G4_C_GLHIERParameters" sap:content-version="1" sap:semantics="parameters">\
<Key>\
<PropertyRef Name="P_CHARTOFACCOUNTS"/>\
<PropertyRef Name="P_FINANCIALSTATEMENTVARIANT"/>\
</Key>\
<Property MaxLength="4" Name="P_CHARTOFACCOUNTS" Nullable="false" Type="Edm.String" sap:label="Chart of Accounts" sap:parameter="mandatory" sap:sortable="false" sap:text="P_CHARTOFACCOUNTSText"/>\
<Property MaxLength="60" Name="P_CHARTOFACCOUNTSText" Type="Edm.String" sap:filterable="false" sap:label="Chart of Accounts" sap:sortable="false"/>\
<Property MaxLength="60" Name="P_FINANCIALSTATEMENTVARIANT" Nullable="false" Type="Edm.String" sap:filterable="false" sap:label="Fin. Stmt Vers." sap:parameter="mandatory" sap:sortable="false" sap:text="P_FINANCIALSTATEMENTVARIANTText"/>\
<Property MaxLength="60" Name="P_FINANCIALSTATEMENTVARIANTText" Type="Edm.String" sap:filterable="false" sap:label="Fin. Stmt Vers." sap:sortable="false"/>\
<NavigationProperty FromRole="ToRole_P_CHARTOFACCOUNTSToListOfValues" Name="P_CHARTOFACCOUNTSDetails" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.P_CHARTOFACCOUNTSToListOfValues" ToRole="FromRole_P_CHARTOFACCOUNTSToListOfValues"/>\
<NavigationProperty FromRole="FromRole_ZTJG4GLHIERParametersToResult" Name="Results" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJG4GLHIERParametersToResult" ToRole="ToRole_ZTJG4GLHIERParametersToResult"/>\
<NavigationProperty FromRole="FromRole_ZTJG4GLHIERParametersToLabels" Name="Labels" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJG4GLHIERParametersToLabels" ToRole="ToRole_ZTJG4GLHIERParametersToLabels"/>\
</EntityType>\
<EntityType Name="P_CHARTOFACCOUNTS" sap:content-version="1" sap:label="Chart of Accounts">\
<Key>\
<PropertyRef Name="P_CHARTOFACCOUNTS_ID"/>\
</Key>\
<Property MaxLength="4" Name="P_CHARTOFACCOUNTS_ID" Nullable="false" Type="Edm.String" sap:creatable="false" sap:label="Chart of Accounts" sap:sortable="false" sap:text="P_CHARTOFACCOUNTS_TEXT" sap:updatable="false"/>\
<Property Name="P_CHARTOFACCOUNTS_TEXT" Type="Edm.String" sap:creatable="false" sap:filterable="false" sap:sortable="false" sap:updatable="false"/>\
</EntityType>\
<EntityType Name="ODataQueryAdditionalMetadata" sap:content-version="1">\
<Key>\
<PropertyRef Name="ODataQueryMetadata"/>\
</Key>\
<Property Name="ODataQueryMetadata" Nullable="false" Type="Edm.String" sap:creatable="false" sap:filterable="false" sap:sortable="false" sap:updatable="false"/>\
<Property Name="ODataQueryMetadataValue_Current" Type="Edm.String" sap:creatable="false" sap:filterable="false" sap:sortable="false" sap:updatable="false"/>\
<Property Name="ODataQueryMetadataValueAtDefine" Type="Edm.String" sap:creatable="false" sap:filterable="false" sap:sortable="false" sap:updatable="false"/>\
</EntityType>\
<EntityType Name="I_ChartOfAccountsType" sap:content-version="1" sap:label="Chart Of Accounts">\
<Key>\
<PropertyRef Name="ChartOfAccounts"/>\
</Key>\
<Property MaxLength="4" Name="ChartOfAccounts" Nullable="false" Type="Edm.String" sap:display-format="UpperCase" sap:label="Chart of Accounts" sap:text="ChartOfAccounts_Text"/>\
<Property MaxLength="50" Name="ChartOfAccounts_Text" Type="Edm.String" sap:creatable="false" sap:label="Description" sap:quickinfo="Chart of Accounts Description" sap:updatable="false"/>\
<Property MaxLength="4" Name="CorporateGroupChartOfAccounts" Type="Edm.String" sap:display-format="UpperCase" sap:label="Group Chart of Accts"/>\
<Property Name="ChartOfAcctsIsBlocked" Type="Edm.Boolean" sap:display-format="UpperCase" sap:label="Blocked" sap:quickinfo="Indicator: Is the Chart of Accounts Blocked ?"/>\
<Property MaxLength="2" Name="MaintenanceLanguage" Type="Edm.String" sap:label="Maint.Language" sap:quickinfo="Maintenance Language for the Chart of Accounts"/>\
</EntityType>\
<EntityType Name="I_DraftAdministrativeDataType" sap:content-version="1" sap:label="Draft Administrative Data">\
<Key>\
<PropertyRef Name="DraftUUID"/>\
</Key>\
<Property Name="DraftUUID" Nullable="false" Type="Edm.Guid" sap:label="Draft (Technical ID)"/>\
<Property MaxLength="30" Name="DraftEntityType" Type="Edm.String" sap:display-format="UpperCase" sap:label="Draft Entity ID"/>\
<Property Name="CreationDateTime" Precision="7" Type="Edm.DateTimeOffset" sap:label="Draft Created On"/>\
<Property MaxLength="12" Name="CreatedByUser" Type="Edm.String" sap:display-format="UpperCase" sap:label="Draft Created By" sap:text="CreatedByUserDescription"/>\
<Property Name="LastChangeDateTime" Precision="7" Type="Edm.DateTimeOffset" sap:label="Draft Last Changed On"/>\
<Property MaxLength="12" Name="LastChangedByUser" Type="Edm.String" sap:display-format="UpperCase" sap:label="Draft Last Changed By" sap:text="LastChangedByUserDescription"/>\
<Property MaxLength="1" Name="DraftAccessType" Type="Edm.String" sap:display-format="UpperCase" sap:label="Draft Access Type"/>\
<Property Name="ProcessingStartDateTime" Precision="7" Type="Edm.DateTimeOffset" sap:label="Draft In Process Since"/>\
<Property MaxLength="12" Name="InProcessByUser" Type="Edm.String" sap:display-format="UpperCase" sap:label="Draft In Process By" sap:text="InProcessByUserDescription"/>\
<Property Name="DraftIsKeptByUser" Type="Edm.Boolean" sap:display-format="UpperCase" sap:label="Draft Is Kept By User"/>\
<Property Name="EnqueueStartDateTime" Precision="7" Type="Edm.DateTimeOffset" sap:label="Draft Locked Since"/>\
<Property Name="DraftIsCreatedByMe" Type="Edm.Boolean" sap:display-format="UpperCase" sap:label="Draft Created By Me"/>\
<Property Name="DraftIsLastChangedByMe" Type="Edm.Boolean" sap:display-format="UpperCase" sap:label="Draft Last Changed By Me"/>\
<Property Name="DraftIsProcessedByMe" Type="Edm.Boolean" sap:display-format="UpperCase" sap:label="Draft In Process By Me"/>\
<Property MaxLength="80" Name="CreatedByUserDescription" Type="Edm.String" sap:label="Draft Created By (Description)"/>\
<Property MaxLength="80" Name="LastChangedByUserDescription" Type="Edm.String" sap:label="Draft Last Changed By (Description)"/>\
<Property MaxLength="80" Name="InProcessByUserDescription" Type="Edm.String" sap:label="Draft In Process By (Description)"/>\
</EntityType>\
<EntityType Name="I_FinancialStatementVersionTType" sap:content-version="1" sap:label="Financial Statement Version Text">\
<Key>\
<PropertyRef Name="FinancialStatementVariant"/>\
<PropertyRef Name="Language"/>\
</Key>\
<Property MaxLength="4" Name="FinancialStatementVariant" Nullable="false" Type="Edm.String" sap:display-format="UpperCase" sap:label="FS Version" sap:quickinfo="Financial Statement Version"/>\
<Property MaxLength="2" Name="Language" Nullable="false" Type="Edm.String" sap:label="Language Key"/>\
<Property MaxLength="50" Name="FinancialStatementVariantName" Type="Edm.String" sap:label="Name" sap:quickinfo="Financial Statement Version Name"/>\
</EntityType>\
<EntityType Name="I_LanguageType" sap:content-version="1" sap:label="Language">\
<Key>\
<PropertyRef Name="Language"/>\
</Key>\
<Property MaxLength="2" Name="Language" Nullable="false" Type="Edm.String" sap:label="Language Key" sap:text="Language_Text"/>\
<Property MaxLength="16" Name="Language_Text" Type="Edm.String" sap:creatable="false" sap:label="Name" sap:quickinfo="Name of Language" sap:updatable="false"/>\
<Property MaxLength="2" Name="LanguageISOCode" Type="Edm.String" sap:display-format="UpperCase" sap:label="Lang. (ISO 639)" sap:quickinfo="2-Character SAP Language Code"/>\
</EntityType>\
<EntityType Name="ZTJ_C_FSVHierarchyTPType" sap:content-version="1" sap:label="fsv hierarchy draft consumption">\
<Key>\
<PropertyRef Name="FinancialStatementVariant"/>\
<PropertyRef Name="DraftUUID"/>\
<PropertyRef Name="IsActiveEntity"/>\
</Key>\
<Property Name="Activation_ac" Type="Edm.Boolean" sap:creatable="false" sap:filterable="false" sap:label="Dyn. Action Control" sap:sortable="false" sap:updatable="false"/>\
<Property Name="Edit_ac" Type="Edm.Boolean" sap:creatable="false" sap:filterable="false" sap:label="Dyn. Action Control" sap:sortable="false" sap:updatable="false"/>\
<Property Name="Preparation_ac" Type="Edm.Boolean" sap:creatable="false" sap:filterable="false" sap:label="Dyn. Action Control" sap:sortable="false" sap:updatable="false"/>\
<Property Name="Validation_ac" Type="Edm.Boolean" sap:creatable="false" sap:filterable="false" sap:label="Dyn. Action Control" sap:sortable="false" sap:updatable="false"/>\
<Property Name="FunctionalAreaIsUsed_fc" Type="Edm.Byte" sap:creatable="false" sap:filterable="false" sap:label="Dyn. Field Control" sap:sortable="false" sap:updatable="false"/>\
<Property Name="GroupChartOfAccountIsUsed_fc" Type="Edm.Byte" sap:creatable="false" sap:filterable="false" sap:label="Dyn. Field Control" sap:sortable="false" sap:updatable="false"/>\
<Property Name="HierarchyVariantForEdit_fc" Type="Edm.Byte" sap:creatable="false" sap:filterable="false" sap:label="Dyn. Field Control" sap:sortable="false" sap:updatable="false"/>\
<Property Name="MaintenanceLanguage_fc" Type="Edm.Byte" sap:creatable="false" sap:filterable="false" sap:label="Dyn. Field Control" sap:sortable="false" sap:updatable="false"/>\
<Property MaxLength="4" Name="FinancialStatementVariant" Nullable="false" Type="Edm.String" sap:creatable="false" sap:display-format="UpperCase" sap:label="FS Version" sap:quickinfo="Financial Statement Version" sap:updatable="false"/>\
<Property MaxLength="4" Name="ChartOfAccounts" Type="Edm.String" sap:creatable="false" sap:display-format="UpperCase" sap:label="Chart of Accounts" sap:quickinfo="Financial Statement Version Uses Only One Chart of Accounts" sap:text="to_ChartOfAccounts/ChartOfAccounts_Text" sap:updatable="false" sap:value-list="standard"/>\
<Property MaxLength="4" Name="HierarchyVariantForEdit" Type="Edm.String" sap:display-format="UpperCase" sap:field-control="HierarchyVariantForEdit_fc" sap:label="FS Version" sap:quickinfo="Financial Statement Version" sap:value-list="standard"/>\
<Property MaxLength="2" Name="MaintenanceLanguage" Type="Edm.String" sap:field-control="MaintenanceLanguage_fc" sap:label="Language Key" sap:text="to_Language/Language_Text" sap:value-list="standard"/>\
<Property Name="GroupChartOfAccountIsUsed" Type="Edm.Boolean" sap:display-format="UpperCase" sap:field-control="GroupChartOfAccountIsUsed_fc" sap:label="Group Account Number" sap:quickinfo="Financial Statement Version Uses Group Chart of Accounts"/>\
<Property MaxLength="1" Name="FunctionalAreaIsUsed" Type="Edm.String" sap:display-format="UpperCase" sap:field-control="FunctionalAreaIsUsed_fc" sap:label="Fun.Area Perm." sap:quickinfo="Indicator: Assignment of Functional Areas Is Permitted"/>\
<Property Name="DraftUUID" Nullable="false" Type="Edm.Guid" sap:label="Key"/>\
<Property Name="DraftEntityCreationDateTime" Precision="7" Type="Edm.DateTimeOffset" sap:label="Draft Created On"/>\
<Property Name="DraftEntityLastChangeDateTime" Precision="7" Type="Edm.DateTimeOffset" sap:label="Draft Last Changed On"/>\
<Property Name="HasActiveEntity" Type="Edm.Boolean" sap:display-format="UpperCase" sap:label="Has active" sap:sortable="false"/>\
<Property Name="HasDraftEntity" Type="Edm.Boolean" sap:display-format="UpperCase" sap:label="Has Draft" sap:sortable="false"/>\
<Property Name="IsActiveEntity" Nullable="false" Type="Edm.Boolean" sap:display-format="UpperCase" sap:label="Is active" sap:sortable="false"/>\
<NavigationProperty FromRole="FromRole_assoc_58EB9B168452ADF63C3BE45CDEE99844" Name="DraftAdministrativeData" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_58EB9B168452ADF63C3BE45CDEE99844" ToRole="ToRole_assoc_58EB9B168452ADF63C3BE45CDEE99844"/>\
<NavigationProperty FromRole="FromRole_assoc_4782569891A012A4D3F3B4E587E57712" Name="SiblingEntity" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_4782569891A012A4D3F3B4E587E57712" ToRole="ToRole_assoc_4782569891A012A4D3F3B4E587E57712"/>\
<NavigationProperty FromRole="FromRole_assoc_ECBAB52142C877BEDABDE3ABD9491FA6" Name="to_ChartOfAccounts" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_ECBAB52142C877BEDABDE3ABD9491FA6" ToRole="ToRole_assoc_ECBAB52142C877BEDABDE3ABD9491FA6"/>\
<NavigationProperty FromRole="FromRole_assoc_000A78B51019E07B6DC9989DCC09F81D" Name="to_Language" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_000A78B51019E07B6DC9989DCC09F81D" ToRole="ToRole_assoc_000A78B51019E07B6DC9989DCC09F81D"/>\
<NavigationProperty FromRole="FromRole_assoc_13A43A207F51A1B4207B9E03FEF38AD5" Name="to_Text" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_13A43A207F51A1B4207B9E03FEF38AD5" ToRole="ToRole_assoc_13A43A207F51A1B4207B9E03FEF38AD5"/>\
</EntityType>\
<EntityType Name="Ztj_G4_ChartofaccountsType" sap:content-version="1" sap:label="Chart Of Accounts">\
<Key>\
<PropertyRef Name="ChartOfAccounts"/>\
</Key>\
<Property MaxLength="4" Name="ChartOfAccounts" Nullable="false" Type="Edm.String" sap:display-format="UpperCase" sap:label="Chart of Accounts" sap:text="ChartOfAccounts_Text"/>\
<Property MaxLength="50" Name="ChartOfAccounts_Text" Type="Edm.String" sap:creatable="false" sap:label="Description" sap:quickinfo="Chart of Accounts Description" sap:updatable="false"/>\
<Property MaxLength="4" Name="CorporateGroupChartOfAccounts" Type="Edm.String" sap:display-format="UpperCase" sap:label="Group Chart of Accts"/>\
<Property Name="ChartOfAcctsIsBlocked" Type="Edm.Boolean" sap:display-format="UpperCase" sap:label="Blocked" sap:quickinfo="Indicator: Is the Chart of Accounts Blocked ?"/>\
<Property MaxLength="2" Name="MaintenanceLanguage" Type="Edm.String" sap:label="Maint.Language" sap:quickinfo="Maintenance Language for the Chart of Accounts"/>\
</EntityType>\
<EntityType Name="Ztj_G4_HierarchyType" sap:content-version="1" sap:label="Financial Statement Version">\
<Key>\
<PropertyRef Name="FinancialStatementVariant"/>\
<PropertyRef Name="ChartOfAccounts"/>\
</Key>\
<Property MaxLength="4" Name="FinancialStatementVariant" Nullable="false" Type="Edm.String" sap:display-format="UpperCase" sap:label="FS Version" sap:quickinfo="Financial Statement Version" sap:text="FinancialStatementVariantName"/>\
<Property MaxLength="4" Name="ChartOfAccounts" Nullable="false" Type="Edm.String" sap:display-format="UpperCase" sap:label="Chart of Accounts" sap:quickinfo="Financial Statement Version Uses Only One Chart of Accounts" sap:text="to_ChartOfAccounts/ChartOfAccounts_Text" sap:value-list="standard"/>\
<Property MaxLength="2" Name="MaintenanceLanguage" Type="Edm.String" sap:label="Language Key" sap:text="to_Language/Language_Text" sap:value-list="standard"/>\
<Property Name="GroupChartOfAccountIsUsed" Type="Edm.Boolean" sap:display-format="UpperCase" sap:label="Group Account Number" sap:quickinfo="Financial Statement Version Uses Group Chart of Accounts"/>\
<Property MaxLength="1" Name="FunctionalAreaIsUsed" Type="Edm.String" sap:display-format="UpperCase" sap:label="Fun.Area Perm." sap:quickinfo="Indicator: Assignment of Functional Areas Is Permitted"/>\
<Property MaxLength="10" Name="Assets" Type="Edm.String" sap:display-format="UpperCase" sap:label="Assets" sap:quickinfo="Item Key Representing the Assets"/>\
<Property MaxLength="10" Name="Equity" Type="Edm.String" sap:display-format="UpperCase" sap:label="Liabilities &amp; Equity" sap:quickinfo="Item Key Representing the Liabilities"/>\
<Property MaxLength="10" Name="NetLoss" Type="Edm.String" sap:display-format="UpperCase" sap:label="Net Result: Loss" sap:quickinfo="Item Key Representing the Line Item Net Loss"/>\
<Property MaxLength="10" Name="NetProfit" Type="Edm.String" sap:display-format="UpperCase" sap:label="Net Profit/Year" sap:quickinfo="Fin.Statement Key Representing the Net Profit/Yr"/>\
<Property MaxLength="10" Name="PLResult" Type="Edm.String" sap:display-format="UpperCase" sap:label="P+L Profit" sap:quickinfo="Fin.Statement Key Representing the P+L Profit Item"/>\
<Property MaxLength="10" Name="NotAssigned" Type="Edm.String" sap:display-format="UpperCase" sap:label="Not Assignable" sap:quickinfo="Item Key Representing the Non-Assignable Accounts"/>\
<Property MaxLength="10" Name="Notes" Type="Edm.String" sap:display-format="UpperCase" sap:label="Fin. Statement Notes" sap:quickinfo="Item Key That Represents the Notes to Financial Statements"/>\
<Property MaxLength="14" Name="UpdateTime" Type="Edm.String" sap:display-format="UpperCase"/>\
<Property MaxLength="50" Name="FinancialStatementVariantName" Type="Edm.String" sap:label="Name" sap:quickinfo="Financial Statement Version Name"/>\
<NavigationProperty FromRole="FromRole_assoc_CB9E73935418CD69ACAF70778A03FC0C" Name="to_ChartOfAccounts" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_CB9E73935418CD69ACAF70778A03FC0C" ToRole="ToRole_assoc_CB9E73935418CD69ACAF70778A03FC0C"/>\
<NavigationProperty FromRole="FromRole_assoc_41C0A870D47E10A2558F6C3607AC0098" Name="to_Language" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_41C0A870D47E10A2558F6C3607AC0098" ToRole="ToRole_assoc_41C0A870D47E10A2558F6C3607AC0098"/>\
<NavigationProperty FromRole="FromRole_assoc_F58ADADA0E579745A4DFA3A419FA5A93" Name="to_Text" Relationship="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_F58ADADA0E579745A4DFA3A419FA5A93" ToRole="ToRole_assoc_F58ADADA0E579745A4DFA3A419FA5A93"/>\
</EntityType>\
<EntityType Name="Ztj_G4_HierarchytType" sap:content-version="1" sap:label="Financial Statement Version Text">\
<Key>\
<PropertyRef Name="FinancialStatementVariant"/>\
<PropertyRef Name="Language"/>\
</Key>\
<Property MaxLength="4" Name="FinancialStatementVariant" Nullable="false" Type="Edm.String" sap:display-format="UpperCase" sap:label="FS Version" sap:quickinfo="Financial Statement Version"/>\
<Property MaxLength="2" Name="Language" Nullable="false" Type="Edm.String" sap:label="Language Key"/>\
<Property MaxLength="50" Name="FinancialStatementVariantName" Type="Edm.String" sap:label="Name" sap:quickinfo="Financial Statement Version Name"/>\
</EntityType>\
<ComplexType Name="ValidationFunctionResult">\
<Property Name="IsValid" Type="Edm.Boolean" sap:label="Is valid"/>\
</ComplexType>\
<Association Name="P_CHARTOFACCOUNTSToListOfValues" sap:content-version="1">\
<End Multiplicity="1" Role="FromRole_P_CHARTOFACCOUNTSToListOfValues" Type="ZTJ_SFIN_HIERARCHY_02_SRV.P_CHARTOFACCOUNTS"/>\
<End Multiplicity="*" Role="ToRole_P_CHARTOFACCOUNTSToListOfValues" Type="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERParameters"/>\
<ReferentialConstraint>\
<Principal Role="FromRole_P_CHARTOFACCOUNTSToListOfValues">\
<PropertyRef Name="P_CHARTOFACCOUNTS_ID"/>\
</Principal>\
<Dependent Role="ToRole_P_CHARTOFACCOUNTSToListOfValues">\
<PropertyRef Name="P_CHARTOFACCOUNTS"/>\
</Dependent>\
</ReferentialConstraint>\
</Association>\
<Association Name="ZTJG4GLHIERParametersToResult" sap:content-version="1">\
<End Multiplicity="1" Role="FromRole_ZTJG4GLHIERParametersToResult" Type="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERParameters"/>\
<End Multiplicity="*" Role="ToRole_ZTJG4GLHIERParametersToResult" Type="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"/>\
</Association>\
<Association Name="ZTJG4GLHIERParametersToLabels" sap:content-version="1">\
<End Multiplicity="1" Role="FromRole_ZTJG4GLHIERParametersToLabels" Type="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERParameters"/>\
<End Multiplicity="*" Role="ToRole_ZTJG4GLHIERParametersToLabels" Type="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJG4GLHIERLabels"/>\
</Association>\
<Association Name="assoc_4782569891A012A4D3F3B4E587E57712" sap:content-version="1">\
<End Multiplicity="1" Role="FromRole_assoc_4782569891A012A4D3F3B4E587E57712" Type="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType"/>\
<End Multiplicity="0..1" Role="ToRole_assoc_4782569891A012A4D3F3B4E587E57712" Type="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType"/>\
</Association>\
<Association Name="assoc_ECBAB52142C877BEDABDE3ABD9491FA6" sap:content-version="1">\
<End Multiplicity="1" Role="FromRole_assoc_ECBAB52142C877BEDABDE3ABD9491FA6" Type="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType"/>\
<End Multiplicity="0..1" Role="ToRole_assoc_ECBAB52142C877BEDABDE3ABD9491FA6" Type="ZTJ_SFIN_HIERARCHY_02_SRV.I_ChartOfAccountsType"/>\
<ReferentialConstraint>\
<Principal Role="ToRole_assoc_ECBAB52142C877BEDABDE3ABD9491FA6">\
<PropertyRef Name="ChartOfAccounts"/>\
</Principal>\
<Dependent Role="FromRole_assoc_ECBAB52142C877BEDABDE3ABD9491FA6">\
<PropertyRef Name="ChartOfAccounts"/>\
</Dependent>\
</ReferentialConstraint>\
</Association>\
<Association Name="assoc_000A78B51019E07B6DC9989DCC09F81D" sap:content-version="1">\
<End Multiplicity="1" Role="FromRole_assoc_000A78B51019E07B6DC9989DCC09F81D" Type="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType"/>\
<End Multiplicity="0..1" Role="ToRole_assoc_000A78B51019E07B6DC9989DCC09F81D" Type="ZTJ_SFIN_HIERARCHY_02_SRV.I_LanguageType"/>\
<ReferentialConstraint>\
<Principal Role="ToRole_assoc_000A78B51019E07B6DC9989DCC09F81D">\
<PropertyRef Name="Language"/>\
</Principal>\
<Dependent Role="FromRole_assoc_000A78B51019E07B6DC9989DCC09F81D">\
<PropertyRef Name="MaintenanceLanguage"/>\
</Dependent>\
</ReferentialConstraint>\
</Association>\
<Association Name="assoc_13A43A207F51A1B4207B9E03FEF38AD5" sap:content-version="1">\
<End Multiplicity="1" Role="FromRole_assoc_13A43A207F51A1B4207B9E03FEF38AD5" Type="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType"/>\
<End Multiplicity="*" Role="ToRole_assoc_13A43A207F51A1B4207B9E03FEF38AD5" Type="ZTJ_SFIN_HIERARCHY_02_SRV.I_FinancialStatementVersionTType"/>\
</Association>\
<Association Name="assoc_58EB9B168452ADF63C3BE45CDEE99844" sap:content-version="1">\
<End Multiplicity="1" Role="FromRole_assoc_58EB9B168452ADF63C3BE45CDEE99844" Type="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType"/>\
<End Multiplicity="0..1" Role="ToRole_assoc_58EB9B168452ADF63C3BE45CDEE99844" Type="ZTJ_SFIN_HIERARCHY_02_SRV.I_DraftAdministrativeDataType"/>\
</Association>\
<Association Name="assoc_CB9E73935418CD69ACAF70778A03FC0C" sap:content-version="1">\
<End Multiplicity="1" Role="FromRole_assoc_CB9E73935418CD69ACAF70778A03FC0C" Type="ZTJ_SFIN_HIERARCHY_02_SRV.Ztj_G4_HierarchyType"/>\
<End Multiplicity="0..1" Role="ToRole_assoc_CB9E73935418CD69ACAF70778A03FC0C" Type="ZTJ_SFIN_HIERARCHY_02_SRV.Ztj_G4_ChartofaccountsType"/>\
<ReferentialConstraint>\
<Principal Role="ToRole_assoc_CB9E73935418CD69ACAF70778A03FC0C">\
<PropertyRef Name="ChartOfAccounts"/>\
</Principal>\
<Dependent Role="FromRole_assoc_CB9E73935418CD69ACAF70778A03FC0C">\
<PropertyRef Name="ChartOfAccounts"/>\
</Dependent>\
</ReferentialConstraint>\
</Association>\
<Association Name="assoc_41C0A870D47E10A2558F6C3607AC0098" sap:content-version="1">\
<End Multiplicity="1" Role="FromRole_assoc_41C0A870D47E10A2558F6C3607AC0098" Type="ZTJ_SFIN_HIERARCHY_02_SRV.Ztj_G4_HierarchyType"/>\
<End Multiplicity="0..1" Role="ToRole_assoc_41C0A870D47E10A2558F6C3607AC0098" Type="ZTJ_SFIN_HIERARCHY_02_SRV.I_LanguageType"/>\
<ReferentialConstraint>\
<Principal Role="ToRole_assoc_41C0A870D47E10A2558F6C3607AC0098">\
<PropertyRef Name="Language"/>\
</Principal>\
<Dependent Role="FromRole_assoc_41C0A870D47E10A2558F6C3607AC0098">\
<PropertyRef Name="MaintenanceLanguage"/>\
</Dependent>\
</ReferentialConstraint>\
</Association>\
<Association Name="assoc_F58ADADA0E579745A4DFA3A419FA5A93" sap:content-version="1">\
<End Multiplicity="1" Role="FromRole_assoc_F58ADADA0E579745A4DFA3A419FA5A93" Type="ZTJ_SFIN_HIERARCHY_02_SRV.Ztj_G4_HierarchyType"/>\
<End Multiplicity="*" Role="ToRole_assoc_F58ADADA0E579745A4DFA3A419FA5A93" Type="ZTJ_SFIN_HIERARCHY_02_SRV.Ztj_G4_HierarchytType"/>\
</Association>\
<EntityContainer Name="ZTJ_SFIN_HIERARCHY_02_SRV_Entities" m:IsDefaultEntityContainer="true" sap:supported-formats="atom json xlsx">\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.ODataQueryAdditionalMetadata" Name="AdditionalMetadata" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult" Name="ZTJ_G4_C_GLHIERResults" sap:addressable="false" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJG4GLHIERLabels" Name="ZTJG4GLHIERLabels" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERParameters" Name="ZTJ_G4_C_GLHIER" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.P_CHARTOFACCOUNTS" Name="P_CHARTOFACCOUNTS" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.I_ChartOfAccountsType" Name="I_ChartOfAccounts" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.I_DraftAdministrativeDataType" Name="I_DraftAdministrativeData" sap:addressable="false" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:searchable="true" sap:updatable="false"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.I_FinancialStatementVersionTType" Name="I_FinancialStatementVersionT" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.I_LanguageType" Name="I_Language" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:searchable="true" sap:updatable="false"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType" Name="ZTJ_C_FSVHierarchyTP" sap:content-version="1" sap:searchable="true"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.Ztj_G4_ChartofaccountsType" Name="Ztj_G4_Chartofaccounts" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.Ztj_G4_HierarchyType" Name="Ztj_G4_Hierarchy" sap:content-version="1" sap:deletable="false" sap:searchable="true"/>\
<EntitySet EntityType="ZTJ_SFIN_HIERARCHY_02_SRV.Ztj_G4_HierarchytType" Name="Ztj_G4_Hierarchyt" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false"/>\
<AssociationSet Association="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJG4GLHIERParametersToResult" Name="ZTJG4GLHIERParametersToResult_AssocSet" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false">\
<End EntitySet="ZTJ_G4_C_GLHIER" Role="FromRole_ZTJG4GLHIERParametersToResult"/>\
<End EntitySet="ZTJ_G4_C_GLHIERResults" Role="ToRole_ZTJG4GLHIERParametersToResult"/>\
</AssociationSet>\
<AssociationSet Association="ZTJ_SFIN_HIERARCHY_02_SRV.P_CHARTOFACCOUNTSToListOfValues" Name="P_CHARTOFACCOUNTSToListOfValues_AssocSet" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false">\
<End EntitySet="P_CHARTOFACCOUNTS" Role="FromRole_P_CHARTOFACCOUNTSToListOfValues"/>\
<End EntitySet="ZTJ_G4_C_GLHIER" Role="ToRole_P_CHARTOFACCOUNTSToListOfValues"/>\
</AssociationSet>\
<AssociationSet Association="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJG4GLHIERParametersToLabels" Name="ZTJG4GLHIERParametersToLabels_AssocSet" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false">\
<End EntitySet="ZTJ_G4_C_GLHIER" Role="FromRole_ZTJG4GLHIERParametersToLabels"/>\
<End EntitySet="ZTJG4GLHIERLabels" Role="ToRole_ZTJG4GLHIERParametersToLabels"/>\
</AssociationSet>\
<AssociationSet Association="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_58EB9B168452ADF63C3BE45CDEE99844" Name="assoc_58EB9B168452ADF63C3BE45CDEE99844" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false">\
<End EntitySet="ZTJ_C_FSVHierarchyTP" Role="FromRole_assoc_58EB9B168452ADF63C3BE45CDEE99844"/>\
<End EntitySet="I_DraftAdministrativeData" Role="ToRole_assoc_58EB9B168452ADF63C3BE45CDEE99844"/>\
</AssociationSet>\
<AssociationSet Association="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_41C0A870D47E10A2558F6C3607AC0098" Name="assoc_41C0A870D47E10A2558F6C3607AC0098" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false">\
<End EntitySet="Ztj_G4_Hierarchy" Role="FromRole_assoc_41C0A870D47E10A2558F6C3607AC0098"/>\
<End EntitySet="I_Language" Role="ToRole_assoc_41C0A870D47E10A2558F6C3607AC0098"/>\
</AssociationSet>\
<AssociationSet Association="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_ECBAB52142C877BEDABDE3ABD9491FA6" Name="assoc_ECBAB52142C877BEDABDE3ABD9491FA6" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false">\
<End EntitySet="ZTJ_C_FSVHierarchyTP" Role="FromRole_assoc_ECBAB52142C877BEDABDE3ABD9491FA6"/>\
<End EntitySet="I_ChartOfAccounts" Role="ToRole_assoc_ECBAB52142C877BEDABDE3ABD9491FA6"/>\
</AssociationSet>\
<AssociationSet Association="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_F58ADADA0E579745A4DFA3A419FA5A93" Name="assoc_F58ADADA0E579745A4DFA3A419FA5A93" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false">\
<End EntitySet="Ztj_G4_Hierarchy" Role="FromRole_assoc_F58ADADA0E579745A4DFA3A419FA5A93"/>\
<End EntitySet="Ztj_G4_Hierarchyt" Role="ToRole_assoc_F58ADADA0E579745A4DFA3A419FA5A93"/>\
</AssociationSet>\
<AssociationSet Association="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_4782569891A012A4D3F3B4E587E57712" Name="assoc_4782569891A012A4D3F3B4E587E57712" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false">\
<End EntitySet="ZTJ_C_FSVHierarchyTP" Role="FromRole_assoc_4782569891A012A4D3F3B4E587E57712"/>\
<End EntitySet="ZTJ_C_FSVHierarchyTP" Role="ToRole_assoc_4782569891A012A4D3F3B4E587E57712"/>\
</AssociationSet>\
<AssociationSet Association="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_000A78B51019E07B6DC9989DCC09F81D" Name="assoc_000A78B51019E07B6DC9989DCC09F81D" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false">\
<End EntitySet="ZTJ_C_FSVHierarchyTP" Role="FromRole_assoc_000A78B51019E07B6DC9989DCC09F81D"/>\
<End EntitySet="I_Language" Role="ToRole_assoc_000A78B51019E07B6DC9989DCC09F81D"/>\
</AssociationSet>\
<AssociationSet Association="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_CB9E73935418CD69ACAF70778A03FC0C" Name="assoc_CB9E73935418CD69ACAF70778A03FC0C" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false">\
<End EntitySet="Ztj_G4_Hierarchy" Role="FromRole_assoc_CB9E73935418CD69ACAF70778A03FC0C"/>\
<End EntitySet="Ztj_G4_Chartofaccounts" Role="ToRole_assoc_CB9E73935418CD69ACAF70778A03FC0C"/>\
</AssociationSet>\
<AssociationSet Association="ZTJ_SFIN_HIERARCHY_02_SRV.assoc_13A43A207F51A1B4207B9E03FEF38AD5" Name="assoc_13A43A207F51A1B4207B9E03FEF38AD5" sap:content-version="1" sap:creatable="false" sap:deletable="false" sap:updatable="false">\
<End EntitySet="ZTJ_C_FSVHierarchyTP" Role="FromRole_assoc_13A43A207F51A1B4207B9E03FEF38AD5"/>\
<End EntitySet="I_FinancialStatementVersionT" Role="ToRole_assoc_13A43A207F51A1B4207B9E03FEF38AD5"/>\
</AssociationSet>\
<FunctionImport EntitySet="ZTJ_C_FSVHierarchyTP" Name="ZTJ_C_FSVHierarchyTPActivation" ReturnType="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType" m:HttpMethod="POST" sap:action-for="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType" sap:applicable-path="Activation_ac">\
<Parameter MaxLength="4" Mode="In" Name="FinancialStatementVariant" Type="Edm.String"/>\
<Parameter Mode="In" Name="DraftUUID" Type="Edm.Guid"/>\
<Parameter Mode="In" Name="IsActiveEntity" Type="Edm.Boolean"/>\
</FunctionImport>\
<FunctionImport EntitySet="ZTJ_C_FSVHierarchyTP" Name="ZTJ_C_FSVHierarchyTPEdit" ReturnType="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType" m:HttpMethod="POST" sap:action-for="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType" sap:applicable-path="Edit_ac">\
<Parameter MaxLength="4" Mode="In" Name="FinancialStatementVariant" Type="Edm.String"/>\
<Parameter Mode="In" Name="DraftUUID" Type="Edm.Guid"/>\
<Parameter Mode="In" Name="IsActiveEntity" Type="Edm.Boolean"/>\
<Parameter Mode="In" Name="PreserveChanges" Nullable="true" Type="Edm.Boolean"/>\
</FunctionImport>\
<FunctionImport EntitySet="ZTJ_C_FSVHierarchyTP" Name="ZTJ_C_FSVHierarchyTPPreparation" ReturnType="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType" m:HttpMethod="POST" sap:action-for="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType" sap:applicable-path="Preparation_ac">\
<Parameter MaxLength="4" Mode="In" Name="FinancialStatementVariant" Type="Edm.String"/>\
<Parameter Mode="In" Name="DraftUUID" Type="Edm.Guid"/>\
<Parameter Mode="In" Name="IsActiveEntity" Type="Edm.Boolean"/>\
<Parameter Mode="In" Name="SideEffectsQualifier" Nullable="true" Type="Edm.String"/>\
</FunctionImport>\
<FunctionImport Name="ZTJ_C_FSVHierarchyTPValidation" ReturnType="ZTJ_SFIN_HIERARCHY_02_SRV.ValidationFunctionResult" m:HttpMethod="GET" sap:action-for="ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_C_FSVHierarchyTPType" sap:applicable-path="Validation_ac">\
<Parameter MaxLength="4" Mode="In" Name="FinancialStatementVariant" Type="Edm.String"/>\
<Parameter Mode="In" Name="DraftUUID" Type="Edm.Guid"/>\
<Parameter Mode="In" Name="IsActiveEntity" Type="Edm.Boolean"/>\
<Parameter Mode="In" Name="SideEffectsQualifier" Nullable="true" Type="Edm.String"/>\
</FunctionImport>\
</EntityContainer>\
<Annotations Target="ZTJ_G4_C_GLHIER_CDS.ZTJ_G4_C_GLHIERParameters/P_CHARTOFACCOUNTS" xmlns="http://docs.oasis-open.org/odata/ns/edm">\
<Annotation Term="Common.ValueList">\
<Record>\
<PropertyValue Property="Label" String="Chart of Accounts"/>\
<PropertyValue Property="CollectionPath" String="P_CHARTOFACCOUNTS"/>\
<PropertyValue Bool="false" Property="SearchSupported"/>\
<PropertyValue Property="Parameters">\
<Collection>\
<Record Type="Common.ValueListParameterInOut">\
<PropertyValue Property="LocalDataProperty" PropertyPath="P_CHARTOFACCOUNTS"/>\
<PropertyValue Property="ValueListProperty" String="P_CHARTOFACCOUNTS_ID"/>\
</Record>\
<Record Type="Common.ValueListParameterDisplayOnly">\
<PropertyValue Property="ValueListProperty" String="P_CHARTOFACCOUNTS_TEXT"/>\
</Record>\
</Collection>\
</PropertyValue>\
</Record>\
</Annotation>\
</Annotations>\
<Annotations Target="ZTJ_G4_C_GLHIER_CDS.ZTJ_G4_C_GLHIERResult/GLAccount_NodeID" xmlns="http://docs.oasis-open.org/odata/ns/edm">\
<Annotation Term="Common.ValueList">\
<Record>\
<PropertyValue Property="Label" String="G/L Account (Node)"/>\
<PropertyValue Property="CollectionPath" String="GLAccount_NodeID"/>\
<PropertyValue Bool="false" Property="SearchSupported"/>\
<PropertyValue Property="Parameters">\
<Collection>\
<Record Type="Common.ValueListParameterInOut">\
<PropertyValue Property="LocalDataProperty" PropertyPath="GLAccount_NodeID"/>\
<PropertyValue Property="ValueListProperty" String="GLAccount_NodeID"/>\
</Record>\
<Record Type="Common.ValueListParameterDisplayOnly">\
<PropertyValue Property="ValueListProperty" String="GLAccount_NodeIDText"/>\
</Record>\
</Collection>\
</PropertyValue>\
</Record>\
</Annotation>\
</Annotations>\
<Annotations Target="ZTJ_SFIN_HIERARCHY_05_SRV.Ztj_G4_HierarchyType/FinancialStatementVariant" xmlns="http://docs.oasis-open.org/odata/ns/edm">\
<Annotation EnumMember="Common.FieldControlType/Mandatory" Term="Common.FieldControl"/>\
</Annotations>\
<Annotations Target="ZTJ_SFIN_HIERARCHY_05_SRV.Ztj_G4_HierarchyType/ChartOfAccounts" xmlns="http://docs.oasis-open.org/odata/ns/edm">\
<Annotation EnumMember="Common.FieldControlType/Mandatory" Term="Common.FieldControl"/>\
<Annotation Term="Common.ValueList">\
<Record>\
<PropertyValue Property="Label" String="Chart Of Accounts"/>\
<PropertyValue Property="CollectionPath" String="Ztj_G4_Chartofaccounts"/>\
<PropertyValue Bool="false" Property="SearchSupported"/>\
<PropertyValue Property="Parameters">\
<Collection>\
<Record Type="Common.ValueListParameterInOut">\
<PropertyValue Property="LocalDataProperty" PropertyPath="ChartOfAccounts"/>\
<PropertyValue Property="ValueListProperty" String="ChartOfAccounts"/>\
</Record>\
<Record Type="Common.ValueListParameterDisplayOnly">\
<PropertyValue Property="ValueListProperty" String="ChartOfAccounts_Text"/>\
</Record>\
<Record Type="Common.ValueListParameterDisplayOnly">\
<PropertyValue Property="ValueListProperty" String="CorporateGroupChartOfAccounts"/>\
</Record>\
<Record Type="Common.ValueListParameterDisplayOnly">\
<PropertyValue Property="ValueListProperty" String="ChartOfAcctsIsBlocked"/>\
</Record>\
<Record Type="Common.ValueListParameterDisplayOnly">\
<PropertyValue Property="ValueListProperty" String="MaintenanceLanguage"/>\
</Record>\
</Collection>\
</PropertyValue>\
</Record>\
</Annotation>\
</Annotations>\
<Annotations Target="ZTJ_SFIN_HIERARCHY_05_SRV.Ztj_G4_HierarchyType/MaintenanceLanguage" xmlns="http://docs.oasis-open.org/odata/ns/edm">\
<Annotation EnumMember="Common.FieldControlType/Mandatory" Term="Common.FieldControl"/>\
<Annotation Term="Common.ValueList">\
<Record>\
<PropertyValue Property="Label" String="Language"/>\
<PropertyValue Property="CollectionPath" String="I_Language"/>\
<PropertyValue Bool="true" Property="SearchSupported"/>\
<PropertyValue Property="Parameters">\
<Collection>\
<Record Type="Common.ValueListParameterInOut">\
<PropertyValue Property="LocalDataProperty" PropertyPath="MaintenanceLanguage"/>\
<PropertyValue Property="ValueListProperty" String="Language"/>\
</Record>\
<Record Type="Common.ValueListParameterDisplayOnly">\
<PropertyValue Property="ValueListProperty" String="Language_Text"/>\
</Record>\
<Record Type="Common.ValueListParameterDisplayOnly">\
<PropertyValue Property="ValueListProperty" String="LanguageISOCode"/>\
</Record>\
</Collection>\
</PropertyValue>\
</Record>\
</Annotation>\
</Annotations>\
<Annotations Target="ZTJ_SFIN_HIERARCHY_05_SRV.ZTJ_SFIN_HIERARCHY_05_SRV_Entities/ZTJ_C_FSVHierarchyTP" xmlns="http://docs.oasis-open.org/odata/ns/edm">\
<Annotation Term="Common.DraftRoot">\
<Record>\
<PropertyValue Property="ActivationAction" String="ZTJ_SFIN_HIERARCHY_05_SRV.ZTJ_SFIN_HIERARCHY_05_SRV_Entities/ZTJ_C_FSVHierarchyTPActivation"/>\
<PropertyValue Property="EditAction" String="ZTJ_SFIN_HIERARCHY_05_SRV.ZTJ_SFIN_HIERARCHY_05_SRV_Entities/ZTJ_C_FSVHierarchyTPEdit"/>\
<PropertyValue Property="PreparationAction" String="ZTJ_SFIN_HIERARCHY_05_SRV.ZTJ_SFIN_HIERARCHY_05_SRV_Entities/ZTJ_C_FSVHierarchyTPPreparation"/>\
<PropertyValue Property="ValidationFunction" String="ZTJ_SFIN_HIERARCHY_05_SRV.ZTJ_SFIN_HIERARCHY_05_SRV_Entities/ZTJ_C_FSVHierarchyTPValidation"/>\
</Record>\
</Annotation>\
</Annotations>\
<Annotations Target="ZTJ_SFIN_HIERARCHY_05_SRV.ZTJ_C_FSVHierarchyTPType/ChartOfAccounts" xmlns="http://docs.oasis-open.org/odata/ns/edm">\
<Annotation Term="Common.ValueList">\
<Record>\
<PropertyValue Property="Label" String="Chart Of Accounts"/>\
<PropertyValue Property="CollectionPath" String="I_ChartOfAccounts"/>\
<PropertyValue Bool="false" Property="SearchSupported"/>\
<PropertyValue Property="Parameters">\
<Collection>\
<Record Type="Common.ValueListParameterInOut">\
<PropertyValue Property="LocalDataProperty" PropertyPath="ChartOfAccounts"/>\
<PropertyValue Property="ValueListProperty" String="ChartOfAccounts"/>\
</Record>\
<Record Type="Common.ValueListParameterDisplayOnly">\
<PropertyValue Property="ValueListProperty" String="ChartOfAccounts_Text"/>\
</Record>\
</Collection>\
</PropertyValue>\
</Record>\
</Annotation>\
</Annotations>\
<Annotations Target="ZTJ_SFIN_HIERARCHY_05_SRV.ZTJ_C_FSVHierarchyTPType/HierarchyVariantForEdit" xmlns="http://docs.oasis-open.org/odata/ns/edm">\
<Annotation Term="Common.ValueList">\
<Record>\
<PropertyValue Property="Label" String="Financial Statement Version Text"/>\
<PropertyValue Property="CollectionPath" String="I_FinancialStatementVersionT"/>\
<PropertyValue Bool="false" Property="SearchSupported"/>\
<PropertyValue Property="Parameters">\
<Collection>\
<Record Type="Common.ValueListParameterInOut">\
<PropertyValue Property="LocalDataProperty" PropertyPath="HierarchyVariantForEdit"/>\
<PropertyValue Property="ValueListProperty" String="FinancialStatementVariant"/>\
</Record>\
<Record Type="Common.ValueListParameterDisplayOnly">\
<PropertyValue Property="ValueListProperty" String="FinancialStatementVariantName"/>\
</Record>\
</Collection>\
</PropertyValue>\
</Record>\
</Annotation>\
</Annotations>\
<Annotations Target="ZTJ_SFIN_HIERARCHY_05_SRV.ZTJ_C_FSVHierarchyTPType/MaintenanceLanguage" xmlns="http://docs.oasis-open.org/odata/ns/edm">\
<Annotation Term="Common.ValueList">\
<Record>\
<PropertyValue Property="Label" String="Language"/>\
<PropertyValue Property="CollectionPath" String="I_Language"/>\
<PropertyValue Bool="true" Property="SearchSupported"/>\
<PropertyValue Property="Parameters">\
<Collection>\
<Record Type="Common.ValueListParameterInOut">\
<PropertyValue Property="LocalDataProperty" PropertyPath="MaintenanceLanguage"/>\
<PropertyValue Property="ValueListProperty" String="Language"/>\
</Record>\
<Record Type="Common.ValueListParameterDisplayOnly">\
<PropertyValue Property="ValueListProperty" String="Language_Text"/>\
</Record>\
</Collection>\
</PropertyValue>\
</Record>\
</Annotation>\
</Annotations>\
<Annotations Target="ZTJ_SFIN_HIERARCHY_05_SRV.ZTJ_C_FSVHierarchyTPType" xmlns="http://docs.oasis-open.org/odata/ns/edm">\
<Annotation Term="Common.SemanticKey">\
<Collection>\
<PropertyPath>FinancialStatementVariant</PropertyPath>\
</Collection>\
</Annotation>\
</Annotations>\
<atom:link href="https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/$metadata" rel="self" xmlns:atom="http://www.w3.org/2005/Atom"/>\
<atom:link href="https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/$metadata" rel="latest-version" xmlns:atom="http://www.w3.org/2005/Atom"/>\
</Schema>\
</edmx:DataServices>\
</edmx:Edmx>\
	';

	/* =============================================================
		Restore expansion state mock data
	*/

	var sResultsEmptyCollection = '{"d":{"__count":"0","results":[]}}';

	var sResultsL0Top120 = '{"d":{"__count":"7","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99991%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99991%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99991%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99991","GLAccount_NodeIDExt":"9999/1","GLAccount_NodeText":"Assets","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"14","counter_F":"14","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99991%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99992%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99992%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99992%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99992","GLAccount_NodeIDExt":"9999/2","GLAccount_NodeText":"Liabilities & Stockholders\' Equity","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"29","counter_F":"29","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99992%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99993%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993","GLAccount_NodeIDExt":"9999/3","GLAccount_NodeText":"Common","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"3","counter_F":"3","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99994%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994","GLAccount_NodeIDExt":"9999/4","GLAccount_NodeText":"Stock owner\'s equity","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"140","counter_F":"140","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99996%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99996%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99996%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996","GLAccount_NodeIDExt":"9999/6","GLAccount_NodeText":"Profit & Loss","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"139","counter_F":"139","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99996%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99997%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99997%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99997%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99997","GLAccount_NodeIDExt":"9999/7","GLAccount_NodeText":"Not assigned accounts","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99997%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99998%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99998%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99998%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99998","GLAccount_NodeIDExt":"9999/8","GLAccount_NodeText":"Financial St. Notes","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99998%2523%2523\')/Parameters"}}}]}}';

	var sResultsL0Parent0Top120 = '{"d":{"__count":"6","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999912%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999912%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999912%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999912","GLAccount_NodeIDExt":"9999/12","GLAccount_NodeText":"FM","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999912%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999915%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999915%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999915%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999915","GLAccount_NodeIDExt":"9999/15","GLAccount_NodeText":"Long-term investments","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"6","counter_F":"6","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999915%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999916%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999916%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999916%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999916","GLAccount_NodeIDExt":"9999/16","GLAccount_NodeText":"Fixed assets","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999916%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999917%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999917%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999917%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999917","GLAccount_NodeIDExt":"9999/17","GLAccount_NodeText":"Intangible assets","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"4","counter_F":"4","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999917%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999918%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999918%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999918%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999918","GLAccount_NodeIDExt":"9999/18","GLAccount_NodeText":"Long term deferred","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"2","counter_F":"2","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999918%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999919%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999919%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999919%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999919","GLAccount_NodeIDExt":"9999/19","GLAccount_NodeText":"Gain/loss fro handling assets","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"2","counter_F":"2","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999919%2523%2523\')/Parameters"}}}]}}';

	var sResultsL0Top7 = '{"d":{"results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99991%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99991%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99991%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99991","GLAccount_NodeIDExt":"9999/1","GLAccount_NodeText":"Assets","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"14","counter_F":"14","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99991%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99992%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99992%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99992%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99992","GLAccount_NodeIDExt":"9999/2","GLAccount_NodeText":"Liabilities & Stockholders\' Equity","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"29","counter_F":"29","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99992%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99993%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993","GLAccount_NodeIDExt":"9999/3","GLAccount_NodeText":"Common","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"3","counter_F":"3","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99994%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994","GLAccount_NodeIDExt":"9999/4","GLAccount_NodeText":"Stock owner\'s equity","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"140","counter_F":"140","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99996%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99996%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99996%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996","GLAccount_NodeIDExt":"9999/6","GLAccount_NodeText":"Profit & Loss","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"139","counter_F":"139","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99996%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99997%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99997%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99997%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99997","GLAccount_NodeIDExt":"9999/7","GLAccount_NodeText":"Not assigned accounts","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99997%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99998%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99998%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99998%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99998","GLAccount_NodeIDExt":"9999/8","GLAccount_NodeText":"Financial St. Notes","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99998%2523%2523\')/Parameters"}}}]}}';

	var sResultsL0Parent0Top6 = sResultsL0Parent0Top120;

	var sResultsL1Parent0Top120 = '{"d":{"__count":"1","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeIDExt":"Y/0","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:999912","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"}]}}';

	var sResultsL1Parent0Top1 = sResultsL1Parent0Top120;

	var sResultsL1Top120 = '{"d":{"__count":"29","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99991%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99991%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99991%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99991","GLAccount_NodeIDExt":"9999/1","GLAccount_NodeText":"Assets","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"14","counter_F":"14","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99991%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999912%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999912%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999912%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999912","GLAccount_NodeIDExt":"9999/12","GLAccount_NodeText":"FM","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999912%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999915%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999915%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999915%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999915","GLAccount_NodeIDExt":"9999/15","GLAccount_NodeText":"Long-term investments","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"6","counter_F":"6","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999915%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999916%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999916%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999916%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999916","GLAccount_NodeIDExt":"9999/16","GLAccount_NodeText":"Fixed assets","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999916%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999917%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999917%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999917%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999917","GLAccount_NodeIDExt":"9999/17","GLAccount_NodeText":"Intangible assets","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"4","counter_F":"4","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999917%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999918%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999918%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999918%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999918","GLAccount_NodeIDExt":"9999/18","GLAccount_NodeText":"Long term deferred","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"2","counter_F":"2","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999918%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999919%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999919%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999919%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999919","GLAccount_NodeIDExt":"9999/19","GLAccount_NodeText":"Gain/loss fro handling assets","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"2","counter_F":"2","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999919%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99992%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99992%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99992%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99992","GLAccount_NodeIDExt":"9999/2","GLAccount_NodeText":"Liabilities & Stockholders\' Equity","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"29","counter_F":"29","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99992%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999922%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999922%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999922%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999922","GLAccount_NodeIDExt":"9999/22","GLAccount_NodeText":"Liabilities","GLAccount_ParentID":"FinancialStatementItem:99992","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"29","counter_F":"29","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999922%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99993%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993","GLAccount_NodeIDExt":"9999/3","GLAccount_NodeText":"Common","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"3","counter_F":"3","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993101%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993101%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99993101%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993101","GLAccount_NodeIDExt":"9999/3101","GLAccount_NodeText":"Derivative financial tools","GLAccount_ParentID":"FinancialStatementItem:99993","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993101%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993201%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993201%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99993201%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993201","GLAccount_NodeIDExt":"9999/3201","GLAccount_NodeText":"Hedging financial tools","GLAccount_ParentID":"FinancialStatementItem:99993","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993201%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993202%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993202%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99993202%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993202","GLAccount_NodeIDExt":"9999/3202","GLAccount_NodeText":"Hedged items","GLAccount_ParentID":"FinancialStatementItem:99993","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99993202%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99994%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994","GLAccount_NodeIDExt":"9999/4","GLAccount_NodeText":"Stock owner\'s equity","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"140","counter_F":"140","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994001%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994001%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99994001%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994001","GLAccount_NodeIDExt":"9999/4001","GLAccount_NodeText":"Pain-in capital","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"3","counter_F":"3","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994001%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994002%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994002%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99994002%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994002","GLAccount_NodeIDExt":"9999/4002","GLAccount_NodeText":"Capital surplus","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994002%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994101%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994101%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99994101%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994101","GLAccount_NodeIDExt":"9999/4101","GLAccount_NodeText":"Legal sruplus","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"93","counter_F":"93","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994101%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994103%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994103%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99994103%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994103","GLAccount_NodeIDExt":"9999/4103","GLAccount_NodeText":"test","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"11","counter_F":"11","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994103%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994104%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994104%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99994104%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994104","GLAccount_NodeIDExt":"9999/4104","GLAccount_NodeText":"Approprited retained earnings","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"30","counter_F":"30","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994104%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994201%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994201%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99994201%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994201","GLAccount_NodeIDExt":"9999/4201","GLAccount_NodeText":"Stock shares inventory","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.14.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99994201%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.15.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999941031%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.15.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999941031%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.15.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999941031%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999941031","GLAccount_NodeIDExt":"9999/41031","GLAccount_NodeText":"Current year profit - calculated, checki","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.15.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999941031%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.15.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999941032%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.15.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999941032%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.15.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999941032%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999941032","GLAccount_NodeIDExt":"9999/41032","GLAccount_NodeText":"Current year loss - calculated, checking","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.15.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999941032%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99996%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99996%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99996%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996","GLAccount_NodeIDExt":"9999/6","GLAccount_NodeText":"Profit & Loss","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"141","counter_F":"141","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99996%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999961%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999961%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999961%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961","GLAccount_NodeIDExt":"9999/61","GLAccount_NodeText":"Net income","GLAccount_ParentID":"FinancialStatementItem:99996","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"141","counter_F":"141","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999961%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999949%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999949%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372:999949%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999949","GLAccount_NodeIDExt":"9999/49","GLAccount_NodeText":"Net income","GLAccount_ParentID":"FinancialStatementItem:99996","GLAccount_Level":1,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.12.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A999949%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99997%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99997%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99997%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99997","GLAccount_NodeIDExt":"9999/7","GLAccount_NodeText":"Not assigned accounts","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99997%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.16.1.1.X.1.1_IEQCACNIEQ9999CACN%3ACACNY0000000000%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.16.1.1.X.1.1_IEQCACNIEQ9999CACN%3ACACNY0000000000%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.16.1.1.X.1.1_IEQCACNIEQ9999CACN:CACNY0000000000%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeIDExt":"Y/0","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:99997","GLAccount_Level":1,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.16.1.1.X.1.1_IEQCACNIEQ9999CACN%3ACACNY0000000000%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99998%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99998%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372:99998%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99998","GLAccount_NodeIDExt":"9999/8","GLAccount_NodeText":"Financial St. Notes","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":0,"GLAccount_T":"","Action":"","NodeType":"","counter":"1","counter_F":"1","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.11.1.1.X.1.1_IEQCACNIEQ9999CACN52372%3A99998%2523%2523\')/Parameters"}}},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.16.1.1.X.1.1_IEQCACNIEQ9999CACN%3ACACNY0000000000%2523%2523\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.16.1.1.X.1.1_IEQCACNIEQ9999CACN%3ACACNY0000000000%2523%2523\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"1.2.4.0.1.2.4.0:4.16.1.1.X.1.1_IEQCACNIEQ9999CACN:CACNY0000000000%23%23","TotaledProperties":"","ChartOfAccounts":"CACN","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeIDExt":"Y/0","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:99998","GLAccount_Level":1,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A4.16.1.1.X.1.1_IEQCACNIEQ9999CACN%3ACACNY0000000000%2523%2523\')/Parameters"}}}]}}';

	var sResultsL1Top29 = sResultsL1Top120;

	// for expansion state after delete operation
	// The result contains 120 items
	var sResultsL4Top120 = '{"d":{"__count":"370","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99991\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99991\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99991","GLAccount_NodeText":"Assets","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":13,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99991"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999917\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999917\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999917","GLAccount_NodeText":"Intangible assets","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999917"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991711\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991711\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99991711","GLAccount_NodeText":"Goodwill","GLAccount_ParentID":"FinancialStatementItem:999917","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99991711"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1711%20%20%20%20%20%2099990000060017110000-0017119999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1711%20%20%20%20%20%2099990000060017110000-0017119999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:1711      99990000060017110000-0017119999","GLAccount_NodeText":"0017110000-0017119999","GLAccount_ParentID":"FinancialStatementItem:99991711","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:1711      99990000060017110000-0017119999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200017110000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200017110000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"17110000","GLAccount_NodeID":":CACN 0017110000","GLAccount_NodeText":"Goodwill","GLAccount_ParentID":"RangeNode:1711      99990000060017110000-0017119999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Goodwill","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0017110000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999918\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999918\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999918","GLAccount_NodeText":"Long term deferred","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999918"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991811\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991811\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99991811","GLAccount_NodeText":"Deferred tax","GLAccount_ParentID":"FinancialStatementItem:999918","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99991811"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1811%20%20%20%20%20%2099990000100018110000-0018119999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1811%20%20%20%20%20%2099990000100018110000-0018119999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:1811      99990000100018110000-0018119999","GLAccount_NodeText":"0018110000-0018119999","GLAccount_ParentID":"FinancialStatementItem:99991811","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:1811      99990000100018110000-0018119999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200018110000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200018110000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"18110000","GLAccount_NodeID":":CACN 0018110000","GLAccount_NodeText":"Deferred tax assets","GLAccount_ParentID":"RangeNode:1811      99990000100018110000-0018119999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Deferred tax assets","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0018110000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999919\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999919\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999919","GLAccount_NodeText":"Gain/loss fro handling assets","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999919"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991901\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991901\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99991901","GLAccount_NodeText":"Gain/loss fro handling assets","GLAccount_ParentID":"FinancialStatementItem:999919","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99991901"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1901%20%20%20%20%20%2099990000140019010000-0019019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1901%20%20%20%20%20%2099990000140019010000-0019019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:1901      99990000140019010000-0019019999","GLAccount_NodeText":"0019010000-0019019999","GLAccount_ParentID":"FinancialStatementItem:99991901","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:1901      99990000140019010000-0019019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200019010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200019010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"19010000","GLAccount_NodeID":":CACN 0019010000","GLAccount_NodeText":"Gain/loss for handli","GLAccount_ParentID":"RangeNode:1901      99990000140019010000-0019019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Gain/loss for handli","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0019010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200019010003\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200019010003\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"19010003","GLAccount_NodeID":":CACN 0019010003","GLAccount_NodeText":"Gain/loss 3","GLAccount_ParentID":"RangeNode:1901      99990000140019010000-0019019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Gain/loss 3","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0019010003"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99992\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99992\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99992","GLAccount_NodeText":"Liabilities & Stockholders\' Equity","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":37,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99992"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999922\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999922\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999922","GLAccount_NodeText":"Liabilities","GLAccount_ParentID":"FinancialStatementItem:99992","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":36,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999922"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992221\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992221\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99992221","GLAccount_NodeText":"Current liabilities","GLAccount_ParentID":"FinancialStatementItem:999922","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":19,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99992221"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222103\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222103\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222103","GLAccount_NodeText":"Financial liabilities for deal","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222103"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222103%20%20%20%2099990000210021010000-0021019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222103%20%20%20%2099990000210021010000-0021019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222103    99990000210021010000-0021019999","GLAccount_NodeText":"0021010000-0021019999","GLAccount_ParentID":"FinancialStatementItem:9999222103","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222103    99990000210021010000-0021019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222111\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222111\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222111","GLAccount_NodeText":"Notes payable","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222111"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222111%20%20%20%2099990000240022010000-0022019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222111%20%20%20%2099990000240022010000-0022019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222111    99990000240022010000-0022019999","GLAccount_NodeText":"0022010000-0022019999","GLAccount_ParentID":"FinancialStatementItem:9999222111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222111    99990000240022010000-0022019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222121\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222121\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222121","GLAccount_NodeText":"Accounts payable","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222121"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222121%20%20%20%2099990000270022020000-0022029999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222121%20%20%20%2099990000270022020000-0022029999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222121    99990000270022020000-0022029999","GLAccount_NodeText":"0022020000-0022029999","GLAccount_ParentID":"FinancialStatementItem:9999222121","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222121    99990000270022020000-0022029999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222122\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222122\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222122","GLAccount_NodeText":"Interest payable","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222122"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222122%20%20%20%2099990000320022310000-0022319999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222122%20%20%20%2099990000320022310000-0022319999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222122    99990000320022310000-0022319999","GLAccount_NodeText":"0022310000-0022319999","GLAccount_ParentID":"FinancialStatementItem:9999222122","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222122    99990000320022310000-0022319999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222141\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222141\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222141","GLAccount_NodeText":"Taxes payable","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222141"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222141%20%20%20%2099990000350022210000-0022219999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222141%20%20%20%2099990000350022210000-0022219999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222141    99990000350022210000-0022219999","GLAccount_NodeText":"0022210000-0022219999","GLAccount_ParentID":"FinancialStatementItem:9999222141","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222141    99990000350022210000-0022219999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222151\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222151\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222151","GLAccount_NodeText":"Dividends payable","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222151"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222151%20%20%20%2099990000400022320000-0022329999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222151%20%20%20%2099990000400022320000-0022329999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222151    99990000400022320000-0022329999","GLAccount_NodeText":"0022320000-0022329999","GLAccount_ParentID":"FinancialStatementItem:9999222151","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222151    99990000400022320000-0022329999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222161\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222161\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222161","GLAccount_NodeText":"Advances from customers","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222161"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222161%20%20%20%2099990000430022030000-0022039999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222161%20%20%20%2099990000430022030000-0022039999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222161    99990000430022030000-0022039999","GLAccount_NodeText":"0022030000-0022039999","GLAccount_ParentID":"FinancialStatementItem:9999222161","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222161    99990000430022030000-0022039999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222171\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222171\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222171","GLAccount_NodeText":"Other payables","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222171"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222171%20%20%20%2099990000480022410000-0022419999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222171%20%20%20%2099990000480022410000-0022419999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222171    99990000480022410000-0022419999","GLAccount_NodeText":"0022410000-0022419999","GLAccount_ParentID":"FinancialStatementItem:9999222171","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222171    99990000480022410000-0022419999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222199\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222199\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222199","GLAccount_NodeText":"Other current liabilities","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222199"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222199%20%20%20%2099990000510023140000-0023149999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222199%20%20%20%2099990000510023140000-0023149999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222199    99990000510023140000-0023149999","GLAccount_NodeText":"0023140000-0023149999","GLAccount_ParentID":"FinancialStatementItem:9999222199","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222199    99990000510023140000-0023149999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222199%20%20%20%2099990000510024010000-0024019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222199%20%20%20%2099990000510024010000-0024019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222199    99990000510024010000-0024019999","GLAccount_NodeText":"0024010000-0024019999","GLAccount_ParentID":"FinancialStatementItem:9999222199","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222199    99990000510024010000-0024019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992222\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992222\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99992222","GLAccount_NodeText":"Long-term liabilities","GLAccount_ParentID":"FinancialStatementItem:999922","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":10,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99992222"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222201","GLAccount_NodeText":"Long-term loans","GLAccount_ParentID":"FinancialStatementItem:99992222","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222201"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222201%20%20%20%2099990000570025010000-0025019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222201%20%20%20%2099990000570025010000-0025019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222201    99990000570025010000-0025019999","GLAccount_NodeText":"0025010000-0025019999","GLAccount_ParentID":"FinancialStatementItem:9999222201","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222201    99990000570025010000-0025019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222211\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222211\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222211","GLAccount_NodeText":"Long-term Bonds","GLAccount_ParentID":"FinancialStatementItem:99992222","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222211"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222211%20%20%20%2099990000620025020000-0025029999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222211%20%20%20%2099990000620025020000-0025029999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222211    99990000620025020000-0025029999","GLAccount_NodeText":"0025020000-0025029999","GLAccount_ParentID":"FinancialStatementItem:9999222211","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222211    99990000620025020000-0025029999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222212\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222212\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222212","GLAccount_NodeText":"Discount on debentures payable","GLAccount_ParentID":"FinancialStatementItem:99992222","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222212"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:9999222212","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222221\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222221\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222221","GLAccount_NodeText":"Payables due after one year","GLAccount_ParentID":"FinancialStatementItem:99992222","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222221"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027010000-0027019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027010000-0027019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222221    99990000660027010000-0027019999","GLAccount_NodeText":"0027010000-0027019999","GLAccount_ParentID":"FinancialStatementItem:9999222221","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222221    99990000660027010000-0027019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027020000-0027029999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027020000-0027029999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222221    99990000660027020000-0027029999","GLAccount_NodeText":"0027020000-0027029999","GLAccount_ParentID":"FinancialStatementItem:9999222221","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222221    99990000660027020000-0027029999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027110000-0027119999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027110000-0027119999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222221    99990000660027110000-0027119999","GLAccount_NodeText":"0027110000-0027119999","GLAccount_ParentID":"FinancialStatementItem:9999222221","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222221    99990000660027110000-0027119999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992223\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992223\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99992223","GLAccount_NodeText":"Other liabilities","GLAccount_ParentID":"FinancialStatementItem:999922","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99992223"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222301\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222301\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222301","GLAccount_NodeText":"Other liabilities","GLAccount_ParentID":"FinancialStatementItem:99992223","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222301"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222301%20%20%20%2099990000740028010000-0028019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222301%20%20%20%2099990000740028010000-0028019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222301    99990000740028010000-0028019999","GLAccount_NodeText":"0028010000-0028019999","GLAccount_ParentID":"FinancialStatementItem:9999222301","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222301    99990000740028010000-0028019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222321\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222321\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222321","GLAccount_NodeText":"Deferred taxes payable","GLAccount_ParentID":"FinancialStatementItem:99992223","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222321"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222321%20%20%20%2099990000770029010000-0029019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222321%20%20%20%2099990000770029010000-0029019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222321    99990000770029010000-0029019999","GLAccount_NodeText":"0029010000-0029019999","GLAccount_ParentID":"FinancialStatementItem:9999222321","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222321    99990000770029010000-0029019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99993\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99993\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993","GLAccount_NodeText":"Common","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":9,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99993"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99993101\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99993101\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993101","GLAccount_NodeText":"Derivative financial tools","GLAccount_ParentID":"FinancialStatementItem:99993","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99993101"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A3101%20%20%20%20%20%2099990000810031010000-0031019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A3101%20%20%20%20%20%2099990000810031010000-0031019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:3101      99990000810031010000-0031019999","GLAccount_NodeText":"0031010000-0031019999","GLAccount_ParentID":"FinancialStatementItem:99993101","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:3101      99990000810031010000-0031019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200031010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200031010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"31010000","GLAccount_NodeID":":CACN 0031010000","GLAccount_NodeText":"Derivative financial","GLAccount_ParentID":"RangeNode:3101      99990000810031010000-0031019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Derivative financial","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0031010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99993201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99993201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993201","GLAccount_NodeText":"Hedging financial tools","GLAccount_ParentID":"FinancialStatementItem:99993","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99993201"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A3201%20%20%20%20%20%2099990000840032010000-0032019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A3201%20%20%20%20%20%2099990000840032010000-0032019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:3201      99990000840032010000-0032019999","GLAccount_NodeText":"0032010000-0032019999","GLAccount_ParentID":"FinancialStatementItem:99993201","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:3201      99990000840032010000-0032019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200032010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200032010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"32010000","GLAccount_NodeID":":CACN 0032010000","GLAccount_NodeText":"Hedging financial","GLAccount_ParentID":"RangeNode:3201      99990000840032010000-0032019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Hedging financial","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0032010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99993202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99993202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993202","GLAccount_NodeText":"Hedged items","GLAccount_ParentID":"FinancialStatementItem:99993","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99993202"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A3202%20%20%20%20%20%2099990000870032020000-0032029999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A3202%20%20%20%20%20%2099990000870032020000-0032029999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:3202      99990000870032020000-0032029999","GLAccount_NodeText":"0032020000-0032029999","GLAccount_ParentID":"FinancialStatementItem:99993202","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:3202      99990000870032020000-0032029999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200032020000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200032020000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"32020000","GLAccount_NodeID":":CACN 0032020000","GLAccount_NodeText":"Hedged items","GLAccount_ParentID":"RangeNode:3202      99990000870032020000-0032029999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Hedged items","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0032020000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99994\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99994\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994","GLAccount_NodeText":"Stock owner\'s equity","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":57,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99994"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994001","GLAccount_NodeText":"Pain-in capital","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":5,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4001%20%20%20%20%20%2099990000910009527124-0009527125\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4001%20%20%20%20%20%2099990000910009527124-0009527125\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4001      99990000910009527124-0009527125","GLAccount_NodeText":"0009527124-0009527125","GLAccount_ParentID":"FinancialStatementItem:99994001","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4001      99990000910009527124-0009527125"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200009527124\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200009527124\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"9527124","GLAccount_NodeID":":CACN 0009527124","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4001      99990000910009527124-0009527125","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0009527124"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200009527125\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200009527125\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"9527125","GLAccount_NodeID":":CACN 0009527125","GLAccount_NodeText":"tests","GLAccount_ParentID":"RangeNode:4001      99990000910009527124-0009527125","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"tests","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0009527125"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4001%20%20%20%20%20%2099990000910040010000-0040019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4001%20%20%20%20%20%2099990000910040010000-0040019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4001      99990000910040010000-0040019999","GLAccount_NodeText":"0040010000-0040019999","GLAccount_ParentID":"FinancialStatementItem:99994001","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4001      99990000910040010000-0040019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200040010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200040010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"40010000","GLAccount_NodeID":":CACN 0040010000","GLAccount_NodeText":"Paid-in capital","GLAccount_ParentID":"RangeNode:4001      99990000910040010000-0040019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Paid-in capital","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0040010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994002","GLAccount_NodeText":"Capital surplus","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4002%20%20%20%20%20%2099990000940040020000-0040029999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4002%20%20%20%20%20%2099990000940040020000-0040029999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4002      99990000940040020000-0040029999","GLAccount_NodeText":"0040020000-0040029999","GLAccount_ParentID":"FinancialStatementItem:99994002","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4002      99990000940040020000-0040029999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200040020000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200040020000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"40020000","GLAccount_NodeID":":CACN 0040020000","GLAccount_NodeText":"Capital surplus","GLAccount_ParentID":"RangeNode:4002      99990000940040020000-0040029999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Capital surplus","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0040020000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994101\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994101\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994101","GLAccount_NodeText":"Legal sruplus","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":47,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994101"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4101%20%20%20%20%20%2099990000970041010000-0041019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4101%20%20%20%20%20%2099990000970041010000-0041019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_NodeText":"0041010000-0041019999","GLAccount_ParentID":"FinancialStatementItem:99994101","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":46,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4101      99990000970041010000-0041019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010000","GLAccount_NodeID":":CACN 0041010000","GLAccount_NodeText":"Surplus","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Surplus","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010100\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010100\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010100","GLAccount_NodeID":":CACN 0041010100","GLAccount_NodeText":"Raw material","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Raw material","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010100"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010200\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010200\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010200","GLAccount_NodeID":":CACN 0041010200","GLAccount_NodeText":"Direct wages","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Direct wages","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010200"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010300\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010300\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010300","GLAccount_NodeID":":CACN 0041010300","GLAccount_NodeText":"OEM-Prod. - consumed","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"OEM-Prod. - consumed","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010300"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010400\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010400\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010400","GLAccount_NodeID":":CACN 0041010400","GLAccount_NodeText":"Pack. Mat- - consu.","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Pack. Mat- - consu.","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010400"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010401\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010401\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010401","GLAccount_NodeID":":CACN 0041010401","GLAccount_NodeText":"Pack. Mat- - consu.","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Pack. Mat- - consu.","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010401"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010402\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010402\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010402","GLAccount_NodeID":":CACN 0041010402","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010402"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010403\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010403\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010403","GLAccount_NodeID":":CACN 0041010403","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010403"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010404\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010404\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010404","GLAccount_NodeID":":CACN 0041010404","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010404"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010405\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010405\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010405","GLAccount_NodeID":":CACN 0041010405","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010405"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010406\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010406\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010406","GLAccount_NodeID":":CACN 0041010406","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010406"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010407\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010407\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010407","GLAccount_NodeID":":CACN 0041010407","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010407"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010408\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010408\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010408","GLAccount_NodeID":":CACN 0041010408","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010408"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010409\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010409\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010409","GLAccount_NodeID":":CACN 0041010409","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010409"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010410\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010410\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010410","GLAccount_NodeID":":CACN 0041010410","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010410"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010411\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010411\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010411","GLAccount_NodeID":":CACN 0041010411","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010411"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010412\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010412\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010412","GLAccount_NodeID":":CACN 0041010412","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010412"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010413\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010413\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010413","GLAccount_NodeID":":CACN 0041010413","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010413"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010414\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010414\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010414","GLAccount_NodeID":":CACN 0041010414","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010414"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010415\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010415\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010415","GLAccount_NodeID":":CACN 0041010415","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010415"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010416\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010416\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010416","GLAccount_NodeID":":CACN 0041010416","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010416"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010417\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010417\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010417","GLAccount_NodeID":":CACN 0041010417","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010417"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010418\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010418\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010418","GLAccount_NodeID":":CACN 0041010418","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010418"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010419\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010419\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010419","GLAccount_NodeID":":CACN 0041010419","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010419"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010420\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010420\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010420","GLAccount_NodeID":":CACN 0041010420","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010420"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010421\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010421\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010421","GLAccount_NodeID":":CACN 0041010421","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010421"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010422\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010422\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010422","GLAccount_NodeID":":CACN 0041010422","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010422"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010423\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010423\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010423","GLAccount_NodeID":":CACN 0041010423","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010423"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010424\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010424\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010424","GLAccount_NodeID":":CACN 0041010424","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010424"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010425\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010425\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010425","GLAccount_NodeID":":CACN 0041010425","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010425"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010426\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010426\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010426","GLAccount_NodeID":":CACN 0041010426","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010426"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010427\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010427\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010427","GLAccount_NodeID":":CACN 0041010427","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010427"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010428\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010428\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010428","GLAccount_NodeID":":CACN 0041010428","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010428"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010429\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010429\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010429","GLAccount_NodeID":":CACN 0041010429","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010429"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010430\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010430\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010430","GLAccount_NodeID":":CACN 0041010430","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010430"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010431\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010431\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010431","GLAccount_NodeID":":CACN 0041010431","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010431"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010432\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010432\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010432","GLAccount_NodeID":":CACN 0041010432","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010432"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010433\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010433\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010433","GLAccount_NodeID":":CACN 0041010433","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010433"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010434\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010434\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010434","GLAccount_NodeID":":CACN 0041010434","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010434"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010435\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010435\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010435","GLAccount_NodeID":":CACN 0041010435","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010435"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010436\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010436\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010436","GLAccount_NodeID":":CACN 0041010436","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010436"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010437\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010437\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010437","GLAccount_NodeID":":CACN 0041010437","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010437"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010438\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010438\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010438","GLAccount_NodeID":":CACN 0041010438","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010438"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010439\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010439\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010439","GLAccount_NodeID":":CACN 0041010439","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010439"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010440\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010440\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010440","GLAccount_NodeID":":CACN 0041010440","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010440"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010441\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010441\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010441","GLAccount_NodeID":":CACN 0041010441","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000970041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010441"}]}}';
	// The result contains 203 items
	var sResultsL4Skip167Top120 = '{"d":{"results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994103\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994103\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994103","GLAccount_NodeText":"test","GLAccount_ParentID":"","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":12,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994103"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4103%20%20%20%20%20%2099990001060041030000-0041030010\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4103%20%20%20%20%20%2099990001060041030000-0041030010\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_NodeText":"0041030000-0041030010","GLAccount_ParentID":"FinancialStatementItem:99994103","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":11,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4103      99990001060041030000-0041030010"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030000","GLAccount_NodeID":":CACN 0041030000","GLAccount_NodeText":"Current profit","GLAccount_ParentID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Current profit","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030001","GLAccount_NodeID":":CACN 0041030001","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030002","GLAccount_NodeID":":CACN 0041030002","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030003\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030003\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030003","GLAccount_NodeID":":CACN 0041030003","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030003"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030004\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030004\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030004","GLAccount_NodeID":":CACN 0041030004","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030004"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030005\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030005\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030005","GLAccount_NodeID":":CACN 0041030005","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030005"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030006\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030006\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030006","GLAccount_NodeID":":CACN 0041030006","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030006"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030007\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030007\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030007","GLAccount_NodeID":":CACN 0041030007","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030007"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030008\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030008\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030008","GLAccount_NodeID":":CACN 0041030008","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030008"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030009\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030009\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030009","GLAccount_NodeID":":CACN 0041030009","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030009"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030010\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030010\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030010","GLAccount_NodeID":":CACN 0041030010","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001060041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030010"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994104\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994104\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994104","GLAccount_NodeText":"Approprited retained earnings","GLAccount_ParentID":"","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":31,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994104"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4104%20%20%20%20%20%2099990001090041040000-0041049999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4104%20%20%20%20%20%2099990001090041040000-0041049999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_NodeText":"0041040000-0041049999","GLAccount_ParentID":"FinancialStatementItem:99994104","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":30,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4104      99990001090041040000-0041049999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040000","GLAccount_NodeID":":CACN 0041040000","GLAccount_NodeText":"Profit assignment","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Profit assignment","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040001","GLAccount_NodeID":":CACN 0041040001","GLAccount_NodeText":"tt","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"tt","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040002","GLAccount_NodeID":":CACN 0041040002","GLAccount_NodeText":"41040002","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"41040002","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040003\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040003\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040003","GLAccount_NodeID":":CACN 0041040003","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040003"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040004\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040004\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040004","GLAccount_NodeID":":CACN 0041040004","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040004"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040005\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040005\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040005","GLAccount_NodeID":":CACN 0041040005","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040005"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040006\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040006\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040006","GLAccount_NodeID":":CACN 0041040006","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040006"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040007\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040007\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040007","GLAccount_NodeID":":CACN 0041040007","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040007"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040008\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040008\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040008","GLAccount_NodeID":":CACN 0041040008","GLAccount_NodeText":"8","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"8","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040008"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040009\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040009\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040009","GLAccount_NodeID":":CACN 0041040009","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040009"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040010\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040010\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040010","GLAccount_NodeID":":CACN 0041040010","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040010"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040011\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040011\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040011","GLAccount_NodeID":":CACN 0041040011","GLAccount_NodeText":"Profit assign11","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Profit assign11","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040011"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040012\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040012\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040012","GLAccount_NodeID":":CACN 0041040012","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040012"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040013\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040013\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040013","GLAccount_NodeID":":CACN 0041040013","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040013"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040014\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040014\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040014","GLAccount_NodeID":":CACN 0041040014","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040014"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040015\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040015\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040015","GLAccount_NodeID":":CACN 0041040015","GLAccount_NodeText":"test15","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test15","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040015"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040016\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040016\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040016","GLAccount_NodeID":":CACN 0041040016","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040016"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040017\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040017\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040017","GLAccount_NodeID":":CACN 0041040017","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040017"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040022\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040022\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040022","GLAccount_NodeID":":CACN 0041040022","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040022"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040025\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040025\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040025","GLAccount_NodeID":":CACN 0041040025","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040025"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040044\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040044\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040044","GLAccount_NodeID":":CACN 0041040044","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040044"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040045\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040045\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040045","GLAccount_NodeID":":CACN 0041040045","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040045"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040046\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040046\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040046","GLAccount_NodeID":":CACN 0041040046","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040046"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040047\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040047\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040047","GLAccount_NodeID":":CACN 0041040047","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040047"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040048\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040048\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040048","GLAccount_NodeID":":CACN 0041040048","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040048"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040051\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040051\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040051","GLAccount_NodeID":":CACN 0041040051","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040051"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040077\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040077\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040077","GLAccount_NodeID":":CACN 0041040077","GLAccount_NodeText":"test changed by Alex","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test changed by Alex","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040077"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040086\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040086\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040086","GLAccount_NodeID":":CACN 0041040086","GLAccount_NodeText":"test86","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test86","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040086"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040087\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040087\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040087","GLAccount_NodeID":":CACN 0041040087","GLAccount_NodeText":"test87","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test87","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040087"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040099\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040099\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040099","GLAccount_NodeID":":CACN 0041040099","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001090041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040099"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994201","GLAccount_NodeText":"Stock shares inventory","GLAccount_ParentID":"","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994201"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4201%20%20%20%20%20%2099990001410042010000-0042019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4201%20%20%20%20%20%2099990001410042010000-0042019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4201      99990001410042010000-0042019999","GLAccount_NodeText":"0042010000-0042019999","GLAccount_ParentID":"FinancialStatementItem:99994201","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4201      99990001410042010000-0042019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200042010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200042010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"42010000","GLAccount_NodeID":":CACN 0042010000","GLAccount_NodeText":"Stock shares","GLAccount_ParentID":"RangeNode:4201      99990001410042010000-0042019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Stock shares","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0042010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999941031\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999941031\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999941031","GLAccount_NodeText":"Current year profit - calculated, checki","GLAccount_ParentID":"","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999941031"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:999941031","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999941032\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999941032\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999941032","GLAccount_NodeText":"Current year loss - calculated, checking","GLAccount_ParentID":"","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999941032"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:999941032","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99996\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99996\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996","GLAccount_NodeText":"Profit & Loss","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":146,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99996"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999961\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999961\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961","GLAccount_NodeText":"Net income","GLAccount_ParentID":"FinancialStatementItem:99996","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":143,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999961"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999611\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999611\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999611","GLAccount_NodeText":"Income before tax","GLAccount_ParentID":"FinancialStatementItem:999961","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":13,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.13.0.0_IEQCACNIEQ999952372:9999611"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996111\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996111\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996111","GLAccount_NodeText":"Operating income","GLAccount_ParentID":"FinancialStatementItem:9999611","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99996111"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961111\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961111\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961111","GLAccount_NodeText":"Operating Income","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961111"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961112\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961112\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961112","GLAccount_NodeText":"Business tax and other","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961112"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961113\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961113\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961113","GLAccount_NodeText":"Other operating income","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961113"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961114\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961114\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961114","GLAccount_NodeText":"Gain/loss for fair value","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961114"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961115\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961115\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961115","GLAccount_NodeText":"Gain/loss from investment","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961115"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961116\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961116\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961116","GLAccount_NodeText":"Operating expense","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961116"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.17.0.0_IEQCACNIEQ999952372%3A99996112%2F01\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.17.0.0_IEQCACNIEQ999952372%3A99996112%2F01\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996112/01","GLAccount_NodeText":"Non-operating revenue","GLAccount_ParentID":"FinancialStatementItem:9999611","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.17.0.0_IEQCACNIEQ999952372:99996112/01"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6112%2F01%20%20%2099990001930063010000-0063019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6112%2F01%20%20%2099990001930063010000-0063019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:6112/01   99990001930063010000-0063019999","GLAccount_NodeText":"0063010000-0063019999","GLAccount_ParentID":"FinancialStatementItem:99996112/01","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:6112/01   99990001930063010000-0063019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996113\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996113\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996113","GLAccount_NodeText":"Non-operating expense","GLAccount_ParentID":"FinancialStatementItem:9999611","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99996113"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6113%20%20%20%20%20%2099990001960067110000-0067119999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6113%20%20%20%20%20%2099990001960067110000-0067119999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:6113      99990001960067110000-0067119999","GLAccount_NodeText":"0067110000-0067119999","GLAccount_ParentID":"FinancialStatementItem:99996113","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:6113      99990001960067110000-0067119999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996114\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996114\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996114","GLAccount_NodeText":"Loss on revalue of assets","GLAccount_ParentID":"FinancialStatementItem:9999611","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99996114"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6114%20%20%20%20%20%2099990001990067010000-0067019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6114%20%20%20%20%20%2099990001990067010000-0067019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:6114      99990001990067010000-0067019999","GLAccount_NodeText":"0067010000-0067019999","GLAccount_ParentID":"FinancialStatementItem:99996114","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:6114      99990001990067010000-0067019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999612\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999612\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999612","GLAccount_NodeText":"Income tax expence","GLAccount_ParentID":"FinancialStatementItem:999961","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":125,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.13.0.0_IEQCACNIEQ999952372:9999612"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A612%20%20%20%20%20%20%2099990002020068010000-0068019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A612%20%20%20%20%20%20%2099990002020068010000-0068019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_NodeText":"0068010000-0068019999","GLAccount_ParentID":"FinancialStatementItem:9999612","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":124,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:612       99990002020068010000-0068019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010000","GLAccount_NodeID":":CACN 0068010000","GLAccount_NodeText":"Income tax","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Income tax","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010001","GLAccount_NodeID":":CACN 0068010001","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010002","GLAccount_NodeID":":CACN 0068010002","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010003\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010003\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010003","GLAccount_NodeID":":CACN 0068010003","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010003"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010004\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010004\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010004","GLAccount_NodeID":":CACN 0068010004","GLAccount_NodeText":"aa","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"aa","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010004"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010005\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010005\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010005","GLAccount_NodeID":":CACN 0068010005","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010005"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010006\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010006\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010006","GLAccount_NodeID":":CACN 0068010006","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010006"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010007\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010007\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010007","GLAccount_NodeID":":CACN 0068010007","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010007"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010008\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010008\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010008","GLAccount_NodeID":":CACN 0068010008","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010008"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010009\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010009\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010009","GLAccount_NodeID":":CACN 0068010009","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010009"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010010\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010010\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010010","GLAccount_NodeID":":CACN 0068010010","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010010"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010011\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010011\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010011","GLAccount_NodeID":":CACN 0068010011","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010011"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010012\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010012\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010012","GLAccount_NodeID":":CACN 0068010012","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010012"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010013\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010013\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010013","GLAccount_NodeID":":CACN 0068010013","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010013"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010014\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010014\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010014","GLAccount_NodeID":":CACN 0068010014","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010014"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010015\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010015\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010015","GLAccount_NodeID":":CACN 0068010015","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010015"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010016\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010016\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010016","GLAccount_NodeID":":CACN 0068010016","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010016"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010017\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010017\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010017","GLAccount_NodeID":":CACN 0068010017","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010017"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010018\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010018\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010018","GLAccount_NodeID":":CACN 0068010018","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010018"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010019\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010019\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010019","GLAccount_NodeID":":CACN 0068010019","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010019"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010020\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010020\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010020","GLAccount_NodeID":":CACN 0068010020","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010020"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010021\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010021\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010021","GLAccount_NodeID":":CACN 0068010021","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010021"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010022\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010022\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010022","GLAccount_NodeID":":CACN 0068010022","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010022"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010023\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010023\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010023","GLAccount_NodeID":":CACN 0068010023","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010023"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010024\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010024\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010024","GLAccount_NodeID":":CACN 0068010024","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010024"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010025\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010025\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010025","GLAccount_NodeID":":CACN 0068010025","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010025"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010026\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010026\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010026","GLAccount_NodeID":":CACN 0068010026","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010026"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010027\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010027\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010027","GLAccount_NodeID":":CACN 0068010027","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010027"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010028\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010028\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010028","GLAccount_NodeID":":CACN 0068010028","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010028"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010029\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010029\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010029","GLAccount_NodeID":":CACN 0068010029","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010029"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010030\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010030\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010030","GLAccount_NodeID":":CACN 0068010030","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010030"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010031\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010031\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010031","GLAccount_NodeID":":CACN 0068010031","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010031"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010032\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010032\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010032","GLAccount_NodeID":":CACN 0068010032","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010032"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010033\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010033\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010033","GLAccount_NodeID":":CACN 0068010033","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010033"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010034\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010034\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010034","GLAccount_NodeID":":CACN 0068010034","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010034"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010035\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010035\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010035","GLAccount_NodeID":":CACN 0068010035","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010035"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010036\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010036\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010036","GLAccount_NodeID":":CACN 0068010036","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010036"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010037\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010037\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010037","GLAccount_NodeID":":CACN 0068010037","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010037"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010038\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010038\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010038","GLAccount_NodeID":":CACN 0068010038","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010038"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010039\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010039\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010039","GLAccount_NodeID":":CACN 0068010039","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010039"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010040\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010040\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010040","GLAccount_NodeID":":CACN 0068010040","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010040"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010041\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010041\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010041","GLAccount_NodeID":":CACN 0068010041","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010041"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010042\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010042\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010042","GLAccount_NodeID":":CACN 0068010042","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010042"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010043\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010043\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010043","GLAccount_NodeID":":CACN 0068010043","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010043"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010044\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010044\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010044","GLAccount_NodeID":":CACN 0068010044","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010044"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010045\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010045\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010045","GLAccount_NodeID":":CACN 0068010045","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010045"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010046\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010046\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010046","GLAccount_NodeID":":CACN 0068010046","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010046"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010047\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010047\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010047","GLAccount_NodeID":":CACN 0068010047","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010047"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010048\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010048\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010048","GLAccount_NodeID":":CACN 0068010048","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010048"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010049\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010049\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010049","GLAccount_NodeID":":CACN 0068010049","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010049"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010050\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010050\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010050","GLAccount_NodeID":":CACN 0068010050","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010050"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010051\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010051\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010051","GLAccount_NodeID":":CACN 0068010051","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010051"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010052\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010052\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010052","GLAccount_NodeID":":CACN 0068010052","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010052"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010053\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010053\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010053","GLAccount_NodeID":":CACN 0068010053","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010053"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010054\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010054\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010054","GLAccount_NodeID":":CACN 0068010054","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010054"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010055\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010055\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010055","GLAccount_NodeID":":CACN 0068010055","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010055"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010056\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010056\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010056","GLAccount_NodeID":":CACN 0068010056","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010056"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010057\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010057\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010057","GLAccount_NodeID":":CACN 0068010057","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010057"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010058\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010058\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010058","GLAccount_NodeID":":CACN 0068010058","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010058"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010059\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010059\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010059","GLAccount_NodeID":":CACN 0068010059","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010059"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010060\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010060\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010060","GLAccount_NodeID":":CACN 0068010060","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010060"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010061\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010061\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010061","GLAccount_NodeID":":CACN 0068010061","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010061"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010062\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010062\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010062","GLAccount_NodeID":":CACN 0068010062","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010062"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010063\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010063\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010063","GLAccount_NodeID":":CACN 0068010063","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010063"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010064\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010064\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010064","GLAccount_NodeID":":CACN 0068010064","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010064"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010065\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010065\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010065","GLAccount_NodeID":":CACN 0068010065","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010065"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010066\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010066\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010066","GLAccount_NodeID":":CACN 0068010066","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010066"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010067\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010067\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010067","GLAccount_NodeID":":CACN 0068010067","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010067"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010068\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010068\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010068","GLAccount_NodeID":":CACN 0068010068","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010068"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010069\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010069\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010069","GLAccount_NodeID":":CACN 0068010069","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010069"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010070\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010070\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010070","GLAccount_NodeID":":CACN 0068010070","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010070"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010071\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010071\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010071","GLAccount_NodeID":":CACN 0068010071","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010071"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010072\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010072\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010072","GLAccount_NodeID":":CACN 0068010072","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010072"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010073\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010073\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010073","GLAccount_NodeID":":CACN 0068010073","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010073"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010074\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010074\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010074","GLAccount_NodeID":":CACN 0068010074","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010074"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010075\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010075\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010075","GLAccount_NodeID":":CACN 0068010075","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010075"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010076\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010076\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010076","GLAccount_NodeID":":CACN 0068010076","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010076"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010077\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010077\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010077","GLAccount_NodeID":":CACN 0068010077","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010077"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010078\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010078\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010078","GLAccount_NodeID":":CACN 0068010078","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010078"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010079\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010079\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010079","GLAccount_NodeID":":CACN 0068010079","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010079"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010080\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010080\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010080","GLAccount_NodeID":":CACN 0068010080","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010080"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010081\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010081\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010081","GLAccount_NodeID":":CACN 0068010081","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010081"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010082\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010082\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010082","GLAccount_NodeID":":CACN 0068010082","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010082"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010083\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010083\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010083","GLAccount_NodeID":":CACN 0068010083","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010083"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010084\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010084\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010084","GLAccount_NodeID":":CACN 0068010084","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010084"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010085\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010085\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010085","GLAccount_NodeID":":CACN 0068010085","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010085"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010086\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010086\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010086","GLAccount_NodeID":":CACN 0068010086","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010086"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010087\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010087\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010087","GLAccount_NodeID":":CACN 0068010087","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010087"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010088\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010088\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010088","GLAccount_NodeID":":CACN 0068010088","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010088"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010089\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010089\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010089","GLAccount_NodeID":":CACN 0068010089","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010089"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010090\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010090\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010090","GLAccount_NodeID":":CACN 0068010090","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010090"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010091\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010091\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010091","GLAccount_NodeID":":CACN 0068010091","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010091"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010092\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010092\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010092","GLAccount_NodeID":":CACN 0068010092","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010092"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010093\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010093\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010093","GLAccount_NodeID":":CACN 0068010093","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010093"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010094\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010094\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010094","GLAccount_NodeID":":CACN 0068010094","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010094"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010095\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010095\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010095","GLAccount_NodeID":":CACN 0068010095","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010095"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010096\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010096\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010096","GLAccount_NodeID":":CACN 0068010096","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010096"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010097\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010097\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010097","GLAccount_NodeID":":CACN 0068010097","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010097"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010098\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010098\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010098","GLAccount_NodeID":":CACN 0068010098","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010098"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010099\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010099\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010099","GLAccount_NodeID":":CACN 0068010099","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010099"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010100\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010100\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010100","GLAccount_NodeID":":CACN 0068010100","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010100"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010101\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010101\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010101","GLAccount_NodeID":":CACN 0068010101","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010101"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010102\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010102\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010102","GLAccount_NodeID":":CACN 0068010102","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010102"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010103\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010103\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010103","GLAccount_NodeID":":CACN 0068010103","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010103"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010104\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010104\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010104","GLAccount_NodeID":":CACN 0068010104","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010104"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010105\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010105\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010105","GLAccount_NodeID":":CACN 0068010105","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010105"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010106\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010106\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010106","GLAccount_NodeID":":CACN 0068010106","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010106"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010107\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010107\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010107","GLAccount_NodeID":":CACN 0068010107","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010107"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010108\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010108\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010108","GLAccount_NodeID":":CACN 0068010108","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010108"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010109\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010109\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010109","GLAccount_NodeID":":CACN 0068010109","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010109"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010110\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010110\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010110","GLAccount_NodeID":":CACN 0068010110","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010110"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010111\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010111\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010111","GLAccount_NodeID":":CACN 0068010111","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010111"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010112\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010112\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010112","GLAccount_NodeID":":CACN 0068010112","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010112"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010113\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010113\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010113","GLAccount_NodeID":":CACN 0068010113","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010113"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010114\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010114\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010114","GLAccount_NodeID":":CACN 0068010114","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010114"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010115\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010115\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010115","GLAccount_NodeID":":CACN 0068010115","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010115"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010116\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010116\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010116","GLAccount_NodeID":":CACN 0068010116","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010116"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010117\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010117\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010117","GLAccount_NodeID":":CACN 0068010117","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010117"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010118\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010118\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010118","GLAccount_NodeID":":CACN 0068010118","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010118"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010119\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010119\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010119","GLAccount_NodeID":":CACN 0068010119","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010119"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010120\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010120\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010120","GLAccount_NodeID":":CACN 0068010120","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010120"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010121\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010121\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010121","GLAccount_NodeID":":CACN 0068010121","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010121"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010122\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010122\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010122","GLAccount_NodeID":":CACN 0068010122","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010122"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010123\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010123\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010123","GLAccount_NodeID":":CACN 0068010123","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990002020068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010123"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999613\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999613\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999613","GLAccount_NodeText":"Adjustment for prior year","GLAccount_ParentID":"FinancialStatementItem:999961","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.13.0.0_IEQCACNIEQ999952372:9999613"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A613%20%20%20%20%20%20%2099990002050069010005-0069019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A613%20%20%20%20%20%20%2099990002050069010005-0069019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:613       99990002050069010005-0069019999","GLAccount_NodeText":"0069010005-0069019999","GLAccount_ParentID":"FinancialStatementItem:9999613","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:613       99990002050069010005-0069019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"RangeNode:613       99990002050069010005-0069019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999949\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999949\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999949","GLAccount_NodeText":"Net income","GLAccount_ParentID":"FinancialStatementItem:99996","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999949"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:999949","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99997\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99997\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99997","GLAccount_NodeText":"Not assigned accounts","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99997"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:99997","GLAccount_Level":1,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99998\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99998\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99998","GLAccount_NodeText":"Financial St. Notes","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99998"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:99998","GLAccount_Level":1,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"}]}}';
	// The result contains 117 items (request is for 118 due to potentially generated server index nodes)
	var sResultsL4Top118 = '{"d":{"results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99991\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99991\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99991","GLAccount_NodeText":"Assets","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":13,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99991"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999917\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999917\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999917","GLAccount_NodeText":"Intangible assets","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999917"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991711\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991711\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99991711","GLAccount_NodeText":"Goodwill","GLAccount_ParentID":"FinancialStatementItem:999917","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99991711"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1711%20%20%20%20%20%2099990000060017110000-0017119999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1711%20%20%20%20%20%2099990000060017110000-0017119999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:1711      99990000060017110000-0017119999","GLAccount_NodeText":"0017110000-0017119999","GLAccount_ParentID":"FinancialStatementItem:99991711","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:1711      99990000060017110000-0017119999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200017110000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200017110000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"17110000","GLAccount_NodeID":":CACN 0017110000","GLAccount_NodeText":"Goodwill","GLAccount_ParentID":"RangeNode:1711      99990000060017110000-0017119999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Goodwill","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0017110000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999918\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999918\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999918","GLAccount_NodeText":"Long term deferred","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999918"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991811\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991811\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99991811","GLAccount_NodeText":"Deferred tax","GLAccount_ParentID":"FinancialStatementItem:999918","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99991811"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1811%20%20%20%20%20%2099990000100018110000-0018119999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1811%20%20%20%20%20%2099990000100018110000-0018119999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:1811      99990000100018110000-0018119999","GLAccount_NodeText":"0018110000-0018119999","GLAccount_ParentID":"FinancialStatementItem:99991811","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:1811      99990000100018110000-0018119999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200018110000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200018110000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"18110000","GLAccount_NodeID":":CACN 0018110000","GLAccount_NodeText":"Deferred tax assets","GLAccount_ParentID":"RangeNode:1811      99990000100018110000-0018119999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Deferred tax assets","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0018110000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999919\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999919\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999919","GLAccount_NodeText":"Gain/loss fro handling assets","GLAccount_ParentID":"FinancialStatementItem:99991","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999919"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991901\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99991901\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99991901","GLAccount_NodeText":"Gain/loss fro handling assets","GLAccount_ParentID":"FinancialStatementItem:999919","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99991901"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1901%20%20%20%20%20%2099990000140019010000-0019019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A1901%20%20%20%20%20%2099990000140019010000-0019019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:1901      99990000140019010000-0019019999","GLAccount_NodeText":"0019010000-0019019999","GLAccount_ParentID":"FinancialStatementItem:99991901","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:1901      99990000140019010000-0019019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200019010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200019010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"19010000","GLAccount_NodeID":":CACN 0019010000","GLAccount_NodeText":"Gain/loss for handli","GLAccount_ParentID":"RangeNode:1901      99990000140019010000-0019019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Gain/loss for handli","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0019010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200019010003\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200019010003\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"19010003","GLAccount_NodeID":":CACN 0019010003","GLAccount_NodeText":"Gain/loss 3","GLAccount_ParentID":"RangeNode:1901      99990000140019010000-0019019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Gain/loss 3","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0019010003"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99992\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99992\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99992","GLAccount_NodeText":"Liabilities & Stockholders\' Equity","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":37,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99992"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999922\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999922\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999922","GLAccount_NodeText":"Liabilities","GLAccount_ParentID":"FinancialStatementItem:99992","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":36,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999922"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992221\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992221\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99992221","GLAccount_NodeText":"Current liabilities","GLAccount_ParentID":"FinancialStatementItem:999922","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":19,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99992221"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222103\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222103\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222103","GLAccount_NodeText":"Financial liabilities for deal","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222103"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222103%20%20%20%2099990000210021010000-0021019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222103%20%20%20%2099990000210021010000-0021019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222103    99990000210021010000-0021019999","GLAccount_NodeText":"0021010000-0021019999","GLAccount_ParentID":"FinancialStatementItem:9999222103","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222103    99990000210021010000-0021019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222111\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222111\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222111","GLAccount_NodeText":"Notes payable","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222111"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222111%20%20%20%2099990000240022010000-0022019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222111%20%20%20%2099990000240022010000-0022019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222111    99990000240022010000-0022019999","GLAccount_NodeText":"0022010000-0022019999","GLAccount_ParentID":"FinancialStatementItem:9999222111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222111    99990000240022010000-0022019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222121\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222121\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222121","GLAccount_NodeText":"Accounts payable","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222121"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222121%20%20%20%2099990000270022020000-0022029999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222121%20%20%20%2099990000270022020000-0022029999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222121    99990000270022020000-0022029999","GLAccount_NodeText":"0022020000-0022029999","GLAccount_ParentID":"FinancialStatementItem:9999222121","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222121    99990000270022020000-0022029999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222122\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222122\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222122","GLAccount_NodeText":"Interest payable","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222122"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222122%20%20%20%2099990000320022310000-0022319999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222122%20%20%20%2099990000320022310000-0022319999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222122    99990000320022310000-0022319999","GLAccount_NodeText":"0022310000-0022319999","GLAccount_ParentID":"FinancialStatementItem:9999222122","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222122    99990000320022310000-0022319999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222141\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222141\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222141","GLAccount_NodeText":"Taxes payable","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222141"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222141%20%20%20%2099990000350022210000-0022219999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222141%20%20%20%2099990000350022210000-0022219999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222141    99990000350022210000-0022219999","GLAccount_NodeText":"0022210000-0022219999","GLAccount_ParentID":"FinancialStatementItem:9999222141","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222141    99990000350022210000-0022219999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222151\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222151\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222151","GLAccount_NodeText":"Dividends payable","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222151"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222151%20%20%20%2099990000400022320000-0022329999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222151%20%20%20%2099990000400022320000-0022329999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222151    99990000400022320000-0022329999","GLAccount_NodeText":"0022320000-0022329999","GLAccount_ParentID":"FinancialStatementItem:9999222151","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222151    99990000400022320000-0022329999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222161\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222161\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222161","GLAccount_NodeText":"Advances from customers","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222161"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222161%20%20%20%2099990000430022030000-0022039999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222161%20%20%20%2099990000430022030000-0022039999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222161    99990000430022030000-0022039999","GLAccount_NodeText":"0022030000-0022039999","GLAccount_ParentID":"FinancialStatementItem:9999222161","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222161    99990000430022030000-0022039999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222171\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222171\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222171","GLAccount_NodeText":"Other payables","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222171"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222171%20%20%20%2099990000480022410000-0022419999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222171%20%20%20%2099990000480022410000-0022419999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222171    99990000480022410000-0022419999","GLAccount_NodeText":"0022410000-0022419999","GLAccount_ParentID":"FinancialStatementItem:9999222171","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222171    99990000480022410000-0022419999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222199\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222199\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222199","GLAccount_NodeText":"Other current liabilities","GLAccount_ParentID":"FinancialStatementItem:99992221","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222199"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222199%20%20%20%2099990000510023140000-0023149999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222199%20%20%20%2099990000510023140000-0023149999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222199    99990000510023140000-0023149999","GLAccount_NodeText":"0023140000-0023149999","GLAccount_ParentID":"FinancialStatementItem:9999222199","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222199    99990000510023140000-0023149999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222199%20%20%20%2099990000510024010000-0024019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222199%20%20%20%2099990000510024010000-0024019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222199    99990000510024010000-0024019999","GLAccount_NodeText":"0024010000-0024019999","GLAccount_ParentID":"FinancialStatementItem:9999222199","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222199    99990000510024010000-0024019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992222\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992222\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99992222","GLAccount_NodeText":"Long-term liabilities","GLAccount_ParentID":"FinancialStatementItem:999922","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":10,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99992222"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222201","GLAccount_NodeText":"Long-term loans","GLAccount_ParentID":"FinancialStatementItem:99992222","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222201"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222201%20%20%20%2099990000570025010000-0025019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222201%20%20%20%2099990000570025010000-0025019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222201    99990000570025010000-0025019999","GLAccount_NodeText":"0025010000-0025019999","GLAccount_ParentID":"FinancialStatementItem:9999222201","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222201    99990000570025010000-0025019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222211\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222211\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222211","GLAccount_NodeText":"Long-term Bonds","GLAccount_ParentID":"FinancialStatementItem:99992222","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222211"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222211%20%20%20%2099990000620025020000-0025029999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222211%20%20%20%2099990000620025020000-0025029999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222211    99990000620025020000-0025029999","GLAccount_NodeText":"0025020000-0025029999","GLAccount_ParentID":"FinancialStatementItem:9999222211","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222211    99990000620025020000-0025029999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222212\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222212\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222212","GLAccount_NodeText":"Discount on debentures payable","GLAccount_ParentID":"FinancialStatementItem:99992222","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222212"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:9999222212","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222221\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222221\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222221","GLAccount_NodeText":"Payables due after one year","GLAccount_ParentID":"FinancialStatementItem:99992222","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222221"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027010000-0027019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027010000-0027019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222221    99990000660027010000-0027019999","GLAccount_NodeText":"0027010000-0027019999","GLAccount_ParentID":"FinancialStatementItem:9999222221","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222221    99990000660027010000-0027019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027020000-0027029999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027020000-0027029999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222221    99990000660027020000-0027029999","GLAccount_NodeText":"0027020000-0027029999","GLAccount_ParentID":"FinancialStatementItem:9999222221","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222221    99990000660027020000-0027029999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027110000-0027119999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222221%20%20%20%2099990000660027110000-0027119999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222221    99990000660027110000-0027119999","GLAccount_NodeText":"0027110000-0027119999","GLAccount_ParentID":"FinancialStatementItem:9999222221","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222221    99990000660027110000-0027119999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992223\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99992223\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99992223","GLAccount_NodeText":"Other liabilities","GLAccount_ParentID":"FinancialStatementItem:999922","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99992223"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222301\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222301\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222301","GLAccount_NodeText":"Other liabilities","GLAccount_ParentID":"FinancialStatementItem:99992223","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222301"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222301%20%20%20%2099990000740028010000-0028019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222301%20%20%20%2099990000740028010000-0028019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222301    99990000740028010000-0028019999","GLAccount_NodeText":"0028010000-0028019999","GLAccount_ParentID":"FinancialStatementItem:9999222301","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222301    99990000740028010000-0028019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222321\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ999952372%3A9999222321\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999222321","GLAccount_NodeText":"Deferred taxes payable","GLAccount_ParentID":"FinancialStatementItem:99992223","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ999952372:9999222321"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222321%20%20%20%2099990000770029010000-0029019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A222321%20%20%20%2099990000770029010000-0029019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:222321    99990000770029010000-0029019999","GLAccount_NodeText":"0029010000-0029019999","GLAccount_ParentID":"FinancialStatementItem:9999222321","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:222321    99990000770029010000-0029019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99993\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99993\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993","GLAccount_NodeText":"Common","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99993"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99993201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99993201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993201","GLAccount_NodeText":"Hedging financial tools","GLAccount_ParentID":"FinancialStatementItem:99993","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99993201"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A3201%20%20%20%20%20%2099990000810032010000-0032019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A3201%20%20%20%20%20%2099990000810032010000-0032019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:3201      99990000810032010000-0032019999","GLAccount_NodeText":"0032010000-0032019999","GLAccount_ParentID":"FinancialStatementItem:99993201","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:3201      99990000810032010000-0032019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200032010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200032010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"32010000","GLAccount_NodeID":":CACN 0032010000","GLAccount_NodeText":"Hedging financial","GLAccount_ParentID":"RangeNode:3201      99990000810032010000-0032019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Hedging financial","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0032010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99993202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99993202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99993202","GLAccount_NodeText":"Hedged items","GLAccount_ParentID":"FinancialStatementItem:99993","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99993202"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A3202%20%20%20%20%20%2099990000840032020000-0032029999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A3202%20%20%20%20%20%2099990000840032020000-0032029999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:3202      99990000840032020000-0032029999","GLAccount_NodeText":"0032020000-0032029999","GLAccount_ParentID":"FinancialStatementItem:99993202","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:3202      99990000840032020000-0032029999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200032020000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200032020000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"32020000","GLAccount_NodeID":":CACN 0032020000","GLAccount_NodeText":"Hedged items","GLAccount_ParentID":"RangeNode:3202      99990000840032020000-0032029999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Hedged items","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0032020000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99994\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99994\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994","GLAccount_NodeText":"Stock owner\'s equity","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":57,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99994"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994001","GLAccount_NodeText":"Pain-in capital","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":5,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4001%20%20%20%20%20%2099990000880009527124-0009527125\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4001%20%20%20%20%20%2099990000880009527124-0009527125\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4001      99990000880009527124-0009527125","GLAccount_NodeText":"0009527124-0009527125","GLAccount_ParentID":"FinancialStatementItem:99994001","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4001      99990000880009527124-0009527125"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200009527124\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200009527124\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"9527124","GLAccount_NodeID":":CACN 0009527124","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4001      99990000880009527124-0009527125","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0009527124"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200009527125\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200009527125\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"9527125","GLAccount_NodeID":":CACN 0009527125","GLAccount_NodeText":"tests","GLAccount_ParentID":"RangeNode:4001      99990000880009527124-0009527125","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"tests","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0009527125"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4001%20%20%20%20%20%2099990000880040010000-0040019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4001%20%20%20%20%20%2099990000880040010000-0040019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4001      99990000880040010000-0040019999","GLAccount_NodeText":"0040010000-0040019999","GLAccount_ParentID":"FinancialStatementItem:99994001","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4001      99990000880040010000-0040019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200040010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200040010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"40010000","GLAccount_NodeID":":CACN 0040010000","GLAccount_NodeText":"Paid-in capital","GLAccount_ParentID":"RangeNode:4001      99990000880040010000-0040019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Paid-in capital","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0040010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994002","GLAccount_NodeText":"Capital surplus","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4002%20%20%20%20%20%2099990000910040020000-0040029999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4002%20%20%20%20%20%2099990000910040020000-0040029999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4002      99990000910040020000-0040029999","GLAccount_NodeText":"0040020000-0040029999","GLAccount_ParentID":"FinancialStatementItem:99994002","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4002      99990000910040020000-0040029999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200040020000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200040020000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"40020000","GLAccount_NodeID":":CACN 0040020000","GLAccount_NodeText":"Capital surplus","GLAccount_ParentID":"RangeNode:4002      99990000910040020000-0040029999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Capital surplus","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0040020000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994101\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994101\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994101","GLAccount_NodeText":"Legal sruplus","GLAccount_ParentID":"FinancialStatementItem:99994","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":47,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994101"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4101%20%20%20%20%20%2099990000940041010000-0041019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4101%20%20%20%20%20%2099990000940041010000-0041019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_NodeText":"0041010000-0041019999","GLAccount_ParentID":"FinancialStatementItem:99994101","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":46,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4101      99990000940041010000-0041019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010000","GLAccount_NodeID":":CACN 0041010000","GLAccount_NodeText":"Surplus","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Surplus","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010100\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010100\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010100","GLAccount_NodeID":":CACN 0041010100","GLAccount_NodeText":"Raw material","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Raw material","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010100"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010200\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010200\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010200","GLAccount_NodeID":":CACN 0041010200","GLAccount_NodeText":"Direct wages","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Direct wages","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010200"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010300\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010300\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010300","GLAccount_NodeID":":CACN 0041010300","GLAccount_NodeText":"OEM-Prod. - consumed","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"OEM-Prod. - consumed","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010300"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010400\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010400\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010400","GLAccount_NodeID":":CACN 0041010400","GLAccount_NodeText":"Pack. Mat- - consu.","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Pack. Mat- - consu.","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010400"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010401\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010401\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010401","GLAccount_NodeID":":CACN 0041010401","GLAccount_NodeText":"Pack. Mat- - consu.","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Pack. Mat- - consu.","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010401"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010402\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010402\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010402","GLAccount_NodeID":":CACN 0041010402","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010402"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010403\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010403\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010403","GLAccount_NodeID":":CACN 0041010403","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010403"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010404\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010404\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010404","GLAccount_NodeID":":CACN 0041010404","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010404"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010405\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010405\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010405","GLAccount_NodeID":":CACN 0041010405","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010405"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010406\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010406\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010406","GLAccount_NodeID":":CACN 0041010406","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010406"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010407\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010407\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010407","GLAccount_NodeID":":CACN 0041010407","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010407"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010408\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010408\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010408","GLAccount_NodeID":":CACN 0041010408","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010408"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010409\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010409\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010409","GLAccount_NodeID":":CACN 0041010409","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010409"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010410\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010410\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010410","GLAccount_NodeID":":CACN 0041010410","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010410"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010411\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010411\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010411","GLAccount_NodeID":":CACN 0041010411","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010411"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010412\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010412\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010412","GLAccount_NodeID":":CACN 0041010412","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010412"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010413\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010413\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010413","GLAccount_NodeID":":CACN 0041010413","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010413"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010414\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010414\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010414","GLAccount_NodeID":":CACN 0041010414","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010414"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010415\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010415\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010415","GLAccount_NodeID":":CACN 0041010415","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010415"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010416\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010416\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010416","GLAccount_NodeID":":CACN 0041010416","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010416"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010417\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010417\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010417","GLAccount_NodeID":":CACN 0041010417","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010417"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010418\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010418\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010418","GLAccount_NodeID":":CACN 0041010418","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010418"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010419\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010419\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010419","GLAccount_NodeID":":CACN 0041010419","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010419"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010420\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010420\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010420","GLAccount_NodeID":":CACN 0041010420","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010420"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010421\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010421\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010421","GLAccount_NodeID":":CACN 0041010421","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010421"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010422\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010422\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010422","GLAccount_NodeID":":CACN 0041010422","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010422"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010423\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010423\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010423","GLAccount_NodeID":":CACN 0041010423","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010423"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010424\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010424\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010424","GLAccount_NodeID":":CACN 0041010424","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010424"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010425\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010425\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010425","GLAccount_NodeID":":CACN 0041010425","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010425"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010426\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010426\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010426","GLAccount_NodeID":":CACN 0041010426","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010426"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010427\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010427\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010427","GLAccount_NodeID":":CACN 0041010427","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010427"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010428\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010428\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010428","GLAccount_NodeID":":CACN 0041010428","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010428"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010429\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010429\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010429","GLAccount_NodeID":":CACN 0041010429","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010429"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010430\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010430\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010430","GLAccount_NodeID":":CACN 0041010430","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010430"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010431\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010431\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010431","GLAccount_NodeID":":CACN 0041010431","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010431"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010432\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010432\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010432","GLAccount_NodeID":":CACN 0041010432","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010432"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010433\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010433\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010433","GLAccount_NodeID":":CACN 0041010433","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010433"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010434\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010434\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010434","GLAccount_NodeID":":CACN 0041010434","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010434"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010435\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010435\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010435","GLAccount_NodeID":":CACN 0041010435","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010435"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010436\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010436\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010436","GLAccount_NodeID":":CACN 0041010436","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010436"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010437\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010437\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010437","GLAccount_NodeID":":CACN 0041010437","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010437"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010438\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010438\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010438","GLAccount_NodeID":":CACN 0041010438","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010438"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010439\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010439\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010439","GLAccount_NodeID":":CACN 0041010439","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010439"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010440\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010440\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010440","GLAccount_NodeID":":CACN 0041010440","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010440"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010441\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041010441\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41010441","GLAccount_NodeID":":CACN 0041010441","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4101      99990000940041010000-0041019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041010441"}]}}';
	// The result contains 203 items (request is for 204 due to potentially generated server index nodes)
	var sResultsL4Skip164Top204 = '{"d":{"results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994103\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994103\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994103","GLAccount_NodeText":"test","GLAccount_ParentID":"","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":12,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994103"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4103%20%20%20%20%20%2099990001030041030000-0041030010\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4103%20%20%20%20%20%2099990001030041030000-0041030010\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_NodeText":"0041030000-0041030010","GLAccount_ParentID":"FinancialStatementItem:99994103","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":11,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4103      99990001030041030000-0041030010"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030000","GLAccount_NodeID":":CACN 0041030000","GLAccount_NodeText":"Current profit","GLAccount_ParentID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Current profit","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030001","GLAccount_NodeID":":CACN 0041030001","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030002","GLAccount_NodeID":":CACN 0041030002","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030003\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030003\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030003","GLAccount_NodeID":":CACN 0041030003","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030003"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030004\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030004\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030004","GLAccount_NodeID":":CACN 0041030004","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030004"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030005\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030005\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030005","GLAccount_NodeID":":CACN 0041030005","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030005"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030006\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030006\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030006","GLAccount_NodeID":":CACN 0041030006","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030006"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030007\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030007\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030007","GLAccount_NodeID":":CACN 0041030007","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030007"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030008\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030008\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030008","GLAccount_NodeID":":CACN 0041030008","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030008"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030009\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030009\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030009","GLAccount_NodeID":":CACN 0041030009","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030009"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030010\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041030010\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41030010","GLAccount_NodeID":":CACN 0041030010","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:4103      99990001030041030000-0041030010","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041030010"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994104\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994104\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994104","GLAccount_NodeText":"Approprited retained earnings","GLAccount_ParentID":"","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":31,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994104"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4104%20%20%20%20%20%2099990001060041040000-0041049999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4104%20%20%20%20%20%2099990001060041040000-0041049999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_NodeText":"0041040000-0041049999","GLAccount_ParentID":"FinancialStatementItem:99994104","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":30,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4104      99990001060041040000-0041049999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040000","GLAccount_NodeID":":CACN 0041040000","GLAccount_NodeText":"Profit assignment","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Profit assignment","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040001","GLAccount_NodeID":":CACN 0041040001","GLAccount_NodeText":"tt","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"tt","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040002","GLAccount_NodeID":":CACN 0041040002","GLAccount_NodeText":"41040002","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"41040002","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040003\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040003\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040003","GLAccount_NodeID":":CACN 0041040003","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040003"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040004\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040004\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040004","GLAccount_NodeID":":CACN 0041040004","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040004"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040005\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040005\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040005","GLAccount_NodeID":":CACN 0041040005","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040005"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040006\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040006\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040006","GLAccount_NodeID":":CACN 0041040006","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040006"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040007\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040007\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040007","GLAccount_NodeID":":CACN 0041040007","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040007"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040008\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040008\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040008","GLAccount_NodeID":":CACN 0041040008","GLAccount_NodeText":"8","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"8","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040008"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040009\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040009\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040009","GLAccount_NodeID":":CACN 0041040009","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040009"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040010\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040010\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040010","GLAccount_NodeID":":CACN 0041040010","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040010"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040011\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040011\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040011","GLAccount_NodeID":":CACN 0041040011","GLAccount_NodeText":"Profit assign11","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Profit assign11","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040011"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040012\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040012\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040012","GLAccount_NodeID":":CACN 0041040012","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040012"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040013\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040013\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040013","GLAccount_NodeID":":CACN 0041040013","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040013"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040014\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040014\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040014","GLAccount_NodeID":":CACN 0041040014","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040014"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040015\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040015\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040015","GLAccount_NodeID":":CACN 0041040015","GLAccount_NodeText":"test15","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test15","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040015"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040016\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040016\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040016","GLAccount_NodeID":":CACN 0041040016","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040016"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040017\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040017\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040017","GLAccount_NodeID":":CACN 0041040017","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040017"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040022\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040022\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040022","GLAccount_NodeID":":CACN 0041040022","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040022"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040025\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040025\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040025","GLAccount_NodeID":":CACN 0041040025","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040025"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040044\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040044\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040044","GLAccount_NodeID":":CACN 0041040044","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040044"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040045\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040045\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040045","GLAccount_NodeID":":CACN 0041040045","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040045"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040046\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040046\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040046","GLAccount_NodeID":":CACN 0041040046","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040046"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040047\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040047\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040047","GLAccount_NodeID":":CACN 0041040047","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040047"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040048\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040048\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040048","GLAccount_NodeID":":CACN 0041040048","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040048"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040051\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040051\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040051","GLAccount_NodeID":":CACN 0041040051","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040051"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040077\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040077\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040077","GLAccount_NodeID":":CACN 0041040077","GLAccount_NodeText":"test changed by Alex","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test changed by Alex","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040077"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040086\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040086\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040086","GLAccount_NodeID":":CACN 0041040086","GLAccount_NodeText":"test86","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test86","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040086"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040087\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040087\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040087","GLAccount_NodeID":":CACN 0041040087","GLAccount_NodeText":"test87","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test87","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040087"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040099\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200041040099\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"41040099","GLAccount_NodeID":":CACN 0041040099","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:4104      99990001060041040000-0041049999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0041040099"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99994201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99994201","GLAccount_NodeText":"Stock shares inventory","GLAccount_ParentID":"","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99994201"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4201%20%20%20%20%20%2099990001380042010000-0042019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A4201%20%20%20%20%20%2099990001380042010000-0042019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:4201      99990001380042010000-0042019999","GLAccount_NodeText":"0042010000-0042019999","GLAccount_ParentID":"FinancialStatementItem:99994201","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:4201      99990001380042010000-0042019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200042010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200042010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"42010000","GLAccount_NodeID":":CACN 0042010000","GLAccount_NodeText":"Stock shares","GLAccount_ParentID":"RangeNode:4201      99990001380042010000-0042019999","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Stock shares","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0042010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999941031\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999941031\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999941031","GLAccount_NodeText":"Current year profit - calculated, checki","GLAccount_ParentID":"","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999941031"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:999941031","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999941032\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999941032\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999941032","GLAccount_NodeText":"Current year loss - calculated, checking","GLAccount_ParentID":"","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999941032"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:999941032","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99996\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99996\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996","GLAccount_NodeText":"Profit & Loss","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":146,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99996"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999961\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999961\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961","GLAccount_NodeText":"Net income","GLAccount_ParentID":"FinancialStatementItem:99996","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":143,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999961"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999611\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999611\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999611","GLAccount_NodeText":"Income before tax","GLAccount_ParentID":"FinancialStatementItem:999961","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":13,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.13.0.0_IEQCACNIEQ999952372:9999611"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996111\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996111\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996111","GLAccount_NodeText":"Operating income","GLAccount_ParentID":"FinancialStatementItem:9999611","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99996111"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961111\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961111\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961111","GLAccount_NodeText":"Operating Income","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961111"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961112\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961112\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961112","GLAccount_NodeText":"Business tax and other","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961112"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961113\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961113\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961113","GLAccount_NodeText":"Other operating income","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961113"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961114\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961114\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961114","GLAccount_NodeText":"Gain/loss for fair value","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961114"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961115\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961115\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961115","GLAccount_NodeText":"Gain/loss from investment","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961115"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961116\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.15.0.0_IEQCACNIEQ999952372%3A999961116\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999961116","GLAccount_NodeText":"Operating expense","GLAccount_ParentID":"FinancialStatementItem:99996111","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.15.0.0_IEQCACNIEQ999952372:999961116"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.17.0.0_IEQCACNIEQ999952372%3A99996112%2F01\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.17.0.0_IEQCACNIEQ999952372%3A99996112%2F01\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996112/01","GLAccount_NodeText":"Non-operating revenue","GLAccount_ParentID":"FinancialStatementItem:9999611","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.17.0.0_IEQCACNIEQ999952372:99996112/01"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6112%2F01%20%20%2099990001900063010000-0063019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6112%2F01%20%20%2099990001900063010000-0063019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:6112/01   99990001900063010000-0063019999","GLAccount_NodeText":"0063010000-0063019999","GLAccount_ParentID":"FinancialStatementItem:99996112/01","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:6112/01   99990001900063010000-0063019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996113\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996113\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996113","GLAccount_NodeText":"Non-operating expense","GLAccount_ParentID":"FinancialStatementItem:9999611","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99996113"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6113%20%20%20%20%20%2099990001930067110000-0067119999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6113%20%20%20%20%20%2099990001930067110000-0067119999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:6113      99990001930067110000-0067119999","GLAccount_NodeText":"0067110000-0067119999","GLAccount_ParentID":"FinancialStatementItem:99996113","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:6113      99990001930067110000-0067119999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996114\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.14.0.0_IEQCACNIEQ999952372%3A99996114\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99996114","GLAccount_NodeText":"Loss on revalue of assets","GLAccount_ParentID":"FinancialStatementItem:9999611","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.14.0.0_IEQCACNIEQ999952372:99996114"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6114%20%20%20%20%20%2099990001960067010000-0067019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A6114%20%20%20%20%20%2099990001960067010000-0067019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:6114      99990001960067010000-0067019999","GLAccount_NodeText":"0067010000-0067019999","GLAccount_ParentID":"FinancialStatementItem:99996114","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:6114      99990001960067010000-0067019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999612\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999612\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999612","GLAccount_NodeText":"Income tax expence","GLAccount_ParentID":"FinancialStatementItem:999961","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":125,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.13.0.0_IEQCACNIEQ999952372:9999612"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A612%20%20%20%20%20%20%2099990001990068010000-0068019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A612%20%20%20%20%20%20%2099990001990068010000-0068019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_NodeText":"0068010000-0068019999","GLAccount_ParentID":"FinancialStatementItem:9999612","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":124,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:612       99990001990068010000-0068019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010000","GLAccount_NodeID":":CACN 0068010000","GLAccount_NodeText":"Income tax","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"Income tax","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010001","GLAccount_NodeID":":CACN 0068010001","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010002","GLAccount_NodeID":":CACN 0068010002","GLAccount_NodeText":"test","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"test","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010003\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010003\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010003","GLAccount_NodeID":":CACN 0068010003","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010003"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010004\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010004\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010004","GLAccount_NodeID":":CACN 0068010004","GLAccount_NodeText":"aa","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"aa","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010004"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010005\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010005\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010005","GLAccount_NodeID":":CACN 0068010005","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010005"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010006\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010006\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010006","GLAccount_NodeID":":CACN 0068010006","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010006"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010007\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010007\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010007","GLAccount_NodeID":":CACN 0068010007","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010007"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010008\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010008\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010008","GLAccount_NodeID":":CACN 0068010008","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010008"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010009\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010009\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010009","GLAccount_NodeID":":CACN 0068010009","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010009"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010010\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010010\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010010","GLAccount_NodeID":":CACN 0068010010","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010010"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010011\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010011\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010011","GLAccount_NodeID":":CACN 0068010011","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010011"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010012\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010012\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010012","GLAccount_NodeID":":CACN 0068010012","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010012"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010013\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010013\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010013","GLAccount_NodeID":":CACN 0068010013","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010013"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010014\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010014\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010014","GLAccount_NodeID":":CACN 0068010014","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010014"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010015\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010015\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010015","GLAccount_NodeID":":CACN 0068010015","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010015"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010016\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010016\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010016","GLAccount_NodeID":":CACN 0068010016","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010016"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010017\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010017\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010017","GLAccount_NodeID":":CACN 0068010017","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010017"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010018\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010018\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010018","GLAccount_NodeID":":CACN 0068010018","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010018"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010019\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010019\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010019","GLAccount_NodeID":":CACN 0068010019","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010019"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010020\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010020\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010020","GLAccount_NodeID":":CACN 0068010020","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010020"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010021\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010021\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010021","GLAccount_NodeID":":CACN 0068010021","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010021"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010022\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010022\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010022","GLAccount_NodeID":":CACN 0068010022","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010022"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010023\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010023\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010023","GLAccount_NodeID":":CACN 0068010023","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010023"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010024\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010024\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010024","GLAccount_NodeID":":CACN 0068010024","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010024"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010025\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010025\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010025","GLAccount_NodeID":":CACN 0068010025","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010025"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010026\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010026\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010026","GLAccount_NodeID":":CACN 0068010026","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010026"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010027\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010027\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010027","GLAccount_NodeID":":CACN 0068010027","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010027"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010028\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010028\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010028","GLAccount_NodeID":":CACN 0068010028","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010028"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010029\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010029\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010029","GLAccount_NodeID":":CACN 0068010029","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010029"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010030\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010030\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010030","GLAccount_NodeID":":CACN 0068010030","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010030"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010031\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010031\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010031","GLAccount_NodeID":":CACN 0068010031","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010031"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010032\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010032\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010032","GLAccount_NodeID":":CACN 0068010032","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010032"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010033\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010033\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010033","GLAccount_NodeID":":CACN 0068010033","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010033"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010034\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010034\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010034","GLAccount_NodeID":":CACN 0068010034","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010034"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010035\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010035\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010035","GLAccount_NodeID":":CACN 0068010035","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010035"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010036\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010036\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010036","GLAccount_NodeID":":CACN 0068010036","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010036"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010037\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010037\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010037","GLAccount_NodeID":":CACN 0068010037","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010037"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010038\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010038\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010038","GLAccount_NodeID":":CACN 0068010038","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010038"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010039\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010039\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010039","GLAccount_NodeID":":CACN 0068010039","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010039"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010040\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010040\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010040","GLAccount_NodeID":":CACN 0068010040","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010040"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010041\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010041\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010041","GLAccount_NodeID":":CACN 0068010041","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010041"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010042\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010042\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010042","GLAccount_NodeID":":CACN 0068010042","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010042"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010043\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010043\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010043","GLAccount_NodeID":":CACN 0068010043","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010043"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010044\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010044\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010044","GLAccount_NodeID":":CACN 0068010044","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010044"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010045\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010045\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010045","GLAccount_NodeID":":CACN 0068010045","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010045"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010046\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010046\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010046","GLAccount_NodeID":":CACN 0068010046","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010046"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010047\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010047\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010047","GLAccount_NodeID":":CACN 0068010047","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010047"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010048\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010048\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010048","GLAccount_NodeID":":CACN 0068010048","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010048"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010049\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010049\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010049","GLAccount_NodeID":":CACN 0068010049","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010049"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010050\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010050\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010050","GLAccount_NodeID":":CACN 0068010050","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010050"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010051\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010051\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010051","GLAccount_NodeID":":CACN 0068010051","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010051"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010052\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010052\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010052","GLAccount_NodeID":":CACN 0068010052","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010052"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010053\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010053\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010053","GLAccount_NodeID":":CACN 0068010053","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010053"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010054\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010054\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010054","GLAccount_NodeID":":CACN 0068010054","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010054"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010055\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010055\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010055","GLAccount_NodeID":":CACN 0068010055","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010055"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010056\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010056\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010056","GLAccount_NodeID":":CACN 0068010056","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010056"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010057\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010057\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010057","GLAccount_NodeID":":CACN 0068010057","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010057"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010058\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010058\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010058","GLAccount_NodeID":":CACN 0068010058","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010058"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010059\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010059\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010059","GLAccount_NodeID":":CACN 0068010059","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010059"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010060\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010060\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010060","GLAccount_NodeID":":CACN 0068010060","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010060"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010061\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010061\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010061","GLAccount_NodeID":":CACN 0068010061","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010061"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010062\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010062\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010062","GLAccount_NodeID":":CACN 0068010062","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010062"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010063\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010063\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010063","GLAccount_NodeID":":CACN 0068010063","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010063"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010064\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010064\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010064","GLAccount_NodeID":":CACN 0068010064","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010064"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010065\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010065\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010065","GLAccount_NodeID":":CACN 0068010065","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010065"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010066\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010066\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010066","GLAccount_NodeID":":CACN 0068010066","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010066"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010067\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010067\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010067","GLAccount_NodeID":":CACN 0068010067","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010067"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010068\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010068\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010068","GLAccount_NodeID":":CACN 0068010068","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010068"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010069\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010069\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010069","GLAccount_NodeID":":CACN 0068010069","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010069"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010070\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010070\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010070","GLAccount_NodeID":":CACN 0068010070","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010070"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010071\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010071\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010071","GLAccount_NodeID":":CACN 0068010071","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010071"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010072\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010072\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010072","GLAccount_NodeID":":CACN 0068010072","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010072"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010073\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010073\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010073","GLAccount_NodeID":":CACN 0068010073","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010073"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010074\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010074\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010074","GLAccount_NodeID":":CACN 0068010074","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010074"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010075\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010075\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010075","GLAccount_NodeID":":CACN 0068010075","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010075"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010076\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010076\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010076","GLAccount_NodeID":":CACN 0068010076","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010076"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010077\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010077\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010077","GLAccount_NodeID":":CACN 0068010077","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010077"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010078\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010078\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010078","GLAccount_NodeID":":CACN 0068010078","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010078"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010079\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010079\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010079","GLAccount_NodeID":":CACN 0068010079","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010079"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010080\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010080\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010080","GLAccount_NodeID":":CACN 0068010080","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010080"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010081\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010081\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010081","GLAccount_NodeID":":CACN 0068010081","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010081"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010082\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010082\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010082","GLAccount_NodeID":":CACN 0068010082","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010082"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010083\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010083\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010083","GLAccount_NodeID":":CACN 0068010083","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010083"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010084\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010084\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010084","GLAccount_NodeID":":CACN 0068010084","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010084"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010085\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010085\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010085","GLAccount_NodeID":":CACN 0068010085","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010085"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010086\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010086\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010086","GLAccount_NodeID":":CACN 0068010086","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010086"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010087\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010087\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010087","GLAccount_NodeID":":CACN 0068010087","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010087"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010088\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010088\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010088","GLAccount_NodeID":":CACN 0068010088","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010088"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010089\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010089\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010089","GLAccount_NodeID":":CACN 0068010089","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010089"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010090\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010090\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010090","GLAccount_NodeID":":CACN 0068010090","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010090"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010091\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010091\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010091","GLAccount_NodeID":":CACN 0068010091","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010091"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010092\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010092\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010092","GLAccount_NodeID":":CACN 0068010092","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010092"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010093\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010093\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010093","GLAccount_NodeID":":CACN 0068010093","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010093"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010094\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010094\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010094","GLAccount_NodeID":":CACN 0068010094","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010094"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010095\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010095\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010095","GLAccount_NodeID":":CACN 0068010095","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010095"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010096\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010096\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010096","GLAccount_NodeID":":CACN 0068010096","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010096"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010097\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010097\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010097","GLAccount_NodeID":":CACN 0068010097","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010097"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010098\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010098\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010098","GLAccount_NodeID":":CACN 0068010098","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010098"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010099\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010099\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010099","GLAccount_NodeID":":CACN 0068010099","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010099"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010100\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010100\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010100","GLAccount_NodeID":":CACN 0068010100","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010100"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010101\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010101\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010101","GLAccount_NodeID":":CACN 0068010101","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010101"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010102\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010102\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010102","GLAccount_NodeID":":CACN 0068010102","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010102"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010103\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010103\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010103","GLAccount_NodeID":":CACN 0068010103","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010103"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010104\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010104\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010104","GLAccount_NodeID":":CACN 0068010104","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010104"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010105\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010105\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010105","GLAccount_NodeID":":CACN 0068010105","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010105"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010106\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010106\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010106","GLAccount_NodeID":":CACN 0068010106","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010106"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010107\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010107\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010107","GLAccount_NodeID":":CACN 0068010107","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010107"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010108\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010108\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010108","GLAccount_NodeID":":CACN 0068010108","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010108"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010109\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010109\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010109","GLAccount_NodeID":":CACN 0068010109","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010109"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010110\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010110\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010110","GLAccount_NodeID":":CACN 0068010110","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010110"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010111\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010111\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010111","GLAccount_NodeID":":CACN 0068010111","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010111"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010112\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010112\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010112","GLAccount_NodeID":":CACN 0068010112","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010112"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010113\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010113\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010113","GLAccount_NodeID":":CACN 0068010113","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010113"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010114\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010114\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010114","GLAccount_NodeID":":CACN 0068010114","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010114"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010115\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010115\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010115","GLAccount_NodeID":":CACN 0068010115","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010115"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010116\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010116\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010116","GLAccount_NodeID":":CACN 0068010116","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010116"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010117\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010117\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010117","GLAccount_NodeID":":CACN 0068010117","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010117"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010118\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010118\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010118","GLAccount_NodeID":":CACN 0068010118","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010118"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010119\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010119\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010119","GLAccount_NodeID":":CACN 0068010119","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010119"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010120\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010120\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010120","GLAccount_NodeID":":CACN 0068010120","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010120"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010121\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010121\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010121","GLAccount_NodeID":":CACN 0068010121","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010121"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010122\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010122\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010122","GLAccount_NodeID":":CACN 0068010122","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010122"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010123\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACN%200068010123\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"68010123","GLAccount_NodeID":":CACN 0068010123","GLAccount_NodeText":"TEST","GLAccount_ParentID":"RangeNode:612       99990001990068010000-0068019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"TEST","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACN 0068010123"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999613\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.13.0.0_IEQCACNIEQ999952372%3A9999613\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:9999613","GLAccount_NodeText":"Adjustment for prior year","GLAccount_ParentID":"FinancialStatementItem:999961","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.13.0.0_IEQCACNIEQ999952372:9999613"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A613%20%20%20%20%20%20%2099990002020069010005-0069019999\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.47.0.0_IEQCACNIEQ999952371%3A613%20%20%20%20%20%20%2099990002020069010005-0069019999\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:613       99990002020069010005-0069019999","GLAccount_NodeText":"0069010005-0069019999","GLAccount_ParentID":"FinancialStatementItem:9999613","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.47.0.0_IEQCACNIEQ999952371:613       99990002020069010005-0069019999"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"RangeNode:613       99990002020069010005-0069019999","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999949\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.12.0.0_IEQCACNIEQ999952372%3A999949\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:999949","GLAccount_NodeText":"Net income","GLAccount_ParentID":"FinancialStatementItem:99996","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.12.0.0_IEQCACNIEQ999952372:999949"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:999949","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99997\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99997\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99997","GLAccount_NodeText":"Not assigned accounts","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99997"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:99997","GLAccount_Level":1,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99998\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.11.0.0_IEQCACNIEQ999952372%3A99998\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:99998","GLAccount_NodeText":"Financial St. Notes","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"1.2.4.0.1.2.4.0:0.11.0.0_IEQCACNIEQ999952372:99998"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'1.2.4.0.1.2.4.0%3A0.16.0.0_IEQCACNIEQ9999%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:99998","GLAccount_Level":1,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"1.2.4.0.1.2.4.0:0.16.0.0_IEQCACNIEQ9999:CACNY0000000000"}]}}';

	// for testing expansion state after insert operation
	var sResultsUC1L4Top120 = '{"d":{"__count":"61","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000014195:001","GLAccount":"","GLAccount_NodeID":"GLAccountHierarchy:001","GLAccount_NodeText":"hierarchy state 01","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":59,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 1","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 1","GLAccount_NodeText":"001/1","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":37,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55050309\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55050309\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55050309","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55050309","GLAccount_NodeText":"001/UI55050309","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55618761\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55618761\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55618761","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55618761","GLAccount_NodeText":"001/UI55618761","GLAccount_ParentID":"FinancialStatementItem:001 UI55050309","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI55618761001%200000320000113100-0000113222\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI55618761001%200000320000113100-0000113222\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI55618761001 0000320000113100-0000113222","GLAccount":"","GLAccount_NodeID":"RangeNode:UI55618761001 0000320000113100-0000113222","GLAccount_NodeText":"0000113100-0000113222","GLAccount_ParentID":"FinancialStatementItem:001 UI55618761","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51383315\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51383315\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI51383315","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI51383315","GLAccount_NodeText":"001/UI51383315","GLAccount_ParentID":"FinancialStatementItem:001 UI55050309","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111111-0000111112\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111111-0000111112\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000111111-0000111112","GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000111111-0000111112","GLAccount_NodeText":"0000111111-0000111112","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000113333-0000113333\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000113333-0000113333\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000113333-0000113333","GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000113333-0000113333","GLAccount_NodeText":"0000113333-0000113333","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000331752737910-4942386402\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000331752737910-4942386402\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000331752737910-4942386402","GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000331752737910-4942386402","GLAccount_NodeText":"1752737910-4942386402","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57147891\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57147891\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57147891","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57147891","GLAccount_NodeText":"001/UI57147891","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":9,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE400000","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE400000","GLAccount_NodeText":"001/NODE400000","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE400001","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE400001","GLAccount_NodeText":"001/NODE400001","GLAccount_ParentID":"FinancialStatementItem:001 NODE400000","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53844872\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53844872\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI53844872","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI53844872","GLAccount_NodeText":"001/UI53844872","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE404040\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE404040\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE404040","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE404040","GLAccount_NodeText":"001/NODE404040","GLAccount_ParentID":"FinancialStatementItem:001 UI53844872","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE333333\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE333333\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE333333","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE333333","GLAccount_NodeText":"001/NODE333333","GLAccount_ParentID":"FinancialStatementItem:001 UI53844872","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58458721\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58458721\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58458721","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58458721","GLAccount_NodeText":"001/UI58458721","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI58458721","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI56978676\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI56978676\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI56978676","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI56978676","GLAccount_NodeText":"001/UI56978676","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI59427563\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI59427563\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI59427563","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI59427563","GLAccount_NodeText":"001/UI59427563","GLAccount_ParentID":"FinancialStatementItem:001 UI56978676","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57446534","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57446534","GLAccount_NodeText":"001/UI57446534","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":8,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51254370\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51254370\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI51254370","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI51254370","GLAccount_NodeText":"001/UI51254370","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI51254370","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55119750\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55119750\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55119750","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55119750","GLAccount_NodeText":"001/UI55119750","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54161203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54161203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI54161203","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI54161203","GLAccount_NodeText":"001/UI54161203","GLAccount_ParentID":"FinancialStatementItem:001 UI55119750","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58000599\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58000599\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58000599","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58000599","GLAccount_NodeText":"001/UI58000599","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI58000599","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54683202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54683202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI54683202","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI54683202","GLAccount_NodeText":"001/UI54683202","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI54683202","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000052372:001","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001","GLAccount_NodeText":"001/Not assigned","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI5TEST002","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI5TEST002","GLAccount_NodeText":"001/UI5TEST002","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI5TEST002","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1:0.15.0.0.0_IEQCACNIEQ0010000052372:001 NOTE1","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NOTE1","GLAccount_NodeText":"NOTE1","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58014693\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58014693\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58014693","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58014693","GLAccount_NodeText":"001/UI58014693","GLAccount_ParentID":"FinancialStatementItem:001 NOTE1","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58075208\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58075208\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58075208","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58075208","GLAccount_NodeText":"001/UI58075208","GLAccount_ParentID":"FinancialStatementItem:001 UI58014693","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI5TEST001","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI5TEST001","GLAccount_NodeText":"001/UI5TEST001","GLAccount_ParentID":"FinancialStatementItem:001 NOTE1","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58051030\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58051030\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58051030","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58051030","GLAccount_NodeText":"001/UI58051030","GLAccount_ParentID":"FinancialStatementItem:001 UI5TEST001","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1:0.15.0.0.0_IEQCACNIEQ0010000052372:001 NOTE2","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NOTE2","GLAccount_NodeText":"NOTE2","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 NOTE2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 2","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 2","GLAccount_NodeText":"001/2","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 2","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 3","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 3","GLAccount_NodeText":"001/3","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 3","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 4","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 4","GLAccount_NodeText":"001/4","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 4","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 5","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 5","GLAccount_NodeText":"001/5","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 5","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 6","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 6","GLAccount_NodeText":"Liability","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":7,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57202667\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57202667\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57202667","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57202667","GLAccount_NodeText":"001/UI57202667","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI57202667","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ0010000052372:001 EQUITY1","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 EQUITY1","GLAccount_NodeText":"Equity1","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53447609\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53447609\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI53447609","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI53447609","GLAccount_NodeText":"001/UI53447609","GLAccount_ParentID":"FinancialStatementItem:001 EQUITY1","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI53447609","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ0010000052372:001 EQUITY2","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 EQUITY2","GLAccount_NodeText":"Equity2","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 EQUITY2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 7","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 7","GLAccount_NodeText":"Assets","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 ASSET1","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 ASSET1","GLAccount_NodeText":"asset1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 ASSET1","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 ASSET2","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 ASSET2","GLAccount_NodeText":"asset2","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":""},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000","GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 ASSET2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ001000002000000502:REST_H","GLAccount":"","GLAccount_NodeID":"1HIER_REST:REST_H","GLAccount_NodeText":"Not Assigned G/L Account (s)","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":""}]}}';
	var sResultsAfterCreateUC1NODE111114 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'i2uraf135q\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'i2uraf135q\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"i2uraf135q","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000111113-0000111114","GLAccount_NodeIDExt":"RANGE:0000111113-0000111114","GLAccount_NodeText":"","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":0,"GLAccount_PreorderPosition":6,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'\')/Parameters"}}}}';
	var sResultsUC1PrePosNODE111114 = '{"d":{"__count":"1","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111113-0000111114\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111113-0000111114\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"RangeNode:UI51383315001 0000330000111113-0000111114","GLAccount_PreorderPosition":7,"GLAccount_Drillstate":"collapsed","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000111113-0000111114"}]}}';
	var sResultsUC1L4Top62 = '{"d":{"__count":"62","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"GLAccountHierarchy:001","GLAccount_NodeText":"hierarchy state 01","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":60,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000014195:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 1","GLAccount_NodeText":"001/1","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":38,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55050309\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55050309\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55050309","GLAccount_NodeText":"001/UI55050309","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":7,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55050309"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55618761\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55618761\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55618761","GLAccount_NodeText":"001/UI55618761","GLAccount_ParentID":"FinancialStatementItem:001 UI55050309","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55618761"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI55618761001%200000320000113100-0000113222\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI55618761001%200000320000113100-0000113222\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI55618761001 0000320000113100-0000113222","GLAccount_NodeText":"0000113100-0000113222","GLAccount_ParentID":"FinancialStatementItem:001 UI55618761","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI55618761001 0000320000113100-0000113222"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51383315\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51383315\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI51383315","GLAccount_NodeText":"001/UI51383315","GLAccount_ParentID":"FinancialStatementItem:001 UI55050309","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI51383315"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111111-0000111112\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111111-0000111112\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000111111-0000111112","GLAccount_NodeText":"0000111111-0000111112","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000111111-0000111112"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111113-0000111114\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111113-0000111114\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000111113-0000111114","GLAccount_NodeText":"0000111113-0000111114","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000111113-0000111114"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000113333-0000113333\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000113333-0000113333\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000113333-0000113333","GLAccount_NodeText":"0000113333-0000113333","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000113333-0000113333"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000331752737910-4942386402\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000331752737910-4942386402\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000331752737910-4942386402","GLAccount_NodeText":"1752737910-4942386402","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000331752737910-4942386402"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57147891\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57147891\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57147891","GLAccount_NodeText":"001/UI57147891","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":9,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57147891"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE400000","GLAccount_NodeText":"001/NODE400000","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE400000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE400001","GLAccount_NodeText":"001/NODE400001","GLAccount_ParentID":"FinancialStatementItem:001 NODE400000","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE400001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53844872\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53844872\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI53844872","GLAccount_NodeText":"001/UI53844872","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI53844872"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE404040\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE404040\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE404040","GLAccount_NodeText":"001/NODE404040","GLAccount_ParentID":"FinancialStatementItem:001 UI53844872","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE404040"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE333333\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE333333\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE333333","GLAccount_NodeText":"001/NODE333333","GLAccount_ParentID":"FinancialStatementItem:001 UI53844872","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE333333"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58458721\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58458721\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58458721","GLAccount_NodeText":"001/UI58458721","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58458721"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI58458721","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI56978676\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI56978676\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI56978676","GLAccount_NodeText":"001/UI56978676","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI56978676"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI59427563\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI59427563\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI59427563","GLAccount_NodeText":"001/UI59427563","GLAccount_ParentID":"FinancialStatementItem:001 UI56978676","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI59427563"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57446534","GLAccount_NodeText":"001/UI57446534","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":8,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57446534"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51254370\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51254370\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI51254370","GLAccount_NodeText":"001/UI51254370","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI51254370"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI51254370","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55119750\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55119750\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55119750","GLAccount_NodeText":"001/UI55119750","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55119750"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54161203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54161203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI54161203","GLAccount_NodeText":"001/UI54161203","GLAccount_ParentID":"FinancialStatementItem:001 UI55119750","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI54161203"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58000599\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58000599\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58000599","GLAccount_NodeText":"001/UI58000599","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58000599"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI58000599","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54683202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54683202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI54683202","GLAccount_NodeText":"001/UI54683202","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI54683202"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI54683202","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001","GLAccount_NodeText":"001/Not assigned","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000052372:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI5TEST002","GLAccount_NodeText":"001/UI5TEST002","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI5TEST002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI5TEST002","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NOTE1","GLAccount_NodeText":"NOTE1","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1:0.15.0.0.0_IEQCACNIEQ0010000052372:001 NOTE1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58014693\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58014693\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58014693","GLAccount_NodeText":"001/UI58014693","GLAccount_ParentID":"FinancialStatementItem:001 NOTE1","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58014693"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58075208\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58075208\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58075208","GLAccount_NodeText":"001/UI58075208","GLAccount_ParentID":"FinancialStatementItem:001 UI58014693","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58075208"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI5TEST001","GLAccount_NodeText":"001/UI5TEST001","GLAccount_ParentID":"FinancialStatementItem:001 NOTE1","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI5TEST001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58051030\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58051030\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58051030","GLAccount_NodeText":"001/UI58051030","GLAccount_ParentID":"FinancialStatementItem:001 UI5TEST001","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58051030"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NOTE2","GLAccount_NodeText":"NOTE2","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1:0.15.0.0.0_IEQCACNIEQ0010000052372:001 NOTE2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 NOTE2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 2","GLAccount_NodeText":"001/2","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 2","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 3","GLAccount_NodeText":"001/3","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 3","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 4","GLAccount_NodeText":"001/4","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 4","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 5","GLAccount_NodeText":"001/5","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 5"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 5","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 6","GLAccount_NodeText":"Liability","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":7,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57202667\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57202667\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57202667","GLAccount_NodeText":"001/UI57202667","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57202667"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI57202667","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 EQUITY1","GLAccount_NodeText":"Equity1","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ0010000052372:001 EQUITY1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53447609\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53447609\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI53447609","GLAccount_NodeText":"001/UI53447609","GLAccount_ParentID":"FinancialStatementItem:001 EQUITY1","GLAccount_Level":3,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI53447609"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI53447609","GLAccount_Level":4,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 EQUITY2","GLAccount_NodeText":"Equity2","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ0010000052372:001 EQUITY2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 EQUITY2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 7","GLAccount_NodeText":"Assets","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 ASSET1","GLAccount_NodeText":"asset1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 ASSET1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 ASSET1","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 ASSET2","GLAccount_NodeText":"asset2","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 ASSET2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 ASSET2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"1HIER_REST:REST_H","GLAccount_NodeText":"Not Assigned G/L Account (s)","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ001000002000000502:REST_H"}]}}';

	// use case 2
	var sResultsUC2L3Top120 = '{"d":{"__count":"45","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"GLAccountHierarchy:001","GLAccount_NodeText":"hierarchy state 01","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":43,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000014195:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 1","GLAccount_NodeText":"001/1","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":22,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55050309\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55050309\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55050309","GLAccount_NodeText":"001/UI55050309","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55050309"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55618761\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55618761\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55618761","GLAccount_NodeText":"001/UI55618761","GLAccount_ParentID":"FinancialStatementItem:001 UI55050309","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55618761"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51383315\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51383315\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI51383315","GLAccount_NodeText":"001/UI51383315","GLAccount_ParentID":"FinancialStatementItem:001 UI55050309","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI51383315"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57147891\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57147891\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57147891","GLAccount_NodeText":"001/UI57147891","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57147891"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE400000","GLAccount_NodeText":"001/NODE400000","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE400000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53844872\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53844872\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI53844872","GLAccount_NodeText":"001/UI53844872","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI53844872"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58458721\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58458721\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58458721","GLAccount_NodeText":"001/UI58458721","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58458721"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI56978676\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI56978676\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI56978676","GLAccount_NodeText":"001/UI56978676","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI56978676"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57446534","GLAccount_NodeText":"001/UI57446534","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57446534"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51254370\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51254370\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI51254370","GLAccount_NodeText":"001/UI51254370","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI51254370"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55119750\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55119750\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55119750","GLAccount_NodeText":"001/UI55119750","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55119750"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58000599\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58000599\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58000599","GLAccount_NodeText":"001/UI58000599","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58000599"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54683202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54683202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI54683202","GLAccount_NodeText":"001/UI54683202","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI54683202"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001","GLAccount_NodeText":"001/Not assigned","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000052372:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI5TEST002","GLAccount_NodeText":"001/UI5TEST002","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI5TEST002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI5TEST002","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NOTE1","GLAccount_NodeText":"NOTE1","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1:0.15.0.0.0_IEQCACNIEQ0010000052372:001 NOTE1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58014693\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58014693\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58014693","GLAccount_NodeText":"001/UI58014693","GLAccount_ParentID":"FinancialStatementItem:001 NOTE1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58014693"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI5TEST001","GLAccount_NodeText":"001/UI5TEST001","GLAccount_ParentID":"FinancialStatementItem:001 NOTE1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI5TEST001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NOTE2","GLAccount_NodeText":"NOTE2","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1:0.15.0.0.0_IEQCACNIEQ0010000052372:001 NOTE2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 NOTE2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 2","GLAccount_NodeText":"001/2","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 2","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 3","GLAccount_NodeText":"001/3","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 3","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 4","GLAccount_NodeText":"001/4","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 4","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 5","GLAccount_NodeText":"001/5","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 5"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 5","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 6","GLAccount_NodeText":"Liability","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57202667\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57202667\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57202667","GLAccount_NodeText":"001/UI57202667","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57202667"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI57202667","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 EQUITY1","GLAccount_NodeText":"Equity1","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ0010000052372:001 EQUITY1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53447609\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53447609\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI53447609","GLAccount_NodeText":"001/UI53447609","GLAccount_ParentID":"FinancialStatementItem:001 EQUITY1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI53447609"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 EQUITY2","GLAccount_NodeText":"Equity2","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ0010000052372:001 EQUITY2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 EQUITY2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 7","GLAccount_NodeText":"Assets","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 ASSET1","GLAccount_NodeText":"asset1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 ASSET1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 ASSET1","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 ASSET2","GLAccount_NodeText":"asset2","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 ASSET2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 ASSET2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"1HIER_REST:REST_H","GLAccount_NodeText":"Not Assigned G/L Account (s)","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ001000002000000502:REST_H"}]}}';
	var sResultsUC2Top120ParentUI51383315 = '{"d":{"__count":"4","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111111-0000111112\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111111-0000111112\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000111111-0000111112","GLAccount_NodeText":"0000111111-0000111112","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000111111-0000111112"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111113-0000111114\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111113-0000111114\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000111113-0000111114","GLAccount_NodeText":"0000111113-0000111114","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000111113-0000111114"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000113333-0000113333\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000113333-0000113333\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000113333-0000113333","GLAccount_NodeText":"0000113333-0000113333","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000113333-0000113333"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000331752737910-4942386402\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000331752737910-4942386402\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000331752737910-4942386402","GLAccount_NodeText":"1752737910-4942386402","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000331752737910-4942386402"}]}}';
	var sResultsUC2SibPosNode1 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'312qofjbd9\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'312qofjbd9\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_SiblingsPosition":0,"Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'\')/Parameters"}},"ID":"312qofjbd9"}}';
	var sResultsAfterCreateUC2NODE113334 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'14t10bv38u\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'14t10bv38u\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"14t10bv38u","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000113334-","GLAccount_NodeIDExt":"RANGE:0000113334:0000113334","GLAccount_NodeText":"","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":0,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'\')/Parameters"}}}}';
	var sResultsUC2L3Top45 = '{"d":{"__count":"45","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"GLAccountHierarchy:001","GLAccount_NodeText":"hierarchy state 01","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":43,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000014195:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 1","GLAccount_NodeText":"001/1","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":22,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55050309\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55050309\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55050309","GLAccount_NodeText":"001/UI55050309","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55050309"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55618761\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55618761\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55618761","GLAccount_NodeText":"001/UI55618761","GLAccount_ParentID":"FinancialStatementItem:001 UI55050309","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55618761"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51383315\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51383315\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI51383315","GLAccount_NodeText":"001/UI51383315","GLAccount_ParentID":"FinancialStatementItem:001 UI55050309","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI51383315"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57147891\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57147891\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57147891","GLAccount_NodeText":"001/UI57147891","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57147891"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE400000","GLAccount_NodeText":"001/NODE400000","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE400000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53844872\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53844872\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI53844872","GLAccount_NodeText":"001/UI53844872","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI53844872"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58458721\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58458721\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58458721","GLAccount_NodeText":"001/UI58458721","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58458721"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI56978676\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI56978676\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI56978676","GLAccount_NodeText":"001/UI56978676","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI56978676"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57446534","GLAccount_NodeText":"001/UI57446534","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57446534"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51254370\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51254370\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI51254370","GLAccount_NodeText":"001/UI51254370","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI51254370"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55119750\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55119750\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55119750","GLAccount_NodeText":"001/UI55119750","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55119750"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58000599\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58000599\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58000599","GLAccount_NodeText":"001/UI58000599","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58000599"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54683202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54683202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI54683202","GLAccount_NodeText":"001/UI54683202","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI54683202"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001","GLAccount_NodeText":"001/Not assigned","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000052372:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI5TEST002","GLAccount_NodeText":"001/UI5TEST002","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI5TEST002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI5TEST002","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NOTE1","GLAccount_NodeText":"NOTE1","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1:0.15.0.0.0_IEQCACNIEQ0010000052372:001 NOTE1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58014693\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58014693\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58014693","GLAccount_NodeText":"001/UI58014693","GLAccount_ParentID":"FinancialStatementItem:001 NOTE1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58014693"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI5TEST001","GLAccount_NodeText":"001/UI5TEST001","GLAccount_ParentID":"FinancialStatementItem:001 NOTE1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI5TEST001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NOTE2","GLAccount_NodeText":"NOTE2","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1:0.15.0.0.0_IEQCACNIEQ0010000052372:001 NOTE2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 NOTE2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 2","GLAccount_NodeText":"001/2","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 2","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 3","GLAccount_NodeText":"001/3","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 3","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 4","GLAccount_NodeText":"001/4","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 4","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 5","GLAccount_NodeText":"001/5","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 5"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 5","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 6","GLAccount_NodeText":"Liability","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57202667\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57202667\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57202667","GLAccount_NodeText":"001/UI57202667","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57202667"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI57202667","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 EQUITY1","GLAccount_NodeText":"Equity1","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ0010000052372:001 EQUITY1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53447609\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53447609\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI53447609","GLAccount_NodeText":"001/UI53447609","GLAccount_ParentID":"FinancialStatementItem:001 EQUITY1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI53447609"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 EQUITY2","GLAccount_NodeText":"Equity2","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ0010000052372:001 EQUITY2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 EQUITY2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 7","GLAccount_NodeText":"Assets","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 ASSET1","GLAccount_NodeText":"asset1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 ASSET1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 ASSET1","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 ASSET2","GLAccount_NodeText":"asset2","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 ASSET2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 ASSET2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"1HIER_REST:REST_H","GLAccount_NodeText":"Not Assigned G/L Account (s)","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ001000002000000502:REST_H"}]}}';
	var sResultsUC2Top5ParentUI51383315 = '{"d":{"__count":"5","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111111-0000111112\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111111-0000111112\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000111111-0000111112","GLAccount_NodeText":"0000111111-0000111112","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000111111-0000111112"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111113-0000111114\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000111113-0000111114\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000111113-0000111114","GLAccount_NodeText":"0000111113-0000111114","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000111113-0000111114"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000113333-0000113333\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000113333-0000113333\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000113333-0000113333","GLAccount_NodeText":"0000113333-0000113333","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000113333-0000113333"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.55.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.37.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000113334-\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.55.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.37.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000330000113334-\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000330000113334-","GLAccount_NodeText":"0000330000113334-","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.55.0_1.2.4.0.1.2.3.0.1.2.1.1:0.37.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000330000113334-"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000331752737910-4942386402\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3AUI51383315001%200000331752737910-4942386402\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:UI51383315001 0000331752737910-4942386402","GLAccount_NodeText":"1752737910-4942386402","GLAccount_ParentID":"FinancialStatementItem:001 UI51383315","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:UI51383315001 0000331752737910-4942386402"}]}}';

	// use case 3
	var sResultsUC3L3Top120 = sResultsUC2L3Top120;
	var sResultsUC3Top120ParentUI53844872 = '{"d":{"__count":"2","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE404040\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE404040\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE404040","GLAccount_NodeText":"001/NODE404040","GLAccount_ParentID":"FinancialStatementItem:001 UI53844872","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE404040"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE333333\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE333333\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE333333","GLAccount_NodeText":"001/NODE333333","GLAccount_ParentID":"FinancialStatementItem:001 UI53844872","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE333333"}]}}';
	var sResultsAfterCreateUC3NODE333444 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'xccw7jnhn6\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'xccw7jnhn6\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"xccw7jnhn6","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE333444","GLAccount_NodeIDExt":"FSI:NODE333444","GLAccount_NodeText":"","GLAccount_ParentID":"FinancialStatementItem:001 UI53844872","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":0,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'\')/Parameters"}}}}';
	var sResultsAfterCreateUC3RANGE333444 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'97qiqdppge\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'97qiqdppge\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"97qiqdppge","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"RangeNode:NODE333444001 0000380000333444-0000333444","GLAccount_NodeIDExt":"RANGE:0000333444-000333444","GLAccount_NodeText":"","GLAccount_ParentID":"id-1512641814218-76","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":0,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'\')/Parameters"}}}}';
	var sResultsUC3L3Top45 = sResultsUC2L3Top45;
	var sResultsUC3Top3ParentUI53844872 = '{"d":{"__count":"3","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE333444\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE333444\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE333444","GLAccount_NodeText":"001/NODE333444","GLAccount_ParentID":"FinancialStatementItem:001 UI53844872","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE333444"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE404040\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE404040\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE404040","GLAccount_NodeText":"001/NODE404040","GLAccount_ParentID":"FinancialStatementItem:001 UI53844872","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE404040"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE333333\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE333333\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE333333","GLAccount_NodeText":"001/NODE333333","GLAccount_ParentID":"FinancialStatementItem:001 UI53844872","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE333333"}]}}';

	// use case 4
	var sResultsUC4L3Top120 = sResultsUC2L3Top120;
	var sResultsAfterCreateUC4NODE500000 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE500000","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE500000","GLAccount_NodeIDExt":"FSI:NODE500000","GLAccount_NodeText":"","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_PreorderPosition":6,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500000\')/Parameters"}}}}';
	var sResultsAfterCreateUC4NODE500001 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE500001","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE500001","GLAccount_NodeIDExt":"FSI:NODE500001","GLAccount_NodeText":"","GLAccount_ParentID":"id-1512647832935-103","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":0,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500001\')/Parameters"}}}}';
	var sResultsAfterCreateUC4RANGE500001 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE500001001%200000360000500001-0000500001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE500001001%200000360000500001-0000500001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:NODE500001001 0000360000500001-0000500001","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"RangeNode:NODE500001001 0000360000500001-0000500001","GLAccount_NodeIDExt":"RANGE:0000500001-0000500001","GLAccount_NodeText":"","GLAccount_ParentID":"id-1512647854230-112","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":0,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE500001001%200000360000500001-0000500001\')/Parameters"}}}}';
	var sResultsAfterCreateUC4RANGE500002 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE500001001%200000360000500002-0000500002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE500001001%200000360000500002-0000500002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:NODE500001001 0000360000500002-0000500002","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"RangeNode:NODE500001001 0000360000500002-0000500002","GLAccount_NodeIDExt":"RANGE:0000500002-0000500002","GLAccount_NodeText":"","GLAccount_ParentID":"id-1512647854230-112","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":1,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE500001001%200000360000500002-0000500002\')/Parameters"}}}}';
	var sResultsUC4PrePosNODE500000 = '{"d":{"__count":"1","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 NODE500000","GLAccount_PreorderPosition":6,"GLAccount_Drillstate":"collapsed","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE500000"}]}}';
	var sResultsUC4L3Top46 = '{"d":{"__count":"46","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"GLAccountHierarchy:001","GLAccount_NodeText":"hierarchy state 01","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":44,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000014195:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 1","GLAccount_NodeText":"001/1","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":23,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55050309\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55050309\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55050309","GLAccount_NodeText":"001/UI55050309","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55050309"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55618761\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55618761\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55618761","GLAccount_NodeText":"001/UI55618761","GLAccount_ParentID":"FinancialStatementItem:001 UI55050309","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55618761"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51383315\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51383315\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI51383315","GLAccount_NodeText":"001/UI51383315","GLAccount_ParentID":"FinancialStatementItem:001 UI55050309","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI51383315"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57147891\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57147891\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57147891","GLAccount_NodeText":"001/UI57147891","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":5,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57147891"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE500000","GLAccount_NodeText":"001/NODE500000","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE500000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE400000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE400000","GLAccount_NodeText":"001/NODE400000","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE400000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53844872\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53844872\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI53844872","GLAccount_NodeText":"001/UI53844872","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI53844872"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58458721\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58458721\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58458721","GLAccount_NodeText":"001/UI58458721","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58458721"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI56978676\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI56978676\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI56978676","GLAccount_NodeText":"001/UI56978676","GLAccount_ParentID":"FinancialStatementItem:001 UI57147891","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI56978676"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57446534\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57446534","GLAccount_NodeText":"001/UI57446534","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57446534"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51254370\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI51254370\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI51254370","GLAccount_NodeText":"001/UI51254370","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI51254370"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55119750\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI55119750\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI55119750","GLAccount_NodeText":"001/UI55119750","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI55119750"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58000599\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58000599\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58000599","GLAccount_NodeText":"001/UI58000599","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58000599"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54683202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI54683202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI54683202","GLAccount_NodeText":"001/UI54683202","GLAccount_ParentID":"FinancialStatementItem:001 UI57446534","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI54683202"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001","GLAccount_NodeText":"001/Not assigned","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000052372:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI5TEST002","GLAccount_NodeText":"001/UI5TEST002","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI5TEST002"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI5TEST002","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NOTE1","GLAccount_NodeText":"NOTE1","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1:0.15.0.0.0_IEQCACNIEQ0010000052372:001 NOTE1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58014693\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI58014693\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI58014693","GLAccount_NodeText":"001/UI58014693","GLAccount_ParentID":"FinancialStatementItem:001 NOTE1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI58014693"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI5TEST001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI5TEST001","GLAccount_NodeText":"001/UI5TEST001","GLAccount_ParentID":"FinancialStatementItem:001 NOTE1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI5TEST001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.15.0.0.0_IEQCACNIEQ0010000052372%3A001%20NOTE2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NOTE2","GLAccount_NodeText":"NOTE2","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.33.0_1.2.4.0.1.2.3.0.1.2.1.1:0.15.0.0.0_IEQCACNIEQ0010000052372:001 NOTE2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 NOTE2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 2","GLAccount_NodeText":"001/2","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 2","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 3","GLAccount_NodeText":"001/3","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 3","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 4","GLAccount_NodeText":"001/4","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 4","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 5","GLAccount_NodeText":"001/5","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 5"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 5","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 6","GLAccount_NodeText":"Liability","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57202667\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI57202667\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI57202667","GLAccount_NodeText":"001/UI57202667","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI57202667"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 UI57202667","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 EQUITY1","GLAccount_NodeText":"Equity1","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ0010000052372:001 EQUITY1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53447609\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20UI53447609\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 UI53447609","GLAccount_NodeText":"001/UI53447609","GLAccount_ParentID":"FinancialStatementItem:001 EQUITY1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 UI53447609"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ0010000052372%3A001%20EQUITY2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 EQUITY2","GLAccount_NodeText":"Equity2","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ0010000052372:001 EQUITY2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 EQUITY2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 7","GLAccount_NodeText":"Assets","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 ASSET1","GLAccount_NodeText":"asset1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 ASSET1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 ASSET1","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20ASSET2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 ASSET2","GLAccount_NodeText":"asset2","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 ASSET2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 ASSET2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"1HIER_REST:REST_H","GLAccount_NodeText":"Not Assigned G/L Account (s)","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ001000002000000502:REST_H"}]}}';
	var sResultsUC4Top1ParentNODE500000 = '{"d":{"__count":"1","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE500001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE500001","GLAccount_NodeText":"001/NODE500001","GLAccount_ParentID":"FinancialStatementItem:001 NODE500000","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE500001"}]}}';
	var sResultsUC4Top2ParentNODE500001 = '{"d":{"__count":"2","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE500001001%200000360000500001-0000500001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE500001001%200000360000500001-0000500001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:NODE500001001 0000360000500001-0000500001","GLAccount_NodeText":"0000500001-0000500001","GLAccount_ParentID":"FinancialStatementItem:001 NODE500001","GLAccount_Level":5,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:NODE500001001 0000360000500001-0000500001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE500001001%200000360000500002-0000500002\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE500001001%200000360000500002-0000500002\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:NODE500001001 0000360000500002-0000500002","GLAccount_NodeText":"0000500002-0000500002","GLAccount_ParentID":"FinancialStatementItem:001 NODE500001","GLAccount_Level":5,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:NODE500001001 0000360000500002-0000500002"}]}}';

	// use case 4b
	var sResultsUC4bL3Top120 = '{"d":{"__count":"34","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"GLAccountHierarchy:001","GLAccount_NodeText":"hierarchy state 001","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":32,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000014195:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 1","GLAccount_NodeText":"001/1","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 2","GLAccount_NodeText":"001/2","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 2","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 3","GLAccount_NodeText":"001/3","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 3","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 4","GLAccount_NodeText":"001/4","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 4","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 5","GLAccount_NodeText":"001/5","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 5"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 5","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 6","GLAccount_NodeText":"Liability","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":14,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE987654\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE987654\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE987654","GLAccount_NodeText":"001/NODE987654","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE987654"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE987653\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE987653\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE987653","GLAccount_NodeText":"001/NODE987653","GLAccount_ParentID":"FinancialStatementItem:001 NODE987654","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE987653"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B1","GLAccount_NodeText":"1","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B6\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B6\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B6","GLAccount_NodeText":"001/B6","GLAccount_ParentID":"FinancialStatementItem:001 B1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B4\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B4\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B4","GLAccount_NodeText":"001/B4","GLAccount_ParentID":"FinancialStatementItem:001 B1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B2","GLAccount_NodeText":"2","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B8\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B8\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B8","GLAccount_NodeText":"001/B8","GLAccount_ParentID":"FinancialStatementItem:001 B2","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B8"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B7\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B7\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B7","GLAccount_NodeText":"001/B7","GLAccount_ParentID":"FinancialStatementItem:001 B2","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B3","GLAccount_NodeText":"3","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":5,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B35\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B35\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B35","GLAccount_NodeText":"001/B35","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B35"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B34\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B34\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B34","GLAccount_NodeText":"001/B34","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B34"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B33\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B33\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B33","GLAccount_NodeText":"001/B33","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B33"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B32\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B32\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B32","GLAccount_NodeText":"001/B32","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B32"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B31\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B31\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B31","GLAccount_NodeText":"001/B31","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B31"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 7","GLAccount_NodeText":"Assets","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001","GLAccount_NodeText":"001/Not assigned","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000052372:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 A1","GLAccount_NodeText":"1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 A1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 A1","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 A3","GLAccount_NodeText":"3","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 A3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 A3","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"1HIER_REST:REST_H","GLAccount_NodeText":"Not Assigned G/L Account (s)","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ001000002000000502:REST_H"}]}}';
	var sResultsAfterCreateUC4bNODE40090 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40090\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40090\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1:0.19.0.0.0_IEQCACNIEQ0010000052372:001 NODE40090","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE40090","GLAccount_NodeIDExt":"FSI:NODE40090","GLAccount_NodeText":"","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":0,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'\')/Parameters"}}}}';
	var sResultsAfterCreateUC4bNODE40091 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40091\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40091\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1:0.19.0.0.0_IEQCACNIEQ0010000052372:001 NODE40091","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE40091","GLAccount_NodeIDExt":"FSI:NODE40091","GLAccount_NodeText":"","GLAccount_ParentID":"FinancialStatementItem:001 NODE40090","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":0,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'\')/Parameters"}}}}';
	var sResultsAfterCreateUC4bRANGE400090 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'c\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'c\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"c","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"RangeNode:NODE40091 001 0000090000400090-0000400091","GLAccount_NodeIDExt":"RANGE:0000400090-0000400091","GLAccount_NodeText":"","GLAccount_ParentID":"FinancialStatementItem:001 NODE40091","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":0,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'\')/Parameters"}}}}';
	var sResultsAfterCreateUC4bRANGE400092 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'d\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'d\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"d","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"RangeNode:NODE40091 001 0000090000400092-0000400093","GLAccount_NodeIDExt":"RANGE:0000400092-0000400093","GLAccount_NodeText":"","GLAccount_ParentID":"FinancialStatementItem:001 NODE40091","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":1,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'\')/Parameters"}}}}';
	var sResultsUC4bPrePosNODE40090 = '{"d":{"__count":"1","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40090\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40090\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 NODE40090","GLAccount_PreorderPosition":12,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1:0.19.0.0.0_IEQCACNIEQ0010000052372:001 NODE40090"}]}}';
	var sResultsUC4bPrePosNODE40091 = '{"d":{"__count":"1","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40091\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40091\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 NODE40091","GLAccount_PreorderPosition":13,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1:0.19.0.0.0_IEQCACNIEQ0010000052372:001 NODE40091"}]}}';
	var sResultsUC4bL3Top36 = '{"d":{"__count":"36","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"GLAccountHierarchy:001","GLAccount_NodeText":"hierarchy state 001","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":34,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000014195:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 1","GLAccount_NodeText":"001/1","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 2","GLAccount_NodeText":"001/2","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 2","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 3","GLAccount_NodeText":"001/3","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 3","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 4","GLAccount_NodeText":"001/4","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 4","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 5","GLAccount_NodeText":"001/5","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 5"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 5","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 6","GLAccount_NodeText":"Liability","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":16,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40090\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40090\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE40090","GLAccount_NodeText":"001/NODE40090","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1:0.19.0.0.0_IEQCACNIEQ0010000052372:001 NODE40090"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40091\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.19.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE40091\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE40091","GLAccount_NodeText":"001/NODE40091","GLAccount_ParentID":"FinancialStatementItem:001 NODE40090","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.37.0_1.2.4.0.1.2.3.0.1.2.1.1:0.19.0.0.0_IEQCACNIEQ0010000052372:001 NODE40091"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE987654\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE987654\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE987654","GLAccount_NodeText":"001/NODE987654","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE987654"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE987653\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE987653\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE987653","GLAccount_NodeText":"001/NODE987653","GLAccount_ParentID":"FinancialStatementItem:001 NODE987654","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE987653"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B1","GLAccount_NodeText":"1","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B6\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B6\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B6","GLAccount_NodeText":"001/B6","GLAccount_ParentID":"FinancialStatementItem:001 B1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B4\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B4\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B4","GLAccount_NodeText":"001/B4","GLAccount_ParentID":"FinancialStatementItem:001 B1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B2","GLAccount_NodeText":"2","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B8\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B8\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B8","GLAccount_NodeText":"001/B8","GLAccount_ParentID":"FinancialStatementItem:001 B2","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B8"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B7\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B7\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B7","GLAccount_NodeText":"001/B7","GLAccount_ParentID":"FinancialStatementItem:001 B2","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B3","GLAccount_NodeText":"3","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":5,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B35\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B35\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B35","GLAccount_NodeText":"001/B35","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B35"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B34\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B34\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B34","GLAccount_NodeText":"001/B34","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B34"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B33\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B33\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B33","GLAccount_NodeText":"001/B33","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B33"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B32\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B32\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B32","GLAccount_NodeText":"001/B32","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B32"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B31\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B31\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B31","GLAccount_NodeText":"001/B31","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B31"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 7","GLAccount_NodeText":"Assets","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001","GLAccount_NodeText":"001/Not assigned","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000052372:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 A1","GLAccount_NodeText":"1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 A1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 A1","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 A3","GLAccount_NodeText":"3","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 A3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 A3","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"1HIER_REST:REST_H","GLAccount_NodeText":"Not Assigned G/L Account (s)","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ001000002000000502:REST_H"}]}}';
	var sResultsUC4bTop2ParentNODE40091 = '{"d":{"__count":"2","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE40091%20001%200000090000400090-0000400091\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE40091%20001%200000090000400090-0000400091\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:NODE40091 001 0000090000400090-0000400091","GLAccount_NodeText":"0000400090-0000400091","GLAccount_ParentID":"FinancialStatementItem:001 NODE40091","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:NODE40091 001 0000090000400090-0000400091"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE40091%20001%200000090000400092-0000400093\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.47.0.0.0_IEQCACNIEQ0010000052371%3ANODE40091%20001%200000090000400092-0000400093\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"RangeNode:NODE40091 001 0000090000400092-0000400093","GLAccount_NodeText":"0000400092-0000400093","GLAccount_ParentID":"FinancialStatementItem:001 NODE40091","GLAccount_Level":4,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.65.0_1.2.4.0.1.2.3.0.1.2.1.1:0.47.0.0.0_IEQCACNIEQ0010000052371:NODE40091 001 0000090000400092-0000400093"}]}}';

	// use case x3
	var sResultsUCx3L2Top120 = '{"d":{"__count":"23","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"GLAccountHierarchy:001","GLAccount_NodeText":"hierarchy state 01","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":21,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000014195:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 1","GLAccount_NodeText":"001/1","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_1","GLAccount_NodeText":"001/TEST_1","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 TEST_1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 2","GLAccount_NodeText":"001/2","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 2","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 3","GLAccount_NodeText":"001/3","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 3","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 4","GLAccount_NodeText":"001/4","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 4","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 5","GLAccount_NodeText":"001/5","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 5"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 5","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 6","GLAccount_NodeText":"Liability","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B1","GLAccount_NodeText":"1","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B2","GLAccount_NodeText":"2","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B3","GLAccount_NodeText":"3","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 7","GLAccount_NodeText":"Assets","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_7_3","GLAccount_NodeText":"001/TEST_7_3","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_7_3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_7_2","GLAccount_NodeText":"001/TEST_7_2","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_7_2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_7_1","GLAccount_NodeText":"001/TEST_7_1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_7_1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001","GLAccount_NodeText":"001/Not assigned","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000052372:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 A1","GLAccount_NodeText":"1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 A1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 A3","GLAccount_NodeText":"3","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 A3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"1HIER_REST:REST_H","GLAccount_NodeText":"Not Assigned G/L Account (s)","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ001000002000000502:REST_H"}]}}';
	var sResultsAfterCreateUCx3NODE123456 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'3u8atky9ya\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'3u8atky9ya\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"3u8atky9ya","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE123456","GLAccount_NodeIDExt":"FSI:NODE123456","GLAccount_NodeText":"","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_PreorderPosition":2,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'\')/Parameters"}}}}';
	var sResultsUCx3PrePosNODE123456 = '{"d":{"__count":"1","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE123456\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE123456\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 NODE123456","GLAccount_PreorderPosition":2,"GLAccount_Drillstate":"collapsed","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE123456"}]}}';
	var sResultsUCx3L2Top24 = '{"d":{"__count":"24","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"GLAccountHierarchy:001","GLAccount_NodeText":"hierarchy state 01","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":22,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000014195:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 1","GLAccount_NodeText":"001/1","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE123456\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE123456\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE123456","GLAccount_NodeText":"001/NODE123456","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE123456"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_1","GLAccount_NodeText":"001/TEST_1","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 TEST_1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 2","GLAccount_NodeText":"001/2","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 2","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 3","GLAccount_NodeText":"001/3","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 3","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 4","GLAccount_NodeText":"001/4","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 4","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 5","GLAccount_NodeText":"001/5","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 5"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 5","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 6","GLAccount_NodeText":"Liability","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B1","GLAccount_NodeText":"1","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B2","GLAccount_NodeText":"2","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B3","GLAccount_NodeText":"3","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 7","GLAccount_NodeText":"Assets","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_7_3","GLAccount_NodeText":"001/TEST_7_3","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_7_3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_7_2","GLAccount_NodeText":"001/TEST_7_2","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_7_2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_7_1","GLAccount_NodeText":"001/TEST_7_1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_7_1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001","GLAccount_NodeText":"001/Not assigned","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000052372:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 A1","GLAccount_NodeText":"1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 A1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 A3","GLAccount_NodeText":"3","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 A3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"1HIER_REST:REST_H","GLAccount_NodeText":"Not Assigned G/L Account (s)","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ001000002000000502:REST_H"}]}}';
	var sResultsUCx3L2Top1NodeIDNODE123456 = '{"d":{"results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE123456\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE123456\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 NODE123456","GLAccount_Nodecount":0,"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE123456"}]}}';

	// use case x4
	var sResultsUCx4L3Top120 = '{"d":{"__count":"39","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"GLAccountHierarchy:001","GLAccount_NodeText":"hierarchy state 01","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":37,"ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000014195:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 1","GLAccount_NodeText":"001/1","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 TEST_1","GLAccount_NodeText":"001/TEST_1","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 TEST_1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 TEST_1_3","GLAccount_NodeText":"001/TEST_1_3","GLAccount_ParentID":"FinancialStatementItem:001 TEST_1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_1_3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 TEST_1_2","GLAccount_NodeText":"001/TEST_1_2","GLAccount_ParentID":"FinancialStatementItem:001 TEST_1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_1_2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 TEST_1_1","GLAccount_NodeText":"001/TEST_1_1","GLAccount_ParentID":"FinancialStatementItem:001 TEST_1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_1_1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 2","GLAccount_NodeText":"001/2","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 2","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 3","GLAccount_NodeText":"001/3","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 3","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 4","GLAccount_NodeText":"001/4","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 4","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 5","GLAccount_NodeText":"001/5","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 5"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 5","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 6","GLAccount_NodeText":"Liability","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":10,"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 B1","GLAccount_NodeText":"1","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B4\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B4\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 B4","GLAccount_NodeText":"001/B4","GLAccount_ParentID":"FinancialStatementItem:001 B1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 B2","GLAccount_NodeText":"2","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B8\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B8\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 B8","GLAccount_NodeText":"001/B8","GLAccount_ParentID":"FinancialStatementItem:001 B2","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B8"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B7\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B7\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 B7","GLAccount_NodeText":"001/B7","GLAccount_ParentID":"FinancialStatementItem:001 B2","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 B3","GLAccount_NodeText":"3","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":4,"ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B34\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B34\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 B34","GLAccount_NodeText":"001/B34","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B34"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B33\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B33\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 B33","GLAccount_NodeText":"001/B33","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B33"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B32\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B32\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 B32","GLAccount_NodeText":"001/B32","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B32"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B31\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20B31\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 B31","GLAccount_NodeText":"001/B31","GLAccount_ParentID":"FinancialStatementItem:001 B3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 B31"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%207\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 7","GLAccount_NodeText":"Assets","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":12,"ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 7"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 TEST_7_3","GLAccount_NodeText":"001/TEST_7_3","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_7_3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 TEST_7_3","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 TEST_7_2","GLAccount_NodeText":"001/TEST_7_2","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_7_2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 TEST_7_2","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_7_1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 TEST_7_1","GLAccount_NodeText":"001/TEST_7_1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_7_1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 TEST_7_1","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000052372%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001","GLAccount_NodeText":"001/Not assigned","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000052372:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 A1","GLAccount_NodeText":"1","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 A1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 A1","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20A3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 A3","GLAccount_NodeText":"3","GLAccount_ParentID":"FinancialStatementItem:001 7","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 A3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20A21\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.13.0.0.0_IEQCACNIEQ0010000052372%3A001%20A21\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 A21","GLAccount_NodeText":"001/A21","GLAccount_ParentID":"FinancialStatementItem:001 A3","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.31.0_1.2.4.0.1.2.3.0.1.2.1.1:0.13.0.0.0_IEQCACNIEQ0010000052372:001 A21"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.17.0.0.0_IEQCACNIEQ001000002000000502%3AREST_H\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"1HIER_REST:REST_H","GLAccount_NodeText":"Not Assigned G/L Account (s)","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"ID":"V2.34.35.0_1.2.4.0.1.2.3.0.1.2.1.1:0.17.0.0.0_IEQCACNIEQ001000002000000502:REST_H"}]}}';
	var sResultsAfterCreateUCx4NODE000001 = '{"d":{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'cu59y0t37v\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'cu59y0t37v\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"ID":"cu59y0t37v","TotaledProperties":"","ChartOfAccounts":"","GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE000001","GLAccount_NodeIDExt":"FSI:NODE000001","GLAccount_NodeText":"","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":0,"GLAccount_Drillstate":"","GLAccount_Nodecount":0,"GLAccount_T":"","IsBalanceSheetAccount":"","GLAccountGroup":"","CorporateGroupAccount":"","ProfitLossAccountType":"","SampleGLAccount":"","AccountIsMarkedForDeletion":"","AccountIsBlockedForCreation":"","AccountIsBlockedForPosting":"","AccountIsBlockedForPlanning":"","PartnerCompany":"","FunctionalArea":"","FakeGLAccountFlag":"","GLAccount_SiblingsPosition":0,"Action":"","NodeType":"","counter":"0","counter_F":"","Parameters":{"__deferred":{"uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'\')/Parameters"}}}}';
	var sResultsUCx4PrePosNODE000001 = '{"d":{"__count":"1","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'cu59y0t37v\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'cu59y0t37v\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 NODE000001","GLAccount_PreorderPosition":2,"GLAccount_Drillstate":"expanded","ID":"cu59y0t37v","GLAccount_Nodecount":1}]}}';
	var sResultsUCx4L3Top1NodeIDNODE000001 = '{"d":{"results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE000001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE000001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount_NodeID":"FinancialStatementItem:001 NODE000001","GLAccount_Nodecount":2,"ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE000001"}]}}';
	var sResultsUCx4L3Top41 = '{"d":{"__count":"41","results":[{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.9.0.0.0_IEQCACNIEQ0010000014195%3A001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"GLAccountHierarchy:001","GLAccount_NodeText":"hierarchy state 01","GLAccount_ParentID":"","GLAccount_Level":0,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":39,"GLAccount_T":"","ID":"V2.33.27.0_1.2.4.0.1.2.3.0.1.2.1.1:0.9.0.0.0_IEQCACNIEQ0010000014195:001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%201\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 1","GLAccount_NodeText":"001/1","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":6,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE000001\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.20.0.0.0_IEQCACNIEQ0010000052372%3A001%20NODE000001\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 NODE000001","GLAccount_NodeText":"001/NODE000001","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.38.0_1.2.4.0.1.2.3.0.1.2.1.1:0.20.0.0.0_IEQCACNIEQ0010000052372:001 NODE000001"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 NODE000001","GLAccount_Level":3,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_1","GLAccount_NodeText":"001/TEST_1","GLAccount_ParentID":"FinancialStatementItem:001 1","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":3,"GLAccount_T":"","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ0010000052372:001 TEST_1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_3\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_3\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_1_3","GLAccount_NodeText":"001/TEST_1_3","GLAccount_ParentID":"FinancialStatementItem:001 TEST_1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_1_3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_1_2","GLAccount_NodeText":"001/TEST_1_2","GLAccount_ParentID":"FinancialStatementItem:001 TEST_1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_1_2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.18.0.0.0_IEQCACNIEQ0010000052372%3A001%20TEST_1_1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 TEST_1_1","GLAccount_NodeText":"001/TEST_1_1","GLAccount_ParentID":"FinancialStatementItem:001 TEST_1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.36.0_1.2.4.0.1.2.3.0.1.2.1.1:0.18.0.0.0_IEQCACNIEQ0010000052372:001 TEST_1_1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%202\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 2","GLAccount_NodeText":"001/2","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 2","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%203\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 3","GLAccount_NodeText":"001/3","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 3"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 3","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%204\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 4","GLAccount_NodeText":"001/4","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 4","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%205\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 5","GLAccount_NodeText":"001/5","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 5"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.16.0.0.0_IEQCACNIEQ00100000%3ACACNY0000000000\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"0","GLAccount_NodeID":":CACNY0000000000","GLAccount_NodeText":"CACN/Y/0","GLAccount_ParentID":"FinancialStatementItem:001 5","GLAccount_Level":2,"GLAccount_Drillstate":"leaf","GLAccount_Nodecount":0,"GLAccount_T":"CACN/Y/0","ID":"V2.34.34.0_1.2.4.0.1.2.3.0.1.2.1.1:0.16.0.0.0_IEQCACNIEQ00100000:CACNY0000000000"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.11.0.0.0_IEQCACNIEQ0010000052372%3A001%206\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 6","GLAccount_NodeText":"Liability","GLAccount_ParentID":"GLAccountHierarchy:001","GLAccount_Level":1,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":10,"GLAccount_T":"","ID":"V2.34.29.0_1.2.4.0.1.2.3.0.1.2.1.1:0.11.0.0.0_IEQCACNIEQ0010000052372:001 6"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B1\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B1","GLAccount_NodeText":"1","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":1,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B1"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B4\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B4\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B4","GLAccount_NodeText":"001/B4","GLAccount_ParentID":"FinancialStatementItem:001 B1","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B4"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B2\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B2","GLAccount_NodeText":"2","GLAccount_ParentID":"FinancialStatementItem:001 6","GLAccount_Level":2,"GLAccount_Drillstate":"expanded","GLAccount_Nodecount":2,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B2"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B8\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B8\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B8","GLAccount_NodeText":"001/B8","GLAccount_ParentID":"FinancialStatementItem:001 B2","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID":"V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1:0.12.0.0.0_IEQCACNIEQ0010000052372:001 B8"},{"__metadata":{"id":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B7\')","uri":"https://ponyhost/sap/opu/odata/sap/ZTJ_SFIN_HIERARCHY_02_SRV/ZTJ_G4_C_GLHIERResults(\'V2.34.30.0_1.2.4.0.1.2.3.0.1.2.1.1%3A0.12.0.0.0_IEQCACNIEQ0010000052372%3A001%20B7\')","type":"ZTJ_SFIN_HIERARCHY_02_SRV.ZTJ_G4_C_GLHIERResult"},"GLAccount":"","GLAccount_NodeID":"FinancialStatementItem:001 B7","GLAccount_NodeText":"001/B7","GLAccount_ParentID":"FinancialStatementItem:001 B2","GLAccount_Level":3,"GLAccount_Drillstate":"collapsed","GLAccount_Nodecount":0,"GLAccount_T":"","ID"