/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.util.Objects;
import java.util.logging.Level;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.UCPTimerTaskImpl;

class MetricsUpdateTimerTask
extends UCPTimerTaskImpl
implements Diagnosable {
    static final String CLASS_NAME = MetricsUpdateTimerTask.class.getName();
    private UniversalConnectionPoolManagerBase cpMgr = null;
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();

    MetricsUpdateTimerTask(Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
    }

    MetricsUpdateTimerTask() throws UniversalConnectionPoolException {
        this(DiagnosticsCollectorImpl.getCommon());
    }

    @Override
    public void run() {
        try {
            UniversalConnectionPoolManager mgr = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager(this.getDiagnosable());
            if (mgr instanceof UniversalConnectionPoolManagerBase) {
                this.cpMgr = (UniversalConnectionPoolManagerBase)mgr;
                this.cpMgr.updateMetricSensors();
            }
        }
        catch (UniversalConnectionPoolException e) {
            this.trace(Level.WARNING, CLASS_NAME, "run", "", null, e, new Object[0]);
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }
}

