/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.remotefiles;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.editor.api.index.HtmlIndex;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.RemoteFileCache;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class RemoteFiles {
    private static final RequestProcessor RP = new RequestProcessor(RemoteFiles.class);
    private final Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private List<URL> urls;
    private HtmlIndex index;
    private ChangeListener listener;

    public RemoteFiles(Project project) {
        this.project = project;
    }

    private synchronized HtmlIndex getHtmlIndex() {
        if (this.index == null) {
            try {
                this.index = HtmlIndex.get((Project)this.project);
                this.listener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        RemoteFiles.this.update();
                    }
                };
                this.index.addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)this.index));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.index;
    }

    private void update() {
        try {
            ParserManager.parseWhenScanFinished((String)"text/html", (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    RemoteFiles.this.updateRemoteFiles();
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateRemoteFiles() {
        List deps;
        try {
            deps = this.getHtmlIndex().getAllRemoteDependencies();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        RP.post(new Runnable(){
            final /* synthetic */ RemoteFiles this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.setUrls(this.this$0.filter(deps));
                this.this$0.fireChange();
            }
        });
    }

    public synchronized List<URL> getRemoteFiles() {
        if (this.urls == null) {
            this.urls = new ArrayList<URL>();
            this.update();
        }
        return this.urls;
    }

    private synchronized void setUrls(List<URL> urls) {
        this.urls = urls;
        this.prefetchRemoteFiles(urls);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    private void prefetchRemoteFiles(List<URL> urls) {
        for (URL u : urls) {
            try {
                RemoteFileCache.getRemoteFile((URL)u);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private List<URL> filter(List<URL> allRemoteDependencies) {
        ArrayList<URL> res = new ArrayList<URL>();
        for (URL u : allRemoteDependencies) {
            String uu = u.toExternalForm().toLowerCase();
            if (!uu.endsWith(".js") && !uu.endsWith(".css")) continue;
            res.add(u);
        }
        return res;
    }
}

