/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php;

import java.awt.Color;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPDocCommentTokenId;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.xml.XMLUtil;

public final class RefactoringUtils {
    private RefactoringUtils() {
    }

    public static Program getRoot(ParserResult info) {
        return info instanceof PHPParseResult ? ((PHPParseResult)info).getProgram() : null;
    }

    public static Source getSource(Document doc) {
        Source source = Source.create((Document)doc);
        return source;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(FileObject fo) {
        DataObject dob = null;
        try {
            dob = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return dob == null ? null : RefactoringUtils.findCloneableEditorSupport(dob);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Object obj = dob.getLookup().lookup(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getLookup().lookup(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    public static String htmlize(String input) {
        try {
            return XMLUtil.toElementContent((String)input);
        }
        catch (CharConversionException cce) {
            Exceptions.printStackTrace((Throwable)cce);
            return input;
        }
    }

    public static String getHtml(String text) {
        StringBuilder buf = new StringBuilder();
        TokenHierarchy tokenH = TokenHierarchy.create((CharSequence)text, (Language)PHPTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-php5"));
        FontColorSettings settings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tok = tokenH.tokenSequence();
        while (tok.moveNext()) {
            Token token = tok.token();
            String category = token.id().name();
            AttributeSet set = settings.getTokenFontColors(category);
            if (set == null) {
                category = token.id().primaryCategory();
                if (category == null) {
                    category = "whitespace";
                }
                set = settings.getTokenFontColors(category);
            }
            String tokenText = RefactoringUtils.htmlize(token.text().toString());
            buf.append(RefactoringUtils.color(tokenText, set));
        }
        return buf.toString();
    }

    private static String color(String string, AttributeSet set) {
        if (set == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return string.replace(" ", "&nbsp;").replace("\n", "<br>");
        }
        StringBuilder buf = new StringBuilder(string);
        if (StyleConstants.isBold(set)) {
            buf.insert(0, "<b>");
            buf.append("</b>");
        }
        if (StyleConstants.isItalic(set)) {
            buf.insert(0, "<i>");
            buf.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(set)) {
            buf.insert(0, "<s>");
            buf.append("</s>");
        }
        buf.insert(0, "<font color=" + RefactoringUtils.getHTMLColor(StyleConstants.getForeground(set)) + ">");
        buf.append("</font>");
        return buf.toString();
    }

    private static String getHTMLColor(Color c) {
        String colorR = "0" + Integer.toHexString(c.getRed());
        colorR = colorR.substring(colorR.length() - 2);
        String colorG = "0" + Integer.toHexString(c.getGreen());
        colorG = colorG.substring(colorG.length() - 2);
        String colorB = "0" + Integer.toHexString(c.getBlue());
        colorB = colorB.substring(colorB.length() - 2);
        String htmlColor = "#" + colorR + colorG + colorB;
        return htmlColor;
    }

    public static boolean isFileInOpenProject(FileObject file) {
        assert (file != null);
        Project p = ProjectConvertors.getNonConvertorOwner((FileObject)file);
        return OpenProjects.getDefault().isProjectOpen(p);
    }

    public static boolean isOnSourceClasspath(FileObject fo) {
        Project p = ProjectConvertors.getNonConvertorOwner((FileObject)fo);
        if (p == null) {
            return false;
        }
        Project[] opened = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < opened.length; ++i) {
            if (!p.equals((Object)opened[i]) && !opened[i].equals((Object)p)) continue;
            SourceGroup[] gr = ProjectUtils.getSources((Project)p).getSourceGroups("generic");
            for (int j = 0; j < gr.length; ++j) {
                if (fo == gr[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)gr[j].getRootFolder(), (FileObject)fo)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isClasspathRoot(FileObject fo) {
        FileObject f;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp != null && (f = cp.findOwnerRoot(fo)) != null) {
            return fo.equals(f);
        }
        return false;
    }

    public static boolean isRefactorable(FileObject file) {
        return FileUtils.isPhpFile((FileObject)file) && RefactoringUtils.isFileInOpenProject(file) && RefactoringUtils.isOnSourceClasspath(file);
    }

    public static FileObject getOrCreateFolder(URL url) throws IOException {
        try {
            FileObject result = URLMapper.findFileObject((URL)url);
            if (result != null) {
                return result;
            }
            File f = Utilities.toFile((URI)url.toURI());
            result = FileUtil.createFolder((File)f);
            return result;
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public static boolean isOutsidePhp(Lookup lookup, FileObject fo) {
        return RefactoringUtils.isOutsideLanguage(lookup, fo, (Language<? extends TokenId>)PHPTokenId.language());
    }

    public static boolean isOutsidePHPDoc(Lookup lookup, FileObject fo) {
        return RefactoringUtils.isOutsideLanguage(lookup, fo, (Language<? extends TokenId>)PHPDocCommentTokenId.language());
    }

    public static boolean isOutsideLanguage(Lookup lookup, FileObject fo, Language<? extends TokenId> language) {
        EditorCookie ec;
        boolean result = false;
        if (FileUtils.isPhpFile((FileObject)fo) && RefactoringUtils.isFromEditor(ec = (EditorCookie)lookup.lookup(EditorCookie.class))) {
            int caret;
            JEditorPane textC = ec.getOpenedPanes()[0];
            Document d = textC.getDocument();
            result = !(d instanceof BaseDocument) ? true : LexUtilities.getMostEmbeddedTokenSequence((Document)d, (int)(caret = textC.getCaretPosition()), (boolean)true).language() != language;
        }
        return result;
    }

    public static boolean isFromEditor(EditorCookie ec) {
        TopComponent activetc;
        return ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    public static List<ASTNode> underCaret(ParserResult info, final int offset) {
        class Result
        extends Error {
            private final Stack<ASTNode> result;

            public Result(Stack<ASTNode> result) {
                this.result = result;
            }

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        }
        try {
            new DefaultVisitor(){
                private final Stack<ASTNode> s = new Stack();

                public void scan(ASTNode node) {
                    if (node == null) {
                        return;
                    }
                    if (node.getStartOffset() <= offset && offset <= node.getEndOffset()) {
                        this.s.push(node);
                        super.scan(node);
                        throw new Result(this.s);
                    }
                }
            }.scan((ASTNode)RefactoringUtils.getRoot(info));
        }
        catch (Result r) {
            return new LinkedList<ASTNode>(r.result);
        }
        return Collections.emptyList();
    }

    public static boolean isQuoted(String value) {
        return !(value.length() < 2 || !value.startsWith("\"") && !value.startsWith("'") || !value.endsWith("\"") && !value.endsWith("'"));
    }

    public static String dequote(String value) {
        assert (RefactoringUtils.isQuoted(value));
        return value.substring(1, value.length() - 1);
    }

    public static FileObject resolveInclude(ParserResult info, Include include) {
        Scalar s;
        Expression e = include.getExpression();
        if (e instanceof ParenthesisExpression) {
            e = ((ParenthesisExpression)e).getExpression();
        }
        if (e instanceof Scalar && Scalar.Type.STRING == (s = (Scalar)e).getScalarType()) {
            String fileName = s.getStringValue();
            fileName = fileName.length() >= 2 ? fileName.substring(1, fileName.length() - 1) : fileName;
            return RefactoringUtils.resolveRelativeFile(info, fileName);
        }
        return null;
    }

    private static FileObject resolveRelativeFile(ParserResult info, String name) {
        PhpSourcePath psp = null;
        Project p = ProjectConvertors.getNonConvertorOwner((FileObject)info.getSnapshot().getSource().getFileObject());
        if (p != null) {
            psp = (PhpSourcePath)p.getLookup().lookup(PhpSourcePath.class);
        }
        while (true) {
            FileObject result;
            if ((result = psp != null ? PhpSourcePath.resolveFile((FileObject)info.getSnapshot().getSource().getFileObject().getParent(), (String)name) : info.getSnapshot().getSource().getFileObject().getParent().getFileObject(name)) != null) {
                return result;
            }
            int slash = name.indexOf(47);
            if (slash == -1) break;
            name = name.substring(slash + 1);
        }
        return null;
    }

    public static FileObject getFile(Document doc) {
        Object o = doc.getProperty("stream");
        if (o instanceof DataObject) {
            DataObject od = (DataObject)o;
            return od.getPrimaryFile();
        }
        return null;
    }

    public static boolean isUsersFile(FileObject fileObject) {
        boolean result = false;
        PhpSourcePath.FileType fileType = PhpSourcePath.getFileType((FileObject)fileObject);
        if (fileType != PhpSourcePath.FileType.INCLUDE && fileType != PhpSourcePath.FileType.INTERNAL) {
            result = true;
        }
        return result;
    }
}

