/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.annotation;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.JumpList;
import org.netbeans.modules.gsf.testrunner.api.CommonUtils;
import org.netbeans.modules.gsf.testrunner.ui.annotation.Bundle;
import org.netbeans.modules.gsf.testrunner.ui.annotation.PopupUtil;
import org.netbeans.modules.gsf.testrunner.ui.annotation.SelectActionPopup;
import org.netbeans.modules.gsf.testrunner.ui.annotation.TestMethodAnnotation;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.awt.StatusDisplayer;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class RunDebugTestGutterAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(RunDebugTestGutterAction.class.getName());
    private static final Set<String> fixableAnnotations = new HashSet<String>();

    public RunDebugTestGutterAction() {
        this.putValue("Name", Bundle.NM_RunGutterAction());
    }

    @Override
    public Object getValue(String key) {
        if ("supported-annotation-types".equals(key)) {
            return fixableAnnotations.toArray(new String[0]);
        }
        return super.getValue(key);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Action a;
        int nextAction;
        Action[] actions;
        Object source = evt.getSource();
        if (!(source instanceof JTextComponent)) {
            StatusDisplayer.getDefault().setStatusText(Bundle.ERR_NoTestMethod());
            return;
        }
        final JTextComponent comp = (JTextComponent)source;
        final Document doc = comp.getDocument();
        int caretPos = comp.getCaretPosition();
        final int line = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)caretPos);
        AnnotationDesc activeAnnotation = ((BaseDocument)doc).getAnnotations().getActiveAnnotation(line);
        if (activeAnnotation != null && fixableAnnotations.contains(activeAnnotation.getAnnotationType())) {
            Map annotationLines = (Map)doc.getProperty(TestMethodAnnotation.DOCUMENT_ANNOTATION_LINES_KEY);
            int lineStartOffset = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)line);
            int nextLineStartOffset = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)(line + 1));
            TestMethodController.TestMethod testMethod = annotationLines.entrySet().stream().filter(e -> lineStartOffset <= ((Position)e.getKey()).getOffset() && ((Position)e.getKey()).getOffset() < nextLineStartOffset).map(e -> (TestMethodController.TestMethod)e.getValue()).findAny().orElse(null);
            if (testMethod != null) {
                SingleMethod singleMethod = testMethod.method();
                ArrayList<SelectActionPopup.ActionDescription> actions2 = new ArrayList<SelectActionPopup.ActionDescription>();
                ActionProvider ap = CommonUtils.getInstance().getActionProvider(singleMethod.getFile());
                if (ap != null) {
                    for (String command : new String[]{"run.single.method", "debug.single.method"}) {
                        String displayName = NbBundle.getMessage(RunDebugTestGutterAction.class, (String)("DN_" + command), (Object)singleMethod.getMethodName());
                        if (!Arrays.asList(ap.getSupportedActions()).contains(command) || !ap.isActionEnabled(command, Lookups.singleton((Object)singleMethod))) continue;
                        actions2.add(new SelectActionPopup.ActionDescription(displayName, () -> ap.invokeAction(command, Lookups.singleton((Object)singleMethod))));
                    }
                }
                if (actions2.size() > 1) {
                    final Point[] p = new Point[1];
                    doc.render(new Runnable(){
                        final /* synthetic */ RunDebugTestGutterAction this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            try {
                                int startOffset = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)line);
                                p[0] = comp.modelToView(startOffset).getLocation();
                            }
                            catch (BadLocationException ex) {
                                LOG.log(Level.WARNING, null, ex);
                            }
                        }
                    });
                    JumpList.checkAddEntry((JTextComponent)comp, (int)caretPos);
                    SwingUtilities.convertPointToScreen(p[0], comp);
                    PopupUtil.showPopup(new SelectActionPopup(Bundle.CAP_SelectAction(), actions2), Bundle.CAP_SelectAction(), p[0].x, p[0].y, true, 0);
                } else if (actions2.size() == 1) {
                    ((SelectActionPopup.ActionDescription)actions2.get((int)0)).action.run();
                }
                return;
            }
        }
        if ((actions = ImplementationProvider.getDefault().getGlyphGutterActions((JTextComponent)source)) == null) {
            return;
        }
        for (nextAction = 0; nextAction < actions.length && actions[nextAction] != this; ++nextAction) {
        }
        if (actions.length > ++nextAction && (a = actions[nextAction]) != null && a.isEnabled()) {
            a.actionPerformed(evt);
        }
    }

    @Override
    public boolean isEnabled() {
        TopComponent activetc = TopComponent.getRegistry().getActivated();
        return activetc instanceof CloneableEditorSupport.Pane;
    }

    static {
        fixableAnnotations.add("org-netbeans-modules-gsf-testrunner-runnable-test-annotation");
    }
}

