/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.AtomicLockEvent;
import org.netbeans.api.editor.document.AtomicLockListener;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class UndoManager {
    private LinkedHashMap<RefactoringSession, LinkedList<UndoItem>> undoList;
    private LinkedHashMap<RefactoringSession, LinkedList<UndoItem>> redoList;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean wasUndo = false;
    private boolean wasRedo = false;
    private boolean transactionStart;
    private IdentityHashMap<LinkedList, String> descriptionMap;
    private String description;
    private ProgressListener progress;
    private static UndoManager instance;
    public boolean autoConfirm = false;
    private boolean suppressSaveAll;
    private static final RequestProcessor SAVE_RP;
    private int stepCounter = 0;

    boolean setSupressSaveAll(boolean suppressSaveAll) {
        boolean res = this.suppressSaveAll;
        this.suppressSaveAll = suppressSaveAll;
        return res;
    }

    public void setAutoConfirm(boolean autoConfirm) {
        this.autoConfirm = autoConfirm;
    }

    public static synchronized UndoManager getDefault() {
        if (instance == null) {
            instance = new UndoManager();
        }
        return instance;
    }

    private UndoManager() {
        this.undoList = new LinkedHashMap();
        this.redoList = new LinkedHashMap();
        this.descriptionMap = new IdentityHashMap();
    }

    private UndoManager(ProgressListener progress) {
        this();
        this.progress = progress;
    }

    public void setUndoDescription(String desc) {
        this.description = desc;
    }

    public String getUndoDescription(RefactoringSession refactoringSession) {
        RefactoringSession session;
        LinkedList<UndoItem> undoitems;
        if (refactoringSession == null) {
            refactoringSession = this.getLastUndo();
        }
        if ((undoitems = this.undoList.get(session = refactoringSession)) == null) {
            return null;
        }
        return this.descriptionMap.get(undoitems);
    }

    public String getRedoDescription(RefactoringSession refactoringSession) {
        RefactoringSession session;
        LinkedList<UndoItem> redoitems;
        if (refactoringSession == null) {
            refactoringSession = this.getLastUndo();
        }
        if ((redoitems = this.redoList.get(session = refactoringSession)) == null) {
            return null;
        }
        return this.descriptionMap.get(redoitems);
    }

    public void transactionStarted() {
        this.transactionStart = true;
    }

    public void transactionEnded(boolean fail, RefactoringSession session) {
        this.description = null;
        if ((!fail || this.undoList.isEmpty()) && this.isUndoAvailable(session) && this.getUndoDescription(session) == null) {
            this.descriptionMap.remove(this.undoList.remove(session));
        }
        this.fireChange();
    }

    void undo(RefactoringSession session, Document doc) {
        if (!DocumentUtilities.isWriteLocked((Document)doc)) {
            this.undo(session);
        } else {
            final AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.as((Document)doc, AtomicLockDocument.class);
            if (ald == null) {
                this.undo(session);
            } else {
                final boolean orig = this.setSupressSaveAll(true);
                class L
                implements AtomicLockListener,
                Runnable {
                    final /* synthetic */ UndoManager this$0;

                    L() {
                        this.this$0 = this$0;
                    }

                    public void atomicLock(AtomicLockEvent evt) {
                    }

                    public void atomicUnlock(AtomicLockEvent evt) {
                        this.this$0.setSupressSaveAll(orig);
                        SAVE_RP.post((Runnable)this);
                        ald.removeAtomicLockListener((AtomicLockListener)this);
                    }

                    @Override
                    public void run() {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
                L l = new L();
                ald.addAtomicLockListener((AtomicLockListener)l);
                this.undo(session);
            }
        }
    }

    public void undo(RefactoringSession refactoringSession) {
        RefactoringSession session;
        LinkedList<UndoItem> undoitems;
        if (refactoringSession == null) {
            refactoringSession = this.getLastUndo();
        }
        if ((undoitems = this.undoList.get(session = refactoringSession)) != null && !undoitems.isEmpty()) {
            final LinkedList<UndoItem> undo = undoitems;
            if (!this.autoConfirm) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UndoManager.class, (String)"MSG_ReallyUndo", (Object)this.getUndoDescription(session)), NbBundle.getMessage(UndoManager.class, (String)"MSG_ConfirmUndo"), 0);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (!NotifyDescriptor.OK_OPTION.equals(result)) {
                    throw new CannotUndoException();
                }
            }
            Runnable run = new Runnable(){
                final /* synthetic */ UndoManager this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean fail = true;
                    try {
                        this.this$0.transactionStarted();
                        this.this$0.wasUndo = true;
                        this.this$0.fireProgressListenerStart(0, undo.size());
                        Iterator undoIterator = undo.iterator();
                        this.this$0.redoList.put(session, new LinkedList());
                        this.this$0.descriptionMap.put(this.this$0.redoList.get(session), this.this$0.descriptionMap.remove(undo));
                        try {
                            while (undoIterator.hasNext()) {
                                this.this$0.fireProgressListenerStep();
                                UndoItem item = (UndoItem)undoIterator.next();
                                item.undo();
                                if (!(item instanceof SessionUndoItem)) continue;
                                SessionUndoItem sessionUndoItem = (SessionUndoItem)item;
                                this.this$0.addItem(item, sessionUndoItem.change);
                            }
                        }
                        catch (CannotUndoException e) {
                            this.this$0.descriptionMap.put(undo, this.this$0.descriptionMap.get(this.this$0.redoList.get(session)));
                            this.this$0.descriptionMap.remove(this.this$0.redoList.get(session));
                            this.this$0.redoList.remove(session);
                            throw e;
                        }
                        this.this$0.undoList.remove(session);
                        fail = false;
                    }
                    finally {
                        try {
                            this.this$0.wasUndo = false;
                            this.this$0.transactionEnded(fail, session);
                        }
                        finally {
                            this.this$0.fireProgressListenerStop();
                            this.this$0.fireChange();
                        }
                    }
                }
            };
            run.run();
        }
    }

    public void redo(RefactoringSession refactoringSession) {
        RefactoringSession session;
        LinkedList<UndoItem> redoitems;
        if (refactoringSession == null) {
            refactoringSession = this.getLastRedo();
        }
        if ((redoitems = this.redoList.get(session = refactoringSession)) != null) {
            final LinkedList<UndoItem> redo = redoitems;
            if (!this.autoConfirm && JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(UndoManager.class, (String)"MSG_ReallyRedo", (Object)this.getRedoDescription(session)), NbBundle.getMessage(UndoManager.class, (String)"MSG_ConfirmRedo"), 0) != 0) {
                throw new CannotRedoException();
            }
            Runnable run = new Runnable(){
                final /* synthetic */ UndoManager this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean fail = true;
                    try {
                        this.this$0.transactionStarted();
                        this.this$0.wasRedo = true;
                        this.this$0.fireProgressListenerStart(1, redo.size());
                        Iterator redoIterator = redo.iterator();
                        this.this$0.description = this.this$0.descriptionMap.remove(redo);
                        try {
                            while (redoIterator.hasNext()) {
                                this.this$0.fireProgressListenerStep();
                                UndoItem item = (UndoItem)redoIterator.next();
                                item.redo();
                                if (!(item instanceof SessionUndoItem)) continue;
                                this.this$0.addItem(item, session);
                            }
                        }
                        catch (CannotRedoException ex) {
                            this.this$0.descriptionMap.put(redo, this.this$0.description);
                            throw ex;
                        }
                        this.this$0.redoList.remove(session);
                        fail = false;
                    }
                    finally {
                        try {
                            this.this$0.wasRedo = false;
                            this.this$0.transactionEnded(fail, session);
                        }
                        finally {
                            this.this$0.fireProgressListenerStop();
                            this.this$0.fireChange();
                        }
                    }
                }
            };
            run.run();
        }
    }

    public void clear() {
        this.undoList.clear();
        this.redoList.clear();
        this.descriptionMap.clear();
        BackupFacility.getDefault().clear();
        this.fireChange();
    }

    public void addItem(RefactoringSession session) {
        this.addItem(new SessionUndoItem(session), session);
    }

    private void addItem(UndoItem item, RefactoringSession session) {
        if (this.wasUndo) {
            LinkedList<UndoItem> redo = this.redoList.get(session);
            redo.addFirst(item);
        } else {
            if (this.transactionStart) {
                this.undoList.put(session, new LinkedList());
                this.descriptionMap.put(this.undoList.get(session), this.description);
                this.transactionStart = false;
            }
            LinkedList<UndoItem> undo = this.undoList.get(session);
            undo.addFirst(item);
        }
        if (!this.wasUndo && !this.wasRedo) {
            this.redoList.clear();
        }
    }

    public boolean isUndoAvailable(RefactoringSession session) {
        return this.undoList.containsKey(session);
    }

    public boolean isRedoAvailable(RefactoringSession session) {
        return this.redoList.containsKey(session);
    }

    public boolean isUndoAvailable() {
        return !this.undoList.isEmpty();
    }

    public boolean isRedoAvailable() {
        return !this.redoList.isEmpty();
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeSupport.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeSupport.removeChangeListener(cl);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    private void fireProgressListenerStart(int type, int count) {
        this.stepCounter = 0;
        if (this.progress == null) {
            return;
        }
        this.progress.start(new ProgressEvent(this, 1, type, count));
    }

    private void fireProgressListenerStep() {
        if (this.progress == null) {
            return;
        }
        this.progress.step(new ProgressEvent(this, 2, 0, ++this.stepCounter));
    }

    private void fireProgressListenerStop() {
        if (this.progress == null) {
            return;
        }
        this.progress.stop(new ProgressEvent(this, 4));
    }

    private RefactoringSession getLastUndo() {
        RefactoringSession session2 = null;
        if (!this.undoList.isEmpty()) {
            for (RefactoringSession session2 : this.undoList.keySet()) {
            }
        }
        return session2;
    }

    private RefactoringSession getLastRedo() {
        RefactoringSession session2 = null;
        if (!this.redoList.isEmpty()) {
            for (RefactoringSession session2 : this.redoList.keySet()) {
            }
        }
        return session2;
    }

    static {
        SAVE_RP = new RequestProcessor(UndoManager.class);
    }

    private final class SessionUndoItem
    implements UndoItem {
        private RefactoringSession change;

        public SessionUndoItem(RefactoringSession change) {
            this.change = change;
        }

        @Override
        public void undo() {
            this.change.undoRefactoring(!UndoManager.this.suppressSaveAll);
        }

        @Override
        public void redo() {
            this.change.doRefactoring(!UndoManager.this.suppressSaveAll);
        }
    }

    private static interface UndoItem {
        public void undo();

        public void redo();
    }
}

