/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.graalsdk.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.graalvm.polyglot.Language;
import org.netbeans.libs.graalsdk.system.GraalContext;
import org.netbeans.libs.graalsdk.system.GraalEngine;

final class GraalEngineFactory
implements ScriptEngineFactory {
    final String id;
    final Language language;
    final GraalContext ctx;
    private GraalEngine eng;

    GraalEngineFactory(GraalContext ctx, String id, Language language) {
        this.id = id;
        this.language = language;
        this.ctx = ctx;
    }

    @Override
    public String getEngineName() {
        return "GraalVM:" + this.language.getId();
    }

    @Override
    public String getEngineVersion() {
        return this.language.getVersion();
    }

    @Override
    public List<String> getExtensions() {
        return Collections.singletonList(this.id);
    }

    @Override
    public List<String> getMimeTypes() {
        return new ArrayList<String>(this.language.getMimeTypes());
    }

    @Override
    public List<String> getNames() {
        return Arrays.asList(this.language.getName(), this.getEngineName());
    }

    @Override
    public String getLanguageName() {
        return this.language.getName();
    }

    @Override
    public String getLanguageVersion() {
        return this.language.getVersion();
    }

    @Override
    public Object getParameter(String arg0) {
        return null;
    }

    @Override
    public String getMethodCallSyntax(String arg0, String arg1, String ... arg2) {
        return null;
    }

    @Override
    public String getOutputStatement(String arg0) {
        return null;
    }

    @Override
    public String getProgram(String ... arg0) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngine getScriptEngine() {
        GraalEngineFactory graalEngineFactory = this;
        synchronized (graalEngineFactory) {
            if (this.eng == null) {
                this.eng = new GraalEngine(this);
            }
            return this.eng;
        }
    }

    public String toString() {
        return "GraalEngineFactory[" + this.id + "]";
    }
}

