/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonManager;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.netbeans.modules.hudson.ui.actions.CreateJobPanel;
import org.netbeans.modules.hudson.ui.api.UI;
import org.netbeans.modules.hudson.ui.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.hudson.ui.spi.ProjectHudsonProvider;
import org.netbeans.modules.hudson.ui.util.UsageLogging;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;

public class CreateJob
implements ActionListener {
    private final HudsonInstance instance;

    public static ActionListener global() {
        return new CreateJob(null);
    }

    public CreateJob(HudsonInstance instance) {
        this.instance = instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection instances;
        if (this.runCustomActionIfAvailable(e)) {
            return;
        }
        final CreateJobPanel panel = new CreateJobPanel();
        final DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.CreateJob_title());
        final AtomicReference<Dialog> dialog = new AtomicReference<Dialog>();
        final JButton createButton = new JButton(Bundle.CreateJob_create());
        createButton.addActionListener(new ActionListener(){
            final /* synthetic */ CreateJob this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestProcessor.getDefault().post(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.finalizeJob(panel.instance, panel.creator, panel.name(), panel.selectedProject());
                    }
                });
                ((Dialog)dialog.get()).dispose();
            }
        });
        dd.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ CreateJob this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("valid".equals(evt.getPropertyName())) {
                    createButton.setEnabled(dd.isValid());
                }
            }
        });
        HudsonInstance _instance = this.instance != null ? this.instance : ((instances = HudsonManager.getAllInstances()).isEmpty() ? null : (HudsonInstance)instances.iterator().next());
        panel.init(dd, _instance);
        dd.setOptions(new Object[]{createButton, NotifyDescriptor.CANCEL_OPTION});
        dd.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
        dialog.set(DialogDisplayer.getDefault().createDialog(dd));
        ((Dialog)dialog.get()).setVisible(true);
    }

    boolean runCustomActionIfAvailable(ActionEvent e) {
        Action custom;
        if (this.instance != null && (custom = this.instance.getPersistence().getNewJobAction()) != null) {
            custom.actionPerformed(e);
            return true;
        }
        return false;
    }

    private void finalizeJob(HudsonInstance instance, ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator creator, String name, Project project) {
        try {
            Document doc = creator.configure();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLUtil.write((Document)doc, (OutputStream)baos, (String)"UTF-8");
            String createItemURL = instance.getUrl() + "createItem?name=" + Utilities.uriEncode((String)name);
            new ConnectionBuilder().instance(instance).url(createItemURL).header("Content-Type", "text/xml").postData(baos.toByteArray()).httpConnection().disconnect();
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(instance.getUrl() + "job/" + Utilities.uriEncode((String)name) + "/"));
            instance.synchronize(false);
            ProjectHudsonProvider.getDefault().recordAssociation(project, new ProjectHudsonProvider.Association(instance.getUrl(), name));
            OpenProjects.getDefault().open(new Project[]{project}, false);
            UI.selectNode(instance.getUrl(), name);
            UsageLogging.logUI(NbBundle.getBundle(CreateJob.class), "UI_HUDSON_JOB_CREATED", project.getClass().getName());
            UsageLogging.logUsage(CreateJob.class, "USG_HUDSON_JOB_CREATED", project.getClass().getName());
        }
        catch (ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator.SilentIOException x) {
            Logger.getLogger(CreateJob.class.getName()).log(Level.INFO, null, x);
        }
        catch (IOException x) {
            Exceptions.attachLocalizedMessage((Throwable)x, (String)Bundle.CreateJob_failure());
            Logger.getLogger(CreateJob.class.getName()).log(Level.WARNING, null, x);
        }
    }
}

