/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListObjectVersionsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String bucketName;
    private String prefix;
    private String start;
    private String end;
    private Integer limit;
    private String delimiter;
    private String fields;
    private String opcClientRequestId;
    private String startAfter;
    private String page;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getFields() {
        return this.fields;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getStartAfter() {
        return this.startAfter;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).prefix(this.prefix).start(this.start).end(this.end).limit(this.limit).delimiter(this.delimiter).fields(this.fields).opcClientRequestId(this.opcClientRequestId).startAfter(this.startAfter).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",bucketName=").append(String.valueOf(this.bucketName));
        sb.append(",prefix=").append(String.valueOf(this.prefix));
        sb.append(",start=").append(String.valueOf(this.start));
        sb.append(",end=").append(String.valueOf(this.end));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",delimiter=").append(String.valueOf(this.delimiter));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",startAfter=").append(String.valueOf(this.startAfter));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListObjectVersionsRequest)) {
            return false;
        }
        ListObjectVersionsRequest other = (ListObjectVersionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.limit, other.limit) && Objects.equals(this.delimiter, other.delimiter) && Objects.equals(this.fields, other.fields) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.startAfter, other.startAfter) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.prefix == null ? 43 : this.prefix.hashCode());
        result = result * 59 + (this.start == null ? 43 : this.start.hashCode());
        result = result * 59 + (this.end == null ? 43 : this.end.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.delimiter == null ? 43 : this.delimiter.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.startAfter == null ? 43 : this.startAfter.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListObjectVersionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String bucketName = null;
        private String prefix = null;
        private String start = null;
        private String end = null;
        private Integer limit = null;
        private String delimiter = null;
        private String fields = null;
        private String opcClientRequestId = null;
        private String startAfter = null;
        private String page = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder start(String start) {
            this.start = start;
            return this;
        }

        public Builder end(String end) {
            this.end = end;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder fields(String fields) {
            this.fields = fields;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder startAfter(String startAfter) {
            this.startAfter = startAfter;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListObjectVersionsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.prefix(o.getPrefix());
            this.start(o.getStart());
            this.end(o.getEnd());
            this.limit(o.getLimit());
            this.delimiter(o.getDelimiter());
            this.fields(o.getFields());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.startAfter(o.getStartAfter());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListObjectVersionsRequest build() {
            ListObjectVersionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListObjectVersionsRequest buildWithoutInvocationCallback() {
            ListObjectVersionsRequest request = new ListObjectVersionsRequest();
            request.namespaceName = this.namespaceName;
            request.bucketName = this.bucketName;
            request.prefix = this.prefix;
            request.start = this.start;
            request.end = this.end;
            request.limit = this.limit;
            request.delimiter = this.delimiter;
            request.fields = this.fields;
            request.opcClientRequestId = this.opcClientRequestId;
            request.startAfter = this.startAfter;
            request.page = this.page;
            return request;
        }
    }
}

