/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.options;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.maven.TextValueCompleter;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.ActionMappings;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.execute.NbGlobalActionGoalProvider;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.options.Bundle;
import org.netbeans.modules.maven.options.GlobalOptionsPanel;
import org.netbeans.modules.maven.options.MavenOptionController;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.options.NetworkProxySettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SettingsPanel
extends JPanel {
    private static final String SEPARATOR = "SEPARATOR";
    public static final String BUNDLED_RUNTIME_VERSION = MavenSettings.getCommandLineMavenVersion(EmbedderFactory.getDefaultMavenHome());
    public static final int RUNTIME_COUNT_LIMIT = 5;
    private boolean changed;
    private boolean valid;
    private final ActionListener listener;
    private final MavenOptionController controller;
    private final TextValueCompleter completer;
    private final ActionListener listItemChangedListener;
    private final List<String> userDefinedMavenRuntimes = new ArrayList<String>();
    private final List<String> userDefinedMavenRuntimesStored = new ArrayList<String>();
    private final List<String> predefinedRuntimes = new ArrayList<String>();
    private final DefaultComboBoxModel mavenHomeDataModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel jdkHomeDataModel = new DefaultComboBoxModel();
    private String mavenRuntimeHome = null;
    private int lastSelected = -1;
    private static final RequestProcessor RP = new RequestProcessor(SettingsPanel.class);
    static String[] AVAILABLE_OPTIONS = new String[]{"--offline", "--debug", "--errors", "--batch-mode", "--fail-fast", "--fail-at-end", "--fail-never", "--strict-checksums", "--lax-checksums", "--check-plugin-updates", "--no-plugin-updates", "--update-snapshots", "--no-plugin-registry", "--no-transfer-progress"};
    private ButtonGroup bgIndexFilter;
    private JButton btnGoals;
    private JButton btnIndex;
    private JButton btnOptions;
    private ButtonGroup buttonGroup1;
    private JCheckBox cbAlwaysShow;
    private JCheckBox cbCollapseSuccessFolds;
    private JCheckBox cbEnableIndexDownload;
    private JCheckBox cbEnableIndexing;
    private JCheckBox cbEnableMultiThreading;
    private JComboBox<NetworkProxySettings> cbNetworkProxy;
    private JCheckBox cbOutputTabShowConfig;
    private JCheckBox cbPreferWrapper;
    private JComboBox cbProjectNodeNameMode;
    private JCheckBox cbReuse;
    private JCheckBox cbShowInfoLevel;
    private JCheckBox cbSkipTests;
    private JComboBox comBinaries;
    private JComboBox comIndex;
    private JComboBox comJavadoc;
    private JComboBox comJdkHome;
    private JButton comManageJdks;
    private JComboBox comMavenHome;
    private JComboBox comSource;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JLabel lbNetworkSettings;
    private JLabel lblBinaries;
    private JLabel lblCategory;
    private JLabel lblCommandLine;
    private JLabel lblExternalVersion;
    private JLabel lblIndex;
    private JLabel lblIndexFilter;
    private JLabel lblJavadoc;
    private JLabel lblJdkHome;
    private JLabel lblOptions;
    private JLabel lblOutputTab;
    private JLabel lblSource;
    private JList lstCategory;
    private JTable permissionsTable;
    private JPanel pnlAppearance;
    private JPanel pnlCards;
    private JPanel pnlDependencies;
    private JPanel pnlExecution;
    private JPanel pnlIndex;
    private JRadioButton rb2Years;
    private JRadioButton rb5Years;
    private JRadioButton rbFullIndex;
    private JRadioButton rbOutputTabId;
    private JRadioButton rbOutputTabName;
    private JTextField txtOptions;
    private JTextField txtProjectNodeNameCustomPattern;

    SettingsPanel(MavenOptionController controller) {
        this.initComponents();
        MavenSettings.DownloadStrategy[] downloads = MavenSettings.DownloadStrategy.values();
        this.comBinaries.setModel(new DefaultComboBoxModel<MavenSettings.DownloadStrategy>(downloads));
        this.comJavadoc.setModel(new DefaultComboBoxModel<MavenSettings.DownloadStrategy>(downloads));
        this.comSource.setModel(new DefaultComboBoxModel<MavenSettings.DownloadStrategy>(downloads));
        this.comMavenHome.setModel(this.mavenHomeDataModel);
        this.comJdkHome.setModel(this.jdkHomeDataModel);
        this.updatePermissionsTable();
        DefaultListCellRenderer rend = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String txt = "";
                if (value.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
                    txt = NbBundle.getMessage(SettingsPanel.class, (String)"TIT_NEVER");
                } else if (value.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
                    txt = NbBundle.getMessage(SettingsPanel.class, (String)"TIT_EVERY");
                } else if (value.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN)) {
                    txt = NbBundle.getMessage(SettingsPanel.class, (String)"TIT_FIRST");
                }
                return super.getListCellRendererComponent((JList<?>)list, txt, index, isSelected, cellHasFocus);
            }
        };
        this.comBinaries.setRenderer(rend);
        this.comSource.setRenderer(rend);
        this.comJavadoc.setRenderer(rend);
        this.comMavenHome.setRenderer(new ComboBoxRenderer());
        this.controller = controller;
        this.listItemChangedListener = e -> {
            if (SEPARATOR.equals(this.comMavenHome.getSelectedItem())) {
                this.comMavenHome.setSelectedIndex(this.lastSelected);
                return;
            }
            int selected = this.comMavenHome.getSelectedIndex();
            if (selected == this.mavenHomeDataModel.getSize() - 1) {
                this.comMavenHome.setSelectedIndex(this.lastSelected);
                SwingUtilities.invokeLater(this::browseAddNewRuntime);
                return;
            }
            this.listDataChanged();
            this.lastSelected = selected;
        };
        this.comIndex.setSelectedIndex(0);
        this.listener = new ActionListenerImpl();
        this.comIndex.addActionListener(this.listener);
        this.completer = new TextValueCompleter(SettingsPanel.getGlobalOptions(), this.txtOptions, " ");
        this.cbProjectNodeNameMode.addActionListener(this.listener);
        this.cbAlwaysShow.addActionListener(this.listener);
        this.cbShowInfoLevel.addActionListener(this.listener);
        this.cbCollapseSuccessFolds.addActionListener(this.listener);
        this.cbReuse.addActionListener(this.listener);
        this.cbSkipTests.addActionListener(this.listener);
        this.comBinaries.addActionListener(this.listener);
        this.comJavadoc.addActionListener(this.listener);
        this.comSource.addActionListener(this.listener);
        this.cbOutputTabShowConfig.addActionListener(this.listener);
        this.rbOutputTabId.addActionListener(this.listener);
        this.rbOutputTabName.addActionListener(this.listener);
        this.rbFullIndex.addActionListener(this.listener);
        this.rb5Years.addActionListener(this.listener);
        this.rb2Years.addActionListener(this.listener);
        this.cbEnableIndexing.addActionListener(this.listener);
        this.cbEnableMultiThreading.addActionListener(this.listener);
        this.cbEnableIndexDownload.addActionListener(this.listener);
        this.cbPreferWrapper.addActionListener(this.listener);
        this.txtOptions.getDocument().addDocumentListener(new DocumentListenerImpl());
        this.txtProjectNodeNameCustomPattern.setVisible(false);
        this.txtProjectNodeNameCustomPattern.getDocument().addDocumentListener(new DocumentListenerImpl());
        this.lstCategory.setSelectedIndex(0);
        this.lstCategory.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if ("dependencies".equals(value)) {
                    value = Bundle.CAT_Dependencies();
                } else if ("appearance".equals(value)) {
                    value = Bundle.CAT_Appearance();
                } else if ("index".equals(value)) {
                    value = Bundle.CAT_Index();
                } else if ("execution".equals(value)) {
                    value = Bundle.CAT_Execution();
                } else if ("experimental".equals(value)) {
                    value = Bundle.CAT_Experimental();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        DefaultComboBoxModel<NetworkProxySettings> mdl = new DefaultComboBoxModel<NetworkProxySettings>(NetworkProxySettings.values());
        if (!NetworkProxySettings.allowProxyOverride()) {
            mdl.removeElement((Object)NetworkProxySettings.OVERRIDE);
        }
        this.cbNetworkProxy.setModel(mdl);
        this.cbNetworkProxy.addActionListener(this.listener);
    }

    static String[] getAvailableOptionsDescriptions() {
        return new String[]{NbBundle.getMessage(SettingsPanel.class, (String)"WORK_OFFLINE"), NbBundle.getMessage(SettingsPanel.class, (String)"PRODUCE_EXECUTION_DEBUG_OUTPUT"), NbBundle.getMessage(SettingsPanel.class, (String)"PRODUCE_EXECUTION_ERROR_MESSAGES"), NbBundle.getMessage(SettingsPanel.class, (String)"NON-INTERACTIVE_MODE."), NbBundle.getMessage(SettingsPanel.class, (String)"STOP_AT_FIRST_FAILURE"), NbBundle.getMessage(SettingsPanel.class, (String)"ONLY_FAIL_THE_BUILD_AFTERWARDS"), NbBundle.getMessage(SettingsPanel.class, (String)"NEVER_FAIL_THE_BUILD"), NbBundle.getMessage(SettingsPanel.class, (String)"FAIL_CHECKSUMS"), NbBundle.getMessage(SettingsPanel.class, (String)"WARN_CHECKSUMS"), NbBundle.getMessage(SettingsPanel.class, (String)"FORCE_UPTODATE_CHECK"), NbBundle.getMessage(SettingsPanel.class, (String)"SUPPRESS_UPTODATE_CHECK"), NbBundle.getMessage(SettingsPanel.class, (String)"FORCES_A_CHECK"), NbBundle.getMessage(SettingsPanel.class, (String)"DON'T_USE_PLUGIN-REGISTRY"), NbBundle.getMessage(SettingsPanel.class, (String)"NO_TRANSFER_PROGRESS")};
    }

    private static List<String> getGlobalOptions() {
        return Arrays.asList(AVAILABLE_OPTIONS);
    }

    private String getSelectedRuntime(int selected) {
        if (selected < 0) {
            return null;
        }
        if (selected < this.predefinedRuntimes.size()) {
            return this.predefinedRuntimes.get(selected);
        }
        if (!this.userDefinedMavenRuntimes.isEmpty() && selected - this.predefinedRuntimes.size() <= this.userDefinedMavenRuntimes.size()) {
            return this.userDefinedMavenRuntimes.get(selected - 1 - this.predefinedRuntimes.size());
        }
        return null;
    }

    private void listDataChanged() {
        boolean oldvalid = this.valid;
        int selected = this.comMavenHome.getSelectedIndex();
        String path = this.getSelectedRuntime(selected);
        if (path != null && "".equals(path = path.trim())) {
            path = null;
            this.valid = true;
            this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"LBL_ExMavenVersion2", (Object)BUNDLED_RUNTIME_VERSION));
        }
        if (path != null) {
            path = path.trim();
            String ver = null;
            if (Files.exists(Paths.get(path, "bin"), new LinkOption[0])) {
                ver = MavenSettings.getCommandLineMavenVersion(new File(path));
            }
            if (ver != null) {
                this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"LBL_ExMavenVersion2", (Object)ver));
                this.valid = true;
            } else {
                this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"ERR_NoValidInstallation"));
            }
        }
        this.mavenRuntimeHome = path;
        if (oldvalid != this.valid) {
            this.controller.firePropChange("valid", oldvalid, this.valid);
        }
        this.fireChanged();
    }

    private ComboBoxModel createComboModel() {
        return new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(SettingsPanel.class, (String)"FREQ_weekly"), NbBundle.getMessage(SettingsPanel.class, (String)"FREQ_Daily"), NbBundle.getMessage(SettingsPanel.class, (String)"FREQ_Always")});
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.bgIndexFilter = new ButtonGroup();
        this.pnlCards = new JPanel();
        this.pnlAppearance = new JPanel();
        JPanel appearancePanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.cbProjectNodeNameMode = new JComboBox();
        this.txtProjectNodeNameCustomPattern = new JTextField();
        this.pnlDependencies = new JPanel();
        JPanel dependenciesPanel = new JPanel();
        this.lblBinaries = new JLabel();
        this.lblJavadoc = new JLabel();
        this.comBinaries = new JComboBox();
        this.comJavadoc = new JComboBox();
        this.comSource = new JComboBox();
        this.lblSource = new JLabel();
        this.jLabel3 = new JLabel();
        this.pnlIndex = new JPanel();
        JPanel indexerPanel = new JPanel();
        this.cbEnableIndexing = new JCheckBox();
        this.cbEnableIndexDownload = new JCheckBox();
        this.lblIndex = new JLabel();
        this.comIndex = new JComboBox();
        this.btnIndex = new JButton();
        JLabel descriptionLabel = new JLabel();
        JScrollPane permissionsTableScrollPane = new JScrollPane();
        this.permissionsTable = new JTable();
        this.cbEnableMultiThreading = new JCheckBox();
        this.lblIndexFilter = new JLabel();
        this.rbFullIndex = new JRadioButton();
        this.rb5Years = new JRadioButton();
        this.rb2Years = new JRadioButton();
        this.pnlExecution = new JPanel();
        this.lblCommandLine = new JLabel();
        this.comMavenHome = new JComboBox();
        this.lblExternalVersion = new JLabel();
        this.lblOptions = new JLabel();
        this.txtOptions = new JTextField();
        this.btnOptions = new JButton();
        this.cbSkipTests = new JCheckBox();
        this.btnGoals = new JButton();
        this.cbAlwaysShow = new JCheckBox();
        this.cbReuse = new JCheckBox();
        this.cbCollapseSuccessFolds = new JCheckBox();
        this.lblOutputTab = new JLabel();
        this.rbOutputTabName = new JRadioButton();
        this.rbOutputTabId = new JRadioButton();
        this.cbOutputTabShowConfig = new JCheckBox();
        this.cbShowInfoLevel = new JCheckBox();
        this.lblJdkHome = new JLabel();
        this.comJdkHome = new JComboBox();
        this.comManageJdks = new JButton();
        this.cbPreferWrapper = new JCheckBox();
        this.cbNetworkProxy = new JComboBox();
        this.lbNetworkSettings = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstCategory = new JList();
        this.lblCategory = new JLabel();
        this.pnlCards.setLayout(new CardLayout());
        appearancePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.appearancePanel.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jLabel4.text"));
        this.cbProjectNodeNameMode.setModel(this.getProjectNodeModel());
        this.cbProjectNodeNameMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.cbProjectNodeNameModeActionPerformed(evt);
            }
        });
        this.txtProjectNodeNameCustomPattern.setText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.txtProjectNodeNameCustomPattern.text"));
        this.txtProjectNodeNameCustomPattern.setToolTipText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.txtProjectNodeNameCustomPattern.toolTipText"));
        GroupLayout appearancePanelLayout = new GroupLayout(appearancePanel);
        appearancePanel.setLayout(appearancePanelLayout);
        appearancePanelLayout.setHorizontalGroup(appearancePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(appearancePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(appearancePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtProjectNodeNameCustomPattern).addComponent(this.cbProjectNodeNameMode, 0, 377, Short.MAX_VALUE)).addContainerGap()));
        appearancePanelLayout.setVerticalGroup(appearancePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(appearancePanelLayout.createSequentialGroup().addContainerGap().addGroup(appearancePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.cbProjectNodeNameMode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtProjectNodeNameCustomPattern, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout pnlAppearanceLayout = new GroupLayout(this.pnlAppearance);
        this.pnlAppearance.setLayout(pnlAppearanceLayout);
        pnlAppearanceLayout.setHorizontalGroup(pnlAppearanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAppearanceLayout.createSequentialGroup().addContainerGap().addComponent(appearancePanel, -1, -1, Short.MAX_VALUE)));
        pnlAppearanceLayout.setVerticalGroup(pnlAppearanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAppearanceLayout.createSequentialGroup().addContainerGap().addComponent(appearancePanel, -2, -1, -2).addContainerGap(354, Short.MAX_VALUE)));
        this.pnlCards.add((Component)this.pnlAppearance, "appearance");
        dependenciesPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.dependenciesPanel.border.title")));
        this.lblBinaries.setLabelFor(this.comBinaries);
        Mnemonics.setLocalizedText((JLabel)this.lblBinaries, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblBinaries.text"));
        this.lblJavadoc.setLabelFor(this.comJavadoc);
        Mnemonics.setLocalizedText((JLabel)this.lblJavadoc, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblJavadoc.text"));
        this.lblSource.setLabelFor(this.comSource);
        Mnemonics.setLocalizedText((JLabel)this.lblSource, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblSource.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jLabel3.text"));
        this.jLabel3.setVerticalAlignment(1);
        GroupLayout dependenciesPanelLayout = new GroupLayout(dependenciesPanel);
        dependenciesPanel.setLayout(dependenciesPanelLayout);
        dependenciesPanelLayout.setHorizontalGroup(dependenciesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dependenciesPanelLayout.createSequentialGroup().addContainerGap().addGroup(dependenciesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dependenciesPanelLayout.createSequentialGroup().addComponent(this.lblJavadoc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comJavadoc, 0, 384, Short.MAX_VALUE)).addGroup(dependenciesPanelLayout.createSequentialGroup().addComponent(this.lblBinaries).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comBinaries, 0, -1, Short.MAX_VALUE)).addGroup(dependenciesPanelLayout.createSequentialGroup().addComponent(this.lblSource).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comSource, 0, -1, Short.MAX_VALUE)).addComponent(this.jLabel3, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        dependenciesPanelLayout.linkSize(0, this.lblBinaries, this.lblJavadoc, this.lblSource);
        dependenciesPanelLayout.setVerticalGroup(dependenciesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dependenciesPanelLayout.createSequentialGroup().addContainerGap().addGroup(dependenciesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBinaries).addComponent(this.comBinaries, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dependenciesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblJavadoc).addComponent(this.comJavadoc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dependenciesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSource).addComponent(this.comSource, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel3, -1, 36, Short.MAX_VALUE).addContainerGap()));
        GroupLayout pnlDependenciesLayout = new GroupLayout(this.pnlDependencies);
        this.pnlDependencies.setLayout(pnlDependenciesLayout);
        pnlDependenciesLayout.setHorizontalGroup(pnlDependenciesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDependenciesLayout.createSequentialGroup().addContainerGap().addComponent(dependenciesPanel, -1, -1, Short.MAX_VALUE)));
        pnlDependenciesLayout.setVerticalGroup(pnlDependenciesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDependenciesLayout.createSequentialGroup().addContainerGap().addComponent(dependenciesPanel, -2, -1, -2).addContainerGap(277, Short.MAX_VALUE)));
        this.pnlCards.add((Component)this.pnlDependencies, "dependencies");
        indexerPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.indexerPanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableIndexing, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbEnableIndexing.text"));
        this.cbEnableIndexing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.cbEnableIndexingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableIndexDownload, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbEnableIndexDownload.text"));
        this.cbEnableIndexDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.cbEnableIndexDownloadActionPerformed(evt);
            }
        });
        this.lblIndex.setLabelFor(this.comIndex);
        Mnemonics.setLocalizedText((JLabel)this.lblIndex, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblIndex.text"));
        this.comIndex.setModel(this.createComboModel());
        Mnemonics.setLocalizedText((AbstractButton)this.btnIndex, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnIndex.text"));
        this.btnIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.btnIndexActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)descriptionLabel, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.descriptionLabel.text"));
        descriptionLabel.setVerticalAlignment(1);
        descriptionLabel.setPreferredSize(new Dimension(1275, 165));
        this.permissionsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Repository URL", "Permission"}));
        permissionsTableScrollPane.setViewportView(this.permissionsTable);
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableMultiThreading, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbEnableMultiThreading.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblIndexFilter, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblIndexFilter.text"));
        this.bgIndexFilter.add(this.rbFullIndex);
        this.rbFullIndex.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbFullIndex, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.rbFullIndex.text"));
        this.bgIndexFilter.add(this.rb5Years);
        Mnemonics.setLocalizedText((AbstractButton)this.rb5Years, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.rb5Years.text"));
        this.bgIndexFilter.add(this.rb2Years);
        Mnemonics.setLocalizedText((AbstractButton)this.rb2Years, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.rb2Years.text"));
        GroupLayout indexerPanelLayout = new GroupLayout(indexerPanel);
        indexerPanel.setLayout(indexerPanelLayout);
        indexerPanelLayout.setHorizontalGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indexerPanelLayout.createSequentialGroup().addContainerGap().addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(permissionsTableScrollPane).addComponent(descriptionLabel, -2, 0, Short.MAX_VALUE).addGroup(indexerPanelLayout.createSequentialGroup().addComponent(this.lblIndex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comIndex, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnIndex)).addGroup(indexerPanelLayout.createSequentialGroup().addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbEnableIndexing, -1, -1, Short.MAX_VALUE).addComponent(this.cbEnableIndexDownload).addComponent(this.cbEnableMultiThreading, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.lblIndexFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbFullIndex).addComponent(this.rb5Years).addComponent(this.rb2Years)))).addContainerGap()));
        indexerPanelLayout.setVerticalGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indexerPanelLayout.createSequentialGroup().addContainerGap().addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbEnableIndexing).addComponent(this.lblIndexFilter).addComponent(this.rbFullIndex)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbEnableIndexDownload).addComponent(this.rb5Years)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbEnableMultiThreading).addComponent(this.rb2Years)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(indexerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblIndex).addComponent(this.comIndex, -2, -1, -2).addComponent(this.btnIndex)).addGap(18, 18, 18).addComponent(permissionsTableScrollPane, -1, 107, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(descriptionLabel, -2, -1, -2).addContainerGap()));
        GroupLayout pnlIndexLayout = new GroupLayout(this.pnlIndex);
        this.pnlIndex.setLayout(pnlIndexLayout);
        pnlIndexLayout.setHorizontalGroup(pnlIndexLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlIndexLayout.createSequentialGroup().addContainerGap().addComponent(indexerPanel, -1, -1, Short.MAX_VALUE)));
        pnlIndexLayout.setVerticalGroup(pnlIndexLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlIndexLayout.createSequentialGroup().addContainerGap().addComponent(indexerPanel, -1, -1, Short.MAX_VALUE)));
        this.pnlCards.add((Component)this.pnlIndex, "index");
        this.lblCommandLine.setLabelFor(this.comMavenHome);
        Mnemonics.setLocalizedText((JLabel)this.lblCommandLine, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblCommandLine.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblOptions, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblOptions.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOptions, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnOptions.text"));
        this.btnOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.btnOptionsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbSkipTests, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbSkipTests.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnGoals, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnGoals.text"));
        this.btnGoals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.btnGoalsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbAlwaysShow, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbAlwaysShow.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbReuse, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbReuse.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCollapseSuccessFolds, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbCollapseSuccessFolds.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblOutputTab, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblOutputTab.text"));
        this.buttonGroup1.add(this.rbOutputTabName);
        this.rbOutputTabName.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbOutputTabName, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.rbOutputTabName.text"));
        this.buttonGroup1.add(this.rbOutputTabId);
        Mnemonics.setLocalizedText((AbstractButton)this.rbOutputTabId, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.rbOutputTabId.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbOutputTabShowConfig, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbOutputTabShowConfig.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowInfoLevel, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbShowInfoLevel.text"));
        this.cbShowInfoLevel.setToolTipText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbShowInfoLevel.toolTipText"));
        this.lblCommandLine.setLabelFor(this.comMavenHome);
        Mnemonics.setLocalizedText((JLabel)this.lblJdkHome, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblJdkHome.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.comManageJdks, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.comManageJdks.text"));
        this.comManageJdks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.comManageJdksActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbPreferWrapper, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbPreferWrapper.text"));
        this.lbNetworkSettings.setLabelFor(this.cbNetworkProxy);
        Mnemonics.setLocalizedText((JLabel)this.lbNetworkSettings, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lbNetworkSettings.text"));
        GroupLayout pnlExecutionLayout = new GroupLayout(this.pnlExecution);
        this.pnlExecution.setLayout(pnlExecutionLayout);
        pnlExecutionLayout.setHorizontalGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExecutionLayout.createSequentialGroup().addGap(119, 119, 119).addComponent(this.lblExternalVersion, -1, -1, Short.MAX_VALUE)).addGroup(pnlExecutionLayout.createSequentialGroup().addContainerGap().addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExecutionLayout.createSequentialGroup().addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlExecutionLayout.createSequentialGroup().addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbAlwaysShow).addComponent(this.cbReuse).addComponent(this.cbCollapseSuccessFolds).addGroup(pnlExecutionLayout.createSequentialGroup().addComponent(this.lblOutputTab).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbOutputTabShowConfig).addGroup(pnlExecutionLayout.createSequentialGroup().addComponent(this.rbOutputTabName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbOutputTabId)))).addComponent(this.cbShowInfoLevel).addComponent(this.btnGoals)).addGap(18, 18, 18)).addComponent(this.cbSkipTests, GroupLayout.Alignment.LEADING)).addGap(58, 58, 58)).addGroup(pnlExecutionLayout.createSequentialGroup().addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExecutionLayout.createSequentialGroup().addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCommandLine).addComponent(this.lblJdkHome)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExecutionLayout.createSequentialGroup().addComponent(this.cbPreferWrapper).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.comMavenHome, 0, -1, Short.MAX_VALUE).addGroup(pnlExecutionLayout.createSequentialGroup().addComponent(this.comJdkHome, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comManageJdks)))).addGroup(GroupLayout.Alignment.TRAILING, pnlExecutionLayout.createSequentialGroup().addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblOptions, -1, -1, Short.MAX_VALUE).addComponent(this.lbNetworkSettings, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbNetworkProxy, 0, -1, Short.MAX_VALUE).addComponent(this.txtOptions)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOptions))).addContainerGap()))));
        pnlExecutionLayout.setVerticalGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExecutionLayout.createSequentialGroup().addContainerGap().addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCommandLine).addComponent(this.comMavenHome, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblExternalVersion, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPreferWrapper).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblJdkHome).addComponent(this.comJdkHome, -2, -1, -2).addComponent(this.comManageJdks)).addGap(31, 31, 31).addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOptions).addComponent(this.txtOptions, -2, -1, -2).addComponent(this.btnOptions)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cbNetworkProxy, -2, -1, -2).addGroup(pnlExecutionLayout.createSequentialGroup().addComponent(this.lbNetworkSettings, -2, 16, -2).addGap(3, 3, 3))).addGap(18, 18, 18).addComponent(this.cbSkipTests).addGap(18, 18, 18).addComponent(this.btnGoals).addGap(18, 18, 18).addComponent(this.cbReuse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowInfoLevel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAlwaysShow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOutputTab).addComponent(this.rbOutputTabName).addComponent(this.rbOutputTabId)).addGap(6, 6, 6).addComponent(this.cbOutputTabShowConfig).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbCollapseSuccessFolds).addContainerGap()));
        this.pnlCards.add((Component)this.pnlExecution, "execution");
        this.lstCategory.setModel(new AbstractListModel(){
            String[] strings = new String[]{"execution", "index", "appearance", "dependencies"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstCategory.setSelectionMode(0);
        this.lstCategory.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SettingsPanel.this.lstCategoryValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstCategory);
        this.lblCategory.setLabelFor(this.lstCategory);
        Mnemonics.setLocalizedText((JLabel)this.lblCategory, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblCategory.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 140, -2).addComponent(this.lblCategory)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlCards, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblCategory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1)).addComponent(this.pnlCards, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
    }

    private void btnIndexActionPerformed(ActionEvent evt) {
        this.btnIndex.setEnabled(false);
        new RequestProcessor("Maven Repo Index Transfer/Scan").post(() -> {
            RepositoryPreferences.continueIndexDownloads();
            for (RepositoryInfo repo : RepositoryPreferences.getInstance().getRepositoryInfos()) {
                RepositoryIndexer.indexRepo((RepositoryInfo)repo);
            }
            SwingUtilities.invokeLater(() -> this.btnIndex.setEnabled(true));
        });
    }

    private void btnGoalsActionPerformed(ActionEvent evt) {
        SettingsPanel.showGlobalMavenGoalCustomizer();
    }

    public static void showGlobalMavenGoalCustomizer() {
        NbGlobalActionGoalProvider provider = (NbGlobalActionGoalProvider)Lookup.getDefault().lookup(NbGlobalActionGoalProvider.class);
        assert (provider != null);
        try {
            ActionToGoalMapping mappings = new NetbeansBuildActionXpp3Reader().read(new StringReader(provider.getRawMappingsAsString()));
            ActionMappings panel = new ActionMappings(mappings);
            panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SettingsPanel.class, (String)"ACSD_Global"));
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Global"));
            Object retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (retVal == DialogDescriptor.OK_OPTION) {
                FileObject dir = FileUtil.getConfigFile((String)"Projects/org-netbeans-modules-maven");
                CustomizerProviderImpl.writeNbActionsModel(dir, mappings, M2Configuration.getFileNameExt("%%DEFAULT%%"));
                panel.applyToolbarChanges();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void btnOptionsActionPerformed(ActionEvent evt) {
        GlobalOptionsPanel pnl = new GlobalOptionsPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Add_Globals"));
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == DialogDescriptor.OK_OPTION) {
            this.txtOptions.setText(this.txtOptions.getText() + pnl.getSelectedOnes());
        }
    }

    private void cbProjectNodeNameModeActionPerformed(ActionEvent evt) {
        this.txtProjectNodeNameCustomPattern.setVisible(this.cbProjectNodeNameMode.getSelectedIndex() == this.cbProjectNodeNameMode.getItemCount() - 1);
        this.txtProjectNodeNameCustomPattern.getParent().invalidate();
        this.txtProjectNodeNameCustomPattern.getParent().revalidate();
        this.txtProjectNodeNameCustomPattern.getParent().repaint();
    }

    private void lstCategoryValueChanged(ListSelectionEvent evt) {
        CardLayout cl = (CardLayout)this.pnlCards.getLayout();
        cl.show(this.pnlCards, (String)this.lstCategory.getSelectedValue());
    }

    private void comManageJdksActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.findSelectedJdk(new String[1]));
    }

    private void cbEnableIndexingActionPerformed(ActionEvent evt) {
        this.updateIndexingControls();
    }

    private void cbEnableIndexDownloadActionPerformed(ActionEvent evt) {
        this.updateIndexingControls();
    }

    private void updateIndexingControls() {
        this.cbEnableIndexDownload.setEnabled(this.cbEnableIndexing.isSelected());
        this.cbEnableMultiThreading.setEnabled(this.cbEnableIndexing.isSelected() && this.cbEnableIndexDownload.isSelected());
        this.comIndex.setEnabled(this.cbEnableIndexing.isSelected() && this.cbEnableIndexDownload.isSelected());
        this.lblIndex.setEnabled(this.cbEnableIndexing.isSelected() && this.cbEnableIndexDownload.isSelected());
        this.btnIndex.setEnabled(this.cbEnableIndexing.isSelected());
        this.lblIndexFilter.setEnabled(this.cbEnableIndexing.isSelected() && this.cbEnableIndexDownload.isSelected());
        this.rbFullIndex.setEnabled(this.cbEnableIndexing.isSelected() && this.cbEnableIndexDownload.isSelected());
        this.rb5Years.setEnabled(this.cbEnableIndexing.isSelected() && this.cbEnableIndexDownload.isSelected());
        this.rb2Years.setEnabled(this.cbEnableIndexing.isSelected() && this.cbEnableIndexDownload.isSelected());
    }

    private int getDateCutoffFilterValue() {
        return this.rb5Years.isSelected() ? 5 : (this.rb2Years.isSelected() ? 2 : 0);
    }

    private DefaultComboBoxModel getProjectNodeModel() {
        return new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblDefault.text"), "${project.artifactId}", "${project.artifactId}-TRUNK", "${project.artifactId}-${project.version}", "${project.groupId}.${project.artifactId}", "${project.groupId}.${project.artifactId}-${project.version}", NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblCustom.text")});
    }

    private void browseAddNewRuntime() {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Select2"));
        chooser.setFileSelectionMode(1);
        chooser.setFileHidingEnabled(false);
        int selected = this.comMavenHome.getSelectedIndex();
        String path = this.getSelectedRuntime(selected);
        if (path == null || path.isBlank()) {
            path = new File(System.getProperty("user.home")).getAbsolutePath();
        }
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            String newRuntimePath = FileUtil.normalizeFile((File)projectDir).getAbsolutePath();
            boolean existed = false;
            ArrayList<String> runtimes = new ArrayList<String>();
            runtimes.addAll(this.predefinedRuntimes);
            runtimes.addAll(this.userDefinedMavenRuntimes);
            for (String runtime : runtimes) {
                if (!runtime.equals(newRuntimePath)) continue;
                existed = true;
            }
            if (!existed) {
                if (this.userDefinedMavenRuntimes.isEmpty()) {
                    this.mavenHomeDataModel.insertElementAt(SEPARATOR, this.predefinedRuntimes.size());
                }
                this.userDefinedMavenRuntimes.add(newRuntimePath);
                this.mavenHomeDataModel.insertElementAt(newRuntimePath, runtimes.size() + 1);
            }
            this.comMavenHome.setSelectedItem(newRuntimePath);
        }
    }

    public void setValues() {
        this.txtOptions.setText(MavenSettings.getDefault().getDefaultOptions());
        final ArrayList predefined = new ArrayList();
        final ArrayList user = new ArrayList();
        RP.post(new Runnable(){
            final /* synthetic */ SettingsPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                predefined.add("");
                String defaultExternalMavenRuntime = MavenSettings.getDefaultExternalMavenRuntime();
                if (defaultExternalMavenRuntime != null) {
                    predefined.add(defaultExternalMavenRuntime);
                }
                user.addAll(MavenSettings.getDefault().getUserDefinedMavenRuntimes());
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.predefinedRuntimes.clear();
                        this.this$1.this$0.userDefinedMavenRuntimes.clear();
                        this.this$1.this$0.userDefinedMavenRuntimesStored.clear();
                        this.this$1.this$0.predefinedRuntimes.addAll(predefined);
                        this.this$1.this$0.userDefinedMavenRuntimes.addAll(user);
                        this.this$1.this$0.userDefinedMavenRuntimesStored.addAll(user);
                        this.this$1.this$0.comMavenHome.removeActionListener(this.this$1.this$0.listItemChangedListener);
                        this.this$1.this$0.mavenHomeDataModel.removeAllElements();
                        File command = EmbedderFactory.getMavenHome();
                        for (String runtime : this.this$1.this$0.predefinedRuntimes) {
                            boolean bundledRuntime = runtime.isEmpty();
                            String desc = bundledRuntime ? Bundle.MAVEN_RUNTIME_Bundled() : Bundle.MAVEN_RUNTIME_External(runtime);
                            this.this$1.this$0.mavenHomeDataModel.addElement(desc);
                        }
                        this.this$1.this$0.jdkHomeDataModel.removeAllElements();
                        JavaPlatform def = JavaPlatformManager.getDefault().getDefaultPlatform();
                        String defJdkName = MavenSettings.getDefault().getDefaultJdk();
                        if (defJdkName.isEmpty()) {
                            defJdkName = def.getDisplayName();
                        }
                        for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                            this.this$1.this$0.jdkHomeDataModel.addElement(p.getDisplayName());
                            String antName = (String)p.getProperties().get("platform.ant.name");
                            if (!defJdkName.equals(p.getDisplayName()) && !defJdkName.equals(antName)) continue;
                            this.this$1.this$0.jdkHomeDataModel.setSelectedItem(p.getDisplayName());
                        }
                        if (!this.this$1.this$0.userDefinedMavenRuntimes.isEmpty()) {
                            this.this$1.this$0.mavenHomeDataModel.addElement(SettingsPanel.SEPARATOR);
                            for (String runtime : this.this$1.this$0.userDefinedMavenRuntimes) {
                                String desc = Bundle.MAVEN_RUNTIME_External(runtime);
                                this.this$1.this$0.mavenHomeDataModel.addElement(desc);
                            }
                        }
                        this.this$1.this$0.mavenHomeDataModel.addElement(SettingsPanel.SEPARATOR);
                        this.this$1.this$0.mavenHomeDataModel.addElement(Bundle.MAVEN_RUNTIME_Browse());
                        this.this$1.this$0.comMavenHome.setSelectedItem(command.getAbsolutePath());
                        this.this$1.this$0.listDataChanged();
                        this.this$1.this$0.lastSelected = this.this$1.this$0.comMavenHome.getSelectedIndex();
                        this.this$1.this$0.comMavenHome.addActionListener(this.this$1.this$0.listItemChangedListener);
                        this.this$1.this$0.changed = false;
                    }
                });
            }
        });
        this.comIndex.setSelectedIndex(RepositoryPreferences.getIndexUpdateFrequency());
        this.cbEnableIndexing.setSelected(RepositoryPreferences.isIndexRepositories());
        this.cbEnableIndexDownload.setSelected(RepositoryPreferences.isIndexDownloadEnabled());
        this.cbEnableMultiThreading.setSelected(RepositoryPreferences.isMultiThreadedIndexExtractionEnabled());
        switch (RepositoryPreferences.getIndexDateCutoffFilter()) {
            case 5: {
                this.rb5Years.setSelected(true);
                break;
            }
            case 2: {
                this.rb2Years.setSelected(true);
                break;
            }
            default: {
                this.rbFullIndex.setSelected(true);
            }
        }
        this.comBinaries.setSelectedItem((Object)MavenSettings.getDefault().getBinaryDownloadStrategy());
        this.comJavadoc.setSelectedItem((Object)MavenSettings.getDefault().getJavadocDownloadStrategy());
        this.comSource.setSelectedItem((Object)MavenSettings.getDefault().getSourceDownloadStrategy());
        this.cbSkipTests.setSelected(MavenSettings.getDefault().isSkipTests());
        this.cbAlwaysShow.setSelected(MavenSettings.getDefault().isAlwaysShowOutput());
        this.cbShowInfoLevel.setSelected(MavenSettings.getDefault().isShowLoggingLevel());
        this.cbReuse.setSelected(MavenSettings.getDefault().isReuseOutputTabs());
        this.cbCollapseSuccessFolds.setSelected(MavenSettings.getDefault().isCollapseSuccessFolds());
        this.cbOutputTabShowConfig.setSelected(MavenSettings.getDefault().isOutputTabShowConfig());
        this.cbPreferWrapper.setSelected(MavenSettings.getDefault().isPreferMavenWrapper());
        this.updateIndexingControls();
        this.updatePermissionsTable();
        if (MavenSettings.OutputTabName.PROJECT_NAME.equals((Object)MavenSettings.getDefault().getOutputTabName())) {
            this.rbOutputTabName.setSelected(true);
        } else {
            this.rbOutputTabId.setSelected(true);
        }
        String pattern = MavenSettings.getDefault().getProjectNodeNamePattern();
        this.txtProjectNodeNameCustomPattern.setText("");
        if (null == pattern || pattern.isEmpty()) {
            this.cbProjectNodeNameMode.setSelectedIndex(0);
        } else {
            boolean start = true;
            int end = this.cbProjectNodeNameMode.getItemCount() - 1;
            boolean foundPredefinedPattern = false;
            for (int i = 1; i < end; ++i) {
                Object itemAt = this.cbProjectNodeNameMode.getItemAt(i);
                if (!pattern.equals(itemAt)) continue;
                this.cbProjectNodeNameMode.setSelectedIndex(i);
                foundPredefinedPattern = true;
                break;
            }
            if (!foundPredefinedPattern) {
                this.cbProjectNodeNameMode.setSelectedIndex(this.cbProjectNodeNameMode.getItemCount() - 1);
                this.txtProjectNodeNameCustomPattern.setText(pattern);
            }
        }
        this.cbNetworkProxy.setSelectedItem((Object)MavenSettings.getDefault().getNetworkProxy());
        this.changed = false;
    }

    public void applyValues() {
        File command;
        MavenSettings.getDefault().setDefaultOptions(this.txtOptions.getText().trim());
        MavenSettings.getDefault().setDefaultJdk(this.findSelectedJdkName());
        ArrayList<String> runtimes = new ArrayList<String>();
        for (int i = 0; i < this.userDefinedMavenRuntimes.size() && i < 5; ++i) {
            runtimes.add(0, this.userDefinedMavenRuntimes.get(this.userDefinedMavenRuntimes.size() - 1 - i));
        }
        int selected = this.comMavenHome.getSelectedIndex() - this.predefinedRuntimes.size() - 1;
        if (selected >= 0 && runtimes.size() == 5 && this.userDefinedMavenRuntimes.size() - 5 > selected) {
            runtimes.set(0, this.userDefinedMavenRuntimes.get(selected));
        }
        if (this.predefinedRuntimes.size() > 1) {
            runtimes.add(0, this.predefinedRuntimes.get(1));
        }
        MavenSettings.getDefault().setMavenRuntimes(runtimes);
        String cl = this.mavenRuntimeHome;
        File file = command = cl == null || cl.isEmpty() ? null : new File(cl);
        if (command != null && command.isDirectory()) {
            EmbedderFactory.setMavenHome((File)command);
        } else {
            EmbedderFactory.setMavenHome(null);
        }
        RepositoryPreferences.setIndexUpdateFrequency((int)this.comIndex.getSelectedIndex());
        RepositoryPreferences.setIndexRepositories((boolean)this.cbEnableIndexing.isSelected());
        RepositoryPreferences.setIndexDownloadEnabled((boolean)this.cbEnableIndexDownload.isSelected());
        RepositoryPreferences.setMultiThreadedIndexExtractionEnabled((boolean)this.cbEnableMultiThreading.isSelected());
        RepositoryPreferences.setIndexDateCutoffFilter((int)this.getDateCutoffFilterValue());
        RepositoryPreferences.setIndexDownloadPermissions(((IndexDownloadPermissionTableModel)this.permissionsTable.getModel()).getPermissions());
        MavenSettings.getDefault().setBinaryDownloadStrategy((MavenSettings.DownloadStrategy)((Object)this.comBinaries.getSelectedItem()));
        MavenSettings.getDefault().setJavadocDownloadStrategy((MavenSettings.DownloadStrategy)((Object)this.comJavadoc.getSelectedItem()));
        MavenSettings.getDefault().setSourceDownloadStrategy((MavenSettings.DownloadStrategy)((Object)this.comSource.getSelectedItem()));
        MavenSettings.getDefault().setSkipTests(this.cbSkipTests.isSelected());
        MavenSettings.getDefault().setAlwaysShowOutput(this.cbAlwaysShow.isSelected());
        MavenSettings.getDefault().setShowLoggingLevel(this.cbShowInfoLevel.isSelected());
        MavenSettings.getDefault().setReuseOutputTabs(this.cbReuse.isSelected());
        MavenSettings.getDefault().setCollapseSuccessFolds(this.cbCollapseSuccessFolds.isSelected());
        MavenSettings.getDefault().setOutputTabShowConfig(this.cbOutputTabShowConfig.isSelected());
        MavenSettings.getDefault().setPreferMavenWrapper(this.cbPreferWrapper.isSelected());
        MavenSettings.OutputTabName name = this.rbOutputTabName.isSelected() ? MavenSettings.OutputTabName.PROJECT_NAME : MavenSettings.OutputTabName.PROJECT_ID;
        MavenSettings.getDefault().setOutputTabName(name);
        if (0 == this.cbProjectNodeNameMode.getSelectedIndex()) {
            MavenSettings.getDefault().setProjectNodeNamePattern(null);
        } else if (this.cbProjectNodeNameMode.getSelectedIndex() == this.cbProjectNodeNameMode.getItemCount() - 1) {
            MavenSettings.getDefault().setProjectNodeNamePattern(this.txtProjectNodeNameCustomPattern.getText());
        } else {
            MavenSettings.getDefault().setProjectNodeNamePattern(this.cbProjectNodeNameMode.getSelectedItem().toString());
        }
        MavenSettings.getDefault().setNetworkProxy((NetworkProxySettings)((Object)this.cbNetworkProxy.getSelectedItem()));
        this.changed = false;
    }

    boolean hasValidValues() {
        return this.valid;
    }

    boolean hasChangedValues() {
        return this.changed;
    }

    private void fireChanged() {
        boolean isChanged = !MavenSettings.getDefault().getDefaultOptions().equals(this.txtOptions.getText().trim());
        ArrayList<String> runtimes = new ArrayList<String>();
        for (int i = 0; i < this.userDefinedMavenRuntimes.size() && i < 5; ++i) {
            runtimes.add(0, this.userDefinedMavenRuntimes.get(this.userDefinedMavenRuntimes.size() - 1 - i));
        }
        int selected = this.comMavenHome.getSelectedIndex() - this.predefinedRuntimes.size() - 1;
        if (selected >= 0 && runtimes.size() == 5 && this.userDefinedMavenRuntimes.size() - 5 > selected) {
            runtimes.set(0, this.userDefinedMavenRuntimes.get(selected));
        }
        if (this.predefinedRuntimes.size() > 1) {
            runtimes.add(0, this.predefinedRuntimes.get(1));
        }
        isChanged |= !this.userDefinedMavenRuntimesStored.equals(runtimes);
        isChanged |= !this.findSelectedJdkName().equals(MavenSettings.getDefault().getDefaultJdk());
        String cl = this.mavenRuntimeHome;
        File command = cl == null || cl.isEmpty() ? null : new File(cl);
        File mavenHome = EmbedderFactory.getMavenHome();
        isChanged = mavenHome == null ? (isChanged |= command != null && command.isDirectory()) : (isChanged |= !mavenHome.equals(command == null ? EmbedderFactory.getDefaultMavenHome() : command));
        isChanged |= !((IndexDownloadPermissionTableModel)this.permissionsTable.getModel()).getPermissions().equals(RepositoryPreferences.getIndexDownloadPermissions());
        isChanged |= RepositoryPreferences.getIndexUpdateFrequency() != this.comIndex.getSelectedIndex();
        isChanged |= RepositoryPreferences.isIndexRepositories() != this.cbEnableIndexing.isSelected();
        isChanged |= RepositoryPreferences.isIndexDownloadEnabled() != this.cbEnableIndexDownload.isSelected();
        isChanged |= RepositoryPreferences.isMultiThreadedIndexExtractionEnabled() != this.cbEnableMultiThreading.isSelected();
        isChanged |= RepositoryPreferences.getIndexDateCutoffFilter() != this.getDateCutoffFilterValue();
        isChanged |= MavenSettings.getDefault().getBinaryDownloadStrategy().compareTo((MavenSettings.DownloadStrategy)((Object)this.comBinaries.getSelectedItem())) != 0;
        isChanged |= MavenSettings.getDefault().getJavadocDownloadStrategy().compareTo((MavenSettings.DownloadStrategy)((Object)this.comJavadoc.getSelectedItem())) != 0;
        isChanged |= MavenSettings.getDefault().getSourceDownloadStrategy().compareTo((MavenSettings.DownloadStrategy)((Object)this.comSource.getSelectedItem())) != 0;
        isChanged |= MavenSettings.getDefault().isSkipTests() != this.cbSkipTests.isSelected();
        isChanged |= MavenSettings.getDefault().isAlwaysShowOutput() != this.cbAlwaysShow.isSelected();
        isChanged |= MavenSettings.getDefault().isShowLoggingLevel() != this.cbShowInfoLevel.isSelected();
        isChanged |= MavenSettings.getDefault().isReuseOutputTabs() != this.cbReuse.isSelected();
        isChanged |= MavenSettings.getDefault().isCollapseSuccessFolds() != this.cbCollapseSuccessFolds.isSelected();
        isChanged |= MavenSettings.getDefault().isOutputTabShowConfig() != this.cbOutputTabShowConfig.isSelected();
        isChanged |= MavenSettings.getDefault().isPreferMavenWrapper() != this.cbPreferWrapper.isSelected();
        MavenSettings.OutputTabName name = this.rbOutputTabName.isSelected() ? MavenSettings.OutputTabName.PROJECT_NAME : MavenSettings.OutputTabName.PROJECT_ID;
        isChanged |= MavenSettings.getDefault().getOutputTabName().compareTo(name) != 0;
        String projectNodeNamePattern = MavenSettings.getDefault().getProjectNodeNamePattern();
        isChanged = this.cbProjectNodeNameMode.getSelectedIndex() == 0 ? (isChanged |= projectNodeNamePattern != null) : (this.cbProjectNodeNameMode.getSelectedIndex() == this.cbProjectNodeNameMode.getItemCount() - 1 ? (isChanged |= projectNodeNamePattern == null ? !this.txtProjectNodeNameCustomPattern.getText().isEmpty() : !projectNodeNamePattern.equals(this.txtProjectNodeNameCustomPattern.getText())) : (isChanged |= projectNodeNamePattern == null ? !this.cbProjectNodeNameMode.getSelectedItem().toString().isEmpty() : !projectNodeNamePattern.equals(this.cbProjectNodeNameMode.getSelectedItem().toString())));
        this.changed = isChanged |= MavenSettings.getDefault().getNetworkProxy() != this.cbNetworkProxy.getSelectedItem();
    }

    final String findSelectedJdkName() {
        String[] name = new String[]{null};
        this.findSelectedJdk(name);
        return name[0];
    }

    private final JavaPlatform findSelectedJdk(String[] name) {
        if (this.jdkHomeDataModel == null) {
            name[0] = "";
            return null;
        }
        String jdk = (String)this.jdkHomeDataModel.getSelectedItem();
        JavaPlatform def = JavaPlatformManager.getDefault().getDefaultPlatform();
        if (jdk == null || jdk.equals(def.getDisplayName())) {
            name[0] = "";
            return def;
        }
        for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String antName;
            if (!jdk.equals(p.getDisplayName()) || (antName = (String)p.getProperties().get("platform.ant.name")) == null) continue;
            name[0] = antName;
            return p;
        }
        name[0] = jdk;
        return null;
    }

    private void updatePermissionsTable() {
        this.permissionsTable.setModel(new IndexDownloadPermissionTableModel());
        this.permissionsTable.getModel().addTableModelListener(e -> this.fireChanged());
        this.permissionsTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(new JComboBox<String>(new String[]{Bundle.TXT_PermissionTable_Permission_allow(), Bundle.TXT_PermissionTable_Permission_deny(), Bundle.TXT_PermissionTable_Permission_remove()})));
    }

    private static class ComboBoxRenderer
    extends DefaultListCellRenderer {
        private final JSeparator separator = new JSeparator(0);

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (SettingsPanel.SEPARATOR.equals(value)) {
                return this.separator;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsPanel.this.fireChanged();
        }
    }

    private class DocumentListenerImpl
    implements DocumentListener {
        private DocumentListenerImpl() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SettingsPanel.this.fireChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SettingsPanel.this.fireChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SettingsPanel.this.fireChanged();
        }
    }

    private static final class IndexDownloadPermissionTableModel
    extends AbstractTableModel {
        private final List<Map.Entry<String, Boolean>> model = new ArrayList(RepositoryPreferences.getIndexDownloadPermissions().entrySet());

        private IndexDownloadPermissionTableModel() {
            this.model.sort((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey()));
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? Bundle.TXT_PermissionTableHeader_RepoUrl() : Bundle.TXT_PermissionTableHeader_Permission();
        }

        @Override
        public int getRowCount() {
            return this.model.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (column == 1) {
                String str = value.toString();
                if (str.equals(Bundle.TXT_PermissionTable_Permission_allow())) {
                    this.model.get(row).setValue(true);
                } else if (str.equals(Bundle.TXT_PermissionTable_Permission_deny())) {
                    this.model.get(row).setValue(false);
                } else {
                    this.model.get(row).setValue(null);
                }
                this.fireTableDataChanged();
            }
        }

        private String getValueString(Boolean value) {
            if (value == null) {
                return Bundle.TXT_PermissionTable_Permission_remove();
            }
            return value != false ? Bundle.TXT_PermissionTable_Permission_allow() : Bundle.TXT_PermissionTable_Permission_deny();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Map.Entry<String, Boolean> entry = this.model.get(rowIndex);
            return columnIndex == 0 ? entry.getKey() : this.getValueString(entry.getValue());
        }

        public Map<String, Boolean> getPermissions() {
            return this.model.stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

