/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.BasicAggregateProgressFactory;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.DependencyType;
import org.netbeans.modules.maven.ModuleInfoSupport;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.nodes.AddDependencyPanel;
import org.netbeans.modules.maven.nodes.Bundle;
import org.netbeans.modules.maven.nodes.DependencyNode;
import org.netbeans.modules.maven.nodes.PathFinders;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class DependenciesNode
extends AbstractNode {
    private static final Logger LOG = Logger.getLogger(DependenciesNode.class.getName());
    public static final String PREF_DEPENDENCIES_UI = "org/netbeans/modules/maven/dependencies/ui";
    private static final String LIBS_BADGE = "org/netbeans/modules/maven/libraries-badge.png";
    private static final String DEF_FOLDER = "org/netbeans/modules/maven/defaultFolder.gif";
    private final DependenciesSet dependencies;
    private static final RequestProcessor RP = new RequestProcessor(DependenciesNode.class);
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final String ICON_PATH = "org/netbeans/modules/maven/defaultFolder.gif";
    private static final String OPENED_ICON_PATH = "org/netbeans/modules/maven/defaultFolderOpen.gif";

    DependenciesNode(DependenciesSet dependencies) {
        super(Children.create((ChildFactory)new DependenciesChildren(dependencies), (boolean)true), Lookups.fixed((Object[])new Object[]{dependencies.project, PathFinders.createPathFinder()}));
        this.dependencies = dependencies;
        this.setName("Dependencies" + String.valueOf((Object)dependencies.type));
        switch (dependencies.type) {
            case COMPILE: {
                this.setDisplayName(Bundle.LBL_Libraries());
                break;
            }
            case TEST: {
                this.setDisplayName(Bundle.LBL_Test_Libraries());
                break;
            }
            case RUNTIME: {
                this.setDisplayName(Bundle.LBL_Runtime_Libraries());
                break;
            }
            default: {
                this.setDisplayName(Bundle.LBL_non_cp_libraries());
            }
        }
        this.setIconBaseWithExtension("org/netbeans/modules/maven/defaultFolder.gif");
    }

    public Image getIcon(int param) {
        Image retValue = ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(false), (Image)ImageUtilities.loadImage((String)LIBS_BADGE), (int)8, (int)8);
        return retValue;
    }

    public Image getOpenedIcon(int param) {
        Image retValue = ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(true), (Image)ImageUtilities.loadImage((String)LIBS_BADGE), (int)8, (int)8);
        return retValue;
    }

    public Action[] getActions(boolean context) {
        ArrayList<AbstractAction> toRet = new ArrayList<AbstractAction>();
        toRet.add(new AddDependencyAction());
        toRet.add(null);
        toRet.add(new ResolveDepsAction(this.dependencies.project));
        toRet.add(new DownloadJavadocSrcAction(true));
        toRet.add(new DownloadJavadocSrcAction(false));
        toRet.addAll(Utilities.actionsForPath((String)"Projects/org-netbeans-modules-maven/DependenciesActions"));
        toRet.add(null);
        toRet.add(new DependencyNode.ShowManagedStateAction());
        return toRet.toArray(new Action[0]);
    }

    public static Image getTreeFolderIcon(boolean opened) {
        Image base;
        Icon baseIcon = UIManager.getIcon(opened ? OPENED_ICON_KEY_UIMANAGER : ICON_KEY_UIMANAGER);
        if (baseIcon != null) {
            base = ImageUtilities.icon2Image((Icon)baseIcon);
        } else {
            base = (Image)UIManager.get(opened ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
            if (base == null) {
                base = ImageUtilities.loadImage((String)(opened ? OPENED_ICON_PATH : "org/netbeans/modules/maven/defaultFolder.gif"), (boolean)true);
            }
        }
        assert (base != null);
        return base;
    }

    static Preferences prefs() {
        return NbPreferences.root().node(PREF_DEPENDENCIES_UI);
    }

    private static class DependenciesChildren
    extends ChildFactory<DependencyWrapper>
    implements ChangeListener {
        private final DependenciesSet dependencies;

        DependenciesChildren(DependenciesSet dependencies) {
            this.dependencies = dependencies;
            dependencies.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)dependencies));
        }

        protected Node createNodeForKey(DependencyWrapper wr) {
            return new DependencyNode(this.dependencies.project, wr.getArtifact(), wr.getFileObject(), true, wr.getNodeDelegate(), wr.isDeclaredInModuleInfo());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }

        protected boolean createKeys(List<DependencyWrapper> toPopulate) {
            toPopulate.addAll(this.dependencies.list(true));
            return true;
        }
    }

    static final class DependenciesSet
    implements PropertyChangeListener {
        private NbMavenProjectImpl project;
        private final DependencyType type;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final ModuleInfoSupport moduleInfoSupport;

        DependenciesSet(NbMavenProjectImpl project, DependencyType type) {
            this.project = project;
            this.type = type;
            ModuleInfoSupport mis = null;
            switch (type) {
                case COMPILE: 
                case TEST: {
                    try {
                        mis = new ModuleInfoSupport(project, type);
                        break;
                    }
                    catch (LinkageError err) {
                        LOG.log(Level.INFO, "Can't initialize dependencies", err);
                    }
                }
            }
            this.moduleInfoSupport = mis;
            NbMavenProject nbmp = project.getProjectWatcher();
            nbmp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)nbmp));
        }

        Collection<DependencyWrapper> list(boolean longLiving) {
            MavenProject mp = this.project.getOriginalMavenProject();
            Set arts = mp.getArtifacts();
            ArrayList<DependencyWrapper> l = new ArrayList<DependencyWrapper>(switch (this.type) {
                case DependencyType.COMPILE, DependencyType.TEST, DependencyType.RUNTIME -> this.create((Set<Artifact>)arts, longLiving, this.type.artifactScopes());
                default -> this.create((Set<Artifact>)arts, longLiving, (Artifact a) -> !a.getArtifactHandler().isAddedToClasspath());
            });
            l.sort(new DependenciesComparator());
            return l;
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.cs.fireChange();
            }
        }

        private HashSet<DependencyWrapper> create(Set<Artifact> arts, boolean longLiving, List<String> scopesList) {
            return this.create(arts, longLiving, (Artifact a) -> a.getArtifactHandler().isAddedToClasspath() && scopesList.contains(a.getScope()));
        }

        private HashSet<DependencyWrapper> create(Set<Artifact> arts, boolean longLiving, Function<Artifact, Boolean> accept) {
            HashSet<DependencyWrapper> lst = new HashSet<DependencyWrapper>();
            for (Artifact a : arts) {
                String name;
                if (!accept.apply(a).booleanValue()) continue;
                URL url = FileUtil.urlForArchiveOrDir((File)a.getFile());
                String string = name = url != null ? SourceUtils.getModuleName((URL)url) : null;
                if (name != null) {
                    LOG.log(Level.FINE, "Artifact {0} has module name ''{1}''", new Object[]{url, name});
                    lst.add(new DependencyWrapper(a, longLiving, () -> this.moduleInfoSupport != null ? this.moduleInfoSupport.canAddToModuleInfo(name) : false));
                    continue;
                }
                LOG.log(Level.WARNING, "Could not determine module name for artifact {0}", new Object[]{url});
                lst.add(new DependencyWrapper(a, longLiving, () -> false));
            }
            return lst;
        }
    }

    private class AddDependencyAction
    extends AbstractAction {
        AddDependencyAction() {
            this.putValue("Name", Bundle.BTN_Add_Library());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String typeString = DependenciesNode.this.dependencies.type == DependencyType.RUNTIME ? "runtime" : (DependenciesNode.this.dependencies.type == DependencyType.TEST ? "test" : "compile");
            final String[] data = AddDependencyPanel.show(DependenciesNode.this.dependencies.project, true, typeString);
            if (data != null) {
                RP.post(new Runnable(){
                    final /* synthetic */ AddDependencyAction this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        ModelUtils.addDependency(this.this$1.DependenciesNode.this.dependencies.project.getProjectDirectory().getFileObject("pom.xml"), data[0], data[1], data[2], data[4], data[3], data[5], false);
                        ((NbMavenProject)this.this$1.DependenciesNode.this.dependencies.project.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource(false);
                    }
                });
            }
        }
    }

    private static class ResolveDepsAction
    extends AbstractAction {
        private final Project project;

        ResolveDepsAction(Project prj) {
            this.putValue("Name", Bundle.LBL_Download());
            this.project = prj;
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            this.setEnabled(false);
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource(false);
        }
    }

    private class DownloadJavadocSrcAction
    extends AbstractAction {
        private boolean javadoc;

        DownloadJavadocSrcAction(boolean javadoc) {
            this.putValue("Name", javadoc ? Bundle.LBL_Download_Javadoc() : Bundle.LBL_Download__Sources());
            this.javadoc = javadoc;
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Node[] nds = DependenciesNode.this.getChildren().getNodes(true);
                    ProgressContributor[] contribs = new ProgressContributor[nds.length];
                    for (int i = 0; i < nds.length; ++i) {
                        contribs[i] = BasicAggregateProgressFactory.createProgressContributor((String)("multi-" + i));
                    }
                    String label = DownloadJavadocSrcAction.this.javadoc ? Bundle.Progress_Javadoc() : Bundle.Progress_Source();
                    AggregateProgressHandle handle = BasicAggregateProgressFactory.createHandle((String)label, (ProgressContributor[])contribs, (Cancellable)ProgressTransferListener.cancellable(), null);
                    handle.start();
                    try {
                        ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)handle);
                        for (int i = 0; i < nds.length; ++i) {
                            AtomicBoolean cancel = ProgressTransferListener.activeListener().cancel;
                            if (cancel != null && cancel.get()) {
                                return;
                            }
                            if (!(nds[i] instanceof DependencyNode)) continue;
                            DependencyNode nd = (DependencyNode)nds[i];
                            if (DownloadJavadocSrcAction.this.javadoc && !nd.data.hasJavadocInRepository()) {
                                nd.downloadJavadocSources(contribs[i], DownloadJavadocSrcAction.this.javadoc);
                                continue;
                            }
                            if (!DownloadJavadocSrcAction.this.javadoc && !nd.data.hasSourceInRepository()) {
                                nd.downloadJavadocSources(contribs[i], DownloadJavadocSrcAction.this.javadoc);
                                continue;
                            }
                            contribs[i].finish();
                        }
                    }
                    catch (ThreadDeath i) {
                    }
                    catch (IllegalStateException ise) {
                        if (!(ise.getCause() instanceof ThreadDeath)) {
                            throw ise;
                        }
                    }
                    finally {
                        handle.finish();
                        ProgressTransferListener.clearAggregateHandle();
                    }
                }
            });
        }
    }

    private static class DependenciesComparator
    implements Comparator<DependencyWrapper> {
        private DependenciesComparator() {
        }

        @Override
        public int compare(DependencyWrapper art1, DependencyWrapper art2) {
            boolean transitive2;
            boolean transitive1 = art1.getDependencyTrailSize() > 2;
            boolean bl = transitive2 = art2.getDependencyTrailSize() > 2;
            if (transitive1 && !transitive2) {
                return 1;
            }
            if (!transitive1 && transitive2) {
                return -1;
            }
            int ret = art1.getArtifactId().compareTo(art2.getArtifactId());
            if (ret != 0) {
                return ret;
            }
            return art1.getArtifactString().compareTo(art2.getArtifactString());
        }
    }

    private static final class DependencyWrapper {
        private final Artifact artifact;
        private final FileObject fileObject;
        private final Node nodeDelegate;
        private final String artifactString;
        private final String depenencyTrailString;
        private final String filePath;
        private final int dependencyTrailSize;
        private final String artifactId;
        private final Supplier<Boolean> canAddToModuleInfo;

        public DependencyWrapper(Artifact artifact, boolean longLiving, Supplier<Boolean> canAddToModuleInfo) {
            this.artifact = artifact;
            assert (artifact.getFile() != null) : "#200927 Artifact.getFile() is null: " + String.valueOf(artifact);
            assert (artifact.getDependencyTrail() != null) : "#200927 Artifact.getDependencyTrail() is null:" + String.valueOf(artifact);
            assert (artifact.getVersion() != null) : "200927 Artifact.getVersion() is null: " + String.valueOf(artifact);
            this.canAddToModuleInfo = canAddToModuleInfo;
            this.artifactId = artifact.getArtifactId();
            this.artifactString = artifact.toString();
            StringBuilder sb = new StringBuilder();
            ArrayList dependencyTrail = new ArrayList(artifact.getDependencyTrail());
            Collections.sort(dependencyTrail);
            this.dependencyTrailSize = dependencyTrail.size();
            Iterator it = dependencyTrail.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(";");
            }
            this.depenencyTrailString = sb.toString();
            this.filePath = artifact.getFile().getAbsolutePath();
            this.fileObject = FileUtil.toFileObject((File)artifact.getFile());
            this.nodeDelegate = DependencyNode.createNodeDelegate(artifact, this.fileObject, longLiving);
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public Node getNodeDelegate() {
            return this.nodeDelegate;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public Supplier<Boolean> isDeclaredInModuleInfo() {
            return this.canAddToModuleInfo;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyWrapper other = (DependencyWrapper)obj;
            if (!this.artifactString.equals(other.artifactString)) {
                return false;
            }
            if (!this.depenencyTrailString.equals(other.depenencyTrailString)) {
                return false;
            }
            return this.filePath.equals(other.filePath);
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + this.artifactString.hashCode();
            hash = 31 * hash + this.depenencyTrailString.hashCode();
            hash = 31 * hash + this.filePath.hashCode();
            return hash;
        }

        private int getDependencyTrailSize() {
            return this.dependencyTrailSize;
        }

        private String getArtifactId() {
            return this.artifactId;
        }

        private String getArtifactString() {
            return this.artifactString;
        }
    }
}

