/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.swing;

public final class LongRect {
    public long x;
    public long y;
    public long width;
    public long height;

    public LongRect() {
        this(0L, 0L, 0L, 0L);
    }

    public LongRect(LongRect longRect) {
        this(longRect.x, longRect.y, longRect.width, longRect.height);
    }

    public LongRect(long x, long y, long width, long height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public String toString() {
        return "LongRect: [" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + "]";
    }

    public static void clear(LongRect lr) {
        lr.x = 0L;
        lr.y = 0L;
        lr.width = 0L;
        lr.height = 0L;
    }

    public static boolean isClear(LongRect lr) {
        if (lr.x != 0L) {
            return false;
        }
        if (lr.y != 0L) {
            return false;
        }
        if (lr.width != 0L) {
            return false;
        }
        return lr.height == 0L;
    }

    public static boolean isEmpty(LongRect lr) {
        if (lr.width <= 0L) {
            return true;
        }
        return lr.height <= 0L;
    }

    public static void set(LongRect lr1, LongRect lr2) {
        LongRect.set(lr1, lr2.x, lr2.y, lr2.width, lr2.height);
    }

    public static void set(LongRect lr, long x, long y, long width, long height) {
        lr.x = x;
        lr.y = y;
        lr.width = width;
        lr.height = height;
    }

    public static void add(LongRect lr1, LongRect lr2) {
        if (LongRect.isEmpty(lr2)) {
            return;
        }
        if (LongRect.isEmpty(lr1)) {
            lr1.x = lr2.x;
            lr1.y = lr2.y;
            lr1.width = lr2.width;
            lr1.height = lr2.height;
        } else {
            long xx = lr1.x;
            long yy = lr1.y;
            lr1.x = Math.min(lr1.x, lr2.x);
            lr1.y = Math.min(lr1.y, lr2.y);
            lr1.width = Math.max(xx + lr1.width, lr2.x + lr2.width) - lr1.x;
            lr1.height = Math.max(yy + lr1.height, lr2.y + lr2.height) - lr1.y;
        }
    }

    public static void add(LongRect lr, long x, long y) {
        long xx = lr.x;
        long yy = lr.y;
        lr.x = Math.min(lr.x, x);
        lr.y = Math.min(lr.y, y);
        lr.width = Math.max(xx + lr.width, x) - lr.x;
        lr.height = Math.max(yy + lr.height, y) - lr.y;
    }

    public static boolean contains(LongRect lr1, LongRect lr2) {
        if (LongRect.isEmpty(lr1) || LongRect.isEmpty(lr2)) {
            return false;
        }
        if (lr1.x > lr2.x) {
            return false;
        }
        if (lr1.y > lr2.y) {
            return false;
        }
        if (lr1.x + lr1.width < lr2.x + lr2.width) {
            return false;
        }
        return lr1.y + lr1.height >= lr2.y + lr2.height;
    }

    public static boolean equals(LongRect lr1, LongRect lr2) {
        if (lr1.x != lr2.x) {
            return false;
        }
        if (lr1.y != lr2.y) {
            return false;
        }
        if (lr1.width != lr2.width) {
            return false;
        }
        return lr1.height == lr2.height;
    }

    public static boolean touches(LongRect lr1, LongRect lr2) {
        if (LongRect.isEmpty(lr1) || LongRect.isEmpty(lr2)) {
            return false;
        }
        if (lr1.x == lr2.x) {
            return true;
        }
        if (lr1.y == lr2.y) {
            return true;
        }
        if (lr1.x + lr1.width == lr2.x + lr2.width) {
            return true;
        }
        return lr1.y + lr1.height == lr2.y + lr2.height;
    }

    public static void addBorder(LongRect lr, long border) {
        lr.x -= border;
        lr.y -= border;
        lr.width += border * 2L;
        lr.height += border * 2L;
    }
}

