/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.TaskEvent;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.TaskStateListener;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandLocation;
import org.netbeans.modules.payara.tooling.admin.CommandVersion;
import org.netbeans.modules.payara.tooling.admin.ResultMap;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.admin.ServerAdmin;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.logging.Logger;

public class ServerStatus
implements Closeable {
    private static final Logger LOGGER = new Logger(ServerStatus.class);
    private static final int EXECUTOR_POOL_SIZE = 2;
    private static final int CONNECT_TIMEOUT = 15000;
    private static final int COMAND_TIMEOUT_MIN = 100;
    private static final int COMAND_TIMEOUT = 30000;
    private static final int COMAND_STARTUP_TIMEOUT = 600000;
    private final ExecutorService executor = ServerAdmin.executor(2);
    private final AdminPortTask adminPortTask;
    private final VersionTask versionTask;
    private final LocationsTask locationsTask;

    public ServerStatus(PayaraServer server, boolean startup) {
        this.adminPortTask = new AdminPortTask(server, 15000);
        this.versionTask = new VersionTask(server, startup);
        this.locationsTask = new LocationsTask(server, startup);
    }

    public Result getAdminPortResult() {
        return this.adminPortTask.result;
    }

    public ResultVersion getVersionResult() {
        return this.versionTask.result;
    }

    public ResultLocations getLocationsResult() {
        return this.locationsTask.result;
    }

    public void check() {
        this.versionTask.start(this.executor);
        this.locationsTask.start(this.executor);
        Result result = this.adminPortTask.check();
        if (result.status != Status.SUCCESS) {
            this.versionTask.cancel();
            this.locationsTask.cancel();
        }
        this.versionTask.join();
        this.locationsTask.join();
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    private static class AdminPortTask
    extends Task {
        private static final Logger LOGGER = new Logger(AdminPortTask.class);
        String host;
        int port;
        int timeout;
        private Result result;

        AdminPortTask(PayaraServer server, int timeout) {
            super(server);
            this.host = server.getHost();
            this.port = server.getAdminPort();
            this.timeout = timeout;
        }

        Result getResult() {
            return this.result;
        }

        private void closeSocket(Socket socket) {
            try {
                socket.close();
            }
            catch (IOException ioe) {
                this.handleIOException(ioe, this.host, this.port, "Socket closing failed when connecting to {0}:{1}: {2}");
            }
        }

        private void handleIOException(IOException ioe, String host, int port, String message) {
            String METHOD = "handleIOException";
            String logMsg = MessageFormat.format(message, this.server.getName(), host, Integer.toString(port), ioe.getMessage());
            if (this.tmStart >= 0L && LOGGER.isLoggable(Level.FINE)) {
                long tm = System.currentTimeMillis() - this.tmStart;
                LOGGER.log(Level.FINE, "handleIOException", "messageTm", new Object[]{logMsg, AdminPortTask.tm(tm)});
            } else {
                LOGGER.log(Level.INFO, "handleIOException", "message", logMsg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Result check() {
            String METHOD = "check";
            if (this.port < 0 || this.host == null) {
                this.result = new Result(Status.INVALID);
                return this.result;
            }
            this.tmStart = System.currentTimeMillis();
            InetSocketAddress sa = new InetSocketAddress(this.host, this.port);
            Socket socket = new Socket();
            try {
                socket.connect(sa, this.timeout);
                socket.setSoTimeout(this.timeout);
            }
            catch (ConnectException ce) {
                this.handleIOException(ce, this.host, this.port, "[{0}] Port check could not connect to {1}:{2}: {3}");
                Result result = this.result = new Result(Status.FAILED, ce);
                return result;
            }
            catch (SocketTimeoutException ste) {
                this.handleIOException(ste, this.host, this.port, "[{0}] Port check timeout when connecting to {1}:{2}: {3}");
                Result result = this.result = new Result(Status.TIMEOUT, ste);
                return result;
            }
            catch (IOException ioe) {
                this.handleIOException(ioe, this.host, this.port, "[{0}] Port check caught IO exception when connecting to {1}:{2}: {3}");
                Result result = this.result = new Result(Status.EXCEPTION, ioe);
                return result;
            }
            finally {
                this.closeSocket(socket);
            }
            if (this.tmStart >= 0L && LOGGER.isLoggable(Level.FINE)) {
                long tm = System.currentTimeMillis() - this.tmStart;
                LOGGER.log(Level.FINE, "check", "success", new Object[]{AdminPortTask.tm(tm), this.server.getName()});
            }
            this.result = new Result(Status.SUCCESS);
            return this.result;
        }
    }

    private static class VersionTask
    extends Task {
        private static final Logger LOGGER = new Logger(VersionTask.class);
        private final CommandVersion command = new CommandVersion();
        private Future<ResultString> future;
        ResultString taskResult;
        private ResultVersion result;
        private final boolean startup;

        VersionTask(PayaraServer server, boolean startup) {
            super(server);
            this.startup = startup;
        }

        ResultVersion getResult() {
            return this.result;
        }

        void start(ExecutorService executor) {
            String METHOD = "start";
            this.tmStart = System.currentTimeMillis();
            this.future = ServerAdmin.exec(executor, this.server, (Command)this.command, this);
            if (this.tmStart >= 0L && LOGGER.isLoggable(Level.FINE)) {
                long tm = System.currentTimeMillis() - this.tmStart;
                LOGGER.log(Level.FINE, "start", "started", VersionTask.tm(tm));
            }
        }

        private void logExceptionOnJoin(Exception ex) {
            String METHOD = "logExceptionOnJoin";
            LOGGER.log(Level.FINE, "logExceptionOnJoin", "failed", new Object[]{VersionTask.tm(System.currentTimeMillis() - this.tmStart), ex.getClass().getName(), ex.getMessage() != null ? ex.getMessage() : ""});
        }

        void join() {
            String METHOD = "join";
            try {
                this.taskResult = this.future.get(this.timeout(this.startup), TimeUnit.MILLISECONDS);
                this.result = new ResultVersion(this.taskResult, Status.SUCCESS, this.failureEvent, this.serverName, this.exceptionMeasage);
                LOGGER.log(Level.FINE, "completed", VersionTask.tm(System.currentTimeMillis() - this.tmStart));
            }
            catch (TimeoutException te) {
                this.result = new ResultVersion(Status.TIMEOUT, this.failureEvent, this.serverName, this.exceptionMeasage);
                this.logExceptionOnJoin(te);
            }
            catch (ExecutionException ee) {
                this.result = new ResultVersion(Status.FATAL, ee, this.failureEvent, this.serverName, this.exceptionMeasage);
                this.logExceptionOnJoin(ee);
            }
            catch (InterruptedException | CancellationException ie) {
                this.result = new ResultVersion(Status.FAILED, ie, this.failureEvent, this.serverName, this.exceptionMeasage);
                this.logExceptionOnJoin(ie);
            }
        }

        void cancel() {
            if (!this.future.isDone()) {
                this.future.cancel(true);
            }
        }
    }

    private static class LocationsTask
    extends Task {
        private static final Logger LOGGER = new Logger(LocationsTask.class);
        private final CommandLocation command = new CommandLocation();
        private Future<ResultMap<String, String>> future;
        ResultMap<String, String> taskResult;
        private ResultLocations result;
        private final boolean startup;

        LocationsTask(PayaraServer server, boolean startup) {
            super(server);
            this.startup = startup;
        }

        ResultLocations getResult() {
            return this.result;
        }

        void start(ExecutorService executor) {
            String METHOD = "start";
            this.tmStart = System.currentTimeMillis();
            this.future = ServerAdmin.exec(executor, this.server, (Command)this.command, this);
            if (this.tmStart >= 0L && LOGGER.isLoggable(Level.FINE)) {
                long tm = System.currentTimeMillis() - this.tmStart;
                LOGGER.log(Level.FINE, "start", "started", LocationsTask.tm(tm));
            }
        }

        private void logExceptionOnJoin(Exception ex) {
            String METHOD = "logExceptionOnJoin";
            LOGGER.log(Level.FINE, "logExceptionOnJoin", "failed", new Object[]{LocationsTask.tm(System.currentTimeMillis() - this.tmStart), ex.getClass().getName(), ex.getMessage() != null ? ex.getMessage() : ""});
        }

        void join() {
            String METHOD = "join";
            try {
                this.taskResult = this.future.get(this.timeout(this.startup), TimeUnit.MILLISECONDS);
                this.result = new ResultLocations(this.taskResult, Status.SUCCESS, this.failureEvent, this.serverName, this.exceptionMeasage);
                LOGGER.log(Level.FINE, "join", "completed", LocationsTask.tm(System.currentTimeMillis() - this.tmStart));
            }
            catch (TimeoutException te) {
                this.result = new ResultLocations(Status.TIMEOUT, this.failureEvent, this.serverName, this.exceptionMeasage);
                this.logExceptionOnJoin(te);
            }
            catch (ExecutionException ee) {
                this.result = new ResultLocations(Status.FATAL, ee, this.failureEvent, this.serverName, this.exceptionMeasage);
                this.logExceptionOnJoin(ee);
            }
            catch (InterruptedException | CancellationException ie) {
                this.result = new ResultLocations(Status.FAILED, ie, this.failureEvent, this.serverName, this.exceptionMeasage);
                this.logExceptionOnJoin(ie);
            }
        }

        void cancel() {
            if (!this.future.isDone()) {
                this.future.cancel(true);
            }
        }
    }

    public static class Result {
        final Status status;
        private final IOException ioe;
        private final Exception ex;
        private final TaskEvent failureEvent;
        private final String serverName;
        private final String exceptionMeasage;

        Result(Status status, IOException ioe, TaskEvent failureEvent, String serverName, String exceptionMeasage) {
            this.status = status;
            this.ioe = ioe;
            this.ex = null;
            this.failureEvent = failureEvent;
            this.serverName = serverName;
            this.exceptionMeasage = exceptionMeasage;
        }

        Result(Status status, Exception ex, TaskEvent failureEvent, String serverName, String exceptionMeasage) {
            this.status = status;
            this.ioe = null;
            this.ex = ex;
            this.failureEvent = failureEvent;
            this.serverName = serverName;
            this.exceptionMeasage = exceptionMeasage;
        }

        Result(Status status, TaskEvent failureEvent, String serverName, String exceptionMeasage) {
            this.status = status;
            this.ioe = null;
            this.ex = null;
            this.failureEvent = failureEvent;
            this.serverName = serverName;
            this.exceptionMeasage = exceptionMeasage;
        }

        Result(Status status, IOException ioe) {
            this(status, ioe, null, null, null);
        }

        Result(Status status, Exception ex) {
            this(status, ex, null, null, null);
        }

        Result(Status status) {
            this(status, null, null, null);
        }

        public Status getStatus() {
            return this.status;
        }

        public TaskEvent getFailureEvent() {
            return this.failureEvent;
        }

        public String getServerName() {
            return this.serverName;
        }

        public String getExceptionMeasage() {
            return this.exceptionMeasage;
        }
    }

    public static class ResultVersion
    extends Result {
        final ResultString result;

        ResultVersion(ResultString result, Status status, TaskEvent failureEvent, String serverName, String exceptionMeasage) {
            super(status, failureEvent, serverName, exceptionMeasage);
            this.result = result;
        }

        ResultVersion(Status status, Exception ex, TaskEvent failureEvent, String serverName, String exceptionMeasage) {
            super(status, ex, failureEvent, serverName, exceptionMeasage);
            this.result = null;
        }

        ResultVersion(Status status, TaskEvent failureEvent, String serverName, String exceptionMeasage) {
            super(status, failureEvent, serverName, exceptionMeasage);
            this.result = null;
        }

        public ResultString getResult() {
            return this.result;
        }
    }

    public static class ResultLocations
    extends Result {
        final ResultMap<String, String> result;

        ResultLocations(ResultMap<String, String> result, Status status, TaskEvent failureEvent, String serverName, String exceptionMeasage) {
            super(status, failureEvent, serverName, exceptionMeasage);
            this.result = result;
        }

        ResultLocations(Status status, Exception ex, TaskEvent failureEvent, String serverName, String exceptionMeasage) {
            super(status, ex, failureEvent, serverName, exceptionMeasage);
            this.result = null;
        }

        ResultLocations(Status status, TaskEvent failureEvent, String serverName, String exceptionMeasage) {
            super(status, failureEvent, serverName, exceptionMeasage);
            this.result = null;
        }

        public ResultMap<String, String> getResult() {
            return this.result;
        }
    }

    public static enum Status {
        SUCCESS,
        FAILED,
        TIMEOUT,
        EXCEPTION,
        INVALID,
        FATAL;


        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "SUCCESS";
                }
                case 1: {
                    return "FAILED";
                }
                case 2: {
                    return "TIMEOUT";
                }
                case 3: {
                    return "EXCEPTION";
                }
                case 4: {
                    return "INVALID";
                }
                case 5: {
                    return "FATAL";
                }
            }
            throw new IllegalStateException("Unknown Status value");
        }
    }

    private static abstract class Task
    implements TaskStateListener {
        final PayaraServer server;
        long tmStart;
        TaskEvent failureEvent;
        String serverName;
        String exceptionMeasage;

        static String tm(long tm) {
            StringBuilder sb = new StringBuilder(8);
            sb.append(Long.toString(tm / 1000L));
            sb.append('.');
            sb.append(Long.toString(tm % 1000L));
            return sb.toString();
        }

        Task(PayaraServer server) {
            this.server = server;
            this.tmStart = -1L;
        }

        long timeout(boolean startup) {
            long timeout = (long)(startup ? 600000 : 30000) - System.currentTimeMillis() + this.tmStart;
            if (timeout > 100L) {
                return timeout;
            }
            return 100L;
        }

        @Override
        public void operationStateChanged(TaskState newState, TaskEvent event, String[] args) {
            if (args != null && args.length >= 3) {
                this.serverName = args[0];
                this.exceptionMeasage = args[2];
            } else {
                this.exceptionMeasage = null;
                this.serverName = null;
            }
            switch (newState) {
                case FAILED: {
                    this.failureEvent = event;
                }
            }
        }
    }
}

