/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.BorderLayout;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.history.DiffResultsView;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.subversion.ui.history.SearchExecutor;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.util.Context;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SearchHistoryTopComponent
extends TopComponent
implements DiffSetupSource {
    private SearchHistoryPanel shp;

    public SearchHistoryTopComponent() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSN_SearchHistoryT_Top_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSD_SearchHistoryT_Top_Component"));
    }

    public SearchHistoryTopComponent(Context context) {
        this(context, null, null);
    }

    SearchHistoryTopComponent(File[] files) {
        this();
        this.initComponents(files, null, null);
    }

    public SearchHistoryTopComponent(Context context, Date from, Date to) {
        this();
        this.initComponents(context.getRootFiles(), from, to);
    }

    SearchHistoryTopComponent(File file, DiffResultsViewFactory fac) {
        this();
        this.initComponents(new File[]{file}, null, null);
        this.shp.setDiffResultsViewFactory(fac);
    }

    public SearchHistoryTopComponent(SVNUrl repositoryUrl, File localRoot, long revision) {
        this();
        this.initComponents(repositoryUrl, localRoot, revision);
    }

    public void search(boolean showCriteria) {
        this.shp.executeSearch();
        this.shp.setSearchCriteria(showCriteria);
    }

    void activateDiffView(boolean selectFirstRevision) {
        this.shp.activateDiffView(selectFirstRevision);
    }

    private void initComponents(SVNUrl repositoryUrl, File localRoot, long revision) {
        this.setLayout(new BorderLayout());
        SearchCriteriaPanel scp = new SearchCriteriaPanel(repositoryUrl);
        scp.setFrom(Long.toString(revision));
        scp.setTo(Long.toString(revision));
        this.shp = new SearchHistoryPanel(repositoryUrl, localRoot, scp);
        this.add(this.shp);
    }

    private void initComponents(File[] roots, Date from, Date to) {
        this.setLayout(new BorderLayout());
        SearchCriteriaPanel scp = new SearchCriteriaPanel(roots);
        if (from != null) {
            scp.setFrom(SearchExecutor.simpleDateFormat.format(from));
        }
        if (to != null) {
            scp.setTo(SearchExecutor.simpleDateFormat.format(to));
        }
        this.shp = new SearchHistoryPanel(roots, scp);
        this.add(this.shp);
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        this.shp.windowClosed();
        super.componentClosed();
    }

    protected String preferredID() {
        return "Svn.SearchHistoryTopComponent";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public Collection getSetups() {
        return this.shp.getSetups();
    }

    @Override
    public String getSetupDisplayName() {
        return this.getDisplayName();
    }

    public static class DiffResultsViewFactory {
        DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
            return new DiffResultsView(panel, results);
        }
    }
}

