/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.dd.spi.web.WebAppMetadataModelFactory;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleFactory;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebModules
implements WebModuleProvider,
AntProjectListener,
ClassPathProvider {
    private List<FFWebModule> modules;
    private Map<FFWebModule, WebModule> cache;
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final AuxiliaryConfiguration aux;
    private MetadataModel<WebAppMetadata> webAppMetadataModel;

    public WebModules(Project project, AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
        assert (project != null);
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        this.aux = aux;
        helper.addAntProjectListener((AntProjectListener)this);
    }

    public WebModule findWebModule(final FileObject file) {
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        if (this.project.equals((Object)owner)) {
            return (WebModule)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<WebModule>(){
                final /* synthetic */ WebModules this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public WebModule run() {
                    WebModules webModules = this.this$0;
                    synchronized (webModules) {
                        List mods = this.this$0.getModules();
                        for (FFWebModule ffwm : mods) {
                            if (!ffwm.contains(file)) continue;
                            WebModule wm = (WebModule)this.this$0.cache.get(ffwm);
                            if (wm == null) {
                                wm = WebModuleFactory.createWebModule((WebModuleImplementation)ffwm);
                                this.this$0.cache.put(ffwm, wm);
                            }
                            return wm;
                        }
                        return null;
                    }
                }
            });
        }
        return null;
    }

    public ClassPath findClassPath(final FileObject file, final String type) {
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        if (owner != null && owner.equals((Object)this.project)) {
            return (ClassPath)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ClassPath>(){
                final /* synthetic */ WebModules this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ClassPath run() {
                    WebModules webModules = this.this$0;
                    synchronized (webModules) {
                        List mods = this.this$0.getModules();
                        for (FFWebModule ffwm : mods) {
                            if (!ffwm.contains(file)) continue;
                            return ffwm.findClassPath(file, type);
                        }
                    }
                    return null;
                }
            });
        }
        return null;
    }

    private synchronized List<FFWebModule> getModules() {
        if (this.modules == null) {
            this.modules = this.readAuxData();
            this.cache = new HashMap<FFWebModule, WebModule>();
        }
        return this.modules;
    }

    private List<FFWebModule> readAuxData() {
        ArrayList<FFWebModule> mods = new ArrayList<FFWebModule>();
        Element web = this.aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true);
        if (web == null) {
            return mods;
        }
        List webModules = XMLUtil.findSubElements((Element)web);
        for (Element webModulesEl : webModules) {
            assert (webModulesEl.getLocalName().equals("web-module")) : webModulesEl;
            FileObject docRootFO = this.getFile(webModulesEl, "doc-root");
            Element j2eeSpecEl = XMLUtil.findElement((Element)webModulesEl, (String)"j2ee-spec-level", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
            String j2eeSpec = j2eeSpecEl == null ? null : this.evaluator.evaluate(XMLUtil.findText((Node)j2eeSpecEl));
            Element contextPathEl = XMLUtil.findElement((Element)webModulesEl, (String)"context-path", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
            String contextPathText = contextPathEl == null ? null : XMLUtil.findText((Node)contextPathEl);
            String contextPath = contextPathText == null ? null : this.evaluator.evaluate(contextPathText);
            Element classpathEl = XMLUtil.findElement((Element)webModulesEl, (String)"classpath", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
            FileObject[] sources = this.getSources();
            ClassPath cp = classpathEl == null ? null : this.createClasspath(classpathEl, sources);
            Element webInfEl = XMLUtil.findElement((Element)webModulesEl, (String)"web-inf", (String)"http://www.netbeans.org/ns/freeform-project-web/2");
            FileObject webInf = null;
            if (webInfEl != null) {
                webInf = this.getFile(webModulesEl, "web-inf");
            }
            mods.add(new FFWebModule(docRootFO, j2eeSpec, contextPath, sources, cp, webInf));
        }
        return mods;
    }

    private FileObject getFile(Element parent, String fileElName) {
        Element el = XMLUtil.findElement((Element)parent, (String)fileElName, (String)"http://www.netbeans.org/ns/freeform-project-web/2");
        String fname = XMLUtil.findText((Node)el);
        if (fname == null) {
            return null;
        }
        String locationEval = this.evaluator.evaluate(fname);
        if (locationEval != null) {
            File locationFile = this.helper.resolveFile(locationEval);
            return FileUtil.toFileObject((File)locationFile);
        }
        return null;
    }

    private FileObject[] getSources() {
        SourceGroup[] sg = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        HashSet<FileObject> srcRootSet = new HashSet<FileObject>();
        for (int i = 0; i < sg.length; ++i) {
            URL entry = sg[i].getRootFolder().toURL();
            SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)entry);
            FileObject[] srcForBin = res.getRoots();
            for (int j = 0; j < srcForBin.length; ++j) {
                srcRootSet.add(srcForBin[j]);
            }
        }
        FileObject[] roots = new FileObject[sg.length];
        for (int i = 0; i < sg.length; ++i) {
            roots[i] = sg[i].getRootFolder();
        }
        return roots;
    }

    private ClassPath createClasspath(Element classpathEl, FileObject[] sources) {
        int i;
        String cpEval;
        String cp = XMLUtil.findText((Node)classpathEl);
        if (cp == null) {
            cp = "";
        }
        if ((cpEval = this.evaluator.evaluate(cp)) == null) {
            return null;
        }
        String[] path = PropertyUtils.tokenizePath((String)cpEval);
        HashSet<File> entries = new HashSet<File>();
        for (i = 0; i < path.length; ++i) {
            entries.add(this.helper.resolveFile(path[i]));
        }
        if (entries.size() == 0) {
            for (i = 0; i < sources.length; ++i) {
                entries.add(FileUtil.toFile((FileObject)sources[i]));
            }
        }
        URL[] pathURL = new URL[entries.size()];
        int i2 = 0;
        for (File entryFile : entries) {
            URL entry;
            try {
                entry = entryFile.toURI().toURL();
                if (FileUtil.isArchiveFile((URL)entry)) {
                    entry = FileUtil.getArchiveRoot((URL)entry);
                } else {
                    String s = entry.toExternalForm();
                    if (!s.endsWith("/")) {
                        entry = new URL(s + '/');
                    }
                }
            }
            catch (MalformedURLException x) {
                throw new AssertionError((Object)x);
            }
            pathURL[i2++] = entry;
        }
        return ClassPathSupport.createClassPath((URL[])pathURL);
    }

    public synchronized void configurationXmlChanged(AntProjectEvent ev) {
        this.modules = null;
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    private final class FFWebModule
    implements WebModuleImplementation {
        public static final String FOLDER_WEB_INF = "WEB-INF";
        public static final String FILE_DD = "web.xml";
        private final FileObject docRootFO;
        private final FileObject[] sourcesFOs;
        private final ClassPath webClassPath;
        private final ClassPath javaSourcesClassPath;
        private final Map<String, ClassPath> composedClassPath = new HashMap<String, ClassPath>();
        private final String j2eeSpec;
        private final String contextPath;
        private FileObject webInf;
        private ClassPath compileClasspath;

        FFWebModule(FileObject docRootFO, String j2eeSpec, String contextPath, FileObject[] sourcesFOs, ClassPath classPath, FileObject webInf) {
            this.docRootFO = docRootFO;
            this.j2eeSpec = j2eeSpec;
            this.contextPath = contextPath == null ? "" : contextPath;
            this.sourcesFOs = sourcesFOs;
            this.compileClasspath = classPath;
            this.webClassPath = classPath == null ? ClassPathSupport.createClassPath(Collections.emptyList()) : classPath;
            this.webInf = webInf;
            this.javaSourcesClassPath = sourcesFOs == null ? ClassPathSupport.createClassPath(Collections.emptyList()) : ClassPathSupport.createClassPath((FileObject[])sourcesFOs);
        }

        boolean contains(FileObject fo) {
            if (this.docRootFO == null) {
                return false;
            }
            if (this.docRootFO == fo || FileUtil.isParentOf((FileObject)this.docRootFO, (FileObject)fo)) {
                return true;
            }
            for (int i = 0; i < this.sourcesFOs.length; ++i) {
                if (this.sourcesFOs[i] != fo && !FileUtil.isParentOf((FileObject)this.sourcesFOs[i], (FileObject)fo)) continue;
                return true;
            }
            return false;
        }

        public FileObject getDocumentBase() {
            return this.docRootFO;
        }

        public ClassPath findClassPath(FileObject file, String type) {
            assert (Thread.holdsLock(WebModules.this));
            int fileType = this.getType(file);
            if (fileType == 0) {
                if (!type.equals("classpath/source")) {
                    return null;
                }
                return this.javaSourcesClassPath;
            }
            if (fileType == 1) {
                int i;
                ClassPath classPath = this.composedClassPath.get(type);
                if (classPath != null) {
                    return classPath;
                }
                HashSet<FileObject> all = new HashSet<FileObject>();
                FileObject[] javaRoots = null;
                for (i = 0; i < this.sourcesFOs.length; ++i) {
                    ClassPath cp = ClassPath.getClassPath((FileObject)this.sourcesFOs[i], (String)type);
                    if (cp == null) continue;
                    javaRoots = cp.getRoots();
                    for (int j = 0; j < javaRoots.length; ++j) {
                        if (all.contains(javaRoots[j])) continue;
                        all.add(javaRoots[j]);
                    }
                }
                if (all.isEmpty() && "classpath/boot".equals(type)) {
                    ClassPath bootCP = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
                    all.addAll(Arrays.asList(bootCP.getRoots()));
                }
                for (i = 0; i < this.webClassPath.getRoots().length; ++i) {
                    if (all.contains(this.webClassPath.getRoots()[i])) continue;
                    all.add(this.webClassPath.getRoots()[i]);
                }
                FileObject[] roots = new FileObject[all.size()];
                int i2 = 0;
                Iterator it = all.iterator();
                while (it.hasNext()) {
                    roots[i2++] = (FileObject)it.next();
                }
                classPath = ClassPathSupport.createClassPath((FileObject[])roots);
                this.composedClassPath.put(type, classPath);
                return classPath;
            }
            return this.webClassPath;
        }

        public String getJ2eePlatformVersion() {
            return this.j2eeSpec;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("web module in freeform project\n\tdoc root:" + this.docRootFO.getPath() + "\n\tcontext path:" + this.contextPath + "\n\tj2ee version:" + this.j2eeSpec);
            for (int i = 0; i < this.sourcesFOs.length; ++i) {
                sb.append("\n\tsource root:" + this.sourcesFOs[i].getPath());
            }
            return sb.toString();
        }

        public FileObject getDeploymentDescriptor() {
            FileObject winf = this.getWebInf();
            if (winf == null) {
                return null;
            }
            return winf.getFileObject(FILE_DD);
        }

        public FileObject getWebInf() {
            if (this.webInf == null && this.getDocumentBase() != null) {
                this.webInf = this.getDocumentBase().getFileObject(FOLDER_WEB_INF);
            }
            return this.webInf;
        }

        @Deprecated
        public FileObject[] getJavaSources() {
            return this.sourcesFOs;
        }

        public MetadataModel<WebAppMetadata> getMetadataModel() {
            if (WebModules.this.webAppMetadataModel == null) {
                FileObject ddFO = this.getDeploymentDescriptor();
                File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
                MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries(), (ClassPath)this.compileClasspath, (ClassPath)this.javaSourcesClassPath, (File)ddFile);
                WebModules.this.webAppMetadataModel = WebAppMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit, (boolean)true);
            }
            return WebModules.this.webAppMetadataModel;
        }

        private int getType(FileObject file) {
            for (int i = 0; i < this.sourcesFOs.length; ++i) {
                FileObject root = this.sourcesFOs[i];
                if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
                return 0;
            }
            FileObject dir = this.getDocumentBase();
            if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
                return 1;
            }
            return -1;
        }
    }
}

