/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.preferences;

import java.io.File;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.phpunit.PhpUnitTestingProvider;
import org.netbeans.modules.php.phpunit.PhpUnitVersion;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class PhpUnitPreferences {
    private static final String BOOTSTRAP_ENABLED = "bootstrap.enabled";
    private static final String BOOTSTRAP_PATH = "bootstrap.path";
    private static final String BOOTSTRAP_FOR_CREATE_TESTS = "bootstrap.create.tests";
    private static final String CONFIGURATION_ENABLED = "configuration.enabled";
    private static final String CONFIGURATION_PATH = "configuration.path";
    private static final String CUSTOM_SUITE_ENABLED = "customSuite.enabled";
    private static final String CUSTOM_SUITE_PATH = "customSuite.path";
    private static final String PHP_UNIT_ENABLED = "phpUnit.enabled";
    private static final String PHP_UNIT_PATH = "phpUnit.path";
    private static final String PHP_UNIT_VERSION = "phpUnit.version";
    private static final String RUN_PHPUNIT_ONLY = "test.run.phpunit.only";
    private static final String RUN_ALL_TEST_FILES = "test.run.all";
    private static final String ASK_FOR_TEST_GROUPS = "test.groups.ask";
    private static final String TEST_GROUPS = "test.groups";
    private static final String TEST_GROUPS_DELIMITER = ",";

    private PhpUnitPreferences() {
    }

    public static boolean isBootstrapEnabled(PhpModule phpModule) {
        return PhpUnitPreferences.getPreferences(phpModule).getBoolean(BOOTSTRAP_ENABLED, false);
    }

    public static void setBootstrapEnabled(PhpModule phpModule, boolean bootstrapEnabled) {
        PhpUnitPreferences.getPreferences(phpModule).putBoolean(BOOTSTRAP_ENABLED, bootstrapEnabled);
    }

    public static String getBootstrapPath(PhpModule phpModule) {
        return PhpUnitPreferences.resolvePath(phpModule, PhpUnitPreferences.getPreferences(phpModule).get(BOOTSTRAP_PATH, null));
    }

    public static void setBootstrapPath(PhpModule phpModule, String bootstrapPath) {
        PhpUnitPreferences.getPreferences(phpModule).put(BOOTSTRAP_PATH, PhpUnitPreferences.relativizePath(phpModule, bootstrapPath));
    }

    public static boolean isBootstrapForCreateTests(PhpModule phpModule) {
        return PhpUnitPreferences.getPreferences(phpModule).getBoolean(BOOTSTRAP_FOR_CREATE_TESTS, false);
    }

    public static void setBootstrapForCreateTests(PhpModule phpModule, boolean bootstrapEnabled) {
        PhpUnitPreferences.getPreferences(phpModule).putBoolean(BOOTSTRAP_FOR_CREATE_TESTS, bootstrapEnabled);
    }

    public static boolean isConfigurationEnabled(PhpModule phpModule) {
        return PhpUnitPreferences.getPreferences(phpModule).getBoolean(CONFIGURATION_ENABLED, false);
    }

    public static void setConfigurationEnabled(PhpModule phpModule, boolean configurationEnabled) {
        PhpUnitPreferences.getPreferences(phpModule).putBoolean(CONFIGURATION_ENABLED, configurationEnabled);
    }

    public static String getConfigurationPath(PhpModule phpModule) {
        return PhpUnitPreferences.resolvePath(phpModule, PhpUnitPreferences.getPreferences(phpModule).get(CONFIGURATION_PATH, null));
    }

    public static void setConfigurationPath(PhpModule phpModule, String configurationPath) {
        PhpUnitPreferences.getPreferences(phpModule).put(CONFIGURATION_PATH, PhpUnitPreferences.relativizePath(phpModule, configurationPath));
    }

    public static boolean isCustomSuiteEnabled(PhpModule phpModule) {
        return PhpUnitPreferences.getPreferences(phpModule).getBoolean(CUSTOM_SUITE_ENABLED, false);
    }

    public static void setCustomSuiteEnabled(PhpModule phpModule, boolean customSuiteEnabled) {
        PhpUnitPreferences.getPreferences(phpModule).putBoolean(CUSTOM_SUITE_ENABLED, customSuiteEnabled);
    }

    public static String getCustomSuitePath(PhpModule phpModule) {
        return PhpUnitPreferences.resolvePath(phpModule, PhpUnitPreferences.getPreferences(phpModule).get(CUSTOM_SUITE_PATH, null));
    }

    public static void setCustomSuitePath(PhpModule phpModule, String customSuitePath) {
        PhpUnitPreferences.getPreferences(phpModule).put(CUSTOM_SUITE_PATH, PhpUnitPreferences.relativizePath(phpModule, customSuitePath));
    }

    public static boolean isPhpUnitEnabled(PhpModule phpModule) {
        return PhpUnitPreferences.getPreferences(phpModule).getBoolean(PHP_UNIT_ENABLED, false);
    }

    public static void setPhpUnitEnabled(PhpModule phpModule, boolean phpUnitEnabled) {
        PhpUnitPreferences.getPreferences(phpModule).putBoolean(PHP_UNIT_ENABLED, phpUnitEnabled);
    }

    public static String getPhpUnitPath(PhpModule phpModule) {
        return PhpUnitPreferences.resolvePath(phpModule, PhpUnitPreferences.getPreferences(phpModule).get(PHP_UNIT_PATH, null));
    }

    public static void setPhpUnitPath(PhpModule phpModule, String phpUnitPath) {
        PhpUnitPreferences.getPreferences(phpModule).put(PHP_UNIT_PATH, PhpUnitPreferences.relativizePath(phpModule, phpUnitPath));
    }

    public static boolean getRunPhpUnitOnly(PhpModule phpModule) {
        return PhpUnitPreferences.getPreferences(phpModule).getBoolean(RUN_PHPUNIT_ONLY, false);
    }

    public static void setRunPhpUnitOnly(PhpModule phpModule, boolean runPhpUnitOnly) {
        PhpUnitPreferences.getPreferences(phpModule).putBoolean(RUN_PHPUNIT_ONLY, runPhpUnitOnly);
    }

    public static boolean getRunAllTestFiles(PhpModule phpModule) {
        return PhpUnitPreferences.getPreferences(phpModule).getBoolean(RUN_ALL_TEST_FILES, false);
    }

    public static void setRunAllTestFiles(PhpModule phpModule, boolean runAllTestFiles) {
        PhpUnitPreferences.getPreferences(phpModule).putBoolean(RUN_ALL_TEST_FILES, runAllTestFiles);
    }

    public static boolean getAskForTestGroups(PhpModule phpModule) {
        return PhpUnitPreferences.getPreferences(phpModule).getBoolean(ASK_FOR_TEST_GROUPS, false);
    }

    public static void setAskForTestGroups(PhpModule phpModule, boolean askForTestGroups) {
        PhpUnitPreferences.getPreferences(phpModule).putBoolean(ASK_FOR_TEST_GROUPS, askForTestGroups);
    }

    public static List<String> getTestGroups(PhpModule phpModule) {
        return StringUtils.explode((String)PhpUnitPreferences.getPreferences(phpModule).get(TEST_GROUPS, null), (String)TEST_GROUPS_DELIMITER);
    }

    public static void setTestGroups(PhpModule phpModule, List<String> testGroups) {
        PhpUnitPreferences.getPreferences(phpModule).put(TEST_GROUPS, StringUtils.implode(testGroups, (String)TEST_GROUPS_DELIMITER));
    }

    public static PhpUnitVersion getPhpUnitVersion(PhpModule phpModule) {
        return PhpUnitPreferences.getPhpUnitVersion(PhpUnitPreferences.getPreferences(phpModule).get(PHP_UNIT_VERSION, null));
    }

    public static void setPhpUnitVersion(PhpModule phpModule, PhpUnitVersion version) {
        PhpUnitPreferences.getPreferences(phpModule).put(PHP_UNIT_VERSION, version.name());
    }

    private static PhpUnitVersion getPhpUnitVersion(@NullAllowed String version) {
        if (version != null) {
            try {
                return PhpUnitVersion.valueOf(version);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return PhpUnitVersion.getDefault();
    }

    private static Preferences getPreferences(PhpModule module) {
        return module.getPreferences(PhpUnitTestingProvider.class, true);
    }

    private static String relativizePath(PhpModule phpModule, String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return "";
        }
        File file = new File(filePath);
        String path = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)phpModule.getProjectDirectory()), (File)file);
        if (path == null) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    private static String resolvePath(PhpModule phpModule, String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return null;
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)phpModule.getProjectDirectory()), (String)filePath).getAbsolutePath();
    }
}

